/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class FilteredIterator<T>
implements Iterator<T> {
    private static final Object CURR_END = new Object();
    private static final Object CURR_UNDETERMINED = new Object();
    private final Map<T, Boolean> d_filterCache;
    private final Iterator<?> d_it;
    private IObjectFilter<T> d_filter;
    private int d_skippedCount = 0;
    private Object d_curr;
    private final Class<T> d_type;

    public FilteredIterator(Collection<?> objs, Class<T> type) {
        this(objs.iterator(), type);
    }

    public FilteredIterator(Collection<?> objs, Class<T> type, IObjectFilter<T> filter) {
        this(objs.iterator(), type, filter);
    }

    public FilteredIterator(Collection<?> objs, Class<T> type, IObjectFilter<T> filter, Map<T, Boolean> filterCache) {
        this(objs.iterator(), type, filter, filterCache);
    }

    public FilteredIterator(Iterator<?> baseIt, Class<T> type) {
        this(baseIt, type, new AcceptAllFilter());
    }

    public FilteredIterator(Iterator<?> baseIt, Class<T> type, IObjectFilter<T> filter) {
        this(baseIt, type, filter, null);
    }

    public FilteredIterator(Iterator<?> baseIt, Class<T> type, IObjectFilter<T> filter, Map<T, Boolean> filterCache) {
        this.d_it = baseIt;
        this.d_filter = filter;
        this.d_type = type;
        this.d_filterCache = filterCache;
        this.d_curr = CURR_UNDETERMINED;
    }

    public int getSkippedCount() {
        return this.d_skippedCount;
    }

    private boolean shouldFilter(T obj) {
        if (this.d_filterCache != null) {
            Boolean result = this.d_filterCache.get(obj);
            if (result == null) {
                result = this.d_filter.shouldFilter(obj);
                this.d_filterCache.put(obj, result);
            }
            return result;
        }
        return this.d_filter.shouldFilter(obj);
    }

    protected Object curr() {
        if (this.d_curr == CURR_UNDETERMINED) {
            while (this.d_it.hasNext()) {
                Object o = this.d_it.next();
                if (this.d_type.isInstance(o) && !this.shouldFilter(this.d_type.cast(o))) {
                    this.d_curr = o;
                    return this.d_curr;
                }
                ++this.d_skippedCount;
            }
            this.d_curr = CURR_END;
        }
        return this.d_curr;
    }

    @Override
    public boolean hasNext() {
        return this.curr() != CURR_END;
    }

    @Override
    public T next() {
        Object curr = this.curr();
        if (this.d_curr != CURR_END) {
            this.d_curr = CURR_UNDETERMINED;
        }
        return curr != CURR_END ? (T)this.d_type.cast(curr) : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

