/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.APrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagHelper;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.LinkStatus;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Utils;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.WaitCursorMgr;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedEvent;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedListener;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorMgr;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiAction;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiCheckBox;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiIntField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusBar;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusMessage;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiTextField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUnitDoubleField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiValueField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.tool.Tool;
import pyrosim.legacy_2012_1.thunderheadeng.gui.tool.ToolManager;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.io.FilenameManager;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.IntermediateGraphicsXfer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IMaterial;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.AxesScene;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.BasicRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ClearableBackground;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ILayer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Material;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ModelScene;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.NativeImage;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.NativeImageMgr;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.OriginDisp;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.RasterObj;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.RenderComponent;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.SceneLayout;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.StringRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.TextRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.View;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.AToolFunction;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.CursorTool;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.DragFunc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.IToolController;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.ZoomBoxFunc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.ZoomFunc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomPicker;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.IntVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theObservable;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class BGImageDlg
extends guiDialog
implements Observer {
    private static final long serialVersionUID = 5452886056388152870L;
    private final IImageLoader d_loader;
    private final Unit d_displayUnit;
    private Mode d_mode;
    private final BGImageBuilder d_builder;
    private IntermediateGraphicsXfer d_igx;
    private guiPanel d_imgFilenamePanel;
    private JLabel d_imgFilenameTitle;
    private guiTextField d_filenameFld;
    private JButton d_filenameBtn;
    private guiPanel d_anchorPanel;
    private JLabel d_anchorTitle;
    private MultiLineLabel d_anchorDesc;
    private guiUnitDoubleField d_modelX;
    private guiUnitDoubleField d_modelY;
    private guiUnitDoubleField d_modelZ;
    private guiPanel d_scalePanel;
    private JLabel d_scaleTitle;
    private MultiLineLabel d_scaleDesc;
    private guiUnitDoubleField d_distAB;
    private guiCheckBox d_abAngleCB;
    private guiUnitDoubleField d_abAngle;
    private guiPanel d_imagePanel;
    private ImageEditor d_imageEditor;
    private JSlider d_opacitySlider;
    private guiIntField d_opacityField;
    private final IRenderSurface d_parent;
    private static final int STEP_IMAGE_SPECIFIED = 0;
    private static final int STEP_ANCHOR_IMAGE_SET = 1;
    private static final int STEP_ANCHOR_MODEL_SET = 2;
    private static final int STEP_SCALE_POINTA_SET = 3;
    private static final int STEP_SCALE_POINTB_SET = 4;
    private static final int STEP_SCALE_DISTAB_SET = 5;
    public static final String LastDlgWidthPref = "BGImageDlg.BGImageDlg.LastWidth";
    public static final String LastDlgHeightPref = "BGImageDlg.BGImageDlg.LastHeight";

    public BGImageDlg(Window owner, IRenderSurface parent, ColorMgr colors, Map<Colors, String> colorMap, IImageLoader imgLoader, Unit displayUnit, IntermediateGraphicsXfer igx) {
        super(owner, Intl.intl("Configure Background Image"), 9);
        assert (colorMap.size() == Colors.values().length);
        this.d_mode = Mode.CREATE;
        this.d_loader = imgLoader;
        this.d_displayUnit = displayUnit;
        igx.acquire();
        this.d_igx = igx;
        this.d_builder = new BGImageBuilder();
        this.d_builder.addWeakObserver(this);
        this.d_parent = parent;
        this.d_imageEditor = new ImageEditor(parent, colors, colorMap, this.d_displayUnit, this.d_builder);
        this.d_imageEditor.getRenderComp().setPreferredSize(new Dimension(600, 400));
        this.d_opacitySlider = new JSlider(0, 0, 100, 100);
        this.d_opacityField = new guiIntField(100, IntVR.between(0, 100, true, true));
        this.d_opacityField.setColumns(3);
        this.d_opacityField.setHorizontalAlignment(4);
        this.d_imgFilenamePanel = this.buildFileChooserPanel();
        guiPanel dlgPanel = this.buildDialogPanel();
        this.d_imagePanel = this.buildImagePanel();
        guiPanel c = this.getDialogPane();
        c.setLayout(new GridBagLayout());
        GridBagUtil.add(c, this.d_imgFilenamePanel, 1, 1, 2, 1, 11, 11, 0, 11, 2, 1.0, 0.0, 18);
        GridBagUtil.add(c, dlgPanel, 1, 2, 1, 1, 11, 11, 0, 0, 3, 0.0, 1.0, 18);
        GridBagUtil.add(c, this.d_imagePanel, 2, 2, 1, 1, 11, 11, 0, 11, 1, 1.0, 1.0, 18);
        this.d_opacityField.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                if (!BGImageDlg.this.d_opacityField.validateData(false, false)) {
                    return;
                }
                int newValue = (Integer)BGImageDlg.this.d_opacityField.getValue();
                BGImageDlg.this.d_opacitySlider.setValue(newValue);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }
        });
        this.d_opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = BGImageDlg.this.d_opacitySlider.getValue();
                BGImageDlg.this.d_opacityField.setValue(value);
                float opacity = (float)value / (float)BGImageDlg.this.d_opacitySlider.getMaximum();
                BGImageDlg.this.d_builder.setOpacity(opacity);
            }
        });
        this.setDisposeAfterModal(false);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setImage(null, null, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo editImage(Window owner, IRenderSurface parent, ColorMgr colors, Map<Colors, String> colorMap, IImageLoader imgLoader, Unit displayUnit, IntermediateGraphicsXfer igx, ImageInfo img) {
        if (img == null) {
            WaitCursorMgr wait;
            File file = imgLoader.choose(owner, null);
            if (file == null) {
                return null;
            }
            WaitCursorMgr waitCursorMgr = wait = owner != null ? new WaitCursorMgr(owner) : null;
            if (wait != null) {
                wait.beginWaitCursor();
            }
            try {
                Pair<Image, BGImageXform> result = imgLoader.load(file);
                if (result == null) {
                    ImageInfo imageInfo = null;
                    return imageInfo;
                }
                img = new ImageInfo((Image)result.v1, (BGImageXform)result.v2, 1.0f);
            }
            catch (IOException e) {
                BGImageDlg.showLoadError(owner, e);
                ImageInfo imageInfo = null;
                return imageInfo;
            }
            finally {
                if (wait != null) {
                    wait.endWaitCursor();
                }
            }
        }
        BGImageDlg dlg = new BGImageDlg(owner, parent, colors, colorMap, imgLoader, displayUnit, igx);
        dlg.setImage(img.image, img.xform, img.opacity);
        if (dlg.doModal() == 1) {
            return dlg.getImage();
        }
        return null;
    }

    private guiPanel buildFileChooserPanel() {
        guiPanel p = new guiPanel();
        GridBagHelper gb = new GridBagHelper(p);
        this.d_imgFilenameTitle = new JLabel(Intl.intl("1. Choose image file:"));
        this.d_imgFilenameTitle.setFont(new Font("Sans Serif", 1, 11));
        this.d_filenameFld = new guiTextField();
        this.d_filenameFld.setEditable(false);
        ImageIcon icon = guiUtil.loadTeciIcon("Open16.gif");
        this.d_filenameBtn = new JButton(icon);
        this.d_filenameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGImageDlg.this.loadImageFromChooser();
            }
        });
        this.d_filenameBtn.setPreferredSize(new Dimension(icon.getIconWidth() + 6, icon.getIconHeight() + 6));
        gb.addRow(this.d_imgFilenameTitle, this.d_filenameFld, 1.0, this.d_filenameBtn);
        return p;
    }

    private guiPanel buildDialogPanel() {
        guiPanel p = new guiPanel();
        p.setLayout(new GridBagLayout());
        this.d_anchorPanel = new guiPanel(new GridBagLayout());
        int y = 1;
        this.d_anchorTitle = new JLabel(Intl.intl("2. Set Anchor Point:"));
        this.d_anchorTitle.setFont(new Font("Sans Serif", 1, 11));
        GridBagUtil.add(this.d_anchorPanel, this.d_anchorTitle, 1, y++, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 18);
        this.d_anchorDesc = new MultiLineLabel(String.format(Intl.intl("The Anchor Point is a reference point that determines where to place the image in the model.  To set it, make sure the button, \"%s,\" is selected below, and click on the image at the desired anchor location.  Then enter the coordinates for the corresponding point in the model."), this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).getText()));
        GridBagUtil.add(this.d_anchorPanel, this.d_anchorDesc, 1, y++, 2, 1, 6, 11, 0, 0, 2, 1.0, 0.0, 18);
        GridBagUtil.add(this.d_anchorPanel, this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()), 1, y++, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        this.d_modelX = new guiUnitDoubleField(0.0, this.d_displayUnit);
        this.d_modelY = new guiUnitDoubleField(0.0, this.d_displayUnit);
        this.d_modelZ = new guiUnitDoubleField(0.0, this.d_displayUnit);
        this.d_distAB = new guiUnitDoubleField(1.0, DoubleVR.above(0.0, false), this.d_displayUnit);
        this.d_abAngleCB = new guiCheckBox(Intl.intl("A->B angle:"));
        this.d_abAngle = new guiUnitDoubleField(0.0, NonSI.DEGREE_ANGLE);
        this.d_abAngle.aliasValue(null, "");
        new FldListener(new guiValueField[]{this.d_distAB}){

            @Override
            protected void updateToProps() {
                BGImageDlg.this.d_builder.setABDistModel((UnitDouble)BGImageDlg.this.d_distAB.getValue());
            }
        };
        new FldListener(new guiValueField[]{this.d_abAngle}){

            @Override
            protected void updateToProps() {
                if (BGImageDlg.this.d_abAngleCB.isSelected()) {
                    BGImageDlg.this.d_builder.setABAngle((UnitDouble)BGImageDlg.this.d_abAngle.getValue());
                }
            }
        };
        new FldListener(new guiValueField[]{this.d_modelX, this.d_modelY, this.d_modelZ}){

            @Override
            protected void updateToProps() {
                BGImageDlg.this.d_builder.setAnchorModel(new UnitPoint3D((UnitDouble)BGImageDlg.this.d_modelX.getValue(), (UnitDouble)BGImageDlg.this.d_modelY.getValue(), (UnitDouble)BGImageDlg.this.d_modelZ.getValue()));
            }
        };
        GridBagUtil.add(this.d_anchorPanel, new ComponentPair(new JLabel(Intl.intl("Model X:")), this.d_modelX, true), 1, y++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        GridBagUtil.add(this.d_anchorPanel, new ComponentPair(new JLabel(Intl.intl("Model Y:")), this.d_modelY, true), 1, y++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        GridBagUtil.add(this.d_anchorPanel, new ComponentPair(new JLabel(Intl.intl("Model Z:")), this.d_modelZ, true), 1, y++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        this.d_scalePanel = new guiPanel(new GridBagLayout());
        y = 1;
        this.d_scaleTitle = new JLabel(Intl.intl("3. Set Scale:"));
        this.d_scaleTitle.setFont(new Font("Sans Serif", 1, 11));
        GridBagUtil.add(this.d_scalePanel, this.d_scaleTitle, 1, y++, 1, 1, 11, 0, 0, 0);
        this.d_scaleDesc = new MultiLineLabel(Intl.intl("The Scale determines how big the image will appear in the model.  To set the scale, find two points in the image that are a known distance apart, and use the buttons, \"Choose Point A\" and \"Choose Point B\" to set the two points.  Then specify their separation in model coordinates below."));
        GridBagUtil.add(this.d_scalePanel, this.d_scaleDesc, 1, y++, 2, 1, 6, 11, 0, 0, 2, 1.0, 0.0, 18);
        guiPanel pointAPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(pointAPanel, this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()), 0, 0, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_scalePanel, pointAPanel, 1, y++, 2, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 18);
        GridBagUtil.add(this.d_scalePanel, this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()), 1, y++, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_scalePanel, new ComponentPair(new JLabel(Intl.intl("Dist. A to B:")), this.d_distAB, true), 1, y++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        LinkStatus.link((AbstractButton)this.d_abAngleCB, this.d_abAngle);
        GridBagUtil.add(this.d_scalePanel, new ComponentPair(this.d_abAngleCB, this.d_abAngle, true), 1, y, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        this.d_abAngleCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BGImageDlg.this.d_abAngleCB.isSelected()) {
                    BGImageDlg.this.updateABAngleFromProps();
                    BGImageDlg.this.d_builder.setABAngle(null);
                } else {
                    BGImageDlg.this.d_abAngle.requestFocus();
                }
            }
        });
        y = 1;
        GridBagUtil.add(p, this.d_anchorPanel, 1, y++, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 18);
        GridBagUtil.add(p, this.d_scalePanel, 1, y++, 1, 1, 0, 0, 0, 0, 0, 1.0, 0.0, 18);
        GridBagUtil.add(p, Box.createVerticalGlue(), 1, 99, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        return p;
    }

    private guiPanel buildImagePanel() {
        guiPanel p = new guiPanel(new BorderLayout());
        guiPanel mvPanel = new guiPanel();
        mvPanel.setLayout(new BorderLayout());
        mvPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        guiPanel topPanel = new guiPanel(new BorderLayout());
        topPanel.add((Component)this.d_imageEditor.getEditToolbar(), "North");
        topPanel.add(this.d_imageEditor.getRenderComp(), "Center");
        guiPanel bottomPanel = new guiPanel(new BorderLayout());
        bottomPanel.add((Component)this.d_imageEditor.getStatusBar(), "South");
        mvPanel.add((Component)topPanel, "Center");
        mvPanel.add((Component)bottomPanel, "South");
        guiPanel sliderPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(sliderPanel, new guiLabel(Intl.intl("Image Brightness (Opacity)") + ": "), 0, 0, 1, 1, 6, 6, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sliderPanel, this.d_opacitySlider, 1, 0, 1, 1, 6, 0, 0, 6, 2, 1.0, 0.0, 17);
        GridBagUtil.add(sliderPanel, this.d_opacityField, 2, 0, 1, 1, 6, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sliderPanel, new guiLabel("%"), 3, 0, 1, 1, 6, 0, 0, 6, 0, 0.0, 0.0, 17);
        p.add((Component)mvPanel, "Center");
        p.add((Component)sliderPanel, "South");
        return p;
    }

    @Override
    public void update(Observable o, Object arg) {
        Set changes = (Set)arg;
        if (changes.contains(BGImageBuilder.IMAGE_CHANGED)) {
            this.d_filenameFld.setText(this.d_builder.getName());
        }
        if ((changes.contains(BGImageBuilder.A_CHANGED) || changes.contains(BGImageBuilder.B_CHANGED)) && this.d_builder.getABAngle() == null) {
            this.updateABAngleFromProps();
        }
        if (changes.contains(BGImageBuilder.AB_ANGLE_CHANGED)) {
            UnitDouble angle = this.d_builder.getABAngle();
            this.d_abAngleCB.setSelected(angle != null);
            if (angle != null) {
                this.d_abAngle.setValue(angle);
            } else {
                this.updateABAngleFromProps();
            }
        }
        if (changes.contains(BGImageBuilder.ANCHOR_MODEL_CHANGED)) {
            UnitPoint3D anchor = this.d_builder.getAnchorModel();
            this.d_modelX.setValue(anchor.xu());
            this.d_modelY.setValue(anchor.yu());
            this.d_modelZ.setValue(anchor.zu());
        }
        if (changes.contains(BGImageBuilder.OPACITY_CHANGED)) {
            this.d_opacityField.setValue(Math.round(this.d_builder.getOpacity() * 100.0f));
        }
        if (changes.contains(BGImageBuilder.ANCHOR_IMAGE_CHANGED) && this.d_builder.isAnchorImageCommitted()) {
            this.stepCompleted(1);
        } else if (changes.contains(BGImageBuilder.B_CHANGED) && this.d_builder.isBCommitted()) {
            this.stepCompleted(4);
        } else if (changes.contains(BGImageBuilder.A_CHANGED) && this.d_builder.isACommitted()) {
            this.stepCompleted(3);
        }
        if (changes.contains(BGImageBuilder.AB_DIST_CHANGED)) {
            this.d_distAB.setValue(this.d_builder.getDistABModel());
        } else if (changes.contains(BGImageBuilder.IMAGE_CHANGED) && this.d_builder.getImage() != null) {
            this.stepCompleted(0);
        }
    }

    private void updateABAngleFromProps() {
        Point2d a = this.d_builder.getAImage();
        Point2d b = this.d_builder.getBImage();
        if (a == null || b == null) {
            this.d_abAngle.setValue(null);
            return;
        }
        Vector2d vec = Util2D.vectorN(a, b);
        Vector2d x = new Vector2d(1.0, 0.0);
        double angle = Util2D.angle(x, vec);
        this.d_abAngle.setValue(new UnitDouble(angle, SI.RADIAN).convert(NonSI.DEGREE_ANGLE));
    }

    private void stepCompleted(int step) {
        if (this.d_mode == Mode.EDIT) {
            return;
        }
        switch (step) {
            case 0: {
                this.showPanel(this.d_anchorPanel, true);
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).setEnabled(true);
                this.d_imageEditor.getToolManager().setCurrentTool(this.d_imageEditor.getAnchorTool());
                this.d_modelX.setEnabled(true);
                this.d_modelY.setEnabled(true);
                this.d_modelZ.setEnabled(true);
                this.d_modelX.requestFocus();
                break;
            }
            case 1: {
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()).setEnabled(true);
                this.d_imageEditor.getToolManager().setCurrentTool(this.d_imageEditor.getAPointTool());
                break;
            }
            case 3: {
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).setEnabled(true);
                this.d_imageEditor.getToolManager().setCurrentTool(this.d_imageEditor.getBPointTool());
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).requestFocus();
                break;
            }
            case 4: {
                this.d_distAB.setEnabled(true);
                this.d_distAB.requestFocus();
                this.d_abAngleCB.setEnabled(true);
                this.d_abAngle.setEnabled(this.d_abAngleCB.isSelected());
                this.getButton(1).setEnabled(true);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void showPanel(guiPanel panel, boolean visible) {
        if (panel == this.d_imgFilenamePanel && visible) {
            this.d_imgFilenameTitle.setForeground(Color.BLUE);
            this.d_scaleTitle.setForeground(Color.BLACK);
            this.d_scaleDesc.setForeground(Color.BLACK);
            this.d_anchorTitle.setForeground(Color.BLACK);
            this.d_anchorDesc.setForeground(Color.BLACK);
        } else if (panel == this.d_anchorPanel && visible) {
            this.d_imgFilenameTitle.setForeground(Color.BLACK);
            this.d_scaleTitle.setForeground(Color.BLACK);
            this.d_scaleDesc.setForeground(Color.BLACK);
            this.d_anchorTitle.setForeground(Color.BLUE);
            this.d_anchorDesc.setForeground(Color.BLUE);
        } else if (panel == this.d_scalePanel && visible) {
            this.d_imgFilenameTitle.setForeground(Color.BLACK);
            this.d_scaleTitle.setForeground(Color.BLUE);
            this.d_scaleDesc.setForeground(Color.BLUE);
            this.d_anchorTitle.setForeground(Color.BLACK);
            this.d_anchorDesc.setForeground(Color.BLACK);
        }
    }

    public void setZLocation(UnitDouble z) {
        this.d_modelZ.setValue(z);
        this.d_builder.setAnchorModel(new UnitPoint3D(0.0, 0.0, z.getValueNoUnit(), z.getUnit()));
    }

    @Override
    public void dispose() {
        this.d_igx.release();
        this.d_imageEditor = null;
        super.dispose();
    }

    @Override
    public int doModal() {
        this.loadPreferredSize(LastDlgWidthPref, LastDlgHeightPref);
        int ret = super.doModal();
        if (ret != 1) {
            this.dispose();
        }
        this.savePreferredSize(LastDlgWidthPref, LastDlgHeightPref);
        return ret;
    }

    @Override
    public void pack() {
        super.pack();
        this.d_imageEditor.resetCamera();
    }

    public void setImage(Image image, BGImageXform xform, float opacity) {
        Mode mode = this.d_mode = xform == null ? Mode.CREATE : Mode.EDIT;
        if (this.d_mode == Mode.CREATE) {
            this.d_modelX.setEnabled(false);
            this.d_modelY.setEnabled(false);
            this.d_modelZ.setEnabled(false);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).setEnabled(false);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()).setEnabled(false);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).setEnabled(false);
            this.d_distAB.setEnabled(false);
            this.d_abAngleCB.setEnabled(false);
            this.d_abAngle.setEnabled(false);
            this.showPanel(this.d_imgFilenamePanel, true);
            this.getButton(1).setEnabled(false);
        } else {
            this.d_modelX.setEnabled(true);
            this.d_modelY.setEnabled(true);
            this.d_modelZ.setEnabled(true);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).setEnabled(true);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()).setEnabled(true);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).setEnabled(true);
            this.d_distAB.setEnabled(true);
            this.d_abAngleCB.setEnabled(true);
            this.d_abAngle.setEnabled(this.d_abAngleCB.isSelected());
            this.showPanel(this.d_imgFilenamePanel, true);
            this.getButton(1).setEnabled(true);
        }
        this.d_builder.pause();
        if (image != null) {
            this.d_builder.setImage(image);
        }
        if (xform != null) {
            this.d_builder.setTransform(xform);
        }
        this.d_builder.setOpacity(opacity);
        this.d_builder.resume();
    }

    public ImageInfo getImage() {
        if (this.d_builder.getImage() != null) {
            this.d_igx.unregisterGraphics(this.d_builder.getName());
        }
        this.d_imageEditor.registerGraphics(this.d_igx);
        return this.d_builder.save();
    }

    private void loadImageFromChooser() {
        File file = this.d_loader.choose(this, this.d_builder.getFile());
        if (file == null) {
            return;
        }
        try {
            this.loadImage(file);
        }
        catch (IOException e) {
            BGImageDlg.showLoadError(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(File file) throws IOException {
        this.beginWaitCursor();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            File currFile = this.d_builder.getFile();
            if (currFile != null && FilenameManager.equal(currFile, file)) {
                return;
            }
            Pair<Image, BGImageXform> result = this.d_loader.load(file);
            if (result == null) {
                return;
            }
            this.d_builder.pause();
            this.d_builder.setImage((Image)result.v1);
            if (result.v2 != null) {
                this.d_builder.setTransform((BGImageXform)result.v2);
            }
            this.d_builder.resume();
        }
        finally {
            this.endWaitCursor();
        }
    }

    private static void showLoadError(Component parent, IOException error) {
        JOptionPane.showMessageDialog(parent, String.format("%s: %s", error.getClass().getSimpleName(), error.getLocalizedMessage()), Intl.intl("Image Error"), 0);
    }

    private static BGImageXform generateTransform(Point2d anchorImage, UnitPoint3D anchorModel, Point2d aImage, Point2d bImage, UnitDouble distABModel, UnitDouble abAngle) {
        BaseUnit lu = SI.METER;
        Unit au = SI.RADIAN;
        assert (anchorImage != null && anchorModel != null);
        Point3d am = anchorModel.getPoint3dValue(lu);
        if (aImage == null || bImage == null || distABModel == null) {
            return new BGImageXform(anchorImage, am, new Point2d(0.0, 0.0), new Point2d(1.0, 0.0), 1.0, 0.0);
        }
        double dab = distABModel.getValue(lu);
        if (abAngle == null) {
            return new BGImageXform(anchorImage, am, aImage, bImage, dab, Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(aImage, bImage)));
        }
        return new BGImageXform(anchorImage, am, aImage, bImage, dab, abAngle.getValue(au));
    }

    public static enum Colors {
        BACKGROUND,
        AXIS,
        AXIS_BOX,
        AXIS_TEXT,
        ORIGIN;

    }

    public static enum Mode {
        CREATE,
        EDIT;

    }

    public static interface IImageLoader {
        public File choose(Component var1, File var2);

        public Pair<Image, BGImageXform> load(File var1) throws IOException;
    }

    private static class BGImageBuilder
    extends theObservable {
        public static final Object IMAGE_CHANGED = "IMAGE_CHANGED";
        public static final Object A_CHANGED = "A_CHANGED";
        public static final Object B_CHANGED = "B_CHANGED";
        public static final Object AB_DIST_CHANGED = "AB_DIST_CHANGED";
        public static final Object AB_ANGLE_CHANGED = "AB_ANGLE_CHANGED";
        public static final Object ANCHOR_IMAGE_CHANGED = "ANCHOR_IMAGE_CHANGED";
        public static final Object ANCHOR_MODEL_CHANGED = "ANCHOR_MODEL_CHANGED";
        public static final Object OPACITY_CHANGED = "OPACITY_CHANGED";
        public Image d_image = null;
        public Point2d d_anchorImage = new Point2d(0.0, 0.0);
        public boolean d_anchorCommitted = false;
        public UnitPoint3D d_anchorModel = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
        public Point2d d_aImage = null;
        public boolean d_aCommitted = false;
        public Point2d d_bImage = null;
        public boolean d_bCommitted = false;
        public UnitDouble d_distABModel = new UnitDouble(1.0, SI.METER);
        public UnitDouble d_abAngle = null;
        public float d_opacity = 1.0f;
        private Set<Object> d_changes = new HashSet<Object>();
        private Semaphore d_lock = new Semaphore(1);

        private BGImageBuilder() {
        }

        protected boolean lock() {
            return this.d_lock.tryAcquire();
        }

        protected void unlock() {
            this.d_lock.release();
        }

        protected void changed(Object ... changes) {
            for (Object change : changes) {
                this.d_changes.add(change);
            }
            this.setChanged();
            this.tryFireNotification();
        }

        @Override
        protected boolean tryFireNotification(Object objs) {
            if (super.tryFireNotification(this.d_changes)) {
                this.d_changes.clear();
                return true;
            }
            return false;
        }

        public void setImage(Image image) {
            if (!this.lock()) {
                return;
            }
            this.d_image = image;
            this.changed(IMAGE_CHANGED);
            this.unlock();
        }

        public void setTransform(BGImageXform xform) {
            this.pause();
            this.setAnchorImage(xform.anchorImage, true);
            this.setAnchorModel(new UnitPoint3D(xform.anchorModel, (Unit)SI.METER));
            this.setAImage(xform.aImage, true);
            this.setBImage(xform.bImage, true);
            this.setABDistModel(new UnitDouble(xform.distABModel, SI.METER));
            double angle = xform.abAngle;
            double abAngle = Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(xform.aImage, xform.bImage));
            UnitDouble uangle = theUtil.eq(angle, abAngle, 1.0E-6) ? null : new UnitDouble(angle, SI.RADIAN);
            this.setABAngle(uangle);
            this.resume();
        }

        public ImageInfo save() {
            if (this.d_image == null) {
                return null;
            }
            BGImageXform xform = BGImageDlg.generateTransform(this.d_anchorImage, this.d_anchorModel, this.d_aImage, this.d_bImage, this.d_distABModel, this.d_abAngle);
            return new ImageInfo(this.d_image, xform, this.d_opacity);
        }

        public Image getImage() {
            return this.d_image;
        }

        public String getName() {
            return this.d_image != null ? this.d_image.getFilename() : null;
        }

        public File getFile() {
            return this.d_image != null ? new File(this.d_image.getFilename()) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setProperty(String fieldName, Object value, Object changeFlag) {
            if (!this.lock()) {
                return;
            }
            try {
                Field fld = BGImageBuilder.class.getField(fieldName);
                fld.set(this, value);
                this.changed(changeFlag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.unlock();
            }
        }

        public void setOpacity(float opacity) {
            this.setProperty("d_opacity", Float.valueOf(opacity), OPACITY_CHANGED);
        }

        public float getOpacity() {
            return this.d_opacity;
        }

        public void setAnchorModel(UnitPoint3D anchorModel) {
            this.setProperty("d_anchorModel", anchorModel, ANCHOR_MODEL_CHANGED);
        }

        public UnitPoint3D getAnchorModel() {
            return this.d_anchorModel;
        }

        public void setAnchorImage(Point2d anchor, boolean commit) {
            if (!this.lock()) {
                return;
            }
            this.d_anchorImage = anchor;
            this.d_anchorCommitted = commit;
            this.changed(ANCHOR_IMAGE_CHANGED);
            this.unlock();
        }

        public Point2d getAnchorImage() {
            return this.d_anchorImage;
        }

        public boolean isAnchorImageCommitted() {
            return this.d_anchorCommitted;
        }

        public void setABDistModel(UnitDouble dist) {
            this.setProperty("d_distABModel", dist, AB_DIST_CHANGED);
        }

        public UnitDouble getDistABModel() {
            return this.d_distABModel;
        }

        public void setABAngle(UnitDouble angle) {
            this.setProperty("d_abAngle", angle, AB_ANGLE_CHANGED);
        }

        public UnitDouble getABAngle() {
            return this.d_abAngle;
        }

        public void setAImage(Point2d a, boolean commit) {
            if (!this.lock()) {
                return;
            }
            this.d_aImage = a;
            this.d_aCommitted = commit;
            this.changed(A_CHANGED);
            this.unlock();
        }

        public Point2d getAImage() {
            return this.d_aImage;
        }

        public boolean isACommitted() {
            return this.d_aCommitted;
        }

        public void setBImage(Point2d b, boolean commit) {
            if (!this.lock()) {
                return;
            }
            this.d_bImage = b;
            this.d_bCommitted = commit;
            this.changed(B_CHANGED);
            this.unlock();
        }

        public Point2d getBImage() {
            return this.d_bImage;
        }

        public boolean isBCommitted() {
            return this.d_bCommitted;
        }
    }

    public static class ImageEditor
    implements ColorChangedListener,
    IToolController,
    Observer {
        public static final Color COMMITTED_COLOR = new Color(0.8f, 0.1f, 0.3f, 1.0f);
        public static final Color EDITING_COLOR = Color.BLUE;
        private final BGImageBuilder d_builder;
        private final Unit d_displayLenUnit;
        private final SceneLayout d_layout = new SceneLayout(new ILayer[0]);
        private final ClearableBackground d_background = new ClearableBackground(true, true);
        private final AxesScene d_axes = new AxesScene();
        private final ModelScene d_imageScene = new ModelScene();
        private final ModelScene d_toolScene = new ModelScene();
        private final RenderComponent d_renderComp;
        private final View d_mainView;
        private final BasicRenderer d_toolLayer = new BasicRenderer();
        private final OriginDisp d_origin = new OriginDisp();
        private final OrthoCamera d_camera;
        private final ColorMgr d_colors;
        private final Map<Colors, String> d_colorMap;
        private final ToolManager d_tools;
        private final AnchorTool d_anchorTool;
        private final APointTool d_aPointTool;
        private final BPointTool d_bPointTool;
        private final CursorTool d_dragTool;
        private final CursorTool d_zoomTool;
        private final CursorTool d_zoomBoxTool;
        private final StringRenderer d_anchorRenderer;
        private final StringRenderer d_aRenderer;
        private final StringRenderer d_bRenderer;
        private final StringRenderer d_distRenderer;
        private final StringRenderer d_toolTextRenderer;
        private final GeomDisplay d_toolDisplay;
        private final JToolBar d_editToolbar;
        private final guiStatusBar d_statusBar;
        private final guiStatusMessage d_statusMessage;
        private final ResetAction d_resetAction = new ResetAction();
        private RasterObj d_imageDisplay = new RasterObj();

        public ImageEditor(IRenderSurface parent, ColorMgr colors, Map<Colors, String> colorMap, Unit lenDisplayUnit, BGImageBuilder builder) {
            this.d_builder = builder;
            this.d_displayLenUnit = lenDisplayUnit;
            this.d_builder.addWeakObserver(this);
            this.d_colors = colors;
            this.d_colorMap = colorMap;
            this.d_renderComp = new RenderComponent(parent);
            this.d_mainView = new View(this.d_renderComp, this.d_imageScene);
            this.d_renderComp.setLayout(this.d_layout);
            this.d_imageScene.getDrawProps().setLightingEnabled(false);
            this.d_imageScene.getDrawProps().setDepthTestEnabled(false);
            this.d_imageScene.forceImmediate(true);
            this.d_toolScene.getDrawProps().setLightingEnabled(false);
            this.d_toolScene.getDrawProps().setDepthTestEnabled(false);
            this.d_toolScene.forceImmediate(true);
            this.d_camera = new OrthoCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.0, 2.0, 10.0);
            TextRenderer textRenderer = new TextRenderer();
            textRenderer.setFontSize(12.0f);
            textRenderer.setCamera(this.d_camera);
            textRenderer.setPadding(new int[]{4, 4, 4, 4});
            textRenderer.setFontColor(Color.WHITE);
            textRenderer.setRenderType(0);
            this.d_anchorRenderer = ImageEditor.newStringRenderer(textRenderer, "", COMMITTED_COLOR);
            this.d_aRenderer = ImageEditor.newStringRenderer(textRenderer, "A", COMMITTED_COLOR);
            this.d_bRenderer = ImageEditor.newStringRenderer(textRenderer, "B", COMMITTED_COLOR);
            this.d_distRenderer = ImageEditor.newStringRenderer(textRenderer, "", COMMITTED_COLOR);
            this.d_toolTextRenderer = ImageEditor.newStringRenderer(textRenderer, "", EDITING_COLOR);
            this.d_statusBar = new guiStatusBar();
            this.d_statusBar.setLabelBorder(guiStatusBar.BEVEL_BORDER);
            this.d_statusMessage = new guiStatusMessage();
            this.d_statusBar.setStatusMessage(this.d_statusMessage);
            this.d_tools = new ToolManager(this.d_renderComp);
            this.d_anchorTool = new AnchorTool();
            this.d_tools.addTool(this.d_anchorTool, Intl.intl("Choose Anchor Point"), "Set the Anchor Point", null);
            this.d_aPointTool = new APointTool();
            this.d_tools.addTool(this.d_aPointTool, Intl.intl("Choose Point A"), "Set Point A", null);
            this.d_bPointTool = new BPointTool();
            this.d_tools.addTool(this.d_bPointTool, Intl.intl("Choose Point B"), "Set Point B", null);
            DragFunc dragFunc = new DragFunc();
            this.d_dragTool = new CursorTool(this, dragFunc);
            this.d_tools.addTool(this.d_dragTool, "Drag", Intl.intl("Pan View"), guiUtil.loadTeciIcon("drag16.gif"));
            ZoomFunc zoomFunc = new ZoomFunc();
            this.d_zoomTool = new CursorTool(this, zoomFunc);
            this.d_tools.addTool(this.d_zoomTool, "Zoom", Intl.intl("Zoom"), guiUtil.loadTeciIcon("Zoom16.gif"));
            ZoomBoxFunc zoomBoxFunc = new ZoomBoxFunc();
            this.d_zoomBoxTool = new CursorTool(this, zoomBoxFunc);
            this.d_tools.addTool(this.d_zoomBoxTool, "Zoom Box", Intl.intl("Zoom Box"), guiUtil.loadTeciIcon("zoombox16.gif"));
            this.d_tools.addToolChangeListener(new ToolManager.ToolChangeListener(){

                @Override
                public void toolWillChanged(Tool oldTool, Tool newTool) {
                    this.updateCurrentTool();
                }
            });
            this.d_toolDisplay = new GeomDisplay(new INativeDisplayProps(this){

                @Override
                public double getFaceError() {
                    return 0.0;
                }

                @Override
                public double getCurveError() {
                    return 0.0;
                }

                @Override
                public Material getNativeMat(IMaterial mat) {
                    return null;
                }
            }, new ConstGeomSrc());
            this.d_tools.setCurrentTool(this.d_dragTool);
            this.d_imageScene.setCamera(this.d_camera);
            this.d_toolScene.setCamera(this.d_camera);
            this.d_axes.setBaseCamera(this.d_camera);
            this.d_imageScene.addObjects(this.d_imageDisplay);
            this.d_toolScene.addObjects(this.d_toolDisplay, this.d_anchorRenderer, this.d_aRenderer, this.d_bRenderer, this.d_distRenderer);
            this.d_layout.addLayer(this.d_background);
            this.d_layout.addLayer(new BasicRenderer(this.d_imageScene));
            this.d_layout.addLayer(new BasicRenderer(this.d_camera, this.d_origin, this.d_toolScene));
            this.d_layout.addLayer(this.d_axes);
            this.d_layout.addLayer(new BasicRenderer(this.d_camera, this.d_toolTextRenderer));
            this.d_layout.addLayer(this.d_toolLayer);
            this.updateCurrentTool();
            this.d_editToolbar = this.createEditToolbar();
            this.updateColors();
            this.updateOrigin();
            this.updateDisplays();
        }

        @Override
        public GeomPicker getSnapper() {
            return null;
        }

        @Override
        public ModelScene[] getToolScenes() {
            return new ModelScene[2];
        }

        private static StringRenderer newStringRenderer(TextRenderer tr, String text, Color color) {
            StringRenderer rend = new StringRenderer();
            rend.setRenderer(tr);
            rend.setString(text);
            rend.setColor(color);
            return rend;
        }

        @Override
        public ColorMgr getColors() {
            return this.d_colors;
        }

        @Override
        public Component getRenderComp() {
            return this.d_renderComp;
        }

        @Override
        public guiStatusMessage getStatusMessage() {
            return this.d_statusMessage;
        }

        private JToolBar createEditToolbar() {
            JToolBar tb = new JToolBar();
            tb.add(this.d_tools.getToolbarButton(this.d_dragTool));
            tb.add(this.d_tools.getToolbarButton(this.d_zoomTool));
            tb.add(this.d_tools.getToolbarButton(this.d_zoomBoxTool));
            tb.add(this.d_resetAction);
            Utils.noToolBarFocus(tb);
            tb.setMinimumSize(new Dimension(0, 0));
            return tb;
        }

        protected void finalize() throws Throwable {
            System.out.println("finalizing image editor");
            System.out.flush();
            super.finalize();
        }

        @Override
        public void colorChanged(ColorChangedEvent e) {
            this.updateColors();
            this.d_renderComp.repaint();
        }

        public void updateColors() {
            Color bgColor = this.d_colors.getColor(this.d_colorMap.get((Object)Colors.BACKGROUND));
            this.d_background.setColor(bgColor);
            float[] bgColorComps = bgColor.getComponents(new float[4]);
            this.d_axes.setBackgroundColor(new Color(bgColorComps[0], bgColorComps[1], bgColorComps[2], 0.9f));
            this.d_axes.setAxisColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.AXIS)));
            this.d_axes.setBoxColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.AXIS_BOX)));
            this.d_axes.setTextColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.AXIS_TEXT)));
            this.d_origin.setColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.ORIGIN)));
        }

        @Override
        public void update(Observable o, Object arg) {
            Set changes = (Set)arg;
            boolean updateToolDisplay = false;
            boolean updateOrigin = false;
            if (changes.contains(BGImageBuilder.IMAGE_CHANGED)) {
                Image img = this.d_builder.getImage();
                NativeImage ni = img == null ? null : NativeImageMgr.getImage(img);
                this.d_imageDisplay.setImage(ni);
                this.resetCamera();
            }
            if (changes.contains(BGImageBuilder.ANCHOR_MODEL_CHANGED)) {
                this.d_anchorTool.markNativeDirty();
                updateOrigin = true;
                updateToolDisplay = true;
            }
            if (changes.contains(BGImageBuilder.ANCHOR_IMAGE_CHANGED)) {
                this.d_anchorTool.markNativeDirty();
                updateOrigin = true;
                updateToolDisplay = true;
            }
            if (changes.contains(BGImageBuilder.A_CHANGED)) {
                this.d_aPointTool.markNativeDirty();
                updateOrigin = true;
                updateToolDisplay = true;
            }
            if (changes.contains(BGImageBuilder.B_CHANGED)) {
                this.d_bPointTool.markNativeDirty();
                updateOrigin = true;
                updateToolDisplay = true;
            }
            if (changes.contains(BGImageBuilder.AB_ANGLE_CHANGED)) {
                updateOrigin = true;
            }
            if (changes.contains(BGImageBuilder.AB_DIST_CHANGED)) {
                updateOrigin = true;
                updateToolDisplay = true;
            }
            if (changes.contains(BGImageBuilder.OPACITY_CHANGED)) {
                this.d_imageDisplay.setColor(new Color(1.0f, 1.0f, 1.0f, this.d_builder.getOpacity()));
            }
            if (updateToolDisplay) {
                this.updateDisplays();
            }
            if (updateOrigin) {
                this.updateOrigin();
            }
            this.d_mainView.getSurface().repaint();
        }

        private void updateDisplays() {
            Point2d a;
            Color color = COMMITTED_COLOR;
            ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
            PropsBuilder gprops = new PropsBuilder();
            this.d_anchorRenderer.setVisible(this.d_builder.isAnchorImageCommitted());
            if (this.d_builder.isAnchorImageCommitted()) {
                Point2d anchor = this.d_builder.getAnchorImage();
                geoms.add(new Point(new Point3d(anchor.x, anchor.y, 0.0)));
                gprops.add(new IPrimProps.Vertex(color, 5.0));
                String text = this.d_anchorTool.toString();
                this.d_anchorRenderer.setString(text);
                this.d_anchorRenderer.setLocation(new Point3d(anchor.x, anchor.y, 0.0), null);
            }
            this.d_aRenderer.setVisible(this.d_builder.isACommitted());
            if (this.d_builder.isACommitted()) {
                a = this.d_builder.getAImage();
                geoms.add(new Point(new Point3d(a.x, a.y, 0.0)));
                gprops.add(new IPrimProps.Vertex(color, 5.0));
                this.d_aRenderer.setLocation(new Point3d(a.x, a.y, 0.0), null);
            }
            this.d_bRenderer.setVisible(this.d_builder.isBCommitted());
            if (this.d_builder.isBCommitted()) {
                Point2d b = this.d_builder.getBImage();
                geoms.add(new Point(new Point3d(b.x, b.y, 0.0)));
                gprops.add(new IPrimProps.Vertex(color, 5.0));
                this.d_bRenderer.setLocation(new Point3d(b.x, b.y, 0.0), null);
            }
            this.d_distRenderer.setVisible(this.d_builder.getAImage() != null && this.d_builder.getBImage() != null);
            if (this.d_builder.getAImage() != null && this.d_builder.getBImage() != null) {
                a = this.d_builder.getAImage();
                Point2d b = this.d_builder.getBImage();
                LineSeg ls = new LineSeg(new Point3d(a.x, a.y, 0.0), new Point3d(b.x, b.y, 0.0));
                geoms.add(ls);
                gprops.add(new IPrimProps.Edge(color, 3.0));
                this.d_distRenderer.setString(this.d_builder.getDistABModel().toString());
                this.d_distRenderer.setLocation(Util3D.getMidPoint(ls.p1, ls.p2), null);
            }
            GeomGroup geom = new GeomGroup(geoms);
            DisplayGeom dg = new DisplayGeom((IGeom)geom, gprops.finalizeProps());
            ((ConstGeomSrc)this.d_toolDisplay.getSource()).setGeom(dg);
            this.d_toolDisplay.update();
        }

        private void updateOrigin() {
            Matrix4d xform;
            if (this.d_builder.getAnchorImage() == null || this.d_builder.getAnchorModel() == null) {
                xform = new Matrix4d();
                xform.setIdentity();
            } else {
                BGImageXform bgxform = BGImageDlg.generateTransform(this.d_builder.getAnchorImage(), this.d_builder.getAnchorModel(), this.d_builder.getAImage(), this.d_builder.getBImage(), this.d_builder.getDistABModel(), this.d_builder.getABAngle());
                xform = bgxform.toMatrix();
                xform.invert();
            }
            this.d_origin.setTransform(xform);
        }

        public void registerGraphics(IntermediateGraphicsXfer igx) {
            if (igx != null) {
                String name = this.d_builder.getName();
                igx.registerGraphics(name, this.d_imageDisplay);
            }
        }

        public ToolManager getToolManager() {
            return this.d_tools;
        }

        public guiStatusBar getStatusBar() {
            return this.d_statusBar;
        }

        public JToolBar getEditToolbar() {
            return this.d_editToolbar;
        }

        public AnchorTool getAnchorTool() {
            return this.d_anchorTool;
        }

        public APointTool getAPointTool() {
            return this.d_aPointTool;
        }

        public BPointTool getBPointTool() {
            return this.d_bPointTool;
        }

        public void resetCamera() {
            OrthoCamera c = this.d_camera;
            AABox bb = this.d_imageDisplay.getBoundingBox();
            bb = c.ensureValidForReset(bb, 5.0);
            c.reset(bb, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }

        private void updateCurrentTool() {
            Tool tool = this.d_tools.getCurrentTool();
            if (tool instanceof CursorTool) {
                CursorTool ctool = (CursorTool)tool;
                ctool.setView(this.d_mainView);
                this.d_toolLayer.clear();
                this.d_toolLayer.add(ctool);
            }
        }

        @Override
        public Unit[] getLengthUnits() {
            return new Unit[]{Unit.ONE, Unit.ONE};
        }

        private class ResetAction
        extends guiAction {
            private static final long serialVersionUID = 1441942531684678815L;

            public ResetAction() {
                super(Intl.intl("Reset View"), guiUtil.loadTeciIcon("ZoomFit16.gif"));
                this.putValue("ShortDescription", Intl.intl("Reset View"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('r'));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('R'));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageEditor.this.resetCamera();
                ImageEditor.this.d_renderComp.repaint();
            }
        }

        private class AnchorTool
        extends PointTool {
            public AnchorTool() {
                super(0, Intl.intl("Anchor"));
            }

            @Override
            protected void setPoint(Point2d anchorImage, boolean commit) {
                ImageEditor.this.d_builder.setAnchorImage(anchorImage, commit);
            }

            @Override
            protected Point2d getPoint() {
                return ImageEditor.this.d_builder.getAnchorImage();
            }

            @Override
            public String toString() {
                if (ImageEditor.this.d_builder.getAnchorModel() != null) {
                    UnitPoint3D amod = ImageEditor.this.d_builder.getAnchorModel().convert(ImageEditor.this.d_displayLenUnit);
                    String amodstr = String.format("(%s, %s, %s) %s", Global.format(amod.x()), Global.format(amod.y()), Global.format(amod.z()), amod.getUnit().toString());
                    return super.toString() + " " + amodstr;
                }
                return super.toString();
            }
        }

        private class APointTool
        extends PointTool {
            public APointTool() {
                super(1, "A");
            }

            @Override
            protected void setPoint(Point2d aImage, boolean commit) {
                if (!aImage.equals(ImageEditor.this.d_bPointTool.getPoint())) {
                    ImageEditor.this.d_builder.setAImage(aImage, commit);
                }
            }

            @Override
            protected Point2d getPoint() {
                return ImageEditor.this.d_builder.getAImage();
            }

            @Override
            protected String getStatusMessage() {
                if (ImageEditor.this.d_builder.getAImage() != null && ImageEditor.this.d_builder.getBImage() != null && ImageEditor.this.d_builder.getAImage().equals(ImageEditor.this.d_builder.getBImage())) {
                    return Intl.intl("Setting A and B to the same location causes an undefined scale factor.");
                }
                return super.getStatusMessage();
            }
        }

        private class BPointTool
        extends PointTool {
            public BPointTool() {
                super(2, "B");
            }

            @Override
            protected void setPoint(Point2d bImage, boolean commit) {
                if (!bImage.equals(ImageEditor.this.d_aPointTool.getPoint())) {
                    // empty if block
                }
                ImageEditor.this.d_builder.setBImage(bImage, commit);
            }

            @Override
            protected Point2d getPoint() {
                return ImageEditor.this.d_builder.getBImage();
            }

            @Override
            protected String getStatusMessage() {
                if (ImageEditor.this.d_builder.getAImage() != null && ImageEditor.this.d_builder.getBImage() != null && ImageEditor.this.d_builder.getAImage().equals(ImageEditor.this.d_builder.getBImage())) {
                    return Intl.intl("Setting A and B to the same location causes an undefined scale factor.");
                }
                return super.getStatusMessage();
            }
        }

        private static class ConstGeomSrc
        implements IGeomSource {
            private boolean d_visible = true;
            private DisplayGeom d_geom = DisplayGeom.EMPTY;

            private ConstGeomSrc() {
            }

            @Override
            public DisplayGeom getDisplayGeom(IDisplayProps props) {
                return this.d_geom;
            }

            public void setGeom(DisplayGeom dg) {
                this.d_geom = dg;
            }

            @Override
            public boolean isVisible() {
                return this.d_visible;
            }

            @Override
            public void setVisible(boolean visible) {
                this.d_visible = visible;
            }
        }

        public static interface EditPointSetListener {
            public static final int EDIT_POINT_ANCHOR = 0;
            public static final int EDIT_POINT_A = 1;
            public static final int EDIT_POINT_B = 2;

            public void editPointSet(int var1, Point2d var2);
        }

        private abstract class PointTool
        extends CursorTool {
            private int d_editEvent;
            private String d_text;

            public PointTool(int editEvent, String text) {
                super(ImageEditor.this, new ToolFunc());
                this.d_text = "";
                this.d_editEvent = editEvent;
                this.d_text = text;
            }

            protected abstract Point2d getPoint();

            protected abstract void setPoint(Point2d var1, boolean var2);

            public String toString() {
                return this.d_text;
            }

            @Override
            protected String getStatusMessage() {
                return Intl.intl("Image Position") + ": (" + Global.format(this.getP1().referenceSnap.x) + "," + Global.format(this.getP1().referenceSnap.y) + ")";
            }

            protected void updateDisplay(Point3d currentPointWorld) {
                String str = this.toString();
                ImageEditor.this.d_toolTextRenderer.setString(str);
                ImageEditor.this.d_toolTextRenderer.setLocation(new Point3d(currentPointWorld.x, currentPointWorld.y, 0.0), null);
            }

            protected void updatePoint(Point3d currentPointWorld, boolean commit) {
                Point2d pointImage = new Point2d(currentPointWorld.x, currentPointWorld.y);
                this.setPoint(pointImage, commit);
                this.updateDisplay(currentPointWorld);
            }
        }

        private class ToolFunc
        extends AToolFunction<PointTool> {
            private ToolFunc() {
            }

            @Override
            public Cursor getCursor(PointTool tool) {
                return null;
            }

            @Override
            public void mouseEntered(PointTool tool, MouseEvent e) {
                ImageEditor.this.d_toolTextRenderer.setVisible(true);
            }

            @Override
            public void mouseExited(PointTool tool, MouseEvent e) {
                ImageEditor.this.d_toolTextRenderer.setVisible(false);
            }

            @Override
            public void mousePressed(PointTool tool, MouseEvent e) {
                tool.updatePoint(tool.getP0().referenceSnap, false);
            }

            @Override
            public void mouseReleased(PointTool tool, MouseEvent e) {
                tool.updatePoint(tool.getP1().referenceSnap, true);
            }

            @Override
            public void mouseDragged(PointTool tool, MouseEvent e) {
                tool.updatePoint(tool.getP1().referenceSnap, false);
            }

            @Override
            public void mouseMoved(PointTool tool, MouseEvent e) {
                tool.updateDisplay(tool.getP1().referenceSnap);
            }
        }
    }

    public static class ImageInfo {
        public final Image image;
        public final BGImageXform xform;
        public final float opacity;

        public ImageInfo(Image image, BGImageXform xform, float opacity) {
            this.image = image;
            this.xform = xform;
            this.opacity = opacity;
        }
    }

    private class ComponentPair
    extends guiPanel {
        private static final long serialVersionUID = -1461631803827397214L;

        public ComponentPair(Component left, Component right, boolean spreadEm) {
            this.setLayout(new GridBagLayout());
            if (spreadEm) {
                GridBagUtil.add(this, left, 1, 1, 1, 1, 0, 0, 0, 6, 3, 0.0, 1.0, 17);
                GridBagUtil.add(this, right, 2, 1, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
            } else {
                GridBagUtil.add(this, left, 1, 1, 1, 1, 0, 0, 0, 6, 3, 0.0, 1.0, 17);
                GridBagUtil.add(this, right, 2, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
            }
        }
    }

    private static abstract class FldListener
    implements KeyListener,
    FocusListener {
        private guiValueField[] d_fields;

        protected abstract void updateToProps();

        public FldListener(guiValueField ... fields) {
            this.d_fields = fields;
            this.addAsListener();
        }

        private void addAsListener() {
            for (guiValueField field : this.d_fields) {
                field.addKeyListener(this);
                field.addFocusListener(this);
            }
        }

        private void removeAsListener() {
            for (guiValueField field : this.d_fields) {
                field.addKeyListener(this);
                field.removeFocusListener(this);
            }
        }

        private void update(boolean hardValidate) {
            for (guiValueField field : this.d_fields) {
                if (field.validateData(hardValidate, hardValidate)) continue;
                return;
            }
            this.updateToProps();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                this.update(true);
                for (guiValueField field : this.d_fields) {
                    field.setSelectionStart(0);
                    field.setSelectionEnd(field.getDocument().getLength());
                }
                e.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary() && e.getOppositeComponent() != null && e.getSource() instanceof Validateable && ((Validateable)e.getSource()).validateData(true, true)) {
                this.update(false);
            }
        }
    }
}

