/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.license2.crypkey;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiTFWithButton;
import pyrosim.legacy_2012_1.thunderheadeng.license2.ClipboardTextArea;
import pyrosim.legacy_2012_1.thunderheadeng.license2.crypkey.CrypKeyAPI;
import pyrosim.legacy_2012_1.thunderheadeng.license2.crypkey.CrypKeyLM;

public class RegisterDlg
extends guiDialog {
    private static final long serialVersionUID = -3206296867240781625L;
    private guiTFWithButton d_siteCodeField;
    private guiTFWithButton d_siteKeyField;
    private CrypKeyLM d_ck;

    public RegisterDlg(JFrame parentFrame, CrypKeyLM mgr) {
        super((Window)parentFrame, Intl.intl("Register"), 9);
        this.d_ck = mgr;
    }

    @Override
    public int doModal() {
        guiPanel c = this.getDialogPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(c, new MultiLineLabel(this.d_ck.getLicenseDesc()), 0, row++, 3, 1, 6, 0, 0, 0);
        GridBagUtil.add(c, new guiLabel(Intl.intl("Site Code:")), 0, row, 1, 1, 12, 0, 0, 0, 0, 0.0, 0.0, 17);
        this.d_siteCodeField = new guiTFWithButton(new ClipboardTextArea(CrypKeyAPI.getSiteCode2()));
        this.d_siteCodeField.getTextField().setEditable(false);
        this.d_siteCodeField.setButtonCommand(new guiTFWithButton.CopyCmd(this.d_siteCodeField.getTextField()));
        this.d_siteCodeField.setPreferredSize(new Dimension(300, this.d_siteCodeField.getPreferredSize().height));
        GridBagUtil.add(c, this.d_siteCodeField, 1, row++, 2, 1, 12, 12, 0, 0, 2, 1.0, 1.0);
        GridBagUtil.add(c, new guiLabel(Intl.intl("Site Key:")), 0, row, 1, 1, 12, 0, 0, 0, 0, 0.0, 0.0, 17);
        this.d_siteKeyField = new guiTFWithButton(new ClipboardTextArea());
        this.d_siteKeyField.setButtonCommand(new guiTFWithButton.PasteCmd(this.d_siteKeyField.getTextField()));
        GridBagUtil.add(c, this.d_siteKeyField, 1, row, 1, 1, 12, 12, 0, 0, 2, 1.0, 1.0, 17);
        int status = super.doModal();
        if (status == 1) {
            if (this.register()) {
                return 1;
            }
            return 8;
        }
        return status;
    }

    public boolean register() {
        super.validateData(true, true);
        int err = CrypKeyAPI.saveSiteKey(this.d_siteKeyField.getTextField().getValue());
        if (err != 0) {
            String crypError = CrypKeyAPI.explainErr(3, err);
            JOptionPane.showMessageDialog(null, "Software Licensing Error (" + err + ").\n" + crypError, "Access Denied", 0);
            return false;
        }
        if (this.d_ck.isAuthorized()) {
            String message = Intl.intl("Registration Successful.") + "\n\n" + this.d_ck.getLicenseDesc();
            JOptionPane.showMessageDialog(null, message, Intl.intl("Thank You"), 1);
            return true;
        }
        String message = this.d_ck.getError();
        JOptionPane.showMessageDialog(this, message, "Access Denied", 1);
        return false;
    }
}

