/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io;

import java.util.Enumeration;
import java.util.Properties;
import pyrosim.legacy_2012_1.thunderheadeng.util.Queue.UniqQImpl;

public class MRUFileList {
    private static final int DefaultMaxEntries = 4;
    public static final String DefaultPrefixString = "MRU.";
    private static final String FILE_NUM_STR = "FILE_";
    public static final String NUM_ENTRIES_STR = "MAX_ENTRIES";
    private String d_prefix = "MRU.";
    private int d_maxEntries = 4;
    UniqQImpl d_entries = new UniqQImpl(this.d_maxEntries);

    public void setMaxEntries(int maxEntries) {
        this.d_maxEntries = maxEntries;
        this.d_entries.setMaxSize(this.d_maxEntries);
    }

    public int getMaxEntries() {
        return this.d_maxEntries;
    }

    public void setEntryPrefix(String prefix) {
        this.d_prefix = prefix;
    }

    public String getEntryPrefix() {
        return this.d_prefix;
    }

    public void usedFile(String filename) {
        this.d_entries.insertFirst(filename);
    }

    public void removeFile(String filename) {
        this.d_entries.removeElement(filename);
    }

    public int getNumEntries() {
        return this.d_entries.size();
    }

    public String getFilename(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.d_entries.size()) {
            return null;
        }
        Enumeration e = this.d_entries.elements();
        for (int i = 0; i < entryIndex; ++i) {
            e.nextElement();
        }
        return (String)e.nextElement();
    }

    public String[] getFileList() {
        String[] results = new String[this.d_entries.size()];
        Enumeration e = this.d_entries.elements();
        for (int i = 0; e.hasMoreElements() && i < this.d_maxEntries; ++i) {
            results[i] = (String)e.nextElement();
        }
        return results;
    }

    public void load(Properties props) {
        String numStr = props.getProperty(this.d_prefix + NUM_ENTRIES_STR);
        if (numStr != null) {
            try {
                this.setMaxEntries(Integer.parseInt(numStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.loadEntries(props);
    }

    public void store(Properties props) {
        props.setProperty(this.d_prefix + NUM_ENTRIES_STR, Integer.toString(this.getMaxEntries()));
        this.saveEntries(props);
    }

    private void loadEntries(Properties props) {
        String name;
        this.d_entries.clear();
        for (int i = 1; i <= this.d_maxEntries && (name = props.getProperty(this.d_prefix + FILE_NUM_STR + i)) != null; ++i) {
            this.d_entries.insertLast(name);
        }
    }

    private void saveEntries(Properties props) {
        String name;
        Enumeration e = this.d_entries.elements();
        int i = 1;
        while (e.hasMoreElements() && i <= this.d_maxEntries) {
            name = (String)e.nextElement();
            props.setProperty(this.d_prefix + FILE_NUM_STR + i++, name);
        }
        while ((name = props.getProperty(this.d_prefix + FILE_NUM_STR + i)) != null) {
            props.remove(this.d_prefix + FILE_NUM_STR + i);
            ++i;
        }
    }
}

