/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PlanarSurface
extends AFace {
    private static final long serialVersionUID = 1L;
    public final Plane3d plane;
    private static final AABox s_infBox = new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public PlanarSurface(Plane3d plane) {
        this.plane = plane;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.PlanarSurface((thunderheadeng.geometry.Plane3d)dict.get(this.plane));
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        boolean x0 = theUtil.eq0(this.plane.x, 1.0E-9);
        boolean y0 = theUtil.eq0(this.plane.y, 1.0E-9);
        if (x0 && y0) {
            aabb.add(new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.z * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.z * this.plane.w));
            return aabb;
        }
        boolean z0 = theUtil.eq0(this.plane.z, 1.0E-9);
        if (x0 && z0) {
            aabb.add(new AABox(Double.NEGATIVE_INFINITY, -this.plane.y * this.plane.w, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.y * this.plane.w, Double.POSITIVE_INFINITY));
            return aabb;
        }
        if (y0 && z0) {
            aabb.add(new AABox(-this.plane.x * this.plane.w, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.x * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            return aabb;
        }
        aabb.add(s_infBox);
        return aabb;
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IFace optimize(IPointOptimizer pool) {
        return this;
    }

    @Override
    public IFace transform(Matrix4d xform) {
        return new PlanarSurface(this.plane.transformBy(xform));
    }

    @Override
    public Mesh triangulate(double errorTol) {
        return new Mesh(new Point3d[0], new int[0], 2);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        if (filter.acceptGeomType(source, GeomType.FACE)) {
            // empty if block
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Point3d p;
        if (filter.acceptGeomType(source, GeomType.FACE) && (p = Inter3D.lineSegPlaneIntersection(rayBegin, rayEnd, this.plane, 1.0E-6)) != null) {
            isects.add(source, p, GeomType.FACE, this);
        }
    }

    @Override
    public Point3d project(Point3d p) {
        return this.plane.projectOntoPlane(p);
    }

    @Override
    public IFace.PointClassify classify(Point3d p, double tol) {
        return IFace.PointClassify.INSIDE;
    }
}

