/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.MeshBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.AModelObj;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.CloneMap;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.FaceLoop;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.NmtUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Triangulation;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Vertex;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Face
extends AModelObj {
    static final long serialVersionUID = 1L;
    public static final int ORIENT_NONE = 0;
    public static final int ORIENT_CCW = 1;
    public static final int ORIENT_CW = 2;
    public Plane3d plane;
    public List<FaceLoop> edgeLoops;
    private transient AABox d_cachedBounds = null;
    private transient Set<Edge> d_internalEdges = null;

    public Face(Plane3d plane, List<FaceLoop> edgeLoops, boolean calcInternalEdges) {
        this.plane = plane;
        this.edgeLoops = new ArrayList<FaceLoop>(edgeLoops);
        if (!this.isValid()) {
            System.err.println("6 Invalid face orient");
        }
        if (calcInternalEdges) {
            this.recalcInternalEdges();
        } else {
            this.d_internalEdges = new IdentityHashSet<Edge>();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.recalcInternalEdges();
    }

    public boolean isInternalEdge(Edge edge) {
        return this.getInternalEdges().contains(edge);
    }

    private Set<Edge> calcInternalEdges() {
        IdentityHashSet<Edge> internalEdges = new IdentityHashSet<Edge>();
        IdentityHashSet encounteredEdges = new IdentityHashSet();
        for (FaceLoop loop : this.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                if (encounteredEdges.add(eu.edge)) continue;
                internalEdges.add(eu.edge);
            }
        }
        return internalEdges;
    }

    public boolean checkInternalEdgesCorrect() {
        return this.calcInternalEdges().equals(this.d_internalEdges);
    }

    public Set<Edge> getInternalEdges() {
        return this.d_internalEdges;
    }

    public void calcPlane() {
        Plane3d newPlane = NmtUtil.calcLoopPlane(this.edgeLoops.get((int)0).edges);
        if (newPlane == null) {
            System.err.println("0x83229f Could not calculate plane");
        } else {
            this.plane = newPlane;
        }
    }

    public void flipOrient() {
        this.plane.negateEq();
        for (FaceLoop loop : this.edgeLoops) {
            loop.flipOrient();
        }
    }

    public double getArea() {
        double area = 0.0;
        for (FaceLoop loop : this.edgeLoops) {
            area += NmtUtil.loopArea(loop.edges, this.plane);
        }
        return Math.abs(area);
    }

    public boolean isValid() {
        return true;
    }

    public Face clone(CloneMap cloneMap) {
        Face clone = (Face)this.clone();
        clone.edgeLoops = new ArrayList<FaceLoop>(this.edgeLoops.size());
        for (FaceLoop loop : this.edgeLoops) {
            clone.edgeLoops.add(loop.clone(cloneMap));
        }
        clone.d_internalEdges = new IdentityHashSet<Edge>();
        for (Edge iedge : this.d_internalEdges) {
            clone.d_internalEdges.add(cloneMap.get(iedge));
        }
        if (!clone.isValid()) {
            System.err.println("129 Invalid face orient");
        }
        return clone;
    }

    @Override
    public AABox getBounds() {
        if (this.d_cachedBounds == null) {
            AABox bb = new AABox();
            FaceLoop outerLoop = this.outerLoop();
            for (EdgeUse eu : outerLoop.edges) {
                bb.add(eu.edge.getBounds());
            }
            this.d_cachedBounds = bb;
        }
        return this.d_cachedBounds;
    }

    public AABox getLocalBounds() {
        Matrix4d wlXform = Util.getWorldToLocalXform(this.plane);
        AABox worldBounds = this.getBounds();
        AABox localBounds = new AABox();
        localBounds.add(Util3D.xform(wlXform, worldBounds.mmm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.mmM()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.mMm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.mMM()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.Mmm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.MmM()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.MMm()));
        localBounds.add(Util3D.xform(wlXform, worldBounds.MMM()));
        return localBounds;
    }

    public void invalidateBounds() {
        this.d_cachedBounds = null;
    }

    public void recalcInternalEdges() {
        this.d_internalEdges = this.calcInternalEdges();
    }

    public void addInternalEdge(Edge edge) {
        this.getInternalEdges().add(edge);
    }

    public void removeInternalEdge(Edge edge) {
        this.getInternalEdges().remove(edge);
    }

    public void clearConnections() {
        for (FaceLoop loop : this.edgeLoops) {
            loop.removeFace(this);
        }
    }

    public void buildConnections() {
        for (FaceLoop loop : this.edgeLoops) {
            loop.addFace(this);
        }
    }

    public FaceLoop outerLoop() {
        assert (!this.edgeLoops.isEmpty());
        return this.edgeLoops.get(0);
    }

    public List<EdgeUse> getEdges() {
        int count = 0;
        for (int m = 0; m < this.edgeLoops.size(); ++m) {
            count += this.edgeLoops.get((int)m).edges.size();
        }
        ArrayList<EdgeUse> edges = new ArrayList<EdgeUse>(count);
        for (int m = 0; m < this.edgeLoops.size(); ++m) {
            edges.addAll(this.edgeLoops.get((int)m).edges);
        }
        return edges;
    }

    public Triangulation triangulate(double minEdgeAngleDeg) {
        LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> resultTris = new ArrayList<Integer>();
        this.triangulate(minEdgeAngleDeg, pointIxMap, resultTris);
        return new Triangulation(pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]), theUtil.toIntArray(resultTris));
    }

    public boolean triangulate(double minEdgeAngleDeg, Map<Point3d, Integer> pointIxMap, List<Integer> resultTris) {
        int m;
        int toptions;
        HashMap<Point2d, Vertex> localVertMap = new HashMap<Point2d, Vertex>();
        Matrix4d wlXform = Util.getWorldToLocalXform(this.plane);
        Matrix4d lwXform = Util.getLocalToWorldXform(this.plane);
        MeshBuilder mb = new MeshBuilder(1.0E-6);
        for (FaceLoop loop : this.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                Point2d p1 = Util3D.xform2d(wlXform, eu.v1().loc);
                Point2d p2 = Util3D.xform2d(wlXform, eu.v2().loc);
                localVertMap.put(p1, eu.v1());
                localVertMap.put(p2, eu.v2());
                mb.addEdge(p1, p2);
            }
        }
        Mesh mesh = mb.build();
        boolean triangulated = mesh.triangulateEvenOdd(toptions = minEdgeAngleDeg > 0.0 ? 1 : 0, minEdgeAngleDeg);
        if (!triangulated) {
            return false;
        }
        TriangulatorInfo result = mesh.getOutput();
        int[] localWorldIxes = new int[result.points.length];
        for (m = 0; m < result.points.length; ++m) {
            Point3d p3d;
            Point2d p2d = result.points[m];
            Vertex vert = (Vertex)localVertMap.get(p2d);
            if (vert != null) {
                p3d = vert.loc;
            } else {
                p3d = new Point3d(p2d.x, p2d.y, 0.0);
                lwXform.transform(p3d);
            }
            Integer ix = pointIxMap.get(p3d);
            if (ix == null) {
                ix = pointIxMap.size();
                pointIxMap.put(p3d, ix);
            }
            localWorldIxes[m] = ix;
        }
        for (m = 0; m < result.triangles.length; ++m) {
            result.triangles[m] = localWorldIxes[result.triangles[m]];
        }
        resultTris.addAll(Arrays.asList(theUtil.toIntArray(result.triangles)));
        return true;
    }
}

