/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.View;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Util {
    public static final double DBL_EPSILON = 1.0E-9;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    private static final Vector3d s_worldX = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d s_worldY = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d s_worldZ = new Vector3d(0.0, 0.0, 1.0);
    private static final Plane3d s_zPlane = new Plane3d(0.0, 0.0, 1.0, 0.0);

    public static double metersToFeet(double val) {
        return SI.METER.getConverterTo(NonSI.FOOT).convert(val);
    }

    public static double feetToMeters(double val) {
        return NonSI.FOOT.getConverterTo(SI.METER).convert(val);
    }

    public static double inchesToMeters(double val) {
        return NonSI.INCH.getConverterTo(SI.METER).convert(val);
    }

    public static double metersToInches(double val) {
        return SI.METER.getConverterTo(NonSI.INCH).convert(val);
    }

    public static double[] rectify(double ... vals) {
        assert (vals.length == 2);
        if (vals[0] > vals[1]) {
            double temp = vals[1];
            vals[1] = vals[0];
            vals[0] = temp;
        }
        return vals;
    }

    public static double clampT(double t, double min, double max) {
        assert (min <= max);
        if (t < min) {
            return min;
        }
        if (t > max) {
            return max;
        }
        return t;
    }

    public static void clampTs(double[] t, double min, double max) {
        assert (min <= max);
        for (int m = 0; m < t.length; ++m) {
            if (t[m] < min) {
                t[m] = min;
                continue;
            }
            if (!(t[m] > max)) continue;
            t[m] = max;
        }
    }

    public static double[] clampTRange(double t1, double t2) {
        if (t1 > t2) {
            double temp = t1;
            t1 = t2;
            t2 = temp;
        }
        if (t1 < 0.0) {
            t1 = 0.0;
        }
        if (t2 > 1.0) {
            t2 = 1.0;
        }
        return new double[]{t1, t2};
    }

    public static boolean checkRange(double mint, double maxt, double t, double tolerance) {
        return theUtil.ge(t, mint, tolerance) && theUtil.le(t, maxt, tolerance);
    }

    public static double clampTIfValid(double t, double min, double max, double tolerance) {
        if (t >= max && t - max <= tolerance) {
            return max;
        }
        if (t <= min && min - t <= tolerance) {
            return min;
        }
        return t < min || t > max ? Double.NaN : t;
    }

    public static boolean clampTIfValid(double[] ts, double min, double max, double tolerance) {
        for (int m = 0; m < ts.length; ++m) {
            double t = ts[m];
            if (t >= max && t - max <= tolerance) {
                ts[m] = max;
            } else if (t <= min && min - t <= tolerance) {
                ts[m] = min;
            }
            if (!(ts[m] < min) && !(ts[m] > max)) continue;
            return false;
        }
        return true;
    }

    public static Matrix4d rotMatZ(double angle) {
        Matrix4d mat = new Matrix4d();
        mat.rotZ(angle);
        return mat;
    }

    public static Matrix4d rotMat(double x, double y, double z, double angle) {
        AxisAngle4d aangle = new AxisAngle4d(x, y, z, angle);
        Matrix4d mat = new Matrix4d();
        mat.set(aangle);
        return mat;
    }

    public static Matrix4d scaleMat(double sx, double sy, double sz) {
        Matrix4d mat = new Matrix4d();
        mat.m00 = sx;
        mat.m11 = sy;
        mat.m22 = sz;
        mat.m33 = 1.0;
        return mat;
    }

    public static Matrix4d translateMat(double x, double y, double z) {
        Matrix4d mat = new Matrix4d();
        mat.m03 = x;
        mat.m13 = y;
        mat.m23 = z;
        mat.m33 = 1.0;
        mat.m22 = 1.0;
        mat.m11 = 1.0;
        mat.m00 = 1.0;
        return mat;
    }

    public static Matrix4d mirrorMat(double px, double py, double pz, double pw) {
        double px2 = 2.0 * px;
        double py2 = 2.0 * py;
        double pz2 = 2.0 * pz;
        return new Matrix4d(1.0 - px2 * px, -px2 * py, -px2 * pz, -px2 * pw, -py2 * px, 1.0 - py2 * py, -py2 * pz, -py2 * pw, -pz2 * px, -pz2 * py, 1.0 - pz2 * pz, -pz2 * pw, 0.0, 0.0, 0.0, 1.0);
    }

    public static int getClosestAxis(Vector3d vec) {
        double closestOneDiff;
        int closestAxis;
        Vector3d vecNorm = new Vector3d();
        vecNorm.normalize(vec);
        double xdot = vecNorm.dot(s_worldX);
        double ydot = vecNorm.dot(s_worldY);
        double zdot = vecNorm.dot(s_worldZ);
        double xdotOneDiff = Math.abs(Math.abs(xdot) - 1.0);
        double ydotOneDiff = Math.abs(Math.abs(ydot) - 1.0);
        double zdotOneDiff = Math.abs(Math.abs(zdot) - 1.0);
        if (xdotOneDiff < ydotOneDiff) {
            closestAxis = 0;
            closestOneDiff = xdotOneDiff;
        } else {
            closestAxis = 1;
            closestOneDiff = ydotOneDiff;
        }
        if (zdotOneDiff < closestOneDiff) {
            closestAxis = 2;
        }
        return closestAxis;
    }

    public static Point3d getClosestPoint(View view, Point3d point, double toleranceScreen, Point3d ... testPoints) {
        return Util.getClosestPoint(view, point, toleranceScreen, Arrays.asList(testPoints));
    }

    public static Point3d getClosestPoint(View view, Point3d point, double toleranceScreen, Collection<Point3d> testPoints) {
        Point3d pointSc = view.worldToScreen(point);
        double tolSq = toleranceScreen * toleranceScreen;
        Point3d closestPoint = null;
        double closestDistSq = tolSq;
        for (Point3d testPoint : testPoints) {
            if (testPoint == null) continue;
            Point3d testPointSc = view.worldToScreen(testPoint);
            double dx = testPointSc.x - pointSc.x;
            double dy = testPointSc.y - pointSc.y;
            double distSq = dx * dx + dy * dy;
            if (!(distSq <= closestDistSq)) continue;
            closestDistSq = distSq;
            closestPoint = testPoint;
        }
        return closestPoint;
    }

    private static void getLocalAxes(Plane3d plane, Vector3d lx, Vector3d ly, Vector3d lz) {
        plane.getNormal(lz);
        if (Math.abs(lz.x) < 0.015625 && Math.abs(lz.y) < 0.015625) {
            lx.cross(s_worldY, lz);
        } else {
            lx.cross(s_worldZ, lz);
        }
        lx.normalize();
        ly.cross(lz, lx);
        ly.normalize();
    }

    public static Matrix4d getWorldToLocalXform(Plane3d localPlane) {
        Vector3d lx = new Vector3d();
        Vector3d lz = new Vector3d();
        Vector3d ly = new Vector3d();
        Util.getLocalAxes(localPlane, lx, ly, lz);
        double xmove = lz.x * localPlane.w;
        double ymove = lz.y * localPlane.w;
        double zmove = lz.z * localPlane.w;
        return new Matrix4d(lx.x, lx.y, lx.z, lx.x * xmove + lx.y * ymove + lx.z * zmove, ly.x, ly.y, ly.z, ly.x * xmove + ly.y * ymove + ly.z * zmove, lz.x, lz.y, lz.z, lz.x * xmove + lz.y * ymove + lz.z * zmove, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4d getLocalToWorldXform(Plane3d localPlane) {
        Vector3d lx = new Vector3d();
        Vector3d lz = new Vector3d();
        Vector3d ly = new Vector3d();
        Util.getLocalAxes(localPlane, lx, ly, lz);
        double xmove = -lz.x * localPlane.w;
        double ymove = -lz.y * localPlane.w;
        double zmove = -lz.z * localPlane.w;
        return new Matrix4d(lx.x, ly.x, lz.x, xmove, lx.y, ly.y, lz.y, ymove, lx.z, ly.z, lz.z, zmove, 0.0, 0.0, 0.0, 1.0);
    }

    public static Plane3d getPlane(Matrix4d localToWorldXform) {
        return s_zPlane.transformBy(localToWorldXform);
    }
}

