/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Point3f;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class AABoxf
implements Serializable,
Cloneable,
ISearchVol,
ITest<AABoxf> {
    static final long serialVersionUID = 1L;
    public static final float VOL_EPS = 1.1920929E-7f;
    private float d_minx;
    private float d_miny;
    private float d_minz;
    private float d_maxx;
    private float d_maxy;
    private float d_maxz;

    public AABoxf() {
        this(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    public AABoxf(AABoxf box) {
        this(box.d_minx, box.d_miny, box.d_minz, box.d_maxx, box.d_maxy, box.d_maxz);
    }

    public AABoxf(Point3f min, Point3f max) {
        this.set(min, max);
    }

    public AABoxf(float minx, float miny, float minz, float maxx, float maxy, float maxz) {
        this.d_minx = minx;
        this.d_miny = miny;
        this.d_minz = minz;
        this.d_maxx = maxx;
        this.d_maxy = maxy;
        this.d_maxz = maxz;
    }

    public AABoxf(Point3f ... points) {
        this();
        this.add(points);
    }

    public float getWidth() {
        return this.d_maxx - this.d_minx;
    }

    public float getDepth() {
        return this.d_maxy - this.d_miny;
    }

    public float getHeight() {
        return this.d_maxz - this.d_minz;
    }

    public static AABoxf infinite() {
        return new AABoxf(new Point3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY), new Point3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.d_minx) || Float.isInfinite(this.d_miny) || Float.isInfinite(this.d_minz) || Float.isInfinite(this.d_maxx) || Float.isInfinite(this.d_maxy) || Float.isInfinite(this.d_maxz);
    }

    public void reset() {
        this.d_minz = Float.MAX_VALUE;
        this.d_miny = Float.MAX_VALUE;
        this.d_minx = Float.MAX_VALUE;
        this.d_maxz = -3.4028235E38f;
        this.d_maxy = -3.4028235E38f;
        this.d_maxx = -3.4028235E38f;
    }

    @Override
    public boolean isValid() {
        return this.d_minx <= this.d_maxx && this.d_miny <= this.d_maxy && this.d_minz <= this.d_maxz;
    }

    public void set(Point3f min, Point3f max) {
        this.d_minx = min.x;
        this.d_miny = min.y;
        this.d_minz = min.z;
        this.d_maxx = max.x;
        this.d_maxy = max.y;
        this.d_maxz = max.z;
    }

    public void set(float minx, float miny, float minz, float maxx, float maxy, float maxz) {
        this.d_minx = minx;
        this.d_miny = miny;
        this.d_minz = minz;
        this.d_maxx = maxx;
        this.d_maxy = maxy;
        this.d_maxz = maxz;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AABoxf{");
        sb.append(this.getMin().toString() + " --> ");
        sb.append(this.getMax().toString() + "}");
        return sb.toString();
    }

    public Point3f getCenter() {
        return new Point3f((this.d_minx + this.d_maxx) * 0.5f, (this.d_miny + this.d_maxy) * 0.5f, (this.d_minz + this.d_maxz) * 0.5f);
    }

    public Point3f getMin() {
        return new Point3f(this.d_minx, this.d_miny, this.d_minz);
    }

    public Point3f getMax() {
        return new Point3f(this.d_maxx, this.d_maxy, this.d_maxz);
    }

    public Point3f[] getVerts() {
        Point3f[] verts = new Point3f[]{this.mmm(), this.mmM(), this.mMm(), this.mMM(), this.Mmm(), this.MmM(), this.MMm(), this.MMM()};
        return verts;
    }

    public float getMinX() {
        return this.d_minx;
    }

    public float getMinY() {
        return this.d_miny;
    }

    public float getMinZ() {
        return this.d_minz;
    }

    public float getMaxX() {
        return this.d_maxx;
    }

    public float getMaxY() {
        return this.d_maxy;
    }

    public float getMaxZ() {
        return this.d_maxz;
    }

    @Override
    public void add(ISearchVol vol) {
        if (vol instanceof AABoxf) {
            this.add((AABoxf)vol);
        }
    }

    public void add(AABoxf box) {
        if (box.d_minx < this.d_minx) {
            this.d_minx = box.d_minx;
        }
        if (box.d_maxx > this.d_maxx) {
            this.d_maxx = box.d_maxx;
        }
        if (box.d_miny < this.d_miny) {
            this.d_miny = box.d_miny;
        }
        if (box.d_maxy > this.d_maxy) {
            this.d_maxy = box.d_maxy;
        }
        if (box.d_minz < this.d_minz) {
            this.d_minz = box.d_minz;
        }
        if (box.d_maxz > this.d_maxz) {
            this.d_maxz = box.d_maxz;
        }
    }

    public void add(Point3f ... points) {
        for (Point3f p : points) {
            this.add(p);
        }
    }

    public void add(Point3f p) {
        this.addPoint(p.x, p.y, p.z);
    }

    public void addPoint(float x, float y, float z) {
        if (x < this.d_minx) {
            this.d_minx = x;
        }
        if (x > this.d_maxx) {
            this.d_maxx = x;
        }
        if (y < this.d_miny) {
            this.d_miny = y;
        }
        if (y > this.d_maxy) {
            this.d_maxy = y;
        }
        if (z < this.d_minz) {
            this.d_minz = z;
        }
        if (z > this.d_maxz) {
            this.d_maxz = z;
        }
    }

    public void addForMin(Point3f p) {
        if (p.x < this.d_minx) {
            this.d_minx = p.x;
        }
        if (p.y < this.d_miny) {
            this.d_miny = p.y;
        }
        if (p.z < this.d_minz) {
            this.d_minz = p.z;
        }
    }

    public void addForMax(Point3f p) {
        if (p.x > this.d_maxx) {
            this.d_maxx = p.x;
        }
        if (p.y > this.d_maxy) {
            this.d_maxy = p.y;
        }
        if (p.z > this.d_maxz) {
            this.d_maxz = p.z;
        }
    }

    public float volume() {
        return (this.d_maxx - this.d_minx) * (this.d_maxy - this.d_miny) * (this.d_maxz - this.d_minz);
    }

    public float volume(float epsilon) {
        float dx = this.d_maxx - this.d_minx + epsilon;
        float dy = this.d_maxy - this.d_miny + epsilon;
        float dz = this.d_maxz - this.d_minz + epsilon;
        return dx * dy * dz;
    }

    @Override
    public double volumeEps() {
        return this.volume(1.1920929E-7f);
    }

    public AABoxf ensureValidSize(float unsetVal, float offsetVal) {
        Point3f min = this.getMin();
        Point3f max = this.getMax();
        if (!this.isValid()) {
            this.set(new Point3f(-unsetVal, -unsetVal, -unsetVal), new Point3f(unsetVal, unsetVal, unsetVal));
            return this;
        }
        if (min.equals(max)) {
            this.set(new Point3f(min.x - unsetVal, min.y - unsetVal, min.z - unsetVal), new Point3f(max.x + unsetVal, max.y + unsetVal, max.z + unsetVal));
            return this;
        }
        if (min.x == max.x) {
            min.x -= offsetVal;
            max.x += offsetVal;
        }
        if (min.y == max.y) {
            min.y -= offsetVal;
            max.y += offsetVal;
        }
        if (min.z == max.z) {
            min.z -= offsetVal;
            max.z += offsetVal;
        }
        this.set(min, max);
        return this;
    }

    public boolean cull(Point3f point) {
        return !(point.x <= this.d_minx || point.x >= this.d_maxx || point.y <= this.d_miny || point.y >= this.d_maxy || point.z <= this.d_minz) && !(point.z >= this.d_maxz);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AABoxf)) {
            return false;
        }
        AABoxf box = (AABoxf)obj;
        return this.d_minx == box.d_minx && this.d_miny == box.d_miny && this.d_minz == box.d_minz && this.d_maxx == box.d_maxx && this.d_maxy == box.d_maxy && this.d_maxz == box.d_maxz;
    }

    public int hashCode() {
        return theUtil.hashCode(this.d_minx + this.d_miny + this.d_minz + this.d_maxx + this.d_maxy + this.d_maxz);
    }

    @Override
    public Object clone() {
        return new AABoxf(this);
    }

    public boolean contains(Point3f p) {
        return this.d_minx <= p.x && p.x <= this.d_maxx && this.d_miny <= p.y && p.y <= this.d_maxy && this.d_minz <= p.z && p.z <= this.d_maxz;
    }

    public boolean containsOneOf(Point3f ... points) {
        for (Point3f p : points) {
            if (!this.contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Point3f p, float tolerance) {
        return this.d_minx - tolerance <= p.x && p.x <= this.d_maxx + tolerance && this.d_miny - tolerance <= p.y && p.y <= this.d_maxy + tolerance && this.d_minz - tolerance <= p.z && p.z <= this.d_maxz + tolerance;
    }

    public boolean innerPt(Point3f pt) {
        return this.d_minx < pt.x && pt.x < this.d_maxx && this.d_miny < pt.y && pt.y < this.d_maxy && this.d_minz < pt.z && pt.z < this.d_maxz;
    }

    @Override
    public Containment test(AABoxf bb) {
        return AABoxf.contains(this.d_minx, this.d_miny, this.d_minz, this.d_maxx, this.d_maxy, this.d_maxz, bb.d_minx, bb.d_miny, bb.d_minz, bb.d_maxx, bb.d_maxy, bb.d_maxz);
    }

    public Containment test(AABoxf bb, float tol) {
        return AABoxf.contains(this.d_minx - tol, this.d_miny - tol, this.d_minz - tol, this.d_maxx + tol, this.d_maxy + tol, this.d_maxz + tol, bb.d_minx - tol, bb.d_miny - tol, bb.d_minz - tol, bb.d_maxx + tol, bb.d_maxy + tol, bb.d_maxz + tol);
    }

    private static final Containment contains(float minx1, float miny1, float minz1, float maxx1, float maxy1, float maxz1, float minx2, float miny2, float minz2, float maxx2, float maxy2, float maxz2) {
        if (minx1 <= maxx2 && minx2 <= maxx1 && miny1 <= maxy2 && miny2 <= maxy1 && minz1 <= maxz2 && minz2 <= maxz1) {
            if (minx1 <= minx2 && maxx2 <= maxx1 && miny1 <= miny2 && maxy2 <= maxy1 && minz1 <= minz2 && maxz2 <= maxz1) {
                return Containment.INSIDE;
            }
            return Containment.INTERSECTS;
        }
        return Containment.OUTSIDE;
    }

    @Deprecated
    public int contains(AABoxf bb) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(bb));
    }

    @Deprecated
    public int contains(AABoxf bb, float tol) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(bb, tol));
    }

    public boolean intersects(AABoxf bb) {
        Point3f p1Min = this.getMin();
        Point3f p1Max = this.getMax();
        Point3f p2Min = bb.getMin();
        Point3f p2Max = bb.getMax();
        return p1Min.x <= p2Max.x && p1Max.x >= p2Min.x && p1Min.y <= p2Max.y && p1Max.y >= p2Min.y && p1Min.z <= p2Max.z && p1Max.z >= p2Min.z;
    }

    public boolean intersects(AABoxf bb, float tol) {
        float minx1 = this.d_minx - tol;
        float miny1 = this.d_miny - tol;
        float minz1 = this.d_minz - tol;
        float minx2 = bb.d_minx - tol;
        float miny2 = bb.d_miny - tol;
        float minz2 = bb.d_minz - tol;
        float maxx1 = this.d_maxx + tol;
        float maxy1 = this.d_maxy + tol;
        float maxz1 = this.d_maxz + tol;
        float maxx2 = bb.d_maxx + tol;
        float maxy2 = bb.d_maxy + tol;
        float maxz2 = bb.d_maxz + tol;
        return minx2 <= maxx1 && maxx2 >= minx1 && miny2 <= maxy1 && maxy2 >= miny1 && minz2 <= maxz1 && maxz2 >= minz1;
    }

    public Point3f mmm() {
        return this.getMin();
    }

    public Point3f mmM() {
        return new Point3f(this.d_minx, this.d_miny, this.d_maxz);
    }

    public Point3f mMm() {
        return new Point3f(this.d_minx, this.d_maxy, this.d_minz);
    }

    public Point3f mMM() {
        return new Point3f(this.d_minx, this.d_maxy, this.d_maxz);
    }

    public Point3f Mmm() {
        return new Point3f(this.d_maxx, this.d_miny, this.d_minz);
    }

    public Point3f MmM() {
        return new Point3f(this.d_maxx, this.d_miny, this.d_maxz);
    }

    public Point3f MMm() {
        return new Point3f(this.d_maxx, this.d_maxy, this.d_minz);
    }

    public Point3f MMM() {
        return this.getMax();
    }

    public Point3f mmm(Point3f p) {
        p.set(this.d_minx, this.d_miny, this.d_minz);
        return p;
    }

    public Point3f mmM(Point3f p) {
        p.set(this.d_minx, this.d_miny, this.d_maxz);
        return p;
    }

    public Point3f mMm(Point3f p) {
        p.set(this.d_minx, this.d_maxy, this.d_minz);
        return p;
    }

    public Point3f mMM(Point3f p) {
        p.set(this.d_minx, this.d_maxy, this.d_maxz);
        return p;
    }

    public Point3f Mmm(Point3f p) {
        p.set(this.d_maxx, this.d_miny, this.d_minz);
        return p;
    }

    public Point3f MmM(Point3f p) {
        p.set(this.d_maxx, this.d_miny, this.d_maxz);
        return p;
    }

    public Point3f MMm(Point3f p) {
        p.set(this.d_maxx, this.d_maxy, this.d_minz);
        return p;
    }

    public Point3f MMM(Point3f p) {
        p.set(this.d_maxx, this.d_maxy, this.d_maxz);
        return p;
    }

    public Point3f[][] getFaces() {
        Point3f mmm = this.mmm();
        Point3f mmM = this.mmM();
        Point3f mMm = this.mMm();
        Point3f mMM = this.mMM();
        Point3f Mmm = this.Mmm();
        Point3f MmM = this.MmM();
        Point3f MMm = this.MMm();
        Point3f MMM = this.MMM();
        return new Point3f[][]{{mMm, mmm, mmM, mMM}, {Mmm, MMm, MMM, MmM}, {mmm, Mmm, MmM, mmM}, {MMm, mMm, mMM, MMM}, {mmm, mMm, MMm, Mmm}, {mmM, MmM, MMM, mMM}};
    }

    public AABoxf scale(float s) {
        Point3f center = this.getCenter();
        float width = this.getWidth() * s * 0.5f;
        float height = this.getHeight() * s * 0.5f;
        float depth = this.getDepth() * s * 0.5f;
        return new AABoxf(center.x - width, center.y - depth, center.z - height, center.x + width, center.y + depth, center.z + height);
    }
}

