/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.thunderheadeng.io.StringPrintWriter;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.IntVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.ValueRange;

public class FDSRecordSpec {
    public final String rectype;
    public final Map<String, Field> fields;

    public FDSRecordSpec(String type) {
        this.rectype = type;
        this.fields = new HashMap<String, Field>();
    }

    public void addField(Field f) {
        this.fields.put(f.name, f);
    }

    private static <T> int[] getArrayValRange(List<? extends T> vals) {
        int begin = -1;
        int end = -2;
        for (int m = 0; m < vals.size(); ++m) {
            if (vals.get(m) == null) continue;
            if (begin == -1) {
                begin = m;
            }
            end = m;
        }
        if (begin > end) {
            return null;
        }
        return new int[]{begin, end};
    }

    private static <T> void printArrayVals(PrintWriter writer, FDSRenderProps props, List<? extends T> vals, int[] range, SingleField<T> elRenderer) {
        for (int m = range[0]; m <= range[1]; ++m) {
            T elval;
            if (m != range[0]) {
                writer.print(",");
            }
            if ((elval = vals.get(m)) == null) continue;
            writer.print(elRenderer.renderVal(props, elval));
        }
    }

    public static abstract class Field<T> {
        public final String name;
        public final T initialValue;
        public final Class<? super T> clazz;

        public Field(String name, T initialValue, Class<? super T> clazz) {
            this.name = name;
            this.initialValue = initialValue;
            this.clazz = clazz;
        }

        public T newInitialValue() {
            return this.initialValue != null ? (T)this.cloneValue(this.initialValue) : null;
        }

        public abstract T cloneValue(T var1);

        public abstract String render(FDSRenderProps var1, T var2);

        public abstract int[] getDimensions();

        public abstract int[] getIndexOffsets();

        public abstract T set(T var1, int[] var2, String var3) throws ParseException;
    }

    public static abstract class SingleField<T>
    extends Field<T> {
        public SingleField(String name, T initialValue, Class<T> clazz) {
            super(name, initialValue, clazz);
        }

        protected abstract T parse(String var1) throws ParseException;

        protected abstract String renderVal(FDSRenderProps var1, T var2);

        @Override
        public T set(T existing, int[] subscripts, String value) throws ParseException {
            if (value == null) {
                return existing;
            }
            return this.parse(value);
        }

        @Override
        public int[] getDimensions() {
            return new int[]{1};
        }

        @Override
        public int[] getIndexOffsets() {
            return new int[]{1};
        }

        @Override
        public String render(FDSRenderProps props, T val) {
            return this.name + "=" + this.renderVal(props, val);
        }
    }

    public static class ArrayFld<T>
    extends Field<FDSArray<T>> {
        public final SingleField<T> elementChecker;
        public final int[] dimensions;
        private int[] d_ixOffsets;
        private boolean d_allowFrontPackedRendering = false;

        public ArrayFld(String name, FDSArray<T> initialValue, SingleField<T> elementChecker) {
            super(name, initialValue, FDSArray.class);
            this.elementChecker = elementChecker;
            assert (initialValue != null);
            this.dimensions = initialValue.getDimensions();
            this.d_ixOffsets = new int[this.dimensions.length];
            Arrays.fill(this.d_ixOffsets, 1);
        }

        public ArrayFld(String name, SingleField<T> elementChecker, int ... dimensions) {
            super(name, null, FDSArray.class);
            this.elementChecker = elementChecker;
            this.dimensions = dimensions;
            this.d_ixOffsets = new int[dimensions.length];
            Arrays.fill(this.d_ixOffsets, 1);
        }

        public ArrayFld<T> setRenderPacked(boolean flag) {
            this.d_allowFrontPackedRendering = flag;
            return this;
        }

        public void setIndexOffsets(int ... offsets) {
            assert (offsets.length == this.d_ixOffsets.length);
            this.d_ixOffsets = offsets;
        }

        @Override
        public FDSArray<T> cloneValue(FDSArray<T> val) {
            FDSArray clone = new FDSArray(val.getDimensions());
            Object baseArray = val.getBaseArray();
            Object cloneBaseArray = clone.getBaseArray();
            for (int m = 0; m < Array.getLength(baseArray); ++m) {
                Object elval = Array.get(baseArray, m);
                if (elval == null) continue;
                Array.set(cloneBaseArray, m, this.elementChecker.cloneValue(elval));
            }
            return clone;
        }

        @Override
        public String render(FDSRenderProps props, FDSArray<T> val) {
            if (val.isEmpty()) {
                return "";
            }
            if (this.d_allowFrontPackedRendering && val.isFrontPacked()) {
                List<T> valsList = val.getFrontPackedValsAsList();
                return this.renderFrontPacked(props, valsList);
            }
            StringPrintWriter writer = new StringPrintWriter();
            this.render(writer, props, val, 0, new int[this.dimensions.length], 0);
            return writer.toString();
        }

        public String renderFrontPacked(FDSRenderProps props, List<T> vals) {
            StringPrintWriter writer = new StringPrintWriter();
            writer.write(this.name);
            writer.write("=");
            int[] range = new int[]{0, vals.size() - 1};
            FDSRecordSpec.printArrayVals(writer, props, vals, range, this.elementChecker);
            return writer.toString();
        }

        public int render(PrintWriter writer, FDSRenderProps props, FDSArray<T> val, int dimIx, int[] ixes, int numWritten) {
            if (dimIx < this.dimensions.length - 1) {
                int m = 0;
                while (m < this.dimensions[dimIx]) {
                    ixes[dimIx] = m++;
                    numWritten = this.render(writer, props, val, dimIx + 1, ixes, numWritten);
                }
            } else {
                ArrayList<T> vals = new ArrayList<T>(this.dimensions[dimIx]);
                int m = 0;
                while (m < this.dimensions[dimIx]) {
                    ixes[dimIx] = m++;
                    vals.add(val.get(ixes));
                }
                int[] range = FDSRecordSpec.getArrayValRange(vals);
                if (range == null) {
                    return numWritten;
                }
                if (numWritten > 0) {
                    writer.print(props.getFieldSep());
                }
                writer.print(this.name);
                if (this.dimensions.length != 1 || range[0] != 0 || range[1] != this.dimensions[dimIx] - 1) {
                    writer.print('(');
                    for (int m2 = 0; m2 < dimIx; ++m2) {
                        writer.print(this.offsetIx(m2, ixes[m2]) + ",");
                    }
                    writer.print(this.offsetIx(dimIx, range[0]));
                    if (range[0] != range[1]) {
                        writer.print(":" + this.offsetIx(dimIx, range[1]));
                    }
                    writer.print(')');
                }
                writer.print('=');
                FDSRecordSpec.printArrayVals(writer, props, vals, range, this.elementChecker);
                ++numWritten;
            }
            return numWritten;
        }

        private int offsetIx(int dimix, int ix) {
            return ix + this.d_ixOffsets[dimix];
        }

        private int unoffsetIx(int dimix, int ix) {
            return ix - this.d_ixOffsets[dimix];
        }

        @Override
        public int[] getDimensions() {
            return this.dimensions;
        }

        @Override
        public int[] getIndexOffsets() {
            return this.d_ixOffsets;
        }

        @Override
        public FDSArray<T> set(FDSArray<T> existing, int[] subscripts, String value) throws ParseException {
            Object val;
            assert (subscripts.length == this.dimensions.length);
            Object t = val = value != null ? (Object)this.elementChecker.parse(value) : null;
            if (existing == null) {
                existing = new FDSArray(this.dimensions);
            }
            int[] ixes = new int[subscripts.length];
            for (int m = 0; m < subscripts.length; ++m) {
                ixes[m] = this.unoffsetIx(m, subscripts[m]);
                if (ixes[m] < this.dimensions[m] && ixes[m] >= 0) continue;
                return existing;
            }
            existing.set(val, ixes);
            return existing;
        }
    }

    public static class ListFld<T>
    extends Field<List<T>> {
        public final SingleField<T> elementChecker;
        private int d_ixOffset = 1;

        public ListFld(String name, List<T> initialValue, SingleField<T> elementChecker) {
            super(name, initialValue, List.class);
            this.elementChecker = elementChecker;
        }

        public void setIndexOffset(int offset) {
            this.d_ixOffset = offset;
        }

        @Override
        public List<T> cloneValue(List<T> val) {
            ArrayList<Object> clone = new ArrayList<Object>(val.size());
            for (T elval : val) {
                Object newVal = elval != null ? (Object)this.elementChecker.cloneValue(elval) : null;
                clone.add(newVal);
            }
            return clone;
        }

        @Override
        public String render(FDSRenderProps props, List<T> values) {
            if (values.isEmpty()) {
                return "";
            }
            int[] range = FDSRecordSpec.getArrayValRange(values);
            if (range == null) {
                return "";
            }
            StringPrintWriter writer = new StringPrintWriter();
            writer.write(this.name);
            if (range[0] != 0) {
                writer.write("(" + this.offsetIx(range[0]));
                if (range[1] != range[0]) {
                    writer.write(":" + this.offsetIx(range[1]));
                }
                writer.write(")");
            }
            writer.write("=");
            FDSRecordSpec.printArrayVals(writer, props, values, range, this.elementChecker);
            return writer.toString();
        }

        private int offsetIx(int ix) {
            return ix + this.d_ixOffset;
        }

        private int unoffsetIx(int ix) {
            return ix - this.d_ixOffset;
        }

        @Override
        public int[] getDimensions() {
            return new int[]{0x7FFFFFFE};
        }

        @Override
        public int[] getIndexOffsets() {
            return new int[]{this.d_ixOffset};
        }

        @Override
        public List<T> set(List<T> existing, int[] subscripts, String value) throws ParseException {
            int ix;
            Object val;
            assert (subscripts.length == 1);
            Object e = val = value != null ? (Object)this.elementChecker.parse(value) : null;
            if (existing == null) {
                existing = new ArrayList<T>();
            }
            if ((ix = this.unoffsetIx(subscripts[0])) < 0) {
                return existing;
            }
            for (int m = existing.size(); m <= ix; ++m) {
                existing.add(null);
            }
            existing.set(ix, val);
            return existing;
        }
    }

    public static class UnitDoubleFld
    extends NumericField<UnitDouble> {
        public final Unit unit;

        public UnitDoubleFld(String name, Double initialValue, Unit u) {
            this(name, initialValue, DoubleVR.UNBOUNDED, u);
        }

        public UnitDoubleFld(String name, Double initialValue, DoubleVR vr, Unit u) {
            super(name, initialValue == null ? null : new UnitDouble(initialValue, u), UnitDoubleVR.from(vr, u), UnitDouble.class);
            this.unit = u;
        }

        @Override
        public UnitDouble parseUnchecked(String strVal) throws ParseException {
            return new UnitDouble(Double.parseDouble(strVal), this.unit);
        }

        @Override
        public String renderVal(FDSRenderProps props, UnitDouble val) {
            return props.renderDouble(val.getValue(this.unit));
        }
    }

    public static class DoubleFld
    extends NumericField<Double> {
        public DoubleFld(String name, Double initialValue) {
            this(name, initialValue, DoubleVR.UNBOUNDED);
        }

        public DoubleFld(String name, Double initialValue, ValueRange<Double> vr) {
            super(name, initialValue, vr, Double.class);
        }

        @Override
        public Double parseUnchecked(String strVal) {
            return Double.parseDouble(strVal);
        }

        @Override
        public String renderVal(FDSRenderProps props, Double val) {
            return props.renderDouble(val);
        }
    }

    public static class RgbFld
    extends DoubleFld {
        public RgbFld() {
            super(null, 0.0, DoubleVR.between(0.0, 255.0, true, true));
        }

        @Override
        public String renderVal(FDSRenderProps props, Double val) {
            int ival = val.intValue();
            return Integer.toString(ival);
        }
    }

    public static class IntFld
    extends NumericField<Integer> {
        public IntFld(String name, Integer initialValue) {
            this(name, initialValue, IntVR.UNBOUNDED);
        }

        public IntFld(String name, Integer initialValue, ValueRange<Integer> range) {
            super(name, initialValue, range, Integer.class);
        }

        @Override
        public Integer parseUnchecked(String strVal) {
            Integer ival;
            Double dval = Double.parseDouble(strVal);
            if (dval.compareTo((ival = Integer.valueOf(dval.intValue())).doubleValue()) != 0) {
                String warn = String.format(Intl.intl("Floating-point value (%s) converted to integer (%s).\n"), dval, ival);
                JOptionPane.showMessageDialog(null, warn, Intl.intl("Import Warning"), 2);
            }
            return ival;
        }

        @Override
        public String renderVal(FDSRenderProps props, Integer val) {
            return val.toString();
        }
    }

    public static abstract class NumericField<T>
    extends SingleField<T> {
        public final ValueRange<T> range;

        public NumericField(String name, T initialValue, ValueRange<T> range, Class<T> clazz) {
            super(name, initialValue, clazz);
            this.range = range;
        }

        protected abstract T parseUnchecked(String var1) throws ParseException;

        @Override
        protected T parse(String strVal) throws ParseException {
            T value = this.parseUnchecked(strVal);
            if (!this.range.checkValue(value)) {
                throw new ParseException(String.format(Intl.intl("Invalid value for %1$s: %2$s"), this.name, this.range.describeRange()), 0);
            }
            return value;
        }

        @Override
        public T cloneValue(T val) {
            return val;
        }
    }

    public static class BooleanFld
    extends SingleField<Boolean> {
        public BooleanFld(String name, Boolean initialValue) {
            super(name, initialValue, Boolean.class);
        }

        @Override
        protected Boolean parse(String strVal) throws ParseException {
            String str = strVal.toUpperCase();
            if (str.startsWith(".T") || str.startsWith("T")) {
                return Boolean.TRUE;
            }
            if (str.startsWith(".F") || str.startsWith("F")) {
                return Boolean.FALSE;
            }
            throw new ParseException(Intl.intl("Unrecognized logical value specified."), 0);
        }

        @Override
        public Boolean cloneValue(Boolean val) {
            return val;
        }

        @Override
        public String renderVal(FDSRenderProps props, Boolean val) {
            return val != false ? ".TRUE." : ".FALSE.";
        }
    }

    public static class StringFld
    extends SingleField<String> {
        public StringFld(String name, String initialValue) {
            super(name, initialValue, String.class);
        }

        @Override
        protected String parse(String strVal) {
            String result = strVal;
            if (strVal.length() >= 2) {
                String replChar = null;
                int lastIx = strVal.length() - 1;
                if (strVal.charAt(0) == '\"' && strVal.charAt(lastIx) == '\"') {
                    replChar = "\"";
                } else if (strVal.charAt(0) == '\'' && strVal.charAt(lastIx) == '\'') {
                    replChar = "'";
                }
                if (replChar != null) {
                    if (strVal.length() == 2) {
                        result = "";
                    } else {
                        result = strVal.substring(1, lastIx);
                        result = result.replace(replChar + replChar, replChar);
                    }
                }
            }
            return result;
        }

        @Override
        public String cloneValue(String val) {
            return val;
        }

        @Override
        public String renderVal(FDSRenderProps props, String val) {
            return "'" + val.replace("'", "''") + "'";
        }
    }
}

