/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class SetEnabledSomeObjsTask
implements Task {
    private final PyroMod d_mediator;
    private boolean[] d_oldEnabled;
    private final boolean d_newEnabled;
    private final List<? extends IPyroObject> d_selectedObjs;

    public SetEnabledSomeObjsTask(PyroMod med, Collection<? extends IPyroObject> selected, boolean enable) {
        this.d_mediator = med;
        this.d_newEnabled = enable;
        this.d_selectedObjs = new ArrayList<IPyroObject>(selected);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        int index = 0;
        for (IPyroObject iPyroObject : this.d_selectedObjs) {
            iPyroObject.setEnabled(this.d_oldEnabled[index++]);
        }
        this.d_oldEnabled = null;
        this.d_mediator.resumeUpdates();
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        this.d_oldEnabled = new boolean[this.d_selectedObjs.size()];
        int index = 0;
        for (IPyroObject iPyroObject : this.d_selectedObjs) {
            this.d_oldEnabled[index++] = iPyroObject.isEnabled();
            iPyroObject.setEnabled(this.d_newEnabled);
        }
        this.d_mediator.resumeUpdates();
    }
}

