/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.thunderheadeng.util.AOneTimeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.treeview.TVEntryPoint;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;

public class SelectReferencingObjTask
extends AOneTimeTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_selObjs;

    public SelectReferencingObjTask(PyroMod med, Collection<? extends IPyroObject> objs) {
        this.d_mediator = med;
        this.d_selObjs = new ArrayList<IPyroObject>(objs);
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        DepSnapshot ds = this.d_mediator.getDependencies(this.d_selObjs);
        IObjectFilter<Object> filter = new IObjectFilter<Object>(){

            @Override
            public boolean shouldFilter(Object o) {
                if (!(o instanceof IPyroObject)) {
                    return true;
                }
                TVEntryPoint<Object> ep = TVEntryPoints.ep(o);
                if (ep == null) {
                    return true;
                }
                return !ep.showInTree(SelectReferencingObjTask.this.d_mediator, o);
            }
        };
        IdentityHashSet total = new IdentityHashSet();
        for (IPyroObject iPyroObject : this.d_selObjs) {
            ds.findAllDependents(filter, iPyroObject, total);
        }
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(total);
        this.d_mediator.resumeUpdates();
    }
}

