/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class TempRegulation
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_netHeatFlux;
    public final UnitDouble d_temperature;
    public final UnitDouble d_heatFlux;
    public final TimeFunction d_rampup;
    public final double d_emissivity;

    private TempRegulation(UnitDouble netHeatFlux, UnitDouble temperature, UnitDouble heatFlux, TimeFunction rampup, double emissivity) {
        this.d_netHeatFlux = netHeatFlux;
        this.d_temperature = temperature;
        this.d_heatFlux = heatFlux;
        this.d_rampup = rampup;
        this.d_emissivity = emissivity;
    }

    public static TempRegulation newNetHeatFluxTR(UnitDouble netHeatFlux) {
        return new TempRegulation(netHeatFlux, null, null, null, 0.0);
    }

    public static TempRegulation newFixedHeatFluxTR(UnitDouble temperature, UnitDouble heatFlux, TimeFunction rampup, double emissivity) {
        return new TempRegulation(null, temperature, heatFlux, rampup, emissivity);
    }

    public static TempRegulation newDefault() {
        return new TempRegulation(null, null, SIUS.newud(0.0, 33), TimeFunction.newDefault(), 0.9);
    }

    public boolean isNetHeatFluxTR() {
        return this.d_netHeatFlux != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TempRegulation)) {
            return false;
        }
        TempRegulation reg = (TempRegulation)obj;
        if (this.d_netHeatFlux != null) {
            return this.d_netHeatFlux.equals(reg.d_netHeatFlux);
        }
        return theUtil.equal(this.d_temperature, reg.d_temperature) && this.d_heatFlux.equals(reg.d_heatFlux) && this.d_rampup.equals(reg.d_rampup) && this.d_emissivity == reg.d_emissivity;
    }
}

