/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABoxf;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.RTreef;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.CollResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;

public class GeomLocator {
    private Set<IGeomSource> d_dirtyGeom = GeomLocator.newDirtySet();
    private final RTreef<IGeomSource> d_finite = new RTreef(2, 16);
    private final Set<IGeomSource> d_infinite = new LinkedIdentityHashSet<IGeomSource>();

    private static Set<IGeomSource> newDirtySet() {
        return new LinkedIdentityHashSet<IGeomSource>();
    }

    public void add(IGeomSource geom) {
        this.d_dirtyGeom.add(geom);
    }

    public void remove(IGeomSource geom) {
        this.d_finite.remove(geom);
        this.d_infinite.remove(geom);
        this.d_dirtyGeom.remove(geom);
    }

    public void update(IGeomSource geom) {
        this.d_dirtyGeom.add(geom);
    }

    public void updateDirty() {
        if (this.d_dirtyGeom.isEmpty()) {
            return;
        }
        theTimer timer = new theTimer();
        for (IGeomSource geom : this.d_dirtyGeom) {
            this.removeGeometry(geom);
            this.addGeometry(geom);
        }
        this.d_dirtyGeom = GeomLocator.newDirtySet();
        System.out.println("updated geom search " + timer.curr());
    }

    private void addGeometry(IGeomSource geom) {
        AABox bounds = geom.getBounds();
        if (bounds.isInfinite()) {
            this.d_infinite.add(geom);
        } else {
            this.d_finite.insert(bounds.toAABoxf(), geom);
        }
    }

    private void addGeometry(Collection<? extends IGeomSource> searchGeom) {
        for (IGeomSource iGeomSource : searchGeom) {
            this.addGeometry(iGeomSource);
        }
    }

    private boolean removeGeometry(IGeomSource geom) {
        this.d_finite.remove(geom);
        this.d_infinite.remove(geom);
        return true;
    }

    private boolean removeGeometry(Collection<? extends IGeomSource> searchGeom) {
        boolean result = true;
        for (IGeomSource iGeomSource : searchGeom) {
            result &= this.removeGeometry(iGeomSource);
        }
        return result;
    }

    public void find(final ITest<AABox> tester, IResult<? super IGeomSource> result, boolean includeInvisible) {
        ITest<AABoxf> testConverter = new ITest<AABoxf>(){

            @Override
            public Containment test(AABoxf bounds) {
                return tester.test(new AABox(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ(), bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ()));
            }
        };
        this.findf(testConverter, result, includeInvisible);
    }

    public void findf(ITest<AABoxf> tester, IResult<? super IGeomSource> result, boolean includeInvisible) {
        this.updateDirty();
        this.find(tester, result, this.d_finite, includeInvisible);
        this.find(result, this.d_infinite, includeInvisible);
    }

    private void find(ITest<AABoxf> test, final IResult<? super IGeomSource> result, RTreef<IGeomSource> finiteGeom, boolean includeInvisible) {
        IResult<IGeomSource> res = result;
        if (!includeInvisible) {
            res = new IResult<IGeomSource>(){

                @Override
                public void mark(IGeomSource obj, Containment ctmt) {
                    if (!obj.isVisible()) {
                        return;
                    }
                    result.mark(obj, ctmt);
                }
            };
        }
        finiteGeom.find(test, res);
    }

    private void find(IResult<? super IGeomSource> result, Set<IGeomSource> infiniteGeom, boolean includeInvisible) {
        for (IGeomSource geom : infiniteGeom) {
            if (!includeInvisible && !geom.isVisible()) continue;
            result.mark(geom, Containment.INTERSECTS);
        }
    }

    public static class Collector<T extends IGeomSource>
    extends CollResult<IGeomSource, T> {
        public Collector(Class<T> type) {
            this(type, (IObjectFilter<T>)AcceptAllFilter.INSTANCE);
        }

        public Collector(Class<T> type, IObjectFilter<T> filter) {
            super(type, filter);
        }
    }
}

