/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.rasterization;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.ConvexPolygon;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Intersections;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Solid3D;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Util;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IRaster3D;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3DMerger;
import pyrosim.legacy_2006_2.thunderheadeng.util.Sets;
import pyrosim.legacy_2006_2.thunderheadeng.util.theUtil;

public class Raster3D<T>
implements IRaster3D<T> {
    private static final double EPSILON = 1.0E-9;
    private static final Vector3d XPOS = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d YPOS = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d ZPOS = new Vector3d(0.0, 0.0, 1.0);
    private final Class<T> d_fragType;
    private ConvexVolume d_rastVolume;
    private double[] d_xDiv;
    private double[] d_yDiv;
    private double[] d_zDiv;
    private final CellList d_cells;
    private IRasterization<? extends T> d_rast;
    static final theUtil.DoubleComparator d_comp = new theUtil.DoubleComparator(){

        @Override
        public int compare(double o1, double o2) {
            if (Raster3D.doubleEq(o1, o2, 1.0E-9)) {
                return 0;
            }
            return o1 < o2 ? -1 : 1;
        }
    };

    public Raster3D(Class<T> fragType, double[] xDiv, double[] yDiv, double[] zDiv) {
        this(fragType, xDiv, yDiv, zDiv, null);
    }

    public Raster3D(Class<T> fragType, double[] xDiv, double[] yDiv, double[] zDiv, IRasterization rast) {
        assert (xDiv.length > 0 && yDiv.length > 0 && zDiv.length > 0);
        this.d_fragType = fragType;
        this.setRasterization(rast);
        int numCells = xDiv.length * yDiv.length * zDiv.length;
        int iniSize = numCells / 8;
        this.d_cells = new CellList(iniSize);
        this.setDivisions(xDiv, yDiv, zDiv);
    }

    private static double[] getCenters(double[] div) {
        double[] centers = new double[div.length - 1];
        for (int m = 0; m < centers.length; ++m) {
            centers[m] = (div[m] + div[m + 1]) * 0.5;
        }
        return centers;
    }

    public void setDivisions(double[] xDiv, double[] yDiv, double[] zDiv) {
        this.clear();
        if (xDiv == null || yDiv == null || zDiv == null) {
            return;
        }
        this.d_xDiv = xDiv;
        this.d_yDiv = yDiv;
        this.d_zDiv = zDiv;
        double minx = this.d_xDiv[0];
        double maxx = this.d_xDiv[this.d_xDiv.length - 1];
        double miny = this.d_yDiv[0];
        double maxy = this.d_yDiv[this.d_yDiv.length - 1];
        double minz = this.d_zDiv[0];
        double maxz = this.d_zDiv[this.d_zDiv.length - 1];
        assert (minx <= maxx && miny <= maxy && minz <= maxz) : "Inside out raster error";
        Point3d mmm = new Point3d(minx, miny, minz);
        Point3d mmM = new Point3d(minx, miny, maxz);
        Point3d mMm = new Point3d(minx, maxy, minz);
        Point3d mMM = new Point3d(minx, maxy, maxz);
        Point3d Mmm = new Point3d(maxx, miny, minz);
        Point3d MmM = new Point3d(maxx, miny, maxz);
        Point3d MMm = new Point3d(maxx, maxy, minz);
        Point3d MMM = new Point3d(maxx, maxy, maxz);
        ConvexPolygon[] faces = new ConvexPolygon[]{new ConvexPolygon(mmm, mMm, mMM, mmM), new ConvexPolygon(Mmm, MmM, MMM, MMm), new ConvexPolygon(mmm, mmM, MmM, Mmm), new ConvexPolygon(MMm, MMM, mMM, mMm), new ConvexPolygon(mmm, Mmm, MMm, mMm), new ConvexPolygon(mmM, mMM, MMM, MmM)};
        this.d_rastVolume = new ConvexVolume(faces);
    }

    public double[] getXDiv() {
        return this.d_xDiv;
    }

    public double[] getYDiv() {
        return this.d_yDiv;
    }

    public double[] getZDiv() {
        return this.d_zDiv;
    }

    @Override
    public void setRasterization(IRasterization<? extends T> rast) {
        if (rast == null) {
            return;
        }
        this.d_rast = rast;
    }

    @Override
    public void clear() {
        this.d_cells.clear();
    }

    @Override
    public T[] getFrags(boolean mergeCells) {
        return this.d_cells.getFrags(mergeCells);
    }

    public T[] getFrags(Collection<? extends IRasterization<? extends T>> rasts, boolean mergeCells) {
        return this.d_cells.getFrags(rasts, mergeCells);
    }

    @Override
    public void removeRasterization(IRasterization<? extends T> rast) {
        this.d_cells.removeCells(rast);
    }

    private void addCell(Point3i cellIx) {
        this.d_cells.addCell(cellIx, this.d_rast);
    }

    private void markDirty() {
    }

    public void rasterizeTriangle(Point3d ... tri) {
        assert (tri.length >= 3);
        this.rasterizeConvexPolygon(tri);
    }

    public void rasterizeTriangle(IRasterization<? extends T> rast, Point3d ... tri) {
        this.setRasterization(rast);
        this.rasterizeTriangle(tri);
    }

    @Override
    public void rasterizeConvexPolygon(IRasterization<? extends T> rast, Point3d ... poly) {
        this.setRasterization(rast);
        this.rasterizeConvexPolygon(poly);
    }

    @Override
    public void rasterizeConvexPolygon(Point3d ... poly) {
        this.markDirty();
        Point3d[] clippedPoly = this.clipConvexPoly(poly);
        clippedPoly = Raster3D.deleteAdjacentDuplicates(1.0E-9, clippedPoly);
        if (clippedPoly.length <= 0) {
            return;
        }
        this.rasterizeClippedConvexPoly(clippedPoly);
    }

    private static void addToMinMax(Point3i minix, Point3i maxix, Point3i ix) {
        if (ix.x < minix.x) {
            minix.x = ix.x;
        }
        if (ix.x > maxix.x) {
            maxix.x = ix.x;
        }
        if (ix.y < minix.y) {
            minix.y = ix.y;
        }
        if (ix.y > maxix.y) {
            maxix.y = ix.y;
        }
        if (ix.z < minix.z) {
            minix.z = ix.z;
        }
        if (ix.z > maxix.z) {
            maxix.z = ix.z;
        }
    }

    private void rasterizeClippedEdges(Point3i minix, Point3i maxix, Point3d ... poly) {
        for (int ix1 = 0; ix1 < poly.length; ++ix1) {
            int ix2 = (ix1 + 1) % poly.length;
            Point3d p1 = poly[ix1];
            Point3d p2 = poly[ix2];
            Point3i i1 = this.getIndex(p1);
            Point3i i2 = this.getIndex(p2);
            this.rasterizeLineSeg(p1, p2, i1, i2);
            Raster3D.addToMinMax(minix, maxix, i1);
            Raster3D.addToMinMax(minix, maxix, i2);
        }
    }

    private void rasterizeClippedConvexPoly(Point3d ... points) {
        double x;
        int xix;
        Point3d l2;
        Point3d l1;
        double z;
        int zix;
        Point3i minix = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Point3i maxix = new Point3i(-2147483647, -2147483647, -2147483647);
        this.rasterizeClippedEdges(minix, maxix, points);
        if (points.length < 3) {
            return;
        }
        ConvexPolygon poly = new ConvexPolygon(points);
        Point3d intersection = new Point3d();
        for (zix = minix.z; zix < maxix.z; ++zix) {
            for (int yix = minix.y; yix < maxix.y; ++yix) {
                double y = (this.d_yDiv[yix] + this.d_yDiv[yix + 1]) * 0.5;
                z = (this.d_zDiv[zix] + this.d_zDiv[zix + 1]) * 0.5;
                l1 = new Point3d(this.d_xDiv[0], y, z);
                l2 = new Point3d(this.d_xDiv[this.d_xDiv.length - 1], y, z);
                if (!Intersections.lineSegPolyIntersection(intersection, l1, l2, XPOS, poly.d_plane, poly.d_points)) continue;
                this.addCell(new Point3i(Raster3D.getClampedBoundIndex(this.d_xDiv, intersection.x), yix, zix));
            }
        }
        for (zix = minix.z; zix < maxix.z; ++zix) {
            for (xix = minix.x; xix < maxix.x; ++xix) {
                x = (this.d_xDiv[xix] + this.d_xDiv[xix + 1]) * 0.5;
                z = (this.d_zDiv[zix] + this.d_zDiv[zix + 1]) * 0.5;
                l1 = new Point3d(x, this.d_yDiv[0], z);
                l2 = new Point3d(x, this.d_yDiv[this.d_yDiv.length - 1], z);
                if (!Intersections.lineSegPolyIntersection(intersection, l1, l2, YPOS, poly.d_plane, poly.d_points)) continue;
                this.addCell(new Point3i(xix, Raster3D.getClampedBoundIndex(this.d_yDiv, intersection.y), zix));
            }
        }
        for (int yix = minix.y; yix < maxix.y; ++yix) {
            for (xix = minix.x; xix < maxix.x; ++xix) {
                x = (this.d_xDiv[xix] + this.d_xDiv[xix + 1]) * 0.5;
                double y = (this.d_yDiv[yix] + this.d_yDiv[yix + 1]) * 0.5;
                l1 = new Point3d(x, y, this.d_zDiv[0]);
                l2 = new Point3d(x, y, this.d_zDiv[this.d_zDiv.length - 1]);
                if (!Intersections.lineSegPolyIntersection(intersection, l1, l2, ZPOS, poly.d_plane, poly.d_points)) continue;
                this.addCell(new Point3i(xix, yix, Raster3D.getClampedBoundIndex(this.d_zDiv, intersection.z)));
            }
        }
    }

    private void rasterizeLineSeg(Point3d ... lineSeg) {
        this.rasterizeLineSeg(lineSeg[0], lineSeg[1], this.getIndex(lineSeg[0]), this.getIndex(lineSeg[1]));
    }

    private void rasterizeLineSeg(Point3d pa, Point3d pb, Point3i ixa, Point3i ixb) {
        int numXCells = Math.abs(ixb.x - ixa.x);
        int numYCells = Math.abs(ixb.y - ixa.y);
        int numZCells = Math.abs(ixb.z - ixa.z);
        int xix = ixa.x;
        int yix = ixa.y;
        int zix = ixa.z;
        if (numYCells == 0 && numZCells == 0) {
            int minX = Math.min(ixa.x, ixb.x);
            int maxX = Math.max(ixa.x, ixb.x);
            for (xix = minX; xix <= maxX; ++xix) {
                this.addCell(new Point3i(xix, yix, zix));
            }
            return;
        }
        if (numXCells == 0 && numZCells == 0) {
            int minY = Math.min(ixa.y, ixb.y);
            int maxY = Math.max(ixa.y, ixb.y);
            for (yix = minY; yix <= maxY; ++yix) {
                this.addCell(new Point3i(xix, yix, zix));
            }
            return;
        }
        if (numXCells == 0 && numYCells == 0) {
            int minZ = Math.min(ixa.z, ixb.z);
            int maxZ = Math.max(ixa.z, ixb.z);
            for (zix = minZ; zix <= maxZ; ++zix) {
                this.addCell(new Point3i(xix, yix, zix));
            }
            return;
        }
        MarchTester3D marchTester = new MarchTester3D(pa, pb, this.d_xDiv, this.d_yDiv, this.d_zDiv);
        int xinc = pb.x >= pa.x ? 1 : -1;
        int yinc = pb.y >= pa.y ? 1 : -1;
        int zinc = pb.z >= pa.z ? 1 : -1;
        while (true) {
            boolean zlimitReached;
            this.addCell(new Point3i(xix, yix, zix));
            boolean xlimitReached = xix == ixb.x;
            boolean ylimitReached = yix == ixb.y;
            boolean bl = zlimitReached = zix == ixb.z;
            if (xlimitReached && ylimitReached && zlimitReached) break;
            int nextx = xix + xinc;
            int nexty = yix + yinc;
            int nextz = zix + zinc;
            marchTester.test(!xlimitReached, !ylimitReached, !zlimitReached, xix, yix, zix, nextx, nexty, nextz);
            if (marchTester.marchX()) {
                xix = nextx;
            }
            if (marchTester.marchY()) {
                yix = nexty;
            }
            if (!marchTester.marchZ()) continue;
            zix = nextz;
        }
    }

    public void rasterizeSolid(IRasterization<? extends T> fillRast, IRasterization<? extends T>[] faceRasts, Point3d[][] polyPoints) {
        double x;
        int xix;
        int ix1;
        int ix;
        int m;
        List<RayFaceIntersection> intersections;
        double z;
        int zix;
        long timeBegin = System.nanoTime();
        ArrayList<Point3d[]> polys = new ArrayList<Point3d[]>(polyPoints.length);
        ArrayList<IRasterization<? extends T>> filteredFaceRasts = new ArrayList<IRasterization<? extends T>>(polyPoints.length);
        for (int m2 = 0; m2 < polyPoints.length; ++m2) {
            polyPoints[m2] = Raster3D.deleteAdjacentDuplicates(1.0E-9, polyPoints[m2]);
            if (polyPoints[m2].length < 3) continue;
            polys.add(polyPoints[m2]);
            filteredFaceRasts.add(faceRasts[m2]);
        }
        Point3i minix = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Point3i maxix = new Point3i(-2147483647, -2147483647, -2147483647);
        for (int m3 = 0; m3 < polys.size(); ++m3) {
            this.setRasterization((IRasterization)filteredFaceRasts.get(m3));
            Point3d[] clippedPoints = this.clipConvexPoly((Point3d[])polys.get(m3));
            for (int n = 0; n < clippedPoints.length; ++n) {
                this.rasterizeClippedEdges(minix, maxix, clippedPoints);
            }
        }
        Solid3D solid = new Solid3D(polys);
        HashMap<Solid3D.Face, IRasterization> faceRastMap = new HashMap<Solid3D.Face, IRasterization>(solid.getFaces().length);
        for (int m4 = 0; m4 < polys.size(); ++m4) {
            faceRastMap.put(solid.getFaces()[m4], (IRasterization)filteredFaceRasts.get(m4));
        }
        ArrayList<FillRange> xFillRanges = new ArrayList<FillRange>();
        ArrayList<FillRange> yFillRanges = new ArrayList<FillRange>();
        ArrayList<FillRange> zFillRanges = new ArrayList<FillRange>();
        int[] cellIxes = new int[polys.size()];
        Point3d l1 = new Point3d();
        Point3d l2 = new Point3d();
        for (zix = minix.z; zix <= maxix.z; ++zix) {
            for (int yix = minix.y; yix <= maxix.y; ++yix) {
                z = (this.d_zDiv[zix] + this.d_zDiv[zix + 1]) * 0.5;
                double y = (this.d_yDiv[yix] + this.d_yDiv[yix + 1]) * 0.5;
                l1.set(this.d_xDiv[0], y, z);
                l2.set(this.d_xDiv[this.d_xDiv.length - 1], y, z);
                intersections = Raster3D.getRaySolidIntersections(l1, XPOS, solid);
                if (intersections.isEmpty()) continue;
                if (intersections.size() % 2 != 0) {
                    System.err.println("Intersection count not even on x Ray/Solid intersection: " + y + ", " + z + "; " + intersections.size());
                    continue;
                }
                for (m = 0; m < intersections.size(); ++m) {
                    RayFaceIntersection rfIntersection = intersections.get(m);
                    ix = Raster3D.getUnclampedBoundIndex(this.d_xDiv, rfIntersection.d_intersection.x, 1.0);
                    if (ix >= 0 && ix < this.d_xDiv.length - 1) {
                        IRasterization rast = (IRasterization)faceRastMap.get(rfIntersection.d_face);
                        this.setRasterization(rast);
                        this.addCell(new Point3i(ix, yix, zix));
                    }
                    cellIxes[m] = ix;
                }
                Arrays.sort(cellIxes, 0, intersections.size());
                for (m = 0; m < intersections.size(); m += 2) {
                    int n = m + 1;
                    if (m < 0 && n < 0 || m > this.d_xDiv.length - 2 && n > this.d_xDiv.length - 2) continue;
                    if (m < -1) {
                        m = -1;
                    }
                    if (n > this.d_xDiv.length - 1) {
                        n = this.d_xDiv.length - 1;
                    }
                    ix1 = cellIxes[m] + 1;
                    int ix2 = cellIxes[n] - 1;
                    xFillRanges.add(new FillRange(this, yix, zix, ix1, ix2));
                }
            }
        }
        for (zix = minix.z; zix <= maxix.z; ++zix) {
            for (xix = minix.x; xix <= maxix.x; ++xix) {
                z = (this.d_zDiv[zix] + this.d_zDiv[zix + 1]) * 0.5;
                x = (this.d_xDiv[xix] + this.d_xDiv[xix + 1]) * 0.5;
                l1.set(x, this.d_yDiv[0], z);
                l2.set(x, this.d_yDiv[this.d_yDiv.length - 1], z);
                intersections = Raster3D.getRaySolidIntersections(l1, YPOS, solid);
                if (intersections.isEmpty()) continue;
                if (intersections.size() % 2 != 0) {
                    System.err.println("Intersection count not even on y Ray/Solid intersection: " + x + ", " + z + "; " + intersections.size());
                    continue;
                }
                for (m = 0; m < intersections.size(); ++m) {
                    RayFaceIntersection rfIntersection = intersections.get(m);
                    ix = Raster3D.getUnclampedBoundIndex(this.d_yDiv, rfIntersection.d_intersection.y, 1.0);
                    if (ix >= 0 && ix < this.d_yDiv.length - 1) {
                        IRasterization rast = (IRasterization)faceRastMap.get(rfIntersection.d_face);
                        this.setRasterization(rast);
                        this.addCell(new Point3i(xix, ix, zix));
                    }
                    cellIxes[m] = ix;
                }
                Arrays.sort(cellIxes, 0, intersections.size());
                for (m = 0; m < intersections.size(); m += 2) {
                    int n = m + 1;
                    if (m < 0 && n < 0 || m > this.d_yDiv.length - 2 && n > this.d_yDiv.length - 2) continue;
                    if (m < -1) {
                        m = -1;
                    }
                    if (n > this.d_yDiv.length - 1) {
                        n = this.d_yDiv.length - 1;
                    }
                    ix1 = cellIxes[m] + 1;
                    int ix2 = cellIxes[n] - 1;
                    yFillRanges.add(new FillRange(this, xix, zix, ix1, ix2));
                }
            }
        }
        for (int yix = minix.y; yix <= maxix.y; ++yix) {
            for (xix = minix.x; xix <= maxix.x; ++xix) {
                double y = (this.d_yDiv[yix] + this.d_yDiv[yix + 1]) * 0.5;
                x = (this.d_xDiv[xix] + this.d_xDiv[xix + 1]) * 0.5;
                l1.set(x, y, this.d_zDiv[0]);
                l2.set(x, y, this.d_zDiv[this.d_zDiv.length - 1]);
                intersections = Raster3D.getRaySolidIntersections(l1, ZPOS, solid);
                if (intersections.isEmpty()) continue;
                if (intersections.size() % 2 != 0) {
                    System.err.println("Intersection count not even on z Ray/Solid intersection: " + x + ", " + y + "; " + intersections.size());
                    continue;
                }
                for (m = 0; m < intersections.size(); ++m) {
                    RayFaceIntersection rfIntersection = intersections.get(m);
                    ix = Raster3D.getUnclampedBoundIndex(this.d_zDiv, rfIntersection.d_intersection.z, 1.0);
                    if (ix >= 0 && ix < this.d_zDiv.length - 1) {
                        IRasterization rast = (IRasterization)faceRastMap.get(rfIntersection.d_face);
                        this.setRasterization(rast);
                        this.addCell(new Point3i(xix, yix, ix));
                    }
                    cellIxes[m] = ix;
                }
                Arrays.sort(cellIxes, 0, intersections.size());
                for (m = 0; m < intersections.size(); m += 2) {
                    int n = m + 1;
                    if (m < 0 && n < 0 || m > this.d_zDiv.length - 2 && n > this.d_zDiv.length - 2) continue;
                    if (m < -1) {
                        m = -1;
                    }
                    if (n > this.d_zDiv.length - 1) {
                        n = this.d_zDiv.length - 1;
                    }
                    ix1 = cellIxes[m] + 1;
                    int ix2 = cellIxes[n] - 1;
                    zFillRanges.add(new FillRange(this, xix, yix, ix1, ix2));
                }
            }
        }
        for (FillRange xrange : xFillRanges) {
            for (int xix2 = xrange.localZBegin; xix2 <= xrange.localZEnd; ++xix2) {
                this.addCell(new Point3i(xix2, xrange.localx, xrange.localy));
            }
        }
        for (FillRange yrange : yFillRanges) {
            for (int yix = yrange.localZBegin; yix <= yrange.localZEnd; ++yix) {
                this.addCell(new Point3i(yrange.localx, yix, yrange.localy));
            }
        }
        for (FillRange zrange : zFillRanges) {
            for (int zix2 = zrange.localZBegin; zix2 <= zrange.localZEnd; ++zix2) {
                this.addCell(new Point3i(zrange.localx, zrange.localy, zix2));
            }
        }
        long timeEnd = System.nanoTime();
        System.out.println((double)(timeEnd - timeBegin) / 1.0E9);
    }

    private Point3d[] clipConvexPoly(Point3d ... poly) {
        return Raster3D.clipPolyToVolume(this.d_rastVolume, poly);
    }

    private static Point3d[] clipPolyToVolume(ConvexVolume volume, Point3d ... poly) {
        Point3d[] result = poly;
        for (ConvexPolygon clipPoly : volume.d_polys) {
            result = Raster3D.clipPolyToPoly(clipPoly, result);
        }
        return result;
    }

    private static Point3d[] clipPolyToPoly(ConvexPolygon clipPoly, Point3d ... poly) {
        LinkedList<Point3d> result = new LinkedList<Point3d>();
        for (int m = 0; m < poly.length; ++m) {
            boolean p2Pos;
            Point3d p1 = poly[m];
            Point3d p2 = poly[(m + 1) % poly.length];
            boolean p1Pos = Util.distance(p1, clipPoly.d_plane) >= 0.0;
            boolean bl = p2Pos = Util.distance(p2, clipPoly.d_plane) >= 0.0;
            if (p1Pos) {
                result.add(p1);
            }
            if (p1Pos && p2Pos || !p1Pos && !p2Pos) continue;
            Point3d intersection = new Point3d();
            Intersections.linePlaneIntersection(intersection, p1, p2, clipPoly.d_plane);
            result.add(intersection);
        }
        return result.toArray(new Point3d[result.size()]);
    }

    private static <T> T[] deleteAdjacentDuplicates(Class<T> type, T ... points) {
        if (points.length <= 1) {
            return points;
        }
        ArrayList<T> uniquePoints = new ArrayList<T>(points.length);
        for (int m = 0; m < points.length; ++m) {
            T currPoint = points[m];
            T nextPoint = points[(m + 1) % points.length];
            if (currPoint.equals(nextPoint)) continue;
            uniquePoints.add(currPoint);
        }
        if (uniquePoints.size() != points.length) {
            Object[] arr = (Object[])Array.newInstance(type, uniquePoints.size());
            return uniquePoints.toArray(arr);
        }
        return points;
    }

    private static Point3d[] deleteAdjacentDuplicates(double tol, Point3d ... points) {
        if (points.length <= 1) {
            return points;
        }
        ArrayList<Point3d> uniquePoints = new ArrayList<Point3d>(points.length);
        for (int m = 0; m < points.length; ++m) {
            Point3d currPoint = points[m];
            Point3d nextPoint = points[(m + 1) % points.length];
            if (currPoint.epsilonEquals(nextPoint, tol)) continue;
            uniquePoints.add(currPoint);
        }
        if (uniquePoints.size() != points.length) {
            return uniquePoints.toArray(new Point3d[uniquePoints.size()]);
        }
        return points;
    }

    private Point3i getIndex(Point3d p) {
        return new Point3i(Raster3D.getClampedBoundIndex(this.d_xDiv, p.x), Raster3D.getClampedBoundIndex(this.d_yDiv, p.y), Raster3D.getClampedBoundIndex(this.d_zDiv, p.z));
    }

    private static boolean doubleEq(double d1, double d2, double tol) {
        return Math.abs(d1 - d2) <= tol;
    }

    private static boolean doubleEq(Double d1, Double d2, double tol) {
        return Math.abs(d1 - d2) <= tol;
    }

    private static int getUnclampedBoundIndex(double[] divisions, double value, double boundaryRoundHint) {
        int ix = theUtil.binarySearch(divisions, value, d_comp);
        if (ix < 0) {
            ix = -(ix + 1);
            --ix;
        } else if (boundaryRoundHint < 0.0) {
            --ix;
        }
        return ix;
    }

    private static int getClampedBoundIndex(double[] divisions, double value) {
        int ix = Raster3D.getUnclampedBoundIndex(divisions, value, 1.0);
        if (ix < 0) {
            ix = 0;
        } else if (ix > divisions.length - 2) {
            ix = divisions.length - 2;
        }
        return ix;
    }

    private static List<RayFaceIntersection> getRaySolidIntersections(Point3d p, Vector3d dir, Solid3D solid) {
        RayFaceIntersection faceIntersection;
        HashSet<Solid3D.Face> edgeFacesToTest = Sets.fromArrayHS(solid.getFaces());
        ArrayList<RayFaceIntersection> intersections = new ArrayList<RayFaceIntersection>(solid.getFaces().length);
        Solid3D.Vertex[] verts = solid.getVerts();
        for (int m = 0; m < verts.length; ++m) {
            Solid3D.Vertex vert = verts[m];
            if (!Intersections.linePointIntersect(p, dir, vert.getLocation(), 1.0E-9)) continue;
            RayFaceIntersection faceIntersection2 = new RayFaceIntersection();
            faceIntersection2.d_intersection = vert.getLocation();
            faceIntersection2.d_face = vert.getFaces().iterator().next();
            intersections.add(faceIntersection2);
            if (!Raster3D.allFacesInSameAlignmentWithRay(dir, vert.getFaces())) {
                intersections.add(faceIntersection2);
            }
            for (Solid3D.Face face : vert.getFaces()) {
                edgeFacesToTest.remove(face);
            }
        }
        HashSet<Solid3D.Face> facesToTest = new HashSet<Solid3D.Face>(edgeFacesToTest);
        Solid3D.Edge[] edges = solid.getEdges();
        for (int m = 0; m < edges.length; ++m) {
            Point3d intersection;
            Solid3D.Edge edge = edges[m];
            if (!edgeFacesToTest.contains(edge.getFace1()) || !edgeFacesToTest.contains(edge.getFace2()) || (intersection = Intersections.lineLineSegIntersection(p, dir, edge.getP1().getLocation(), edge.getP2().getLocation(), edge.getDirection(), 1.0E-9)) == null) continue;
            faceIntersection = new RayFaceIntersection();
            faceIntersection.d_intersection = (Point3d)intersection.clone();
            faceIntersection.d_face = edge.getFace1();
            intersections.add(faceIntersection);
            if (!Raster3D.allFacesInSameAlignmentWithRay(dir, Arrays.asList(edge.getFace1(), edge.getFace2()))) {
                intersections.add(faceIntersection);
            }
            facesToTest.remove(edge.getFace1());
            facesToTest.remove(edge.getFace2());
        }
        Point3d intersection = new Point3d();
        for (Solid3D.Face face : facesToTest) {
            if (!Intersections.linePolyIntersection(intersection, p, dir, face.getPlaneEquation(), face.getPoints())) continue;
            faceIntersection = new RayFaceIntersection();
            faceIntersection.d_intersection = (Point3d)intersection.clone();
            faceIntersection.d_face = face;
            intersections.add(faceIntersection);
        }
        return intersections;
    }

    private static boolean allFacesInSameAlignmentWithRay(Vector3d dir, Collection<Solid3D.Face> faces) {
        int numPos = 0;
        int numNeg = 0;
        for (Solid3D.Face face : faces) {
            double dot = dir.dot(face.getNormal());
            if (Raster3D.doubleEq(dot, 0.0, 1.0E-9)) continue;
            if (dot < 0.0) {
                if (numPos > 0) {
                    return false;
                }
                ++numNeg;
                continue;
            }
            if (numNeg > 0) {
                return false;
            }
            ++numPos;
        }
        return true;
    }

    private class CellList {
        private final Map<Point3i, Cell<T>> d_cells;

        public CellList(int sizeHint) {
            this.d_cells = new HashMap(sizeHint);
        }

        public T[] getFrags(Collection<? extends IRasterization<? extends T>> rasts, boolean mergeCells) {
            if (mergeCells) {
                Map mergedCells = Raster3DMerger.mergeCells(rasts);
                Object[] frags = (Object[])Array.newInstance(Raster3D.this.d_fragType, mergedCells.size());
                int index = 0;
                for (Map.Entry entry : mergedCells.entrySet()) {
                    Raster3DMerger.MergedCell cell = entry.getKey();
                    frags[index++] = entry.getValue().getFragGenerator().generateFrag(Raster3D.this.d_xDiv[cell.x1], Raster3D.this.d_yDiv[cell.y1], Raster3D.this.d_zDiv[cell.z1], Raster3D.this.d_xDiv[cell.x2 + 1], Raster3D.this.d_yDiv[cell.y2 + 1], Raster3D.this.d_zDiv[cell.z2 + 1]);
                }
                return frags;
            }
            int numFrags = 0;
            for (IRasterization rast : rasts) {
                numFrags += rast.getCells().size();
            }
            Object[] frags = (Object[])Array.newInstance(Raster3D.this.d_fragType, numFrags);
            int index = 0;
            for (IRasterization rast : rasts) {
                for (Point3i cell : rast.getCells()) {
                    frags[index++] = rast.getFragGenerator().generateFrag(Raster3D.this.d_xDiv[cell.x], Raster3D.this.d_yDiv[cell.y], Raster3D.this.d_zDiv[cell.z], Raster3D.this.d_xDiv[cell.x + 1], Raster3D.this.d_yDiv[cell.y + 1], Raster3D.this.d_zDiv[cell.z + 1]);
                }
            }
            return frags;
        }

        public T[] getFrags(boolean mergeCells) {
            HashSet rasts = new HashSet();
            for (Map.Entry entry : this.d_cells.entrySet()) {
                rasts.add(entry.getValue().getCurrentRast());
            }
            return this.getFrags(rasts, mergeCells);
        }

        public void addCell(Point3i cellIx, IRasterization<? extends T> rast) {
            Cell<Object> cell = this.d_cells.get(cellIx);
            if (cell == null) {
                cell = new Cell(cellIx, rast);
                this.d_cells.put(cellIx, cell);
            } else {
                cell.addRast(cellIx, rast);
            }
        }

        public void removeCells(IRasterization<? extends T> rast) {
            Cell cell;
            for (Point3i cellIx : rast.getCells()) {
                cell = this.d_cells.get(cellIx);
                boolean cellEmpty = cell.removeCurrentRast(cellIx);
                if (!cellEmpty) continue;
                this.d_cells.remove(cellIx);
            }
            for (Point3i cellIx : rast.getPotentialCells()) {
                cell = this.d_cells.get(cellIx);
                cell.removePotentialRast(rast);
            }
            rast.clear();
        }

        public void clear() {
            this.d_cells.clear();
        }
    }

    private static class ConvexVolume {
        public final ConvexPolygon[] d_polys;

        public ConvexVolume(ConvexPolygon[] polys) {
            this.d_polys = polys;
        }
    }

    private static class MarchTester3D {
        private final MarchTester2D d_marchTesterXY;
        private final MarchTester2D d_marchTesterXZ;
        private final MarchTester2D d_marchTesterYZ;

        public MarchTester3D(Point3d pa, Point3d pb, double[] xDiv, double[] yDiv, double[] zDiv) {
            Line2d linexy = new Line2d(pa.x, pa.y, pb.x, pb.y);
            Line2d linexz = new Line2d(pa.x, pa.z, pb.x, pb.z);
            Line2d lineyz = new Line2d(pa.y, pa.z, pb.y, pb.z);
            this.d_marchTesterXY = new MarchTester2D(linexy, xDiv, yDiv);
            this.d_marchTesterXZ = new MarchTester2D(linexz, xDiv, zDiv);
            this.d_marchTesterYZ = new MarchTester2D(lineyz, yDiv, zDiv);
        }

        public void test(boolean testx, boolean testy, boolean testz, int xix, int yix, int zix, int nextx, int nexty, int nextz) {
            this.d_marchTesterXY.test(testx, testy, xix, yix, nextx, nexty);
            this.d_marchTesterXZ.test(testx, testz, xix, zix, nextx, nextz);
            this.d_marchTesterYZ.test(testy, testz, yix, zix, nexty, nextz);
        }

        public boolean marchX() {
            return this.d_marchTesterXY.march1 && this.d_marchTesterXZ.march1;
        }

        public boolean marchY() {
            return this.d_marchTesterXY.march2 && this.d_marchTesterYZ.march1;
        }

        public boolean marchZ() {
            return this.d_marchTesterXZ.march2 && this.d_marchTesterYZ.march2;
        }
    }

    private static class RayFaceIntersection {
        public Point3d d_intersection;
        public Solid3D.Face d_face;

        private RayFaceIntersection() {
        }
    }

    private class FillRange {
        public int localx;
        public int localy;
        public int localZBegin;
        public int localZEnd;

        public FillRange(Raster3D raster3D, int x, int y, int zBegin, int zEnd) {
            this.localx = x;
            this.localy = y;
            this.localZBegin = zBegin;
            this.localZEnd = zEnd;
        }
    }

    private static class Cell<T2> {
        private IRasterization<? extends T2> d_currentRast;
        private Set<IRasterization<? extends T2>> d_potentialRasts = new HashSet<IRasterization<? extends T2>>();

        public Cell(Point3i cellIx, IRasterization<? extends T2> rast) {
            this.d_currentRast = rast;
            this.d_currentRast.addCell(cellIx);
        }

        public IRasterization<? extends T2> getCurrentRast() {
            return this.d_currentRast;
        }

        public void addRast(Point3i cellIx, IRasterization<? extends T2> rast) {
            if (this.d_currentRast != rast && !this.d_potentialRasts.contains(rast)) {
                int currPriority;
                int newPriority = rast.getFragGenerator().getCellPriority();
                if (newPriority >= (currPriority = this.d_currentRast.getFragGenerator().getCellPriority())) {
                    rast.addPotentialCell(cellIx);
                    this.d_potentialRasts.add(rast);
                } else {
                    this.d_currentRast.removeCell(cellIx);
                    this.d_currentRast.addPotentialCell(cellIx);
                    this.d_potentialRasts.add(this.d_currentRast);
                    rast.addCell(cellIx);
                    this.d_currentRast = rast;
                }
            }
        }

        public boolean removeCurrentRast(Point3i cellIx) {
            if (this.d_potentialRasts.isEmpty()) {
                return true;
            }
            IRasterization<T2> nextInLine = this.getHighestPriorityRast();
            assert (nextInLine != null);
            nextInLine.removePotentialCell(cellIx);
            nextInLine.addCell(cellIx);
            this.d_potentialRasts.remove(nextInLine);
            this.d_currentRast = nextInLine;
            return false;
        }

        public void removePotentialRast(IRasterization<? extends T2> rast) {
            assert (rast != this.d_currentRast && this.d_currentRast != null);
            this.d_potentialRasts.remove(rast);
        }

        private IRasterization<? extends T2> getHighestPriorityRast() {
            assert (this.d_potentialRasts.size() > 0);
            IRasterization<T2> highest = null;
            int highestPriority = Integer.MAX_VALUE;
            for (IRasterization<T2> rast : this.d_potentialRasts) {
                int priority = rast.getFragGenerator().getCellPriority();
                if (priority == 0) {
                    return rast;
                }
                if (priority >= highestPriority) continue;
                highestPriority = priority;
                highest = rast;
            }
            return highest;
        }
    }

    private static class Line2d {
        public final Vector3d d_eq;

        public Line2d(double x1, double y1, double x2, double y2) {
            Vector2d dir = new Vector2d(x2 - x1, y2 - y1);
            dir.normalize();
            double nx = dir.y;
            double ny = -dir.x;
            double d = -(nx * x1 + ny * y1);
            this.d_eq = new Vector3d(nx, ny, d);
        }

        public double distToPoint(Point2d p) {
            return Math.abs(p.x * this.d_eq.x + p.y * this.d_eq.y + this.d_eq.z);
        }
    }

    private static class MarchTester2D {
        public boolean march1;
        public boolean march2;
        private final Line2d d_line;
        private final double[] d_div1;
        private final double[] d_div2;

        public MarchTester2D(Line2d line, double[] div1, double[] div2) {
            this.d_div1 = div1;
            this.d_div2 = div2;
            this.d_line = line;
        }

        public void test(boolean test1, boolean test2, int curr1, int curr2, int next1, int next2) {
            double dist2;
            if (!test1 && !test2) {
                this.march1 = false;
                this.march2 = false;
                return;
            }
            if (!test1) {
                this.march1 = false;
                this.march2 = true;
                return;
            }
            if (!test2) {
                this.march1 = true;
                this.march2 = false;
                return;
            }
            this.march1 = true;
            this.march2 = false;
            Point2d cellCenter1 = this.getCellCenter(next1, curr2);
            Point2d cellCenter2 = this.getCellCenter(next1, next2);
            double dist1 = this.d_line.distToPoint(cellCenter1);
            if (Raster3D.doubleEq(dist1, dist2 = this.d_line.distToPoint(cellCenter2), 1.0E-9) ? curr2 > next2 : dist1 < dist2) {
                return;
            }
            this.march2 = true;
            Point2d cellCenter3 = this.getCellCenter(curr1, next2);
            double dist3 = this.d_line.distToPoint(cellCenter3);
            if (Raster3D.doubleEq(dist2, dist3, 1.0E-9) ? next1 > curr1 : dist2 < dist3) {
                return;
            }
            this.march1 = false;
        }

        private Point2d getCellCenter(int ix1, int ix2) {
            return new Point2d((this.d_div1[ix1] + this.d_div1[ix1 + 1]) * 0.5, (this.d_div2[ix2] + this.d_div2[ix2 + 1]) * 0.5);
        }
    }
}

