/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LERandomAccessFile
implements DataInput,
DataOutput {
    private static final String EmbeddedCopyright = "Copyright 1998 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected RandomAccessFile r;
    byte[] w;

    public LERandomAccessFile(String f, String rw) throws IOException {
        this.r = new RandomAccessFile(f, rw);
        this.w = new byte[8];
    }

    public LERandomAccessFile(File f, String rw) throws IOException {
        this.r = new RandomAccessFile(f, rw);
        this.w = new byte[8];
    }

    @Override
    public final short readShort() throws IOException {
        this.r.readFully(this.w, 0, 2);
        return (short)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.r.readFully(this.w, 0, 2);
        return (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.r.readFully(this.w, 0, 2);
        return (char)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.r.readFully(this.w, 0, 4);
        return this.w[3] << 24 | (this.w[2] & 0xFF) << 16 | (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        this.r.readFully(this.w, 0, 8);
        return (long)this.w[7] << 56 | (long)(this.w[6] & 0xFF) << 48 | (long)(this.w[5] & 0xFF) << 40 | (long)(this.w[4] & 0xFF) << 32 | (long)(this.w[3] & 0xFF) << 24 | (long)(this.w[2] & 0xFF) << 16 | (long)(this.w[1] & 0xFF) << 8 | (long)(this.w[0] & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.r.write(this.w, 0, 2);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.r.write(this.w, 0, 2);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.w[2] = (byte)(v >> 16);
        this.w[3] = (byte)(v >> 24);
        this.r.write(this.w, 0, 4);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.w[2] = (byte)(v >> 16);
        this.w[3] = (byte)(v >> 24);
        this.w[4] = (byte)(v >> 32);
        this.w[5] = (byte)(v >> 40);
        this.w[6] = (byte)(v >> 48);
        this.w[7] = (byte)(v >> 56);
        this.r.write(this.w, 0, 8);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.r.getFD();
    }

    public final long getFilePointer() throws IOException {
        return this.r.getFilePointer();
    }

    public final long length() throws IOException {
        return this.r.length();
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.r.read(b, off, len);
    }

    public final int read(byte[] b) throws IOException {
        return this.r.read(b);
    }

    public final int read() throws IOException {
        return this.r.read();
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.r.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.r.readFully(b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.r.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.r.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.r.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.r.readUnsignedByte();
    }

    @Override
    public final String readLine() throws IOException {
        return this.r.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.r.readUTF();
    }

    public final void seek(long pos) throws IOException {
        this.r.seek(pos);
    }

    @Override
    public final synchronized void write(int b) throws IOException {
        this.r.write(b);
    }

    @Override
    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        this.r.write(b, off, len);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.r.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.r.writeByte(v);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.r.writeBytes(s);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.r.writeUTF(str);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.r.write(b, 0, b.length);
    }

    public final void close() throws IOException {
        this.r.close();
    }
}

