/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitBox3D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.GasPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

class ThcpProcessor
extends AFDSRecordProcessor {
    public ThcpProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "THCP";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        FDSRecordFormatException caughtExc;
        boolean err;
        block17: {
            err = false;
            caughtExc = null;
            try {
                if (rec.getType() == null) {
                    throw new Exception();
                }
                if (!"THCP".equals(rec.getType())) {
                    return false;
                }
                boolean uSup = this.containsUnsupportedRecords(rec);
                Vector xyz = (Vector)rec.getValue("XYZ");
                String quantity = (String)rec.getValue("QUANTITY");
                String label = (String)rec.getValue("LABEL");
                FdsSISystem system = FdsSISystem.getInstance();
                Unit lengthUnit = system.getLengthUnit();
                FdsSISystem si = FdsSISystem.getInstance();
                UnitDouble dtsam = rec.extractDouble("DTSAM", si.getTimeUnit(), null, (UnitDoubleValueRange)ThcpRecord.getValueRange("DTSAM"));
                Vector xb = (Vector)rec.getValue("XB");
                UnitDouble depth = rec.extractDouble("DEPTH", si.getLengthUnit(), null, null, true);
                UnitDouble diameter = rec.extractDouble("DIAMETER", si.getLengthUnit(), null, null, true);
                UnitDouble emissivity = rec.extractDouble("EMISSIVITY", si.getUnitlessUnit(), null, null, true);
                int ior = rec.extractInt("IOR", Integer.MIN_VALUE, null);
                int k_high = rec.extractInt("K_HIGH", Integer.MIN_VALUE, null);
                int k_low = rec.extractInt("K_LOW", Integer.MIN_VALUE, null);
                ThcpRecord thcpRec = new ThcpRecord();
                if (xyz != null) {
                    thcpRec.d_location = new UnitPoint3D((Double)xyz.elementAt(0), (Double)xyz.elementAt(1), (Double)xyz.elementAt(2), lengthUnit);
                }
                thcpRec.d_gasPhaseQuantity = quantity;
                if (label == null || label.equals("")) {
                    label = "Thermocouple";
                }
                thcpRec.d_label = label;
                thcpRec.d_dtsam = dtsam;
                if (xb != null) {
                    thcpRec.d_xb = new UnitBox3D((Double)xb.get(0), (Double)xb.get(2), (Double)xb.get(4), (Double)xb.get(1), (Double)xb.get(3), (Double)xb.get(5), si.getLengthUnit());
                }
                thcpRec.d_depth = depth;
                thcpRec.d_diameter = diameter;
                thcpRec.d_emissivity = emissivity;
                thcpRec.d_ior = ior != Integer.MIN_VALUE ? Integer.valueOf(ior) : null;
                thcpRec.d_kHigh = k_high != Integer.MIN_VALUE ? Integer.valueOf(k_high) : null;
                Integer n = thcpRec.d_kLow = k_low != Integer.MIN_VALUE ? Integer.valueOf(k_low) : null;
                if (!uSup && xyz != null && quantity != null) {
                    if (!this.getContainer().getThcpList().canMakeUnique(thcpRec)) {
                        return true;
                    }
                    this.getContainer().getThcpList().taskMakeUnique(thcpRec).run();
                    this.getContainer().getThcpList().taskAdd(thcpRec).run();
                    this.flagPyroTypeAffected(ThcpRecord.class);
                    break block17;
                }
                if (uSup && quantity != null) {
                    if (!(quantity.equalsIgnoreCase("VOLUME FLOW") || quantity.equalsIgnoreCase("MASS FLOW") || quantity.equalsIgnoreCase("HEAT FLOW") || quantity.equalsIgnoreCase("HRR"))) {
                        System.err.println("Unsupported integrated quantity in THCP.");
                        return false;
                    }
                    this.getContainer().getThcpList().taskMakeUnique(thcpRec).run();
                    this.getContainer().getThcpList().taskAdd(thcpRec).run();
                    this.flagPyroTypeAffected(ThcpRecord.class);
                    break block17;
                }
                throw new Exception();
            }
            catch (FDSRecordFormatException e) {
                err = true;
                caughtExc = e;
            }
            catch (NullPointerException e1) {
                err = true;
            }
            catch (ClassCastException e2) {
                err = true;
            }
            catch (ArrayIndexOutOfBoundsException e3) {
                err = true;
            }
            catch (Exception e4) {
                err = true;
            }
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }

    private boolean containsUnsupportedRecords(FDSInputRecord record) {
        GasPhaseQuantitiesList quans;
        String quantity = (String)record.getValue("QUANTITY");
        if (quantity != null && !(quans = new GasPhaseQuantitiesList()).contains(quantity)) {
            return true;
        }
        return record.getValue("DEPTH") != null || record.getValue("DIAMETER") != null || record.getValue("EMISSIVITY") != null || record.getValue("K_HIGH") != null || record.getValue("K_LOW") != null || record.getValue("XB") != null || record.getValue("IOR") != null;
    }
}

