/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.awt.geom.Line2D;
import java.util.Vector;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;

public class BoundsFunctions {
    public static final int BOUNDS_INTERSECT = 0;
    public static final int BOUNDS_DONT_INTERSECT = 1;
    public static final int BOUNDS1_CONTAINS_BOUNDS2 = 2;
    public static final int BOUNDS2_CONTAINS_BOUNDS1 = 3;

    public static int categorizeBoundaries(Bounds3D bounds1, Bounds3D bounds2) {
        int m;
        int numPointsInsideBounds2 = 0;
        int numPointsInsideBounds1 = 0;
        for (m = 0; m < 8; ++m) {
            Point3D pointBounds2;
            Point3D pointBounds1 = bounds1.d_points[m];
            if (bounds2.isPointInsideOrOnEdge(pointBounds1)) {
                ++numPointsInsideBounds2;
            }
            if (!bounds1.isPointInsideOrOnEdge(pointBounds2 = bounds2.d_points[m])) continue;
            ++numPointsInsideBounds1;
        }
        if (numPointsInsideBounds2 == 8) {
            return 3;
        }
        if (numPointsInsideBounds1 == 8) {
            return 2;
        }
        for (m = 0; m < 6; ++m) {
            if (!BoundsFunctions.faceIntersectsBoundary(bounds1.d_faces[m], bounds2)) continue;
            return 0;
        }
        return 1;
    }

    public static void divideBoundaries(Vector bounds1FacesInside, Vector bounds2FacesInside, Vector bounds1FacesOutsideBounds2, Vector bounds2FacesOutsideBounds1, Vector bounds1FacesToDivide, Vector bounds2FacesToDivide, Bounds3D bounds1, Bounds3D bounds2) {
        Face faceToSplit;
        Face insideFace;
        int m;
        for (m = 0; m < bounds1FacesToDivide.size(); ++m) {
            insideFace = new Face();
            faceToSplit = (Face)bounds1FacesToDivide.get(m);
            BoundsFunctions.splitFaceWithBoundary(bounds1FacesOutsideBounds2, insideFace, faceToSplit, bounds2);
            bounds1FacesInside.add(insideFace);
        }
        for (m = 0; m < bounds2FacesToDivide.size(); ++m) {
            insideFace = new Face();
            faceToSplit = (Face)bounds2FacesToDivide.get(m);
            BoundsFunctions.splitFaceWithBoundary(bounds2FacesOutsideBounds1, insideFace, faceToSplit, bounds1);
            bounds2FacesInside.add(insideFace);
        }
    }

    public static boolean splitFaceWithBoundary(Vector facesOutside, Face faceInside, Face f, Bounds3D bounds) {
        if (BoundsFunctions.faceLiesWithinBoundary(f, bounds)) {
            return false;
        }
        boolean split = false;
        if (BoundsFunctions.faceIntersectsBoundary(f, bounds)) {
            for (int m = 0; m < 6; ++m) {
                boolean faceSplit;
                Face faceOnPos;
                Face boundsFace = bounds.d_faces[m];
                int facesTouch = BoundsFunctions.facesTouch(f, boundsFace);
                if (facesTouch == 1) {
                    facesOutside.add(f);
                    continue;
                }
                if (facesTouch == -1) {
                    faceOnPos = new Face();
                    Face boundsFace2 = bounds.d_faces[(m + 2) % 6];
                    boolean faceSplit2 = BoundsFunctions.splitFaceWithBoundsFace(faceOnPos, faceInside, f, boundsFace2);
                    if (!faceSplit2) continue;
                    split = true;
                    facesOutside.add(faceOnPos);
                    BoundsFunctions.splitFaceWithBoundary(facesOutside, faceInside, (Face)faceInside.clone(), bounds);
                    continue;
                }
                if (!BoundsFunctions.faceIntersectsBoundaryFace(f, boundsFace) || !(faceSplit = BoundsFunctions.splitFaceWithBoundsFace(faceOnPos = new Face(), faceInside, f, boundsFace))) continue;
                split = true;
                facesOutside.add(faceOnPos);
                BoundsFunctions.splitFaceWithBoundary(facesOutside, faceInside, (Face)faceInside.clone(), bounds);
            }
        }
        if (!split) {
            facesOutside.add(f);
        }
        return split;
    }

    public static int facesTouch(Face f1, Face f2) {
        int faceOrientation = 0;
        if (f2.d_perpAxis == f1.d_perpAxis && f2.d_planeValue == f1.d_planeValue) {
            faceOrientation = f2.d_planeOrientation == -f1.d_planeOrientation ? -1 : 1;
        } else {
            return 0;
        }
        if (f1.isPointWithinInfiniteFaceBox(f2.d_points[0]) && f1.isPointWithinInfiniteFaceBox(f2.d_points[1]) && f1.isPointWithinInfiniteFaceBox(f2.d_points[2]) && f1.isPointWithinInfiniteFaceBox(f2.d_points[3]) || f2.isPointWithinInfiniteFaceBox(f1.d_points[0]) && f2.isPointWithinInfiniteFaceBox(f1.d_points[1]) && f2.isPointWithinInfiniteFaceBox(f1.d_points[2]) && f2.isPointWithinInfiniteFaceBox(f1.d_points[3])) {
            return faceOrientation;
        }
        for (int m = 0; m < 4; ++m) {
            Point3D point1f1 = f1.d_points[m];
            Point3D point2f1 = f1.d_points[(m + 1) % 4];
            Line2D.Double line1 = f1.d_perpAxis == 0 ? new Line2D.Double(point1f1.y, point1f1.z, point2f1.y, point2f1.z) : (f1.d_perpAxis == 1 ? new Line2D.Double(point1f1.x, point1f1.z, point2f1.x, point2f1.z) : new Line2D.Double(point1f1.x, point1f1.y, point2f1.x, point2f1.y));
            for (int n = 0; n < 4; ++n) {
                Point3D point1f2 = f2.d_points[n];
                Point3D point2f2 = f2.d_points[(n + 1) % 4];
                Line2D.Double line2 = f2.d_perpAxis == 0 ? new Line2D.Double(point1f2.y, point1f2.z, point2f2.y, point2f2.z) : (f2.d_perpAxis == 1 ? new Line2D.Double(point1f2.x, point1f2.z, point2f2.x, point2f2.z) : new Line2D.Double(point1f2.x, point1f2.y, point2f2.x, point2f2.y));
                if (!line1.intersectsLine(line2)) continue;
                return faceOrientation;
            }
        }
        return 0;
    }

    public static boolean faceLiesWithinBoundary(Face f, Bounds3D boundary) {
        int numPointsInBoundary = 0;
        for (int m = 0; m < 4; ++m) {
            if (!boundary.isPointInsideOrOnEdge(f.d_points[m])) continue;
            ++numPointsInBoundary;
        }
        return numPointsInBoundary == 4;
    }

    public static boolean faceIntersectsBoundary(Face f, Bounds3D boundary) {
        for (int n = 0; n < 6; ++n) {
            if (!BoundsFunctions.faceIntersectsBoundaryFace(f, boundary.d_faces[n])) continue;
            return true;
        }
        return false;
    }

    public static boolean faceIntersectsBoundaryFace(Face f, Face boundaryFace) {
        if (BoundsFunctions.facesTouch(f, boundaryFace) != 0) {
            return true;
        }
        for (int m = 0; m < 4; ++m) {
            if (!BoundsFunctions.edgeIntersectsFace(f.d_points[m], f.d_points[(m + 1) % 4], boundaryFace) && !BoundsFunctions.edgeIntersectsFace(boundaryFace.d_points[m], boundaryFace.d_points[(m + 1) % 4], f)) continue;
            return true;
        }
        return false;
    }

    public static boolean edgeIntersectsFace(Point3D p1, Point3D p2, Face f) {
        if (f.isPointWithinInfiniteFaceBox(p1)) {
            double testP1 = f.d_plane.testPoint(p1);
            double testP2 = f.d_plane.testPoint(p2);
            if (testP1 > 0.0 && testP2 < 0.0 || testP1 < 0.0 && testP2 > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static boolean splitFaceWithBoundsFace(Face faceOnPos, Face faceOnNeg, Face f, Face boundsFace) {
        for (int m = 0; m < 4; ++m) {
            Point3D point3PosFace;
            Point3D point0PosFace;
            Point3D point2NegFace;
            Point3D point1NegFace;
            Plane plane = f.d_plane;
            Point3D point0 = f.d_points[m];
            Point3D point1 = f.d_points[(m + 1) % 4];
            double testP0 = boundsFace.d_plane.testPoint(point0);
            double testP1 = boundsFace.d_plane.testPoint(point1);
            if (testP0 > 0.0 && testP1 < 0.0) {
                Point3D point3NegFace;
                Point3D point0NegFace;
                Point3D point2PosFace;
                Point3D point1PosFace;
                Point3D point2 = f.d_points[(m + 2) % 4];
                Point3D point3 = f.d_points[(m + 3) % 4];
                Point3D point0PosFace2 = point0;
                Point3D point3PosFace2 = point3;
                Point3D point1NegFace2 = point1;
                Point3D point2NegFace2 = point2;
                if (boundsFace.d_perpAxis == 0) {
                    point1PosFace = new Point3D(boundsFace.d_xMin, point1.y, point1.z);
                    point2PosFace = new Point3D(boundsFace.d_xMin, point2.y, point2.z);
                    point0NegFace = new Point3D(boundsFace.d_xMin, point0.y, point0.z);
                    point3NegFace = new Point3D(boundsFace.d_xMin, point3.y, point3.z);
                } else if (boundsFace.d_perpAxis == 1) {
                    point1PosFace = new Point3D(point1.x, boundsFace.d_yMin, point1.z);
                    point2PosFace = new Point3D(point2.x, boundsFace.d_yMin, point2.z);
                    point0NegFace = new Point3D(point0.x, boundsFace.d_yMin, point0.z);
                    point3NegFace = new Point3D(point3.x, boundsFace.d_yMin, point3.z);
                } else {
                    point1PosFace = new Point3D(point1.x, point1.y, boundsFace.d_zMin);
                    point2PosFace = new Point3D(point2.x, point2.y, boundsFace.d_zMin);
                    point0NegFace = new Point3D(point0.x, point0.y, boundsFace.d_zMin);
                    point3NegFace = new Point3D(point3.x, point3.y, boundsFace.d_zMin);
                }
                faceOnPos.setPoints(point0PosFace2, point1PosFace, point2PosFace, point3PosFace2, plane);
                faceOnNeg.setPoints(point0NegFace, point1NegFace2, point2NegFace2, point3NegFace, plane);
                return true;
            }
            if (!(testP0 < 0.0) || !(testP1 > 0.0)) continue;
            Point3D point2 = f.d_points[(m + 2) % 4];
            Point3D point3 = f.d_points[(m + 3) % 4];
            Point3D point0NegFace = point0;
            Point3D point3NegFace = point3;
            Point3D point1PosFace = point1;
            Point3D point2PosFace = point2;
            if (boundsFace.d_perpAxis == 0) {
                point1NegFace = new Point3D(boundsFace.d_xMin, point1.y, point1.z);
                point2NegFace = new Point3D(boundsFace.d_xMin, point2.y, point2.z);
                point0PosFace = new Point3D(boundsFace.d_xMin, point0.y, point0.z);
                point3PosFace = new Point3D(boundsFace.d_xMin, point3.y, point3.z);
            } else if (boundsFace.d_perpAxis == 1) {
                point1NegFace = new Point3D(point1.x, boundsFace.d_yMin, point1.z);
                point2NegFace = new Point3D(point2.x, boundsFace.d_yMin, point2.z);
                point0PosFace = new Point3D(point0.x, boundsFace.d_yMin, point0.z);
                point3PosFace = new Point3D(point3.x, boundsFace.d_yMin, point3.z);
            } else {
                point1NegFace = new Point3D(point1.x, point1.y, boundsFace.d_zMin);
                point2NegFace = new Point3D(point2.x, point2.y, boundsFace.d_zMin);
                point0PosFace = new Point3D(point0.x, point0.y, boundsFace.d_zMin);
                point3PosFace = new Point3D(point3.x, point3.y, boundsFace.d_zMin);
            }
            faceOnPos.setPoints(point0PosFace, point1PosFace, point2PosFace, point3PosFace, plane);
            faceOnNeg.setPoints(point0NegFace, point1NegFace, point2NegFace, point3NegFace, plane);
            return true;
        }
        return false;
    }

    public static String printFace(Face f) {
        Object s = "";
        for (int m = 0; m < 4; ++m) {
            s = (String)s + f.d_points[m].x + "," + f.d_points[m].y + "," + f.d_points[m].z + " : ";
        }
        return s;
    }

    public static void main(String[] args) {
        Face f1 = new Face(new Point3D(4.0, 0.0, 0.0), new Point3D(4.0, 0.0, 10.0), new Point3D(4.0, 5.0, 10.0), new Point3D(4.0, 5.0, 0.0), new Plane(1.0, 0.0, 0.0, -4.0));
        Face f2 = new Face(new Point3D(4.0, 5.0, 2.0), new Point3D(4.0, 5.0, 12.0), new Point3D(4.0, 7.0, 12.0), new Point3D(4.0, 7.0, 2.0), new Plane(-1.0, 0.0, 0.0, 4.0));
        int touching = BoundsFunctions.facesTouch(f1, f2);
        System.out.println(touching);
    }

    public static class Bounds3D {
        public double d_xMin;
        public double d_xMax;
        public double d_yMin;
        public double d_yMax;
        public double d_zMin;
        public double d_zMax;
        public Point3D d_mmm;
        public Point3D d_mmM;
        public Point3D d_mMm;
        public Point3D d_mMM;
        public Point3D d_Mmm;
        public Point3D d_MmM;
        public Point3D d_MMm;
        public Point3D d_MMM;
        public Face[] d_faces = new Face[6];
        public Point3D[] d_points = new Point3D[8];

        public Bounds3D(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax) {
            this.d_xMin = xMin;
            this.d_xMax = xMax;
            this.d_yMin = yMin;
            this.d_yMax = yMax;
            this.d_zMin = zMin;
            this.d_zMax = zMax;
            this.d_mmm = new Point3D(xMin, yMin, zMin);
            this.d_mmM = new Point3D(xMin, yMin, zMax);
            this.d_mMm = new Point3D(xMin, yMax, zMin);
            this.d_mMM = new Point3D(xMin, yMax, zMax);
            this.d_Mmm = new Point3D(xMax, yMin, zMin);
            this.d_MmM = new Point3D(xMax, yMin, zMax);
            this.d_MMm = new Point3D(xMax, yMax, zMin);
            this.d_MMM = new Point3D(xMax, yMax, zMax);
            this.d_points[0] = this.d_mmm;
            this.d_points[1] = this.d_mmM;
            this.d_points[2] = this.d_mMm;
            this.d_points[3] = this.d_mMM;
            this.d_points[4] = this.d_Mmm;
            this.d_points[5] = this.d_MmM;
            this.d_points[6] = this.d_MMm;
            this.d_points[7] = this.d_MMM;
            this.d_faces[0] = new Face(this.d_MMM, this.d_MMm, this.d_Mmm, this.d_MmM, new Plane(1.0, 0.0, 0.0, -xMax));
            this.d_faces[1] = new Face(this.d_mMM, this.d_mmM, this.d_mmm, this.d_mMm, new Plane(-1.0, 0.0, 0.0, xMin));
            this.d_faces[2] = new Face(this.d_MMM, this.d_mMM, this.d_mMm, this.d_MMm, new Plane(0.0, 1.0, 0.0, -yMax));
            this.d_faces[3] = new Face(this.d_mmM, this.d_MmM, this.d_Mmm, this.d_mmm, new Plane(0.0, -1.0, 0.0, yMin));
            this.d_faces[4] = new Face(this.d_mmM, this.d_mMM, this.d_MMM, this.d_MmM, new Plane(0.0, 0.0, 1.0, -zMax));
            this.d_faces[5] = new Face(this.d_mmm, this.d_Mmm, this.d_MMm, this.d_mMm, new Plane(0.0, 0.0, -1.0, zMin));
        }

        public boolean isPointInsideOrOnEdge(Point3D point) {
            return point.x <= this.d_xMax && point.x >= this.d_xMin && point.y <= this.d_yMax && point.y >= this.d_yMin && point.z <= this.d_zMax && point.z >= this.d_zMin;
        }

        public boolean isPointInside(Point3D point) {
            return point.x < this.d_xMax && point.x > this.d_xMin && point.y < this.d_yMax && point.y > this.d_yMin && point.z < this.d_zMax && point.z > this.d_zMin;
        }
    }

    public static class Face {
        public Point3D[] d_points = new Point3D[4];
        public double d_xMin;
        public double d_xMax;
        public double d_yMin;
        public double d_yMax;
        public double d_zMin;
        public double d_zMax;
        public Plane d_plane;
        public int d_perpAxis;
        public double d_planeValue;
        public double d_planeOrientation;
        public static final int X_AXIS = 0;
        public static final int Y_AXIS = 1;
        public static final int Z_AXIS = 2;

        public Face() {
        }

        public Face(Point3D p0, Point3D p1, Point3D p2, Point3D p3, Plane plane) {
            this.setPoints(p0, p1, p2, p3, plane);
        }

        public void setPoints(Point3D p0, Point3D p1, Point3D p2, Point3D p3, Plane plane) {
            this.d_points[0] = p0;
            this.d_points[1] = p1;
            this.d_points[2] = p2;
            this.d_points[3] = p3;
            this.d_plane = plane;
            this.d_xMin = Math.min(p0.x, p2.x);
            this.d_xMax = Math.max(p0.x, p2.x);
            this.d_yMin = Math.min(p0.y, p2.y);
            this.d_yMax = Math.max(p0.y, p2.y);
            this.d_zMin = Math.min(p0.z, p2.z);
            this.d_zMax = Math.max(p0.z, p2.z);
            if (this.d_xMin == this.d_xMax) {
                this.d_perpAxis = 0;
                this.d_planeValue = this.d_xMin;
                this.d_planeOrientation = this.d_plane.d_x;
            } else if (this.d_yMin == this.d_yMax) {
                this.d_perpAxis = 1;
                this.d_planeValue = this.d_yMin;
                this.d_planeOrientation = this.d_plane.d_y;
            } else {
                this.d_perpAxis = 2;
                this.d_planeValue = this.d_zMin;
                this.d_planeOrientation = this.d_plane.d_z;
            }
        }

        public Object clone() {
            return new Face(this.d_points[0], this.d_points[1], this.d_points[2], this.d_points[3], this.d_plane);
        }

        public boolean isPointWithinInfiniteFaceBox(Point3D point) {
            if (this.d_perpAxis == 0) {
                return point.y <= this.d_yMax && point.y >= this.d_yMin && point.z <= this.d_zMax && point.z >= this.d_zMin;
            }
            if (this.d_perpAxis == 1) {
                return point.x <= this.d_xMax && point.x >= this.d_xMin && point.z <= this.d_zMax && point.z >= this.d_zMin;
            }
            return point.x <= this.d_xMax && point.x >= this.d_xMin && point.y <= this.d_yMax && point.y >= this.d_yMin;
        }

        public boolean isPointOnInfiniteFaceBox(Point3D point) {
            if (this.d_perpAxis == 0) {
                return !(point.y != this.d_yMax && point.y != this.d_yMin || point.z != this.d_zMax && point.z != this.d_zMin);
            }
            if (this.d_perpAxis == 1) {
                return !(point.x != this.d_xMax && point.x != this.d_xMin || point.z != this.d_zMax && point.z != this.d_zMin);
            }
            return !(point.x != this.d_xMax && point.x != this.d_xMin || point.y != this.d_yMax && point.y != this.d_yMin);
        }
    }

    public static class Plane {
        public double d_x;
        public double d_y;
        public double d_z;
        public double d_w;

        public Plane(double x, double y, double z, double w) {
            this.d_x = x;
            this.d_y = y;
            this.d_z = z;
            this.d_w = w;
        }

        public double testPoint(Point3D point) {
            return this.d_x * point.x + this.d_y * point.y + this.d_z * point.z + this.d_w;
        }
    }
}

