/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.events;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;

public class FDSRasterDomainEvent
extends ADomainEvent {
    public static final byte CHANGE_GENERAL = 1;
    public static final byte CHANGE_SELECTION = 2;
    public static final byte CHANGE_VISIBILITY = 4;
    private final Set<FDSObjectRasterization> d_objs = new HashSet<FDSObjectRasterization>();
    private final Set<FDSObjectRasterization> d_objsAdded = new HashSet<FDSObjectRasterization>();
    private final Set<FDSObjectRasterization> d_objsRemoved = new HashSet<FDSObjectRasterization>();
    private final Map<FDSObjectRasterization, Change> d_changes = new HashMap<FDSObjectRasterization, Change>();
    private boolean d_previewChanged = false;

    public boolean hasChanges() {
        return this.d_previewChanged || !this.d_objsAdded.isEmpty() || !this.d_objsRemoved.isEmpty() || !this.d_changes.isEmpty();
    }

    public static FDSRasterDomainEvent previewModeChangedEvent() {
        FDSRasterDomainEvent evt = new FDSRasterDomainEvent();
        evt.previewModeChanged();
        return evt;
    }

    public void previewModeChanged() {
        this.d_previewChanged = true;
    }

    public boolean isPreviewModeChanged() {
        return this.d_previewChanged;
    }

    public void objectsAdded(FDSObjectRasterization ... objs) {
        for (FDSObjectRasterization obj : objs) {
            this.objectAdded(obj);
        }
    }

    public void objectsAdded(Collection<? extends FDSObjectRasterization> objs) {
        for (FDSObjectRasterization fDSObjectRasterization : objs) {
            this.objectAdded(fDSObjectRasterization);
        }
    }

    public void objectAdded(FDSObjectRasterization obj) {
        if (this.d_objs.add(obj)) {
            if (!this.d_objsRemoved.remove(obj)) {
                this.d_objsAdded.add(obj);
            } else {
                this.objectChanged((byte)1, obj);
            }
        }
    }

    public Set<FDSObjectRasterization> getObjectsAdded() {
        return this.d_objsAdded;
    }

    public void objectsRemoved(FDSObjectRasterization ... objs) {
        for (FDSObjectRasterization obj : objs) {
            this.objectRemoved(obj);
        }
    }

    public void objectsRemoved(Collection<? extends FDSObjectRasterization> objs) {
        for (FDSObjectRasterization fDSObjectRasterization : objs) {
            this.objectRemoved(fDSObjectRasterization);
        }
    }

    public void objectRemoved(FDSObjectRasterization obj) {
        if (this.d_objs.remove(obj) && !this.d_objsAdded.remove(obj)) {
            this.d_changes.remove(obj);
            this.d_objsRemoved.add(obj);
        }
    }

    public Set<FDSObjectRasterization> getObjectsRemoved() {
        return this.d_objsRemoved;
    }

    public void objectsChanged(byte change, FDSObjectRasterization ... objs) {
        for (FDSObjectRasterization obj : objs) {
            this.objectChanged(change, obj);
        }
    }

    public void objectsChanged(byte change, Collection<? extends FDSObjectRasterization> objs) {
        for (FDSObjectRasterization fDSObjectRasterization : objs) {
            this.objectChanged(change, fDSObjectRasterization);
        }
    }

    public void objectChanged(byte change, FDSObjectRasterization obj) {
        if (this.d_objs.contains(obj) && !this.d_objsAdded.contains(obj)) {
            Change c = this.d_changes.get(obj);
            if (c == null) {
                c = new Change(obj);
                this.d_changes.put(obj, c);
            }
            c.addChange(change);
        }
    }

    public Collection<Change> getChanges() {
        return this.d_changes.values();
    }

    public void objectChanged(FDSObjectRasterization obj) {
        this.objectChanged((byte)1, obj);
    }

    public void objectVisibilityChanged(FDSObjectRasterization obj) {
        this.objectChanged((byte)4, obj);
    }

    public void objectSelectionChanged(FDSObjectRasterization obj) {
        this.objectChanged((byte)2, obj);
    }

    @Override
    public void eventDispatched() {
        this.d_objsAdded.clear();
        this.d_objsRemoved.clear();
        this.d_changes.clear();
        this.d_previewChanged = false;
    }

    @Override
    public IDomainEvent.MergeResult merge(IDomainEvent nextEvent) {
        if (!(nextEvent instanceof FDSRasterDomainEvent)) {
            return IDomainEvent.MergeResult.keepBoth();
        }
        FDSRasterDomainEvent evt = (FDSRasterDomainEvent)nextEvent;
        if (evt.isPreviewModeChanged()) {
            this.previewModeChanged();
            return IDomainEvent.MergeResult.keepCurrent();
        }
        if (this.isPreviewModeChanged()) {
            evt.previewModeChanged();
            return IDomainEvent.MergeResult.keepNext();
        }
        return IDomainEvent.MergeResult.keepBoth();
    }

    public String toString() {
        String str = "";
        if (!this.d_objsAdded.isEmpty()) {
            str = this.addMessage(str, this.d_objsAdded.size(), "Added");
        }
        if (!this.d_objsRemoved.isEmpty()) {
            str = this.addMessage(str, this.d_objsRemoved.size(), "Removed");
        }
        if (!this.d_changes.isEmpty()) {
            int numChangedSelection;
            int numChangedVisibility;
            int numChangedGeneral = this.countChanges(1);
            if (numChangedGeneral > 0) {
                str = this.addMessage(str, numChangedGeneral, "Changed");
            }
            if ((numChangedVisibility = this.countChanges(4)) > 0) {
                str = this.addMessage(str, numChangedVisibility, "Visibility Changed");
            }
            if ((numChangedSelection = this.countChanges(2)) > 0) {
                str = this.addMessage(str, numChangedSelection, "Selection Changed");
            }
        }
        if (this.isPreviewModeChanged()) {
            str = this.addMessage(str, this.d_objs.size(), "Preview Mode Changed");
        }
        return str;
    }

    private String addMessage(String str, int count, String type) {
        if (((String)str).length() > 0) {
            str = (String)str + System.getProperty("line.separator");
        }
        str = (String)str + "FDSRasterDomainEvent: " + type + " (" + count + " objects)";
        return str;
    }

    private int countChanges(int type) {
        int numChanges = 0;
        for (Change c : this.d_changes.values()) {
            if ((c.getChanges() & type) != type) continue;
            ++numChanges;
        }
        return numChanges;
    }

    public static class Change {
        private byte d_changes = 0;
        private final FDSObjectRasterization d_obj;

        private Change(FDSObjectRasterization obj) {
            this.d_obj = obj;
        }

        private void addChange(byte change) {
            this.d_changes = (byte)(this.d_changes | change);
        }

        public FDSObjectRasterization getObject() {
            return this.d_obj;
        }

        public int getChanges() {
            return this.d_changes;
        }

        public boolean isSelectionChanged() {
            return (this.d_changes & 2) == 2;
        }

        public boolean isVisbilityChanged() {
            return (this.d_changes & 4) == 4;
        }

        public boolean isChanged() {
            return (this.d_changes & 1) == 1;
        }
    }
}

