/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.dependencies;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSConvexPoly;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.Hole;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;

public final class FDSDependencyMap {
    private static Map<Class, Set<Class>> d_fdsDependedOnDependencies = new HashMap<Class, Set<Class>>();
    private static Map<Class, Set<Class>> d_fdsDependentDependencies;

    public static Map<Class, Set<Class>> getPossibleDependenciesForObjectsDependedOn() {
        return d_fdsDependedOnDependencies;
    }

    public static Map<Class, Set<Class>> getPossibleDependenciesForDependentObjects() {
        return d_fdsDependentDependencies;
    }

    private static Set<Class> getMaterialDependents() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(FDSConvexPoly.class);
        deps.add(Vent.class);
        deps.add(Wall.class);
        deps.add(AlignedBlock.class);
        deps.add(Slab.class);
        deps.add(PyroMod.MiscRecord.class);
        deps.add(FDSComposite.class);
        return deps;
    }

    private static Set<Class> getHeatDetectorDependents() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(FDSConvexPoly.class);
        deps.add(Vent.class);
        deps.add(AlignedBlock.class);
        deps.add(Wall.class);
        deps.add(Slab.class);
        deps.add(AlignedHole.class);
        deps.add(Hole.class);
        deps.add(FDSComposite.class);
        return deps;
    }

    private static Set<Class> getSmokeDetectorDependents() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(Vent.class);
        deps.add(AlignedBlock.class);
        deps.add(Wall.class);
        deps.add(Slab.class);
        deps.add(AlignedHole.class);
        deps.add(Hole.class);
        deps.add(FDSComposite.class);
        return deps;
    }

    private static Set<Class> getPartRecordDependents() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(Material.class);
        deps.add(SprkRecord.class);
        return deps;
    }

    private static Set<Class> getReactionDependents() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(PyroMod.MiscRecord.class);
        return deps;
    }

    private static Set<Class> getDependedOnByAbstractFDSObject() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(Material.class);
        deps.add(HeatDetector.class);
        return deps;
    }

    private static Set<Class> getDependedOnByAlignedBlock() {
        return FDSDependencyMap.getDependedOnByAbstractFDSObject();
    }

    private static Set<Class> getDependedOnByWall() {
        return FDSDependencyMap.getDependedOnByAbstractFDSObject();
    }

    private static Set<Class> getDependedOnBySlab() {
        return FDSDependencyMap.getDependedOnByAbstractFDSObject();
    }

    private static Set<Class> getDependedOnByVent() {
        return FDSDependencyMap.getDependedOnByAbstractFDSObject();
    }

    private static Set<Class> getDependedOnByHole() {
        Set<Class> deps = FDSDependencyMap.getDependedOnByAbstractFDSObject();
        deps.remove(Material.class);
        return deps;
    }

    private static Set<Class> getDependedOnByFDSComposite() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.addAll(FDSDependencyMap.getDependedOnByWall());
        deps.addAll(FDSDependencyMap.getDependedOnByVent());
        deps.addAll(FDSDependencyMap.getDependedOnByAlignedBlock());
        deps.addAll(FDSDependencyMap.getDependedOnByHole());
        return deps;
    }

    private static Set<Class> getDependedOnByMaterial() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(PartRecord.class);
        return deps;
    }

    private static Set<Class> getDependedOnBySprkRecord() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(PartRecord.class);
        return deps;
    }

    private static Set<Class> getDependedOnByMiscRecord() {
        HashSet<Class> deps = new HashSet<Class>();
        deps.add(Material.class);
        deps.add(Reaction.class);
        return deps;
    }

    static {
        d_fdsDependedOnDependencies.put(Material.class, FDSDependencyMap.getMaterialDependents());
        d_fdsDependedOnDependencies.put(HeatDetector.class, FDSDependencyMap.getHeatDetectorDependents());
        d_fdsDependedOnDependencies.put(SmodRecord.class, FDSDependencyMap.getSmokeDetectorDependents());
        d_fdsDependedOnDependencies.put(PartRecord.class, FDSDependencyMap.getPartRecordDependents());
        d_fdsDependedOnDependencies.put(Reaction.class, FDSDependencyMap.getReactionDependents());
        d_fdsDependentDependencies = new HashMap<Class, Set<Class>>();
        d_fdsDependentDependencies.put(FDSConvexPoly.class, FDSDependencyMap.getDependedOnByAlignedBlock());
        d_fdsDependentDependencies.put(AlignedBlock.class, FDSDependencyMap.getDependedOnByAlignedBlock());
        d_fdsDependentDependencies.put(Wall.class, FDSDependencyMap.getDependedOnByWall());
        d_fdsDependentDependencies.put(Vent.class, FDSDependencyMap.getDependedOnByVent());
        d_fdsDependentDependencies.put(AlignedHole.class, FDSDependencyMap.getDependedOnByHole());
        d_fdsDependentDependencies.put(Hole.class, FDSDependencyMap.getDependedOnByHole());
        d_fdsDependentDependencies.put(Slab.class, FDSDependencyMap.getDependedOnBySlab());
        d_fdsDependentDependencies.put(FDSComposite.class, FDSDependencyMap.getDependedOnByFDSComposite());
        d_fdsDependentDependencies.put(Material.class, FDSDependencyMap.getDependedOnByMaterial());
        d_fdsDependentDependencies.put(SprkRecord.class, FDSDependencyMap.getDependedOnBySprkRecord());
        d_fdsDependentDependencies.put(PyroMod.MiscRecord.class, FDSDependencyMap.getDependedOnByMiscRecord());
    }
}

