/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManOpTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.ReactionDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class ReactionList
extends APyroDomainManager<String, Reaction>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SortedSet<Reaction> d_reacs = new TreeSet<Reaction>(new LinOrd());

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Object obj = fields.get("d_reacs", null);
        if (obj instanceof List) {
            this.d_reacs = new TreeSet<Reaction>(new LinOrd());
            this.d_reacs.addAll((List)obj);
        } else {
            this.d_reacs = (SortedSet)obj;
        }
    }

    @Override
    public Collection<? extends Reaction> toCollection() {
        return new PyroCollection<String, Reaction>(this);
    }

    public static ReactionList fromLegacy(pyrosim.legacy_2006_2.legacy.ReactionList old) {
        ReactionList newReacs = new ReactionList();
        Reaction[] allReacs = old.getAllReactions();
        for (int i = 0; i < allReacs.length; ++i) {
            newReacs.add(allReacs[i]);
        }
        return newReacs;
    }

    @Override
    public int size() {
        return this.d_reacs.size();
    }

    @Override
    public boolean contains(String reacName) {
        return this.get(reacName) != null;
    }

    public Reaction[] toArray() {
        return this.d_reacs.toArray(new Reaction[this.d_reacs.size()]);
    }

    public int indexOf(Reaction r) {
        Iterator it = this.d_reacs.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (it.next() == r) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean add(Reaction r, int index) {
        return this.add(r);
    }

    @Override
    protected boolean add(Reaction r) {
        Reaction oldReac = this.get(r.getName());
        if (oldReac != null) {
            return false;
        }
        super.add(r);
        this.d_reacs.add(r);
        this.fireDomainEvent(new ReactionDomainEvent(this, r, 3));
        return true;
    }

    @Override
    public Reaction get(String name) {
        for (Reaction reac : this.d_reacs) {
            if (!reac.getName().equals(name)) continue;
            return reac;
        }
        return null;
    }

    @Override
    public Reaction get(int index) {
        return (Reaction)this.d_reacs.toArray()[index];
    }

    @Override
    protected boolean remove(Reaction r) {
        boolean result = this.d_reacs.remove(r);
        super.remove(r);
        this.fireDomainEvent(new ReactionDomainEvent(this, r, 4));
        return result;
    }

    private boolean removeAll(Collection<? extends Reaction> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (Reaction reaction : objs) {
            if (this.remove(reaction)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    @Override
    public Object clone() {
        ReactionList res = new ReactionList();
        for (Reaction original : this.d_reacs) {
            Reaction newReac = (Reaction)original.clone();
            res.add(newReac);
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.d_reacs.isEmpty();
    }

    public Reaction[] toArray(Reaction[] array) {
        return this.d_reacs.toArray(array);
    }

    @Override
    public Iterator<Reaction> iterator() {
        return this.d_reacs.iterator();
    }

    @Override
    public Class<Reaction> getVClass() {
        return Reaction.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(Reaction pyroObject) {
        return true;
    }

    @Override
    public Task taskMakeUnique(Reaction pyroObject) {
        return new AMakeUniqueNameTask<Reaction>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(Reaction obj) {
                return obj.taskSetName(APyroDomainManager.getUniqueName(ReactionList.this, obj.getName()));
            }
        };
    }

    public Task taskSetMatName(final Reaction reac, String name) {
        return new AChangePyroDepOnIDTask(reac, name, this.getDomains()){

            @Override
            public void setID(String newID) {
                this.pauseUpdates();
                ReactionList.this.d_reacs.remove(reac);
                reac.setName(newID);
                ReactionList.this.d_reacs.add(reac);
                ReactionList.this.fireDomainEvent(new ReactionDomainEvent(ReactionList.this.toCollection(), 2));
                this.resumeUpdates();
            }
        };
    }

    @Override
    public Reaction get(Reaction pyroObject) {
        return this.get(pyroObject.getName());
    }

    @Override
    public String describeObject(Reaction pyroObject) {
        return pyroObject.getName();
    }

    public Task taskAdd(Reaction pyroObject, int index) {
        return this.taskAddAll(Arrays.asList(pyroObject), index);
    }

    public Task taskAddAll(Collection<Reaction> pyroObjects, int index) {
        APyroManAddAtIndexTask<String, Reaction> t = new APyroManAddAtIndexTask<String, Reaction>((IPyroManager)this, pyroObjects, index){

            @Override
            public void removeAll(Collection<? extends Reaction> objs) {
                ReactionList.this.removeAll(objs);
            }

            @Override
            public boolean add(Reaction obj, int index) {
                return ReactionList.this.add(obj, index);
            }
        };
        return new AddTask(this, t);
    }

    @Override
    public Task taskAddAll(Collection<? extends Reaction> pyroObjects) {
        APyroManAddTask<String, Reaction> t = new APyroManAddTask<String, Reaction>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(Reaction obj) {
                return ReactionList.this.add(obj);
            }

            @Override
            public boolean remove(Reaction obj) {
                return ReactionList.this.remove(obj);
            }
        };
        return new AddTask(this, t);
    }

    @Override
    public Task taskRemoveAll(List<Reaction> pyroObjects, List<Reaction> replacements) {
        return new APyroManReplaceDepOnTask<String, Reaction>((IPyroManager)this, pyroObjects, replacements, this.getDomains()){

            @Override
            public boolean add(Reaction obj) {
                return ReactionList.this.add(obj);
            }

            @Override
            public boolean remove(Reaction obj) {
                return ReactionList.this.remove(obj);
            }
        };
    }

    private static class LinOrd
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 8666170485159989321L;

        private LinOrd() {
        }

        public int compare(Object o1, Object o2) {
            Reaction r1 = (Reaction)o1;
            Reaction r2 = (Reaction)o2;
            return r1.getName().compareToIgnoreCase(r2.getName());
        }
    }

    private static class AddTask
    extends CompositeTask<PyroMod> {
        private final ReactionList d_parent;
        private final APyroManOpTask d_mainAddTask;

        public AddTask(ReactionList parent, APyroManOpTask mainAddTask) {
            super(parent.getDomains());
            this.d_parent = parent;
            this.d_mainAddTask = mainAddTask;
        }

        @Override
        protected void queueBeginRuntimeTasks() {
            Collection addReacs = this.d_mainAddTask.getObjects();
            if (addReacs.isEmpty()) {
                return;
            }
            this.addTask(this.d_mainAddTask);
            if (this.d_parent.isEmpty()) {
                Reaction firstReac = (Reaction)addReacs.iterator().next();
                PyroMod.MiscRecord misc = ((PyroMod)this.getDomains().iterator().next()).getMiscManager().getMiscRecord();
                this.addTask(misc.taskSetReaction(firstReac.getName()));
            }
        }
    }
}

