/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class PL3DRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public static final int MAX_QUANTITIES = 5;
    public static final int MIN_QUANTITIES = 1;
    protected Hashtable d_hQuantities = new Hashtable(5);
    protected UnitDouble d_udDTSam;
    protected boolean d_bEnabled = true;
    protected boolean d_bWriteXYZ = false;
    private static final Hashtable<String, ValueRange> d_ranges;

    public static ValueRange getValueRange(String field) {
        return d_ranges.get(field);
    }

    public PL3DRecord(UnitDouble dtsam) {
        this.d_hQuantities.put("TEMPERATURE", "TEMPERATURE");
        this.d_hQuantities.put("U-VELOCITY", "U-VELOCITY");
        this.d_hQuantities.put("V-VELOCITY", "V-VELOCITY");
        this.d_hQuantities.put("W-VELOCITY", "W-VELOCITY");
        this.d_hQuantities.put("HRRPUV", "HRRPUV");
        this.d_udDTSam = dtsam;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if ((!(ois instanceof PyroSimObjectInputStream) || ois instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)ois).getVersion() < 13) && this.d_udDTSam != null && !PL3DRecord.getValueRange("DTSAM").checkValue(this.d_udDTSam)) {
            this.d_udDTSam = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PL3DRecord)) {
            return false;
        }
        PL3DRecord p = (PL3DRecord)o;
        boolean equal = this.d_hQuantities.equals(p.d_hQuantities) && this.d_bEnabled == p.d_bEnabled && this.d_bWriteXYZ == p.d_bWriteXYZ && (this.d_udDTSam == null ? p.d_udDTSam == null : this.d_udDTSam.equals(p.d_udDTSam));
        return equal;
    }

    public void setDTSam(UnitDouble dtsam) {
        this.d_udDTSam = dtsam;
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    public UnitDouble getDTSam() {
        return this.d_udDTSam;
    }

    public void setWriteXYZ(boolean writeXYZ) {
        this.d_bWriteXYZ = writeXYZ;
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    public boolean getWriteXYZ() {
        return this.d_bWriteXYZ;
    }

    public String[] getQuantities() {
        return this.d_hQuantities.values().toArray(new String[this.d_hQuantities.size()]);
    }

    public boolean addQuantity(String quantity) {
        String existing = (String)this.d_hQuantities.get(quantity);
        if (existing != null) {
            return false;
        }
        this.d_hQuantities.put(quantity, quantity);
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
        return true;
    }

    public boolean removeQuantity(String quantity) {
        if (this.d_hQuantities.remove(quantity) == null) {
            return false;
        }
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
        return true;
    }

    public void clearQuantities() {
        this.d_hQuantities.clear();
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    @Override
    public String getFDSType() {
        return "PL3D";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord record = new FDSInputRecord();
        record.setType("PL3D");
        String[] quantitiesS = this.getQuantities();
        Vector<String> quantities = new Vector<String>(this.d_hQuantities.size());
        for (int m = 0; m < quantitiesS.length; ++m) {
            quantities.add(quantitiesS[m]);
        }
        record.setValue("QUANTITIES", quantities);
        FdsSISystem us = FdsSISystem.getInstance();
        if (this.d_udDTSam != null) {
            record.setValue("DTSAM", this.d_udDTSam.getValue(us.getTimeUnit()));
        }
        record.setValue("WRITE_XYZ", this.d_bWriteXYZ);
        recs.add(record);
    }

    public boolean isEnabled() {
        return this.d_bEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.d_hQuantities.size() > 0) {
            this.d_bEnabled = enabled;
        }
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Plot3D Record";
    }

    @Override
    public Object clone() {
        PL3DRecord rec = new PL3DRecord(this.d_udDTSam != null ? (UnitDouble)this.d_udDTSam.clone() : null);
        rec.d_bEnabled = this.d_bEnabled;
        rec.d_bWriteXYZ = this.d_bWriteXYZ;
        rec.d_hQuantities = (Hashtable)this.d_hQuantities.clone();
        return rec;
    }

    static {
        FdsSISystem si = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
    }
}

