/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatActivationEventList;
import pyrosim.legacy_2006_2.domain.TimeActivationEventList;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public abstract class AbstractActivationEventList
extends ADomainObject<PyroMod>
implements ActivationEventList,
Serializable {
    static final long serialVersionUID = 1L;
    private int d_iEventType;

    public AbstractActivationEventList(int eventType, Set<PyroMod> mediators) {
        this.d_iEventType = eventType;
        for (PyroMod mod : mediators) {
            super.addDomain(mod);
        }
    }

    @Override
    public void addDomain(PyroMod domain) {
        super.addDomain(domain);
        for (ActivationEvent evt : this.getAllEvents()) {
            evt.addDomain(domain);
        }
    }

    @Override
    public void removeDomain(PyroMod domain) {
        super.removeDomain(domain);
        for (ActivationEvent evt : this.getAllEvents()) {
            evt.removeDomain(domain);
        }
    }

    @Override
    public int getEventType() {
        return this.d_iEventType;
    }

    public static ActivationEventList createNewList(int type, Set<PyroMod> mediators) {
        switch (type) {
            case 0: {
                return new TimeActivationEventList(mediators);
            }
            case 1: {
                return new HeatActivationEventList(mediators);
            }
        }
        return null;
    }
}

