/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy.v160.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.AOutFlowSurfDesc;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.HeatTransfer3D;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.Variant;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class HeatTransfer3DSurfDesc
extends AOutFlowSurfDesc
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    public final double d_cellSize;
    public final TempRegulation d_temperature;
    public final Fuel.IReaction d_iReac;
    public final boolean d_burnAway;
    public final SpecInjList d_specInj;
    public final ZonePath d_leakPath;
    public Material d_material;

    public HeatTransfer3DSurfDesc(Fuel.IReaction reac, SpecInjList specInj, ParticleInjection partInj, boolean burnAway, ZonePath leakPath, TempRegulation tr, double cellSize, Material mat) {
        super(partInj);
        this.d_specInj = specInj;
        this.d_iReac = reac;
        this.d_burnAway = burnAway;
        this.d_leakPath = leakPath;
        this.d_temperature = tr;
        this.d_cellSize = cellSize;
        this.d_material = mat;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + theUtil.hashCode(this.d_iReac);
        hash = 31 * hash + theUtil.hashCode(this.d_specInj);
        hash = 31 * hash + theUtil.hashCode(this.d_burnAway);
        hash = 31 * hash + theUtil.hashCode(this.d_leakPath);
        hash = 31 * hash + theUtil.hashCode(this.d_temperature);
        hash = 31 * hash + theUtil.hashCode(this.d_cellSize);
        hash = 31 * hash + theUtil.hashCode(this.d_material);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HeatTransfer3DSurfDesc)) {
            return false;
        }
        HeatTransfer3DSurfDesc other = (HeatTransfer3DSurfDesc)obj;
        return super.equals(obj) && this.d_iReac.equals(other.d_iReac) && theUtil.equal(this.d_specInj, other.d_specInj) && this.d_burnAway == other.d_burnAway && theUtil.equal(this.d_leakPath, other.d_leakPath) && this.d_temperature.equals(other.d_temperature) && theUtil.eq(this.d_cellSize, other.d_cellSize, 1.0E-9) && theUtil.equal(this.d_material, other.d_material);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_material);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, Material.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old != null && old == this.d_material) {
            return new AReplaceRefTask<Material>((Object)this.d_material, (Object)replacement){

                @Override
                protected void set(Material obj) {
                    HeatTransfer3DSurfDesc.this.d_material = obj;
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    private Object readResolve() throws ObjectStreamException {
        Variant tf = SurfComposition.TEMP_RAMP_INTERNAL.getDefault();
        SurfComposition.SurfLayer.SurfComponent surfComponent = new SurfComposition.SurfLayer.SurfComponent(1.0, this.d_material);
        SurfComposition.SurfLayer layer = new SurfComposition.SurfLayer(null, Collections.singleton(surfComponent));
        SurfComposition sc = new SurfComposition(tf, new Backing.Exposed(), null, Collections.singletonList(layer));
        HeatTransfer3D ht3d = new HeatTransfer3D(false, new UnitDouble(this.d_cellSize, SI.METER));
        return new LayeredSurfDesc(IGeometry.DEFAULT, null, this.d_iReac, sc, this.d_specInj, this.d_partInj, this.d_burnAway, this.d_leakPath, this.d_temperature, ht3d);
    }
}

