/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.FDSNameMap;
import pyrosim.io.fds.v7.renderers.PinConnectionRenderer;
import pyrosim.unitsystem.SIUS;

public class RampRenderer {
    public static boolean render(IFDSRecordRenderer props, Map<String, Ramp> ramps, PinConnectionRenderer pinConns) {
        boolean rendered = false;
        for (Map.Entry<String, Ramp> entry : ramps.entrySet()) {
            if (!RampRenderer.render(props, entry.getKey(), entry.getValue(), pinConns)) continue;
            rendered = true;
        }
        return rendered;
    }

    public static boolean render(IFDSRecordRenderer props, String name, Ramp obj, PinConnectionRenderer pinConns) {
        Unit tUnit = SIUS.unit(obj.getTUnitType());
        Unit fUnit = SIUS.unit(obj.getFUnitType());
        boolean first = true;
        for (Ramp.Entry entry : obj.getRecords()) {
            FDSRenderRecord rec = FDS7Const.newRenderRecord("RAMP");
            rec.setValue("ID", name);
            rec.setValue(obj.getInput().getTVar(), entry.t.getValue(tUnit));
            rec.setValue("F", entry.f.getValue(fUnit));
            if (obj.getInput() instanceof SignalInput && first) {
                SignalInput si = (SignalInput)obj.getInput();
                String id = pinConns.getID(si.input);
                if (id != null) {
                    rec.setValue("DEVC_ID", id, false);
                } else {
                    String msg = String.format("Unable to render RAMP(%s). PinConnection not found.", name);
                    System.err.println(msg);
                    return false;
                }
            }
            props.render(rec, null);
            first = false;
        }
        return !obj.getRecords().isEmpty();
    }

    public static String createID(FDSNameMap nameMap, String ownerID, String fieldName) {
        String baseName = ownerID + "_" + fieldName;
        String id = nameMap.generateName("RAMP", baseName);
        return id;
    }
}

