/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.Grid;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.io.fds.FDSPrintRenderer;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.FDS7QuantityMap;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import pyrosim.io.fds.v7.renderers.BoundariesRenderer;
import pyrosim.io.fds.v7.renderers.ControlRenderer;
import pyrosim.io.fds.v7.renderers.DeviceRenderer;
import pyrosim.io.fds.v7.renderers.ExSpecRenderer;
import pyrosim.io.fds.v7.renderers.FDSNameMap;
import pyrosim.io.fds.v7.renderers.GeomRenderer;
import pyrosim.io.fds.v7.renderers.GridRenderer;
import pyrosim.io.fds.v7.renderers.HoleRenderer;
import pyrosim.io.fds.v7.renderers.HvacRenderer;
import pyrosim.io.fds.v7.renderers.IFDS7Renderer;
import pyrosim.io.fds.v7.renderers.IObstructionRenderer;
import pyrosim.io.fds.v7.renderers.InitRenderer;
import pyrosim.io.fds.v7.renderers.IsofRenderer;
import pyrosim.io.fds.v7.renderers.MaterialRenderer;
import pyrosim.io.fds.v7.renderers.ObstructionRenderer;
import pyrosim.io.fds.v7.renderers.PartCloudRenderer;
import pyrosim.io.fds.v7.renderers.ParticleRenderer;
import pyrosim.io.fds.v7.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v7.renderers.Plot3dRenderer;
import pyrosim.io.fds.v7.renderers.ProfRenderer;
import pyrosim.io.fds.v7.renderers.ReactionRenderer;
import pyrosim.io.fds.v7.renderers.SimParamsRenderer;
import pyrosim.io.fds.v7.renderers.SingletonRecords;
import pyrosim.io.fds.v7.renderers.SliceRenderer;
import pyrosim.io.fds.v7.renderers.StatisticsRenderer;
import pyrosim.io.fds.v7.renderers.SurfaceRenderer;
import pyrosim.io.fds.v7.renderers.VentRenderer;
import pyrosim.io.fds.v7.renderers.ZoneRenderer;
import thunderheadeng.image.IImage;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class FDS7Renderer
extends FDSRenderer {
    public FDS7Renderer(PyroMod model, FDSRenderProps props, FDSRenderer.RENDER_ORIGIN origin) {
        super(model, props, origin);
    }

    public static List<? extends IFDS7Renderer> createRenderers(PyroMod model, IFDSRecordRenderer props, FDSRenderProps renderProps, Collection<? extends IPyroObject> objs, Map<IImage, String> imgFilenames, FDSRenderer.RENDER_ORIGIN renderOrigin) {
        FDS7QuantityMap mmap = new FDS7QuantityMap();
        FDSNameMap nameMap = new FDSNameMap();
        PinConnectionRenderer pinConnRenderer = new PinConnectionRenderer(nameMap);
        ExSpecRenderer specRenderer = new ExSpecRenderer(nameMap, pinConnRenderer);
        MaterialRenderer mr = new MaterialRenderer(nameMap, pinConnRenderer);
        ControlRenderer ctrlRenderer = new ControlRenderer(nameMap, pinConnRenderer);
        ZoneRenderer zoneRenderer = new ZoneRenderer();
        ArrayList<AFDS7Renderer> renderers = new ArrayList<AFDS7Renderer>();
        renderers.add(new SimParamsRenderer(mmap, nameMap));
        renderers.add(new Plot3dRenderer(mmap));
        GridProcessUtil gridUtil = new GridProcessUtil(objs.stream().filter(o -> o instanceof Grid).map(o -> (Grid)o).collect(Collectors.toList()), renderProps.getGridProcessSetting(), renderProps.getMPIProcessRule(), renderOrigin);
        renderers.add(new GridRenderer(gridUtil));
        renderers.add(zoneRenderer);
        renderers.add(specRenderer);
        renderers.add(new ParticleRenderer(nameMap, pinConnRenderer));
        renderers.add(new ReactionRenderer());
        renderers.add(ctrlRenderer);
        renderers.add(new DeviceRenderer(nameMap, pinConnRenderer, mmap, ctrlRenderer));
        renderers.add(pinConnRenderer);
        renderers.add(mr);
        renderers.add(new SurfaceRenderer(nameMap, specRenderer, zoneRenderer, pinConnRenderer, imgFilenames));
        renderers.add(new PartCloudRenderer(nameMap, pinConnRenderer));
        renderers.add(new InitRenderer(specRenderer, pinConnRenderer));
        FDSRasterization raster = FDS7Renderer.createRasterization(model, props, objs);
        if (!model.getRastOptions().isFdsGeomEnabled()) {
            renderers.add(new ObstructionRenderer(raster, pinConnRenderer));
        } else {
            renderers.add(new GeomRenderer(raster, pinConnRenderer));
        }
        renderers.add(new HoleRenderer(raster, pinConnRenderer));
        IdentityHashMap<Vent, String> ventNames = new IdentityHashMap<Vent, String>();
        renderers.add(new VentRenderer(pinConnRenderer, nameMap, specRenderer, ventNames));
        renderers.add(new HvacRenderer(nameMap, pinConnRenderer, ventNames));
        renderers.add(new BoundariesRenderer(mmap, nameMap));
        renderers.add(new IsofRenderer(mmap));
        renderers.add(new ProfRenderer(mmap, mr));
        renderers.add(new SliceRenderer(mmap));
        renderers.add(new StatisticsRenderer(mmap, nameMap));
        return renderers;
    }

    public RenderResult renderFileForVersion(FDSRenderer.Filenames filenames, Collection<? extends IPyroObject> objs, DepSnapshot deps, FDSPrintRenderer render, Map<IImage, String> imgFilenames) throws IOException {
        PyroMod model = this.getModel();
        SingletonRecords sr = new SingletonRecords();
        sr.headRec.setValue("CHID", filenames.chid);
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEGE1)) {
            sr.dumpRec.setValue("RENDER_FILE", filenames.ge1);
        }
        render.getWriter().println(filenames.fds);
        if (System.getProperty("minfds") == null) {
            render.getWriter().println("Generated by PyroSim 2023.3.1312");
            render.getWriter().println(DateFormat.getDateTimeInstance().format(new Date()));
        }
        render.getWriter().println();
        String userText = model.getUnprocessedRecords();
        if (userText != null && userText.length() > 0) {
            render.getWriter().println("-------------User Section (not generated by PyroSim)-------------");
            render.getWriter().println();
            render.getWriter().print(userText);
            render.getWriter().println();
            render.getWriter().println();
            render.getWriter().println("--------------------PyroSim-generated Section--------------------");
            render.getWriter().println();
        }
        RenderResult result = this.renderObjects(render, objs, deps, sr, imgFilenames);
        render.getWriter().println();
        FDS7Renderer.printFileTail(render);
        render.getWriter().close();
        return result;
    }

    @Override
    protected void renderFileForVersion(File fdsFile, Collection<? extends IPyroObject> objs, DepSnapshot deps) throws IOException {
        boolean writeIni;
        boolean writeFloors;
        boolean writeViews;
        String fdsFilenameNoEx = FilenameUtils.removeExtension(fdsFile.getName());
        assert (FDSRenderer.isValidChid(fdsFilenameNoEx));
        FDSRenderer.Filenames filenames = new FDSRenderer.Filenames(fdsFile.getParentFile(), fdsFilenameNoEx);
        PyroMod model = this.getModel();
        LinkedHashSet<? extends IPyroObject> objUnion = new LinkedHashSet<IPyroObject>(objs);
        objUnion.addAll(deps.getAllDependedOn());
        Map<IImage, String> imgFilenames = FDS7Renderer.copyImages(model.getAppearances(), filenames.dir, objUnion);
        boolean writeGE1 = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEGE1);
        if (writeGE1) {
            FDS7Renderer.writeGE1(filenames.dir, filenames.ge1, model, imgFilenames);
        }
        if (writeViews = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS)) {
            FDS7Renderer.writeViews(filenames.dir, filenames.views, model.getViews());
        }
        if (writeFloors = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEFLOORS)) {
            FDS7Renderer.writeFloors(filenames.dir, filenames.floors, model.getFloorManager());
        }
        if (writeIni = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITESMVINI)) {
            FDS7Renderer.write(filenames.dir, filenames.ini, writeGE1, objs);
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fdsFile), "UTF-8")));
        FDSRenderProps props = this.getProps();
        FDSPrintRenderer renderer = new FDSPrintRenderer(writer, props);
        RenderResult result = this.renderFileForVersion(filenames, objs, deps, renderer, imgFilenames);
        Map<IObstruction, List<Integer>> obstIxes = Collections.emptyMap();
        Map<Vent, Integer> ventIxes = Collections.emptyMap();
        for (IFDS7Renderer iFDS7Renderer : result.renderers) {
            if (iFDS7Renderer instanceof IObstructionRenderer) {
                obstIxes = ((IObstructionRenderer)iFDS7Renderer).getObstIxes();
                continue;
            }
            if (!(iFDS7Renderer instanceof VentRenderer)) continue;
            ventIxes = ((VentRenderer)iFDS7Renderer).getVentIxes();
        }
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM)) {
            boolean linked = props.getLinkPyroGeom();
            FDS7Renderer.writeGeom(filenames.dir, filenames.geom, model, result.allObjs, linked, obstIxes, ventIxes, false);
        }
    }

    private static void printFileTail(IFDSRecordRenderer props) {
        FDSRenderRecord tailRec = FDS7Const.newRenderRecord("TAIL");
        props.render(tailRec, null);
    }

    @Override
    public void renderObjects(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs, DepSnapshot deps, Map<IImage, String> imgFilenames) {
        this.renderObjects(props, objs, deps, new SingletonRecords(), imgFilenames);
    }

    protected RenderResult renderObjects(IFDSRecordRenderer props, Collection<? extends IPyroObject> objectsToWrite, DepSnapshot deps, SingletonRecords sr, Map<IImage, String> imgFilenames) {
        PyroMod mod = this.getModel();
        ArrayList<? extends IPyroObject> objs = new ArrayList<IPyroObject>(objectsToWrite);
        List<? extends IFDS7Renderer> renderers = FDS7Renderer.createRenderers(mod, props, this.getProps(), objs, imgFilenames, this.getRenderOrigin());
        LinkedIdentityHashSet depsToWrite = new LinkedIdentityHashSet();
        IdentityHashSet implicitObjs = new IdentityHashSet();
        implicitObjs.addAll(deps.getAllDependedOn());
        implicitObjs.removeAll(objs);
        for (IFDS7Renderer iFDS7Renderer : renderers) {
            Iterator<IPyroObject> iterator = FDS7Renderer.filterColl(deps.getAllDependedOn(), iFDS7Renderer, false).iterator();
            while (iterator.hasNext()) {
                IPyroObject obj;
                boolean explicit = !implicitObjs.contains(obj = iterator.next());
                boolean keep = iFDS7Renderer.markDependency(deps, obj, explicit);
                if (!keep || explicit) continue;
                depsToWrite.add(obj);
            }
        }
        objs.addAll(depsToWrite);
        props.props().pushProps();
        for (IFDS7Renderer iFDS7Renderer : renderers) {
            FDS7Renderer.fillSingletons(sr, iFDS7Renderer, objs);
        }
        for (FDSRenderRecord rec : sr.allRecs) {
            if (rec.empty()) continue;
            props.render(rec, null);
        }
        props.renderEmptyLine();
        for (IFDS7Renderer iFDS7Renderer : renderers) {
            FDS7Renderer.renderRecords(props, iFDS7Renderer, objs);
        }
        props.props().popProps();
        return new RenderResult(objs, renderers);
    }

    private static void fillSingletons(SingletonRecords sr, IFDS7Renderer ren, Collection<? extends IPyroObject> objs) {
        Collection<IPyroObject> filteredObjs = FDS7Renderer.filterColl(objs, ren, false);
        if (!filteredObjs.isEmpty()) {
            ren.fillSingletonRecords(sr, filteredObjs);
        }
    }

    private static void renderRecords(IFDSRecordRenderer props, IFDS7Renderer ren, Collection<? extends IPyroObject> objectsToWrite) {
        Collection<IPyroObject> objs = FDS7Renderer.filterColl(objectsToWrite, ren, true);
        if (!objs.isEmpty() && ren.render(props, objs)) {
            props.renderEmptyLine();
        }
    }

    private static FDSRasterization createRasterization(PyroMod model, IFDSRecordRenderer recRenderer, Collection<? extends IPyroObject> objectsToWrite) {
        FDSRasterization raster = new FDSRasterization(model, (Collection)recRenderer.props().getRasterGridSupplier().apply(objectsToWrite));
        return raster;
    }

    private static Collection<IPyroObject> filterColl(Collection<? extends IPyroObject> coll, IFDS7Renderer rend, boolean sortColl) {
        HashSet types = new HashSet();
        rend.getPyroTypes(types);
        IFilteredCollection filteredColl = theUtil.filter(coll, new TypeFilter(types));
        if (sortColl) {
            return rend.sortPyroObjects(filteredColl);
        }
        return filteredColl;
    }

    public static class RenderResult {
        public final Collection<? extends IPyroObject> allObjs;
        public final List<? extends IFDS7Renderer> renderers;

        public RenderResult(Collection<? extends IPyroObject> allObjs, List<? extends IFDS7Renderer> renderers) {
            this.allObjs = allObjs;
            this.renderers = renderers;
        }
    }
}

