/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import pyrosim.io.fds.v7.renderers.FDSNameMap;
import pyrosim.io.fds.v7.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v7.renderers.RampRenderer;
import thunderheadeng.util.Lists;

public class ExSpecRenderer
extends AFDS7Renderer {
    private final FDSNameMap d_nameMap;
    private final PinConnectionRenderer d_pinConns;
    private boolean d_simpleReacDefined;
    private boolean d_complexReacDefined;
    private Map<ExSpec, Double> d_stoichiometryMap;
    private final List<ExSpec> d_requiresExplicit;
    private final List<ExSpec> d_lumpedComponentOnly;

    public ExSpecRenderer(FDSNameMap nameMap, PinConnectionRenderer pinConns) {
        this.d_nameMap = nameMap;
        this.d_pinConns = pinConns;
        this.d_simpleReacDefined = false;
        this.d_complexReacDefined = false;
        this.d_stoichiometryMap = new LinkedHashMap<ExSpec, Double>();
        this.d_requiresExplicit = new ArrayList<ExSpec>();
        this.d_lumpedComponentOnly = new ArrayList<ExSpec>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(ExSpec.class);
        types.add(Reaction.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        if (o instanceof Reaction) {
            Reaction.ReacType reactionType = ((Reaction)o).getReacType();
            this.d_stoichiometryMap = ((Reaction)o).getComplexStoichiometry();
            this.d_simpleReacDefined = reactionType.equals((Object)Reaction.ReacType.SIMPLE);
            this.d_complexReacDefined = reactionType.equals((Object)Reaction.ReacType.COMPLEX);
            return true;
        }
        ExSpec obj = (ExSpec)o;
        if (obj.getType() == 4) {
            return false;
        }
        if (!ExSpecRenderer.shouldRenderExplicit(obj, this.d_simpleReacDefined, this.d_complexReacDefined, this.d_requiresExplicit.contains(obj))) {
            return false;
        }
        FDSRenderRecord rec = FDS7Const.newRenderRecord("SPEC");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getFYI(), false);
        rec.setValue("MASS_FRACTION_0", obj.getMassFrac0(), false);
        rec.setValue("BACKGROUND", obj.isBackgroundSpec(), false);
        if (obj.getType() == 1) {
            String name;
            Variant v;
            if (obj.getWtType() == 2) {
                rec.setValue("FORMULA", obj.getChemFormula());
            } else if (obj.getWtType() == 1) {
                rec.setValue("MW", obj.getMolecularWeight(), false);
            }
            HashMap<String, Ramp> ramps = new HashMap<String, Ramp>();
            ExSpec.PrimitiveParams primParams = obj.getPrimParams();
            if (primParams.isDiffusivitySet()) {
                v = primParams.getDiffusivity();
                if (v.isConstant()) {
                    rec.setValue("DIFFUSIVITY", v.val, false);
                } else if (v.isRamp()) {
                    name = RampRenderer.createID(this.d_nameMap, obj.getName(), "RAMP_D");
                    ramps.put(name, (Ramp)v.val);
                    rec.setValue("RAMP_D", name, false);
                }
            }
            if (primParams.isViscositySet()) {
                v = primParams.getViscosity();
                if (v.isConstant()) {
                    rec.setValue("VISCOSITY", v.val, false);
                } else if (v.isRamp()) {
                    name = RampRenderer.createID(this.d_nameMap, obj.getName(), "RAMP_MU");
                    ramps.put(name, (Ramp)v.val);
                    rec.setValue("RAMP_MU", name, false);
                }
            }
            if (primParams.isSigmaLJSet()) {
                rec.setValue("SIGMALJ", primParams.getSigmaLJ(), false);
            }
            if (primParams.isEpsilonKLJSet()) {
                rec.setValue("EPSILONKLJ", primParams.getEpsilonKLJ(), false);
            }
            if (primParams.getRadCalSurrogate().length() > 0) {
                rec.setValue("RADCAL_ID", primParams.getRadCalSurrogate(), false);
            }
            if (primParams.isAerosol()) {
                rec.setValue("AEROSOL", primParams.isAerosol(), false);
                rec.setValue("DENSITY_SOLID", primParams.getDensitySolid(), false);
                rec.setValue("CONDUCTIVITY_SOLID", primParams.getConductivitySolid(), false);
                rec.setValue("MEAN_DIAMETER", primParams.getMeanDiameter(), false);
            }
            if (primParams.isSpecHeatSet()) {
                v = primParams.getSpecHeat();
                if (v.isConstant()) {
                    rec.setValue("SPECIFIC_HEAT", v.val, false);
                } else if (v.isRamp()) {
                    name = RampRenderer.createID(this.d_nameMap, obj.getName(), "RAMP_CP");
                    ramps.put(name, (Ramp)v.val);
                    rec.setValue("RAMP_CP", name, false);
                }
            }
            if (primParams.isRefTempSet()) {
                rec.setValue("REFERENCE_TEMPERATURE", primParams.getRefTemp(), false);
            }
            if (primParams.isRefEnthalpySet()) {
                assert (primParams.getRefEnthalpy().isConstant());
                rec.setValue("REFERENCE_ENTHALPY", primParams.getRefEnthalpy().val, false);
            }
            if (primParams.isDensityLiquidSet()) {
                assert (primParams.getDensityLiquid().isConstant());
                rec.setValue("DENSITY_LIQUID", primParams.getDensityLiquid().val, false);
            }
            if (primParams.isSpecHeatLiquidSet()) {
                v = primParams.getSpecHeatLiquid();
                if (v.isConstant()) {
                    rec.setValue("SPECIFIC_HEAT_LIQUID", v.val, false);
                } else if (v.isRamp()) {
                    name = RampRenderer.createID(this.d_nameMap, obj.getName(), "RAMP_CP_L");
                    ramps.put(name, (Ramp)v.val);
                    rec.setValue("RAMP_CP_L", name, false);
                }
            }
            if (primParams.isVapTempSet()) {
                assert (primParams.getVapTemp().isConstant());
                rec.setValue("VAPORIZATION_TEMPERATURE", primParams.getVapTemp().val, false);
            }
            if (primParams.isMeltingTempSet()) {
                assert (primParams.getMeltTemp().isConstant());
                rec.setValue("MELTING_TEMPERATURE", primParams.getMeltTemp().val, false);
            }
            if (primParams.isHoVaporizationSet()) {
                assert (primParams.getHoVaporization().isConstant());
                rec.setValue("HEAT_OF_VAPORIZATION", primParams.getHoVaporization().val, false);
            }
            if (primParams.isEoFormationSet()) {
                assert (primParams.getEoFormation().isConstant());
                rec.setValue("ENTHALPY_OF_FORMATION", primParams.getEoFormation().val, false);
            }
            if (primParams.isHVRefTempSet()) {
                assert (primParams.getHVRefTemp().isConstant());
                rec.setValue("H_V_REFERENCE_TEMPERATURE", primParams.getHVRefTemp().val, false);
            }
            RampRenderer.render(props, ramps, this.d_pinConns);
        } else if (obj.getType() == 2 || obj.getType() == 3) {
            int size = obj.getComposition().entrySet().size();
            List<Object> primSpecs = Lists.filled(size, null);
            List<Object> fractions = Lists.filled(size, null);
            int i = 0;
            for (Map.Entry<ExSpec, Double> entr : obj.getComposition().entrySet()) {
                primSpecs.set(i, entr.getKey().getName());
                fractions.set(i, entr.getValue());
                ++i;
            }
            rec.setValue("SPEC_ID", primSpecs, false);
            if (obj.getType() == 2) {
                rec.setValue("MASS_FRACTION", fractions, false);
            } else {
                rec.setValue("VOLUME_FRACTION", fractions, false);
            }
        }
        boolean lumpedOnly = false;
        if (obj.getLumpedComponentOnlyRule().equals((Object)ExSpec.LUMPED_RULE.AUTO)) {
            if (this.d_simpleReacDefined || this.d_complexReacDefined) {
                lumpedOnly = this.isLumpedCompOnly_auto(obj);
            }
        } else if (obj.getLumpedComponentOnlyRule().equals((Object)ExSpec.LUMPED_RULE.TRUE)) {
            lumpedOnly = true;
        }
        rec.setValue("LUMPED_COMPONENT_ONLY", lumpedOnly, false);
        ExSpecRenderer.renderCustomFDSProps(rec, obj);
        props.render(rec, o);
        return true;
    }

    private boolean isLumpedCompOnly_auto(ExSpec spec) {
        boolean isComplexStoichiometrySpec;
        boolean isTruePrim = spec.getType() == 0 || spec.getType() == 1;
        boolean isLumpedDep = this.d_lumpedComponentOnly.contains(spec);
        boolean notCustom = spec.getCustomFDSProps().isEmpty();
        boolean lumpedAirComp = ExSpecList.LUMPED_AIR_COMPS.contains(spec.getName());
        boolean lumpedProdComp = ExSpecList.LUMPED_PRODUCT_COMPS.contains(spec.getName());
        boolean lumpedPredefComp = lumpedAirComp || lumpedProdComp;
        boolean bl = isComplexStoichiometrySpec = this.d_complexReacDefined && this.d_stoichiometryMap.containsKey(spec);
        if (isComplexStoichiometrySpec || spec.isBackgroundSpec()) {
            return false;
        }
        if (isLumpedDep && isTruePrim && notCustom) {
            return true;
        }
        if (!this.d_requiresExplicit.contains(spec) && spec.getMassFrac0() <= 0.0) {
            if (this.d_simpleReacDefined && lumpedPredefComp && notCustom) {
                return true;
            }
            if (lumpedAirComp && notCustom) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean markDependency(DepSnapshot deps, IPyroObject obj, boolean renderExplicit) {
        if (!(obj instanceof ExSpec)) {
            return false;
        }
        ExSpec specObj = (ExSpec)obj;
        if (specObj.getMassFrac0() > 0.0) {
            return true;
        }
        boolean shouldRender = false;
        boolean requiresExplicit = false;
        boolean lumpedCompOnly = false;
        for (Dependency dep : deps.getDependents(obj)) {
            if (dep.source instanceof Reaction) {
                if (((Reaction)dep.source).getReacType().equals((Object)Reaction.ReacType.SIMPLE)) {
                    if (!ExSpecList.equalsPredefinedSpecies(specObj) || !((Reaction)dep.source).isActive()) continue;
                    return false;
                }
                if (!((Reaction)dep.source).isActive()) continue;
                shouldRender = true;
                continue;
            }
            if (dep.source instanceof Particle || dep.source instanceof HvacFilter || dep.source instanceof ReacByproducts || dep.source instanceof SpecInjList || dep.source instanceof InitRegion || dep.source instanceof SmokeDetector) {
                requiresExplicit = true;
                shouldRender = true;
                continue;
            }
            if (dep.source instanceof ExSpec) {
                lumpedCompOnly = true;
                shouldRender = true;
                continue;
            }
            shouldRender = true;
        }
        if (requiresExplicit) {
            this.d_requiresExplicit.add(specObj);
        } else if (lumpedCompOnly) {
            this.d_lumpedComponentOnly.add(specObj);
        }
        return shouldRender;
    }

    @Override
    public Collection<IPyroObject> sortPyroObjects(Collection<IPyroObject> objs) {
        if (objs.isEmpty()) {
            return objs;
        }
        ArrayList<IPyroObject> specList = new ArrayList<IPyroObject>(objs);
        Collections.sort(specList, (o1, o2) -> {
            if (o1 instanceof Reaction && o2 instanceof Reaction) {
                return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
            }
            if (o1 instanceof Reaction && o2 instanceof ExSpec) {
                return -1;
            }
            if (o1 instanceof ExSpec && o2 instanceof Reaction) {
                return 1;
            }
            if (o1 instanceof ExSpec && o2 instanceof ExSpec) {
                return ((ExSpec)o1).compareTo((ExSpec)o2);
            }
            return 0;
        });
        return specList;
    }

    public static boolean shouldRenderExplicit(ExSpec spec, boolean simpleReac, boolean complexReac, boolean requiredExplicit) {
        if (spec.isForceWrite()) {
            return true;
        }
        if (!requiredExplicit) {
            if (!simpleReac && !complexReac && ExSpecList.LUMPED_AIR_COMPS.contains(spec.getName())) {
                return false;
            }
            if (simpleReac && (ExSpecList.LUMPED_AIR_COMPS.contains(spec.getName()) || ExSpecList.LUMPED_PRODUCT_COMPS.contains(spec.getName())) && ExSpecList.equalsPredefinedSpecies(spec)) {
                return false;
            }
        }
        return spec.getType() != 5 || !(spec.getName().equals(ExSpecList.Predefined.AIR.getName()) && !complexReac ? ExSpecList.equalsPredefinedSpecies(spec) : spec.getName().equals(ExSpecList.Predefined.PRODUCTS.getName()) && simpleReac && ExSpecList.equalsPredefinedSpecies(spec));
    }
}

