/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Grid;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.OrOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.devices.ASourceDevice;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IBeamDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IDeviceModel;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.AdiabaticSurfTempGasMeasurer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxGasMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.ISimCtrlDevice;
import pyrosim.domain.devices.simctrl.KillDevice;
import pyrosim.domain.devices.simctrl.RestartFileDevc;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.ISprayer;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.FDS7QuantityMap;
import pyrosim.io.fds.v7.common.GeomUtil;
import pyrosim.io.fds.v7.renderers.AFDS7UniqueRenderer;
import pyrosim.io.fds.v7.renderers.ControlRenderer;
import pyrosim.io.fds.v7.renderers.FDSNameMap;
import pyrosim.io.fds.v7.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v7.renderers.RampRenderer;
import pyrosim.io.fds.v7.renderers.TableRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class DeviceRenderer
extends AFDS7UniqueRenderer {
    private final ControlRenderer d_ctrlRenderer;
    private final PinConnectionRenderer d_pinConnections;
    private final FDS7QuantityMap d_quantityMap;
    private final Map<PropHasher, FDSRenderRecord> d_propMap;
    private final Map<FDSRenderRecord, PropHasher> d_revPropMap;
    private final List<Pair<IPyroObject, FDSRenderRecord>> d_devices;
    private final List<Pair<IPyroObject, FDSRenderRecord>> d_aspSamplers;
    private final List<Pair<IPyroObject, FDSRenderRecord>> d_asps;
    private final Map<AspiratorSampler, List<ReverseSamplerLine>> d_aspSampAspMap;
    private final Map<String, Ramp> d_ramps;
    private final Map<String, List<List<Double>>> d_tables;
    private final Map<DryPipe, DryPipeCtrl> d_dryPipeCtrlMap;
    private final List<IControl> d_addedControls;
    private final List<Grid> d_grids;
    private final Deque<IDevice> d_devcStack;

    public DeviceRenderer(FDSNameMap nameMap, PinConnectionRenderer pinConns, FDS7QuantityMap quantityMap, ControlRenderer ctrlRenderer) {
        super(nameMap);
        this.d_pinConnections = pinConns;
        this.d_ctrlRenderer = ctrlRenderer;
        this.d_propMap = new LinkedHashMap<PropHasher, FDSRenderRecord>();
        this.d_revPropMap = new LinkedIdentityHashMap<FDSRenderRecord, PropHasher>();
        this.d_quantityMap = quantityMap;
        this.d_devices = new ArrayList<Pair<IPyroObject, FDSRenderRecord>>();
        this.d_aspSamplers = new ArrayList<Pair<IPyroObject, FDSRenderRecord>>();
        this.d_asps = new ArrayList<Pair<IPyroObject, FDSRenderRecord>>();
        this.d_aspSampAspMap = new IdentityHashMap<AspiratorSampler, List<ReverseSamplerLine>>();
        this.d_ramps = new LinkedHashMap<String, Ramp>();
        this.d_tables = new LinkedHashMap<String, List<List<Double>>>();
        this.d_dryPipeCtrlMap = new IdentityHashMap<DryPipe, DryPipeCtrl>();
        this.d_addedControls = new ArrayList<IControl>();
        this.d_grids = new ArrayList<Grid>();
        this.d_devcStack = new ArrayDeque<IDevice>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(IDevice.class);
        types.add(IDeviceModel.class);
        types.add(Grid.class);
    }

    @Override
    public boolean markDependency(DepSnapshot deps, IPyroObject obj, boolean renderExplicit) {
        if (renderExplicit) {
            return true;
        }
        return !(obj instanceof IDeviceModel);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        for (Aspirator asp : theUtil.filter(objs, Aspirator.class)) {
            for (Aspirator.SamplerLine line : asp.getSamplerLines()) {
                List<ReverseSamplerLine> asps = this.d_aspSampAspMap.get(line.d_sampler);
                if (asps == null) {
                    asps = new ArrayList<ReverseSamplerLine>();
                    this.d_aspSampAspMap.put(line.d_sampler, asps);
                }
                asps.add(new ReverseSamplerLine(asp, line));
            }
            this.renderAspirator(asp);
        }
        for (AspiratorSampler aspSamp : theUtil.filter(objs, AspiratorSampler.class)) {
            this.renderAspiratorSampler(aspSamp);
        }
        for (DryPipe pipe : theUtil.filter(objs, DryPipe.class)) {
            this.d_dryPipeCtrlMap.put(pipe, new DryPipeCtrl(this, pipe));
        }
        return super.render(props, objs) || !this.d_asps.isEmpty() || !this.d_aspSamplers.isEmpty();
    }

    @Override
    protected void doneRendering(IFDSRecordRenderer props) {
        this.d_ctrlRenderer.render(props, this.d_addedControls);
        props.props().pushProps();
        for (FDSRenderRecord rec2 : this.d_propMap.values()) {
            props.props().setRenderMultiLine(rec2.getProperties().size() > 3);
            props.render(rec2, null);
        }
        props.props().popProps();
        if (!this.d_ramps.isEmpty()) {
            RampRenderer.render(props, this.d_ramps, this.d_pinConnections);
        }
        if (!this.d_tables.isEmpty()) {
            TableRenderer.render(props, this.d_tables);
        }
        Consumer<Pair> render = rec -> {
            if (rec.v1 instanceof IFreezable) {
                this.d_pinConnections.markForInputRetrieval(((IFreezable)rec.v1).getFreezePin(), (FDSRenderRecord)rec.v2, "NO_UPDATE_CTRL_ID", "NO_UPDATE_DEVC_ID");
            } else {
                props.render((FDSRenderRecord)rec.v2, (IPyroObject)rec.v1);
            }
        };
        this.d_aspSamplers.forEach(render);
        this.d_asps.forEach(render);
        this.d_devices.forEach(render);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean render(IFDSRecordRenderer props, IPyroObject o) {
        if (o instanceof Grid) {
            this.d_grids.add((Grid)o);
            return false;
        }
        if (o instanceof IDeviceModel) {
            if (o instanceof SmokeLinkModel) {
                this.renderSmokeLinkModel(null, (SmokeLinkModel)o);
                return true;
            } else if (o instanceof SprinklerLinkModel) {
                this.renderSprinklerLinkModel(null, (SprinklerLinkModel)o);
                return true;
            } else if (o instanceof HeatLinkModel) {
                this.renderHeatLinkModel(null, (HeatLinkModel)o);
                return true;
            } else {
                if (!(o instanceof SprayModel)) return true;
                this.renderSprayModel(null, (SprayModel)o);
            }
            return true;
        }
        IDevice obj = (IDevice)o;
        if (obj instanceof LayerMeasurer) {
            this.renderLayerMsr((LayerMeasurer)obj);
            return false;
        } else if (obj instanceof ISimCtrlDevice) {
            FDSRenderRecord rec = FDS7Const.newRenderRecord("CTRL");
            String id = this.getNameMap().mapToName("CTRL", obj);
            rec.setValue("ID", id);
            rec.setValue("LATCH", false, false);
            this.d_pinConnections.markForInputRetrieval(((ISimCtrlDevice)obj).getInputPin(), rec, "INPUT_ID", "INPUT_ID");
            DeviceRenderer.renderCustomFDSProps(rec, obj);
            if (obj instanceof KillDevice) {
                this.renderKillDevice(rec, (KillDevice)obj);
                return false;
            } else {
                if (!(obj instanceof RestartFileDevc)) return false;
                this.renderRestartFileDevice(rec, (RestartFileDevc)obj);
            }
            return false;
        } else if (obj instanceof ISprayer) {
            if (obj instanceof Nozzle) {
                this.renderNozzle(this.d_ramps, this.d_tables, (Nozzle)obj);
                return false;
            } else {
                if (!(obj instanceof Sprinkler)) return false;
                this.renderSprinkler(this.d_ramps, this.d_tables, (Sprinkler)obj);
            }
            return false;
        } else if (obj instanceof IDetector) {
            if (obj instanceof SprinklerLink) {
                this.renderSprinklerLink(this.d_ramps, this.d_tables, (SprinklerLink)obj);
                return false;
            } else if (obj instanceof HeatDetector) {
                this.renderHeatDetector(this.d_ramps, this.d_tables, (HeatDetector)obj);
                return false;
            } else if (obj instanceof SmokeDetector) {
                this.renderSmokeDetector(this.d_ramps, this.d_tables, (SmokeDetector)obj);
                return false;
            } else {
                if (!(obj instanceof Timer)) return false;
                this.renderTimer((Timer)obj);
            }
            return false;
        } else if (obj instanceof GasPointMeasurer) {
            if (obj instanceof Clock) {
                this.renderClock((Clock)obj);
                return false;
            } else if (obj instanceof Thermocouple) {
                this.renderThemocouple((Thermocouple)obj);
                return false;
            } else if (obj instanceof GaugeHeatFluxGasMeasurer) {
                this.renderGaugeHeatFluxGasMeasurer((GaugeHeatFluxGasMeasurer)obj);
                return false;
            } else if (obj instanceof AdiabaticSurfTempGasMeasurer) {
                this.renderAdiabaticSurfTempGasMeasurer((AdiabaticSurfTempGasMeasurer)obj);
                return false;
            } else {
                this.renderGasPointMeasurer((GasPointMeasurer)obj);
            }
            return false;
        } else if (obj instanceof SolidPointMeasurer) {
            if (obj instanceof PressureCoeffMeasurer) {
                this.renderPressCoeffMsr((PressureCoeffMeasurer)obj);
                return false;
            } else if (obj instanceof InnerTempMeasurer) {
                this.renderInnerTempMsr((InnerTempMeasurer)obj);
                return false;
            } else if (obj instanceof GaugeHeatFluxMeasurer) {
                this.renderGaugeHeatFluxMsr((GaugeHeatFluxMeasurer)obj);
                return false;
            } else if (obj instanceof SolidDensityMeasurer) {
                this.renderSolidDensityMsr((SolidDensityMeasurer)obj);
                return false;
            } else {
                SolidPointMeasurer msr = (SolidPointMeasurer)obj;
                FDSRenderRecord rec = this.newDevcRecord(msr.getOutputPins());
                this.renderSolidPointMeasurer(rec, (SolidPointMeasurer)obj);
                this.addDevice(msr, rec);
            }
            return false;
        } else if (obj instanceof PathObscurationMeasurer) {
            this.renderPathObscurationMsr((PathObscurationMeasurer)obj);
            return false;
        } else if (obj instanceof FlowMeasurer) {
            this.renderFlowMeasurer((FlowMeasurer)obj);
            return false;
        } else if (obj instanceof AABoxMeasurer) {
            this.renderAABoxMeasurer((AABoxMeasurer)obj);
            return false;
        } else {
            if (!(obj instanceof HvacDevice)) return false;
            this.renderHvacDevice((HvacDevice)obj);
        }
        return false;
    }

    private FDSRenderRecord newDevcRecord(Collection<? extends IOutPin> pins) {
        return this.newDevcRecord(pins, false);
    }

    private FDSRenderRecord newDevcRecord(Collection<? extends IOutPin> pins, boolean forcePinNames) {
        return (FDSRenderRecord)this.d_pinConnections.generateRecord((String)"DEVC", (String)"ID", (IOutPin[])pins.toArray(new IOutPin[pins.size()])).v1;
    }

    private FDSRenderRecord newDevcRecord(IOutPin pin) {
        Pair<FDSRenderRecord, Boolean> result = this.d_pinConnections.generateRecord("DEVC", "ID", pin);
        return (Boolean)result.v2 != false ? (FDSRenderRecord)result.v1 : null;
    }

    private FDSRenderRecord newDevcRecord(IDevice devc) {
        FDSRenderRecord rec = FDS7Const.newRenderRecord("DEVC");
        String id = this.getNameMap().generateName("DEVC", devc.getName());
        rec.setValue("ID", id);
        return rec;
    }

    private void renderQuantity(FDSRenderRecord rec, IQuantity m) {
        this.d_quantityMap.renderQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", m);
    }

    private void pushNestedDevc(IDevice devc) {
        this.d_devcStack.addLast(devc);
    }

    private void popNestedDevc(IDevice devc) {
        this.d_devcStack.removeLast();
    }

    private void addDevice(IPyroObject devc, FDSRenderRecord rec) {
        if (devc instanceof ICustomFDSPropsContainer) {
            DeviceRenderer.renderCustomFDSProps(rec, (ICustomFDSPropsContainer)((Object)devc));
        }
        IPyroObject src = !this.d_devcStack.isEmpty() ? (IPyroObject)this.d_devcStack.getFirst() : devc;
        this.d_devices.add(new Pair<IPyroObject, FDSRenderRecord>(src, rec));
    }

    private void renderLayerMsr(LayerMeasurer measurer) {
        if (measurer.measureHeight()) {
            this.addLayerRec(measurer, Quantity.LAYER_HEIGHT, measurer.getHeightInfo());
        }
        if (measurer.measureLowerTemp()) {
            this.addLayerRec(measurer, Quantity.LOWER_TEMPERATURE, measurer.getLowerTempInfo());
        }
        if (measurer.measureUpperTemp()) {
            this.addLayerRec(measurer, Quantity.UPPER_TEMPERATURE, measurer.getUpperTempInfo());
        }
    }

    private void addLayerRec(IBeamDevice measurer, Quantity msr, MeasureOutInfo pinInfo) {
        FDSRenderRecord rec = this.newDevcRecord(pinInfo.getPins());
        this.renderQuantity(rec, msr.create());
        DeviceRenderer.renderXB(rec, "XB", measurer.getBeam().getP1(), measurer.getBeam().getP2());
        this.renderAlarm(rec, pinInfo.getPin().getUnitType(), pinInfo.getAlarmInfo());
        this.addDevice(measurer, rec);
    }

    private void renderPathObscurationMsr(PathObscurationMeasurer measurer) {
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        this.renderQuantity(rec, measurer.getQuantity());
        DeviceRenderer.renderXB(rec, "XB", measurer.getBeam().getP1(), measurer.getBeam().getP2());
        this.renderAlarm(rec, measurer.getQuantity(), measurer.getMsrInfo().getAlarmInfo());
        this.addDevice(measurer, rec);
    }

    private void renderFlowMeasurer(FlowMeasurer measurer) {
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        this.renderQuantity(rec, measurer.getQuantity());
        Object ior = null;
        String quantName = rec.getString("QUANTITY");
        if (measurer.getQuantity().get().quantityType == QuantityType.GAS) {
            rec.setValue("SPATIAL_STATISTIC", "AREA INTEGRAL");
        } else {
            rec.setValue("SPATIAL_STATISTIC", "SURFACE INTEGRAL");
        }
        rec.setValue("QUANTITY", quantName);
        FDSArray<Double> quantityRange = new FDSArray<Double>(FDS7Const.DEVC_QUANTITY_RANGE_BOUNDS[0], FDS7Const.DEVC_QUANTITY_RANGE_BOUNDS[1]);
        switch (measurer.getFlowDir()) {
            case 1: {
                quantityRange.set(1, (Double[])new Double[]{0.0});
                break;
            }
            case 0: {
                quantityRange.set(0, (Double[])new Double[]{0.0});
            }
        }
        rec.setValue("QUANTITY_RANGE", quantityRange, false);
        DeviceRenderer.renderAARectangle(rec, "XB", measurer.getRect());
        this.renderAlarm(rec, measurer.getQuantity(), measurer.getMsrInfo().getAlarmInfo());
        this.addDevice(measurer, rec);
    }

    private void renderAABoxMeasurer(AABoxMeasurer measurer) {
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        this.renderQuantity(rec, measurer.getQuantity());
        DeviceRenderer.renderAABox(rec, "XB", measurer.getBox());
        this.renderAlarm(rec, measurer.getQuantity(), measurer.getMsrInfo().getAlarmInfo());
        this.addDevice(measurer, rec);
    }

    private void renderHvacDevice(HvacDevice devc) {
        FDSRenderRecord rec = this.newDevcRecord(devc);
        this.renderQuantity(rec, devc.getQuantity());
        this.addDevice(devc, rec);
    }

    private void renderRestartFileDevice(FDSRenderRecord rec, RestartFileDevc devc) {
        rec.setValue("FUNCTION_TYPE", "RESTART");
    }

    private void renderKillDevice(FDSRenderRecord rec, KillDevice device) {
        rec.setValue("FUNCTION_TYPE", "KILL");
    }

    private void renderTripFlags(FDSRenderRecord rec, int tripFlags) {
        rec.setValue("INITIAL_STATE", TripFlags.initiallyOn(tripFlags), false);
        rec.setValue("LATCH", TripFlags.latch(tripFlags), false);
        int tripDirection = TripFlags.tripDirDescending(tripFlags) ? -1 : 1;
        rec.setValue("TRIP_DIRECTION", tripDirection, false);
    }

    private void renderAlarm(FDSRenderRecord rec, IQuantity msr, AlarmInfo ai) {
        this.renderAlarm(rec, msr.get().unitType, ai);
    }

    private void renderAlarm(FDSRenderRecord rec, int unitType, AlarmInfo ai) {
        if (ai != null) {
            rec.setValue("SETPOINT", ai.setpoint.getValue(SIUS.unit(unitType)), true);
            this.renderTripFlags(rec, ai.tripFlags);
        } else {
            this.renderDefDeviceProps(rec);
        }
    }

    private void renderAspirator(Aspirator aspirator) {
        FDSRenderRecord rec = this.newDevcRecord(aspirator.getOutputPins());
        rec.setValue("QUANTITY", "ASPIRATION");
        this.renderFreePointLoc(rec, aspirator.getLocation());
        rec.setValue("BYPASS_FLOWRATE", aspirator.getBypassFlowrate(), true);
        this.renderAlarm(rec, aspirator.getQuantity(), aspirator.getMsrInfo().getAlarmInfo());
        this.d_asps.add(new Pair<Aspirator, FDSRenderRecord>(aspirator, rec));
        DeviceRenderer.renderCustomFDSProps(rec, aspirator);
    }

    private void renderAspiratorSampler(AspiratorSampler sampler) {
        ObjectQuantity msr = Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT"));
        FDSRenderRecord rec = this.newDevcRecord(sampler.getOutputPins());
        this.renderQuantity(rec, msr);
        this.renderFreePointLoc(rec, sampler.getLocation());
        this.renderAlarm(rec, msr, sampler.getMsrInfo().getAlarmInfo());
        this.d_aspSamplers.add(new Pair<AspiratorSampler, FDSRenderRecord>(sampler, rec));
        DeviceRenderer.renderCustomFDSProps(rec, sampler);
        List<ReverseSamplerLine> asps = this.d_aspSampAspMap.get(sampler);
        if (asps != null) {
            assert (!asps.isEmpty());
            ReverseSamplerLine revLine = asps.get(0);
            rec.setValue("DEVC_ID", this.d_pinConnections.getID(revLine.d_aspirator.getOutputPins().get(0)));
            rec.setValue("FLOWRATE", revLine.d_line.d_flowrate, true);
            rec.setValue("DELAY", revLine.d_line.d_delay, true);
            for (int m = 1; m < asps.size(); ++m) {
                FDSRenderRecord recDup = (FDSRenderRecord)rec.clone();
                String newID = this.getNameMap().generateName("DEVC", sampler.getName());
                recDup.setValue("ID", newID);
                revLine = asps.get(m);
                recDup.setValue("DEVC_ID", this.d_pinConnections.getID(revLine.d_aspirator.getOutputPins().get(0)));
                recDup.setValue("FLOWRATE", revLine.d_line.d_flowrate, true);
                recDup.setValue("DELAY", revLine.d_line.d_delay, true);
                this.d_aspSamplers.add(new Pair<AspiratorSampler, FDSRenderRecord>(sampler, recDup));
            }
        }
    }

    private void renderThemocouple(Thermocouple thermocouple) {
        Consumer<FDSRenderRecord> init = propRec -> {
            propRec.setValue("DIAMETER", thermocouple.getBeadDiameter(), false);
            propRec.setValue("EMISSIVITY", thermocouple.getEmissivity(), false);
            propRec.setValue("DENSITY", thermocouple.getBeadDensity(), false);
            propRec.setValue("SPECIFIC_HEAT", thermocouple.getBeadSpecHeat(), false);
        };
        FDSRenderRecord propRec2 = this.getPropRecord(init, thermocouple, String.format(Intl.intl("%s props"), thermocouple.getName()), new Thermocouple[]{thermocouple});
        FDSRenderRecord rec = this.newDevcRecord(thermocouple.getOutputPins());
        this.renderPropRef(rec, propRec2);
        this.renderGasPointMeasurer(rec, thermocouple);
        this.addDevice(thermocouple, rec);
    }

    private void renderClock(Clock clock) {
        FDSRenderRecord rec = this.newDevcRecord(clock.getOutputPins());
        this.renderQuantity(rec, clock.getQuantity());
        this.renderFreePointLoc(rec, this.getTimeLoc());
        this.renderAlarm(rec, clock.getQuantity(), clock.getMsrInfo().getAlarmInfo());
        this.addDevice(clock, rec);
    }

    private void renderGaugeHeatFluxGasMeasurer(GaugeHeatFluxGasMeasurer measurer) {
        Consumer<FDSRenderRecord> init = propRec -> {
            propRec.setValue("GAUGE_TEMPERATURE", measurer.getGaugeTemperature(), false);
            propRec.setValue("HEAT_TRANSFER_COEFFICIENT", measurer.getHeatTransferCoefficient(), false);
        };
        FDSRenderRecord propRec2 = this.getPropRecord(init, measurer, String.format(Intl.intl("%s props"), measurer.getName()), new GaugeHeatFluxGasMeasurer[]{measurer});
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        this.renderPropRef(rec, propRec2);
        this.renderGasPointMeasurer(measurer, rec);
    }

    private void renderAdiabaticSurfTempGasMeasurer(AdiabaticSurfTempGasMeasurer measurer) {
        Consumer<FDSRenderRecord> init = propRec -> {
            propRec.setValue("EMISSIVITY", measurer.getEmissivity(), true);
            propRec.setValue("HEAT_TRANSFER_COEFFICIENT", measurer.getHeatTransferCoeff(), false);
        };
        FDSRenderRecord propRec2 = this.getPropRecord(init, measurer, String.format(Intl.intl("%s props"), measurer.getName()), new AdiabaticSurfTempGasMeasurer[]{measurer});
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        this.renderPropRef(rec, propRec2);
        this.renderGasPointMeasurer(measurer, rec);
    }

    private void renderGasPointMeasurer(GasPointMeasurer measurer) {
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        this.renderGasPointMeasurer(measurer, rec);
    }

    private void renderGasPointMeasurer(GasPointMeasurer measurer, FDSRenderRecord rec) {
        this.renderGasPointMeasurer(rec, measurer);
        this.addDevice(measurer, rec);
    }

    private void renderGasPointMeasurer(FDSRenderRecord rec, GasPointMeasurer measurer) {
        this.renderQuantity(rec, measurer.getQuantity());
        this.renderFreePointLoc(rec, measurer.getLocation());
        this.renderAlarm(rec, measurer.getQuantity(), measurer.getMsrInfo().getAlarmInfo());
    }

    private void renderGaugeHeatFluxMsr(GaugeHeatFluxMeasurer measurer) {
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        Consumer<FDSRenderRecord> propInit = propRec -> {
            propRec.setValue("GAUGE_TEMPERATURE", measurer.getGaugeTemperature(), false);
            propRec.setValue("GAUGE_EMISSIVITY", measurer.getGaugeEmissivity(), false);
            propRec.setValue("HEAT_TRANSFER_COEFFICIENT", measurer.getHeatTransferCoefficient(), false);
        };
        FDSRenderRecord propRec2 = this.getPropRecord(propInit, measurer, String.format(Intl.intl("%s props"), measurer.getName()), new GaugeHeatFluxMeasurer[]{measurer});
        this.renderPropRef(rec, propRec2);
        this.renderSolidPointMeasurer(rec, measurer);
        this.addDevice(measurer, rec);
    }

    private void renderInnerTempMsr(InnerTempMeasurer measurer) {
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        rec.setValue("DEPTH", measurer.getDepth(), false);
        this.renderSolidPointMeasurer(rec, measurer);
        this.addDevice(measurer, rec);
    }

    private void renderSolidDensityMsr(SolidDensityMeasurer measurer) {
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        rec.setValue("DEPTH", measurer.getDepth(), false);
        this.renderSolidPointMeasurer(rec, measurer);
        this.addDevice(measurer, rec);
    }

    private void renderPressCoeffMsr(PressureCoeffMeasurer measurer) {
        Consumer<FDSRenderRecord> propInit = propRec -> propRec.setValue("CHARACTERISTIC_VELOCITY", measurer.getCharacteristicVel(), false);
        FDSRenderRecord propRec2 = this.getPropRecord(propInit, measurer, String.format(Intl.intl("%s props"), measurer.getName()), new PressureCoeffMeasurer[]{measurer});
        FDSRenderRecord rec = this.newDevcRecord(measurer.getOutputPins());
        this.renderPropRef(rec, propRec2);
        this.renderSolidPointMeasurer(rec, measurer);
        this.addDevice(measurer, rec);
    }

    private void renderSolidPointMeasurer(FDSRenderRecord rec, SolidPointMeasurer measurer) {
        this.renderQuantity(rec, measurer.getQuantity());
        this.renderAttachedPointLoc(rec, measurer.getAttachedLocation());
        this.renderAlarm(rec, measurer.getQuantity(), measurer.getMsrInfo().getAlarmInfo());
    }

    private FreePointLoc getTimeLoc() {
        if (this.d_grids.isEmpty()) {
            return new FreePointLoc();
        }
        Grid g = this.d_grids.get(0);
        UnitPoint3D min = g.getMinPoint();
        return new FreePointLoc(new Point(min.getPoint3dValue(Geometry.LU)));
    }

    private void renderTimer(Timer timer) {
        FDSRenderRecord rec = this.newDevcRecord(timer.getOutputPins().get(0));
        if (rec == null) {
            return;
        }
        this.renderQuantity(rec, Quantity.TIME.create());
        FreePointLoc loc = this.getTimeLoc();
        this.renderFreePointLoc(rec, loc);
        this.renderAlarm(rec, Quantity.TIME.create(), timer.getAlarmInfo());
        this.addDevice(timer, rec);
    }

    private void renderSmokeDetector(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, SmokeDetector obj) {
        FDSRenderRecord propRec = this.renderSmokeLinkModel(obj, obj.getModel());
        FDSRenderRecord rec = this.newDevcRecord(obj.getOutputPins());
        this.renderPropRef(rec, propRec);
        this.renderFreePointLoc(rec, obj.getLocation());
        this.renderTripFlags(rec, obj.getTripFlags());
        this.addDevice(obj, rec);
    }

    private FDSRenderRecord renderSmokeLinkModel(IDevice devc, SmokeLinkModel model) {
        Consumer<FDSRenderRecord> propInit = propRec -> {
            propRec.setValue("QUANTITY", "CHAMBER OBSCURATION");
            this.renderSmokeLinkModel((FDSRenderRecord)propRec, this.d_ramps, this.d_tables, model);
        };
        return this.getPropRecord(propInit, devc, new SmokeLinkModel[]{model});
    }

    private void renderSmokeLinkModel(FDSRenderRecord rec, Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, SmokeLinkModel obj) {
        SmokeLinkModel.ISpec spec;
        rec.setValue("ACTIVATION_OBSCURATION", obj.getActivationObscuration(), false);
        if (obj.getSmokeSpecies() != null) {
            rec.setValue("SPEC_ID", obj.getSmokeSpecies().getName());
        }
        if ((spec = obj.getSpec()) instanceof SmokeLinkModel.Cleary) {
            SmokeLinkModel.Cleary cspec = (SmokeLinkModel.Cleary)spec;
            rec.setValue("ALPHA_E", cspec.d_eAlpha, true);
            rec.setValue("BETA_E", cspec.d_eBeta, true);
            rec.setValue("ALPHA_C", cspec.d_cAlpha, true);
            rec.setValue("BETA_C", cspec.d_cBeta, true);
        } else if (spec instanceof SmokeLinkModel.Heskestad) {
            SmokeLinkModel.Heskestad hspec = (SmokeLinkModel.Heskestad)spec;
            rec.setValue("LENGTH", hspec.d_length, true);
        }
        DeviceRenderer.renderCustomFDSProps(rec, obj);
    }

    private void renderHeatDetector(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, HeatDetector obj) {
        FDSRenderRecord propRec = this.renderHeatLinkModel(obj, obj.getModel());
        FDSRenderRecord rec = this.newDevcRecord(obj.getOutputPins());
        this.renderPropRef(rec, propRec);
        this.renderFreePointLoc(rec, obj.getLocation());
        this.renderTripFlags(rec, obj.getTripFlags());
        this.addDevice(obj, rec);
    }

    private FDSRenderRecord renderHeatLinkModel(IDevice devc, HeatLinkModel model) {
        Consumer<FDSRenderRecord> propInit = propRec -> {
            propRec.setValue("QUANTITY", "LINK TEMPERATURE");
            this.renderHeatLinkModel((FDSRenderRecord)propRec, this.d_ramps, this.d_tables, model);
        };
        FDSRenderRecord propRec2 = this.getPropRecord(propInit, devc, new HeatLinkModel[]{model});
        return propRec2;
    }

    private void renderHeatLinkModel(FDSRenderRecord rec, Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, HeatLinkModel obj) {
        if (obj.getInitialTemp() != null) {
            rec.setValue("INITIAL_TEMPERATURE", obj.getInitialTemp(), false);
        }
        rec.setValue("ACTIVATION_TEMPERATURE", obj.getActivationTemp(), true);
        rec.setValue("RTI", obj.getRti(), false);
        DeviceRenderer.renderCustomFDSProps(rec, obj);
    }

    private void renderSprinklerLink(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, SprinklerLink link) {
        FDSRenderRecord rec = this.newDevcRecord(link.getOutputPins());
        this.renderSprinklerLink(ramps, tables, link, rec);
    }

    private void renderSprinklerLink(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, SprinklerLink link, FDSRenderRecord rec) {
        FDSRenderRecord propRec = this.renderSprinklerLinkModel(link, link.getModel());
        this.renderPropRef(rec, propRec);
        this.renderFreePointLoc(rec, link.getLocation());
        this.renderTripFlags(rec, link.getTripFlags());
        this.addDevice(link, rec);
    }

    private void renderSprinkler(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, Sprinkler sprk) {
        if (sprk.getDryPipe() != null) {
            this.renderSprinklerPreAct(ramps, tables, sprk);
        } else {
            this.renderSprinklerSimple(ramps, tables, sprk);
        }
    }

    private void renderSprinklerSimple(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, Sprinkler sprk) {
        FDSRenderRecord propRec;
        Sprinkler.LinkModel linkModel = sprk.getLinkModel();
        SprayModel sprayModel = sprk.getSprayModel();
        if (linkModel instanceof Sprinkler.TraditionalModel) {
            Sprinkler.TraditionalModel tradLink = (Sprinkler.TraditionalModel)linkModel;
            Consumer<FDSRenderRecord> propInit = rec -> {
                rec.setValue("QUANTITY", "SPRINKLER LINK TEMPERATURE");
                this.renderSprinklerLinkModel((FDSRenderRecord)rec, ramps, tables, tradLink.d_link, false);
                this.renderSprayModel((FDSRenderRecord)rec, ramps, tables, sprayModel, false);
                CustomFDSProps cprops = CustomFDSProps.union(tradLink.d_link.getCustomFDSProps("PROP"), sprayModel.getCustomFDSProps("PROP"));
                DeviceRenderer.renderCustomFDSProps(rec, cprops);
            };
            String name = tradLink.d_link.getName().equals(sprayModel.getName()) ? sprayModel.getName() : null;
            propRec = this.getPropRecord(propInit, sprk, name, new NamedPyroObject[]{tradLink.d_link, sprayModel});
        } else {
            propRec = this.renderSprayModel(sprk, sprayModel);
        }
        FDSRenderRecord devcRec = this.newDevcRecord(sprk.getOutputPins());
        this.renderPropRef(devcRec, propRec);
        this.renderFreePointLoc(devcRec, sprk.getLocation());
        devcRec.setValue("INITIAL_STATE", linkModel.d_initState, false);
        devcRec.setValue("LATCH", linkModel.d_latch, false);
        if (linkModel instanceof Sprinkler.QuantityModel) {
            Sprinkler.QuantityModel quanModel = (Sprinkler.QuantityModel)linkModel;
            this.renderQuantity(devcRec, quanModel.d_quantity);
            Unit u = SIUS.unit(quanModel.d_quantity.get().unitType);
            double setPoint = quanModel.d_setPoint.getValue(u);
            devcRec.setValue("SETPOINT", setPoint, false);
        }
        this.addDevice(sprk, devcRec);
    }

    private void copyCustomRecords(ICustomFDSPropsContainer src, ICustomFDSPropsContainer dest) {
        HashSet<String> dtypes = new HashSet<String>(dest.getCustomFDSTypes());
        for (String type : src.getCustomFDSTypes()) {
            if (!dtypes.contains(type)) continue;
            dest.setCustomFDSProps(type, src.getCustomFDSProps(type));
        }
    }

    private void renderSprinklerPreAct(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, Sprinkler sprk) {
        ASourceDevice link;
        Nozzle nozzle = new Nozzle(String.format(Intl.intl("%s_NOZZLE"), sprk.getName()), sprk.getSprayModel(), sprk.getLocation());
        Sprinkler.LinkModel linkModel = sprk.getLinkModel();
        String linkName = String.format("%s_%s", sprk.getName(), sprk.getLinkAlarmPin().getName());
        LogicOutPin linkOutPin = sprk.getLinkAlarmPin();
        if (linkModel instanceof Sprinkler.TraditionalModel) {
            SprinklerLink sprkLink;
            model = ((Sprinkler.TraditionalModel)linkModel).d_link;
            link = sprkLink = new SprinklerLink(linkName, (SprinklerLinkModel)model, sprk.getLocation());
        } else {
            model = (Sprinkler.QuantityModel)linkModel;
            GasPointMeasurer msr = new GasPointMeasurer(linkName, model.d_quantity, sprk.getLocation());
            msr.getMsrInfo().setAlarmInfo(new AlarmInfo(model.d_setPoint));
            link = msr;
        }
        if (link instanceof IFreezable) {
            IFreezable flink = link;
            for (IOutPin iOutPin : sprk.getFreezePin().getConnections()) {
                assert (flink.getInputPin().canConnect(iOutPin));
                flink.getInputPin().connect(iOutPin);
            }
        }
        this.copyCustomRecords(sprk, link);
        assert (sprk.getDryPipe() != null);
        DryPipeCtrl ctrl = this.d_dryPipeCtrlMap.get(sprk.getDryPipe());
        ctrl.getInputPin().connect(linkOutPin);
        AndOp op = new AndOp();
        op.setName(String.format(Intl.intl("%s_input"), nozzle.getName()));
        op.getInputPin().connect(ctrl.getOutputPins().get(0));
        op.getInputPin().connect(linkOutPin);
        nozzle.getInputPin().connect(op.getOutputPins().get(0));
        this.d_addedControls.add(op);
        this.pushNestedDevc(sprk);
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(Arrays.asList(sprk.getLinkAlarmPin(), sprk.getLinkQuantityPin()), false);
        if (link instanceof SprinklerLink) {
            this.renderSprinklerLink(ramps, tables, (SprinklerLink)link, fDSRenderRecord);
        } else {
            this.renderGasPointMeasurer((GasPointMeasurer)link, fDSRenderRecord);
        }
        FDSRenderRecord nozzleRec = this.newDevcRecord(Collections.singletonList(sprk.getNozzleAlarmPin()), false);
        this.renderNozzle(ramps, tables, nozzle, nozzleRec);
        this.popNestedDevc(sprk);
    }

    private void renderNozzle(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, Nozzle nozzle) {
        FDSRenderRecord rec = this.newDevcRecord(nozzle.getOutputPins());
        this.renderNozzle(ramps, tables, nozzle, rec);
    }

    private void renderNozzle(Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, Nozzle nozzle, FDSRenderRecord rec) {
        FDSRenderRecord propRec = this.renderSprayModel(nozzle, nozzle.getSprayModel());
        this.renderPropRef(rec, propRec);
        this.renderFreePointLoc(rec, nozzle.getLocation());
        Set<IOutPin> inputs = PinConnectionRenderer.finalizeInputs(nozzle.getInputPin());
        if (!inputs.isEmpty()) {
            this.renderDefDeviceProps(rec);
            IOutPin outPin = inputs.iterator().next();
            if (outPin.getAttachedSource() instanceof Timer) {
                Timer timer = (Timer)outPin.getAttachedSource();
                rec.setValue("QUANTITY", "TIME");
                rec.setValue("SETPOINT", timer.getAlarmInfo().setpoint.getValue(SI.SECOND));
                this.renderTripFlags(rec, timer.getTripFlags());
                this.addDevice(nozzle, rec);
            } else {
                rec.setValue("LATCH", false, false);
                rec.setValue("QUANTITY", "CONTROL");
                if (outPin.getAttachedSource() instanceof IDevice) {
                    AndOp intCtrl = new AndOp();
                    intCtrl.getInputPin().connect(outPin);
                    Pair<FDSRenderRecord, Boolean> intRes = this.d_pinConnections.generateRecord("CTRL", "ID", intCtrl.getOutputPins().get(0));
                    if (((Boolean)intRes.v2).booleanValue()) {
                        ((FDSRenderRecord)intRes.v1).setValue("FUNCTION_TYPE", "ALL");
                        ((FDSRenderRecord)intRes.v1).setValue("LATCH", false, false);
                        ((FDSRenderRecord)intRes.v1).setValue("INITIAL_STATE", false, false);
                        rec.setValue("CTRL_ID", ((FDSRenderRecord)intRes.v1).getString("ID"));
                    }
                    this.d_pinConnections.markForInputRetrieval(intCtrl.getInputPin(), (FDSRenderRecord)intRes.v1, "INPUT_ID", "INPUT_ID");
                    this.addDevice(nozzle, rec);
                } else {
                    this.d_pinConnections.markForInputRetrieval(nozzle.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
                    DeviceRenderer.renderCustomFDSProps(rec, nozzle);
                }
            }
        } else {
            rec.setValue("QUANTITY", "TIME");
            rec.setValue("SETPOINT", 0.0);
            this.addDevice(nozzle, rec);
        }
    }

    private FDSRenderRecord renderSprinklerLinkModel(IDevice devc, SprinklerLinkModel model) {
        Consumer<FDSRenderRecord> propInit = propRec -> {
            propRec.setValue("QUANTITY", "SPRINKLER LINK TEMPERATURE");
            this.renderSprinklerLinkModel((FDSRenderRecord)propRec, this.d_ramps, this.d_tables, model, true);
        };
        FDSRenderRecord propRec2 = this.getPropRecord(propInit, devc, new SprinklerLinkModel[]{model});
        return propRec2;
    }

    private void renderSprinklerLinkModel(FDSRenderRecord rec, Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, SprinklerLinkModel obj, boolean renderCustom) {
        if (obj.getInitialTemp() != null) {
            rec.setValue("INITIAL_TEMPERATURE", obj.getInitialTemp(), false);
        }
        rec.setValue("ACTIVATION_TEMPERATURE", obj.getActivationTemp(), true);
        rec.setValue("RTI", obj.getRti(), false);
        rec.setValue("C_FACTOR", obj.getCFactor(), false);
        if (renderCustom) {
            DeviceRenderer.renderCustomFDSProps(rec, obj);
        }
    }

    private FDSRenderRecord renderSprayModel(IDevice devc, SprayModel model) {
        Consumer<FDSRenderRecord> propInit = propRec -> this.renderSprayModel((FDSRenderRecord)propRec, this.d_ramps, this.d_tables, model, true);
        FDSRenderRecord propRec2 = this.getPropRecord(propInit, devc, new SprayModel[]{model});
        return propRec2;
    }

    private void renderSprayModel(FDSRenderRecord rec, Map<String, Ramp> ramps, Map<String, List<List<Double>>> tables, SprayModel obj, boolean renderCustom) {
        String id = (String)rec.get("ID");
        rec.setValue("PART_ID", this.getNameMap().getName(obj.getParticle()));
        rec.setValue("OFFSET", obj.getSprayOffset(), false);
        rec.setValue("PARTICLES_PER_SECOND", obj.getDropsPerSecond(), false);
        this.renderFlowRate(rec, id, ramps, obj.getFlowRate());
        this.renderJets(rec, id, tables, obj.getJets());
        if (renderCustom) {
            DeviceRenderer.renderCustomFDSProps(rec, obj);
        }
    }

    private void renderFlowRate(FDSRenderRecord rec, String id, Map<String, Ramp> ramps, SprayModel.FlowRate rate) {
        if (rate instanceof SprayModel.ExplicitFlowRate) {
            SprayModel.ExplicitFlowRate efr = (SprayModel.ExplicitFlowRate)rate;
            rec.setValue("FLOW_RATE", efr.d_rate);
        } else if (rate instanceof SprayModel.PressurizedFlowRate) {
            SprayModel.PressurizedFlowRate pfr = (SprayModel.PressurizedFlowRate)rate;
            rec.setValue("K_FACTOR", pfr.d_kFactor, true);
            rec.setValue("OPERATING_PRESSURE", pfr.d_opPressure, true);
        } else if (rate instanceof SprayModel.VaryingFlowRate) {
            SprayModel.VaryingFlowRate vfr = (SprayModel.VaryingFlowRate)rate;
            String rName = RampRenderer.createID(this.getNameMap(), id, "PRESSURE_RAMP");
            ramps.put(rName, vfr.d_pressureRamp);
            rec.setValue("PRESSURE_RAMP", rName, false);
            if (vfr.d_kFactor != null) {
                rec.setValue("K_FACTOR", vfr.d_kFactor, true);
            }
            if (vfr.d_opPressure != null) {
                rec.setValue("OPERATING_PRESSURE", vfr.d_opPressure, true);
            }
            if (vfr.d_rate != null) {
                rec.setValue("FLOW_RATE", vfr.d_rate, true);
            }
        }
        DeviceRenderer.renderTimeFunc(rec, this.getNameMap(), ramps, id, rate.d_ramp, "FLOW_RAMP", "FLOW_TAU");
    }

    private void renderJets(FDSRenderRecord rec, String id, Map<String, List<List<Double>>> tables, List<SprayModel.Jet> jets) {
        if (jets.size() == 1) {
            SprayModel.Jet jet = jets.get(0);
            if (jet.d_velocity != null) {
                assert (jet.d_orificeDiam == null);
                rec.setValue("PARTICLE_VELOCITY", jet.d_velocity, true);
            } else {
                assert (jet.d_orificeDiam != null);
                rec.setValue("ORIFICE_DIAMETER", jet.d_orificeDiam, true);
            }
            FDSArray<UnitDouble> angles = new FDSArray<UnitDouble>(FDS7Const.PROP_SPRAY_ANGLE_DIMENSIONS);
            if (jet.isConicalSpray()) {
                angles.set(0, jet.d_lat1, jet.d_lat2);
            } else {
                angles.set(0, jet.d_lat1, jet.d_lat2, jet.d_long1, jet.d_long2);
            }
            rec.setValue("SPRAY_ANGLE", angles);
        } else if (!jets.isEmpty()) {
            String tableName = TableRenderer.createID(this.getNameMap(), id, "SPRAY_PATTERN_TABLE");
            ArrayList<List<Double>> table = new ArrayList<List<Double>>(jets.size());
            for (SprayModel.Jet jet : jets) {
                List<Double> jetData = Arrays.asList(jet.d_lat1.getValue(NonSI.DEGREE_ANGLE), jet.d_lat2.getValue(NonSI.DEGREE_ANGLE), jet.d_long1.getValue(NonSI.DEGREE_ANGLE), jet.d_long2.getValue(NonSI.DEGREE_ANGLE), jet.d_velocity.getValue(SIUS.unit(8)), jet.d_flowFrac);
                table.add(jetData);
            }
            tables.put(tableName, table);
            rec.setValue("SPRAY_PATTERN_TABLE", tableName);
        }
    }

    private void renderDefDeviceProps(FDSRenderRecord rec) {
        rec.setValue("INITIAL_STATE", false, false);
    }

    private void renderFreePointLoc(FDSRenderRecord rec, FreePointLoc loc) {
        IGeom pointGeom = loc.d_geom;
        assert (pointGeom instanceof Point);
        DeviceRenderer.renderLoc(rec, "XYZ", new UnitPoint3D(((Point)pointGeom).loc, Geometry.LU));
        Vector3d orient = loc.d_orientation;
        FDSArray<Double> orientArr = new FDSArray<Double>(orient.x, orient.y, orient.z);
        rec.setValue("ORIENTATION", orientArr, false);
        rec.setValue("ROTATION", loc.d_rotation, false);
    }

    private void renderAttachedPointLoc(FDSRenderRecord rec, AttachedPointLoc loc) {
        DeviceRenderer.renderLoc(rec, "XYZ", loc.d_location);
        int ior = GeomUtil.toFDSVec(loc.d_faceNormal);
        rec.setValue("IOR", ior, false);
        rec.setValue("ROTATION", loc.d_rotation, false);
    }

    private <T extends INamed> FDSRenderRecord getPropRecord(Consumer<FDSRenderRecord> initFunc, IDevice devc, T ... objs) {
        return this.getPropRecord(initFunc, devc, null, (INamed[])objs);
    }

    private <T extends INamed> FDSRenderRecord getPropRecord(Consumer<FDSRenderRecord> initFunc, IDevice devc, String overrideName, T ... objs) {
        Map<String, String> cprops = Collections.emptyMap();
        if (devc != null && devc.getCustomFDSTypes().contains("PROP")) {
            cprops = devc.getCustomFDSProps("PROP").getProps();
        }
        PropHasher hasher = new PropHasher(cprops, objs);
        return this.d_propMap.computeIfAbsent(hasher, h -> {
            Object baseID;
            FDSRenderRecord rec = FDS7Const.newRenderRecord("PROP");
            if (overrideName != null) {
                baseID = overrideName;
            } else {
                baseID = "";
                for (INamed obj : objs) {
                    if (((String)baseID).length() != 0) {
                        baseID = (String)baseID + "_";
                    }
                    baseID = (String)baseID + obj.getName();
                }
            }
            String id = this.getNameMap().generateName("PROP", (String)baseID);
            rec.setValue("ID", id);
            initFunc.accept(rec);
            if (devc != null) {
                DeviceRenderer.renderCustomFDSProps(rec, devc);
            }
            this.d_revPropMap.put(rec, hasher);
            return rec;
        });
    }

    private boolean arePropsSet(FDSRenderRecord rec) {
        Map<String, Object> props = rec.getProperties();
        List<FDSRecord.UnknownProp> custom = rec.getUnknownProps();
        boolean notSet = custom.isEmpty() && (props.size() == 0 || props.size() == 1 && props.keySet().iterator().next().equals("ID"));
        return !notSet;
    }

    private void renderPropRef(FDSRenderRecord devcRec, FDSRenderRecord propRec) {
        if (this.arePropsSet(propRec)) {
            devcRec.setValue("PROP_ID", propRec.get("ID"));
        } else {
            PropHasher hasher = this.d_revPropMap.remove(propRec);
            this.d_propMap.remove(hasher);
        }
    }

    private static class ReverseSamplerLine {
        public final Aspirator d_aspirator;
        public final Aspirator.SamplerLine d_line;

        public ReverseSamplerLine(Aspirator asp, Aspirator.SamplerLine line) {
            this.d_line = line;
            this.d_aspirator = asp;
        }
    }

    private class DryPipeCtrl {
        private final OrOp or = new OrOp();
        private final TimeDelayCtrl timeDelay;
        private final IOutPin d_outPin;
        private final IInPin d_inPin;

        public DryPipeCtrl(DeviceRenderer deviceRenderer, DryPipe dryPipe) {
            this.or.setName(String.format(Intl.intl("%s_inputs"), dryPipe.getName()));
            this.d_inPin = this.or.getInputPin();
            this.timeDelay = new TimeDelayCtrl(dryPipe.getDelay());
            this.timeDelay.setName(String.format(Intl.intl("%s_delay"), dryPipe.getName()));
            this.timeDelay.getInputPin().connect(this.or.getOutputPins().get(0));
            this.d_outPin = this.timeDelay.getOutputPins().get(0);
            deviceRenderer.d_addedControls.add(this.or);
            deviceRenderer.d_addedControls.add(this.timeDelay);
        }

        public List<? extends IOutPin> getOutputPins() {
            return Arrays.asList(this.d_outPin);
        }

        public IInPin getInputPin() {
            return this.d_inPin;
        }
    }

    private static class PropHasher<T> {
        private final Map<String, String> d_customProps;
        private final T[] d_objs;

        public PropHasher(Map<String, String> customProps, T ... objs) {
            assert (objs.length > 0);
            this.d_customProps = customProps;
            this.d_objs = objs;
        }

        public int hashCode() {
            int code = this.d_customProps.hashCode();
            for (T o : this.d_objs) {
                code += o.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PropHasher)) {
                return false;
            }
            PropHasher hasher = (PropHasher)obj;
            if (!this.d_customProps.equals(hasher.d_customProps)) {
                return false;
            }
            if (this.d_objs.length != hasher.d_objs.length) {
                return false;
            }
            for (int m = 0; m < this.d_objs.length; ++m) {
                if (this.d_objs[m] == hasher.d_objs[m]) continue;
                return false;
            }
            return true;
        }
    }
}

