/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.evac.Corr;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class CorrRenderer
extends AFDS7Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Corr.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        UnitDouble effLength;
        Double facSpeed;
        UnitDouble[] xb2;
        UnitDouble[] xb1;
        NamedPyroObject toNode;
        Corr obj = (Corr)o;
        FDSRenderRecord rec = FDS7Const.newRenderRecord("CORR");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getProp("FYI"), false);
        Integer maxHumansInside = (Integer)obj.getProp("MAX_HUMANS_INSIDE");
        if (maxHumansInside != null) {
            rec.setValue("MAX_HUMANS_INSIDE", maxHumansInside);
        }
        if ((toNode = (NamedPyroObject)obj.getProp("TO_NODE")) != null) {
            rec.setValue("TO_NODE", toNode.getName(), false);
        }
        if ((xb1 = (UnitDouble[])obj.getProp("XB1")) != null) {
            UnitAABox xb1Box = new UnitAABox(new UnitPoint3D(xb1[0], xb1[2], xb1[4]), new UnitPoint3D(xb1[1], xb1[3], xb1[5]));
            String key = obj.getProp("XB2") == null ? "XB" : "XB1";
            CorrRenderer.renderXB(rec, key, xb1Box.getMin(), xb1Box.getMax());
        }
        if ((xb2 = (UnitDouble[])obj.getProp("XB2")) != null) {
            UnitAABox xb2Box = new UnitAABox(new UnitPoint3D(xb2[0], xb2[2], xb2[4]), new UnitPoint3D(xb2[1], xb2[3], xb2[5]));
            CorrRenderer.renderXB(rec, "XB2", xb2Box.getMin(), xb2Box.getMax());
        }
        if ((facSpeed = (Double)obj.getProp("FAC_SPEED")) != null) {
            rec.setValue("FAC_SPEED", facSpeed, false);
        }
        if ((effLength = (UnitDouble)obj.getProp("EFF_LENGTH")) != null) {
            rec.setValue("EFF_LENGTH", effLength, false);
        }
        props.render(rec, o);
        return true;
    }
}

