/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Colors;
import pyrosim.io.fds.v7.renderers.FDSNameMap;
import pyrosim.io.fds.v7.renderers.IFDS7Renderer;
import pyrosim.io.fds.v7.renderers.RampRenderer;
import pyrosim.io.fds.v7.renderers.SingletonRecords;
import pyrosim.legacy_2006_2.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public abstract class AFDS7Renderer
implements IFDS7Renderer {
    @Override
    public boolean markDependency(DepSnapshot deps, IPyroObject obj, boolean renderExplicit) {
        return true;
    }

    @Override
    public Collection<IPyroObject> sortPyroObjects(Collection<IPyroObject> objs) {
        return objs;
    }

    protected void doneRendering(IFDSRecordRenderer props) {
    }

    public void fillSingletonRecords(SingletonRecords sr, IPyroObject ... objs) {
        this.fillSingletonRecords(sr, Arrays.asList(objs));
    }

    @Override
    public void fillSingletonRecords(SingletonRecords sr, Collection<? extends IPyroObject> objs) {
        for (IPyroObject iPyroObject : objs) {
            this.fillSingletonRecords(sr, iPyroObject);
        }
    }

    protected void fillSingletonRecords(SingletonRecords sr, IPyroObject obj) {
    }

    public void render(IFDSRecordRenderer props, IPyroObject ... objs) {
        this.render(props, Arrays.asList(objs));
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        boolean recWritten = false;
        for (IPyroObject iPyroObject : objs) {
            recWritten |= this.render(props, iPyroObject);
        }
        this.doneRendering(props);
        return recWritten;
    }

    protected boolean render(IFDSRecordRenderer props, IPyroObject obj) {
        return false;
    }

    protected static void renderEvac(FDSRenderRecord rec, String evacKey, String meshIDKey, EvacProps evac) {
        switch (evac.evacuation) {
            case 2: {
                rec.setValue(evacKey, true);
                break;
            }
            case 1: {
                rec.setValue(evacKey, false);
            }
        }
        if (evac.mesh != null) {
            rec.setValue(meshIDKey, evac.mesh.getName());
        }
    }

    protected static void renderColor(FDSRenderRecord rec, boolean isVisible, Color c, String rgbKey, String colorKey, String transparencyKey) {
        if (!isVisible) {
            rec.setValue(colorKey, "INVISIBLE");
            return;
        }
        if (c != null) {
            String colorName;
            boolean colorWritten = false;
            if (colorKey != null && (colorName = FDS7Colors.getName(c)) != null) {
                rec.setValue(colorKey, colorName, false);
                colorWritten = true;
            }
            if (!colorWritten && rgbKey != null) {
                FDSArray<Object> cval = new FDSArray<Object>(c.getRed(), c.getGreen(), c.getBlue());
                rec.setValue(rgbKey, cval, false);
            }
            if (transparencyKey != null) {
                double alpha = (double)c.getAlpha() / 255.0;
                rec.setValue(transparencyKey, alpha, false);
            }
        }
    }

    protected static void renderAABox(FDSRenderRecord rec, String xbKey, AABox box) {
        AFDS7Renderer.renderXB(rec, xbKey, box.getMin(), box.getMax());
    }

    protected static void renderAABox(FDSRenderRecord rec, String xbKey, UnitAABox box) {
        AFDS7Renderer.renderXB(rec, xbKey, box.getMin(), box.getMax());
    }

    protected static void renderXB(FDSRenderRecord rec, String key, Point3d min, Point3d max) {
        FDSArray<Object> vals = new FDSArray<Object>(AFDS7Renderer.lv(min.x), AFDS7Renderer.lv(max.x), AFDS7Renderer.lv(min.y), AFDS7Renderer.lv(max.y), AFDS7Renderer.lv(min.z), AFDS7Renderer.lv(max.z));
        rec.setValue(key, vals);
    }

    private static UnitDouble lv(double v) {
        return new UnitDouble(v, Geometry.GEOM_LENGTH_UNIT);
    }

    protected static void renderXB(FDSRenderRecord rec, String key, UnitPoint3D min, UnitPoint3D max) {
        FDSArray<Object> vals = new FDSArray<Object>(min.xu(), max.xu(), min.yu(), max.yu(), min.zu(), max.zu());
        rec.setValue(key, vals);
    }

    protected static void renderTextureOrigin(FDSRenderRecord rec, String key, FDSObject obj, TexOrigin to) {
        UnitPoint3D loc = to.getWorld(obj);
        if (!loc.equals(TexOrigin.DEF_LOC)) {
            AFDS7Renderer.renderLoc(rec, key, loc, true);
        }
    }

    protected static void renderLoc(FDSRenderRecord rec, String key, UnitPoint3D p) {
        AFDS7Renderer.renderLoc(rec, key, p, true);
    }

    protected static void renderLoc(FDSRenderRecord rec, String key, UnitPoint3D p, boolean force) {
        FDSArray<Object> vals = new FDSArray<Object>(p.xu(), p.yu(), p.zu());
        rec.setValue(key, vals, force);
    }

    protected static void renderTVal(FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, String baseRampName, TimeBasedValue val, String valKey, String rampKey, String tauKey, boolean overrideIfDefault) {
        rec.setValue(valKey, val.val, overrideIfDefault);
        AFDS7Renderer.renderTimeFunc(rec, nameMap, ramps, baseRampName, val.func, rampKey, tauKey);
    }

    protected static void renderTimeFunc(FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, String baseRampName, TimeFunction func, String rampKey, String tauKey) {
        if (func instanceof TimeFunction.TanH) {
            if (tauKey != null) {
                rec.setValue(tauKey, func.val, false);
            }
        } else if (func instanceof TimeFunction.TSquared) {
            UnitDouble time = (UnitDouble)((TimeFunction.TSquared)func).val;
            rec.setValue(tauKey, time.negate(), false);
        } else {
            assert (rampKey != null);
            assert (func instanceof TimeFunction.Custom);
            Ramp r = (Ramp)func.val;
            String rName = RampRenderer.createID(nameMap, baseRampName, rampKey);
            ramps.put(rName, r);
            rec.setValue(rampKey, rName, false);
        }
    }

    protected void renderVariant(IFDSRecordRenderer props, FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, String baseName, Variant var, String valKey, String rampIDKey) {
        if (var.isRamp() && rampIDKey != null) {
            String rName = RampRenderer.createID(nameMap, baseName, rampIDKey);
            ramps.put(rName, (Ramp)var.val);
            rec.setValue(rampIDKey, rName, false);
        } else if (var.isConstant() && valKey != null) {
            rec.setValue(valKey, (UnitDouble)var.val);
        }
    }

    protected void renderSimpleVariant(FDSRenderRecord rec, String valKey, Variant var) {
        this.renderVariant(null, rec, null, null, null, var, valKey, null);
    }

    protected static void renderAARectangle(FDSRenderRecord rec, String xbKey, AARectangle rect) {
        AABox bb = rect.getBoundingBox(new AABox());
        AFDS7Renderer.renderAABox(rec, xbKey, bb);
    }

    protected static Integer renderVelocitySign(VelocitySign vs) {
        switch (vs) {
            case ALWAYS_POSITIVE: {
                return null;
            }
            case MATCH_U: {
                return 1;
            }
            case MATCH_V: {
                return 2;
            }
            case MATCH_W: {
                return 3;
            }
        }
        return null;
    }

    protected static void renderCustomFDSProps(FDSRenderRecord rec, ICustomFDSPropsContainer obj) {
        AFDS7Renderer.renderCustomFDSProps(rec, obj.getCustomFDSProps(rec.getType()));
    }

    protected static void renderCustomFDSProps(FDSRenderRecord rec, CustomFDSProps props) {
        for (Map.Entry<String, String> entry : props.getProps().entrySet()) {
            rec.addUnknownProp(entry.getKey(), Arrays.asList(entry.getValue()));
        }
    }

    protected static Color resolveSurfaceColor(Color setColor, Surface surf) {
        Color color = setColor;
        if (surf != null && surf.getAppearance() != null && surf.getAppearance().getAttributes().getTexture(MatChannel.DIFFUSE) == null) {
            return surf.getAppearance().getAttributes().getDiffuseColorWithOpacity();
        }
        return color;
    }
}

