/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDS7Parser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;
import thunderheadeng.util.Lists;

public class TableParser
extends AFDS7Parser {
    public TableParser(FDS7ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("TABL");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = (String)rec.get("ID");
        if (id == null) {
            this.addWarning(rec, Intl.intl("Table entry has no ID."), Intl.intl("Adding table entry to additional records section."));
            return false;
        }
        List<Double> vals = rec.getList("TABLE_DATA", false);
        if (vals == null || vals.isEmpty()) {
            this.addWarning(rec, Intl.intl("Table entry has no values."), Intl.intl("Ignoring table entry."));
            return true;
        }
        if (Lists.containsNull(vals)) {
            throw new FDSRecordFormatException(rec, Intl.intl("Null values are not allowed in table entries."));
        }
        this.getParsingInfo().addTableRow(id, vals);
        return true;
    }
}

