/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDS7Parser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;

public class RampParser
extends AFDS7Parser {
    public RampParser(FDS7ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("RAMP");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("CTRL_ID", "UNSUPPORTED");
        unsupportedFields.put("NUMBER_INTERPOLATION_POINTS", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = rec.getString("ID");
        if (id == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Ramp does not have ID."));
        }
        Double f = rec.getDouble("F");
        if (f == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Ramp does not have an F."));
        }
        Double rampInput = null;
        Double t = rec.getDouble("T");
        Double x = rec.getDouble("X");
        Double z = rec.getDouble("Z");
        if (t == null && x == null && z == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Ramp does not have a T, X, or Z."));
        }
        if (t != null) {
            rampInput = t;
        } else if (x != null) {
            rampInput = x;
        } else if (z != null) {
            rampInput = z;
        }
        String devcID = rec.getString("DEVC_ID");
        this.getParsingInfo().addRampValue(rec, id, rampInput, f, devcID);
        return true;
    }
}

