/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDS7Parser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;

public class Plot3dParser
extends AFDS7Parser {
    public Plot3dParser(FDS7ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DUMP");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray quantities = rec.getArray("PLOT3D_QUANTITY", true);
        if (quantities == null) {
            return true;
        }
        FDSArray exSpecIds = rec.getArray("PLOT3D_SPEC_ID", true);
        FDSArray partIds = rec.getArray("PLOT3D_PART_ID", true);
        FDSArray veloIndexes = rec.getArray("PLOT3D_VELO_INDEX", true);
        ArrayList<IQuantity> measurements = new ArrayList<IQuantity>(5);
        VelocitySign vs = VelocitySign.ALWAYS_POSITIVE;
        for (int m = 0; m < Math.min(quantities.getTotalLength(), 5); ++m) {
            String quantity = (String)quantities.get(m);
            if (quantity == null) continue;
            String exSpecId = exSpecIds != null ? (String)exSpecIds.get(m) : null;
            String partId = partIds != null ? (String)partIds.get(m) : null;
            Integer veloIndex = veloIndexes != null ? (Integer)veloIndexes.get(m) : null;
            IQuantity msr = this.getQuantityMap().parseQuantity(this.getParsingInfo(), rec, quantity, partId, exSpecId, null, null, null);
            if (msr == null) continue;
            if (!QuantityUtil.canOutputAll(msr.get(), 64L)) {
                this.addWarning(rec, String.format(Intl.intl("Quantity %s is invalid for Plot3D output."), quantity), Intl.intl("Quantity ignored"));
                continue;
            }
            measurements.add(msr);
            if (!msr.get().equals((Object)Quantity.VELOCITY)) continue;
            vs = this.parseVelocitySign(rec, veloIndex);
        }
        Plot3d plot3d = this.getContainer().getPlot3d();
        plot3d.setQuantities(measurements);
        plot3d.setVelocitySign(vs);
        this.flagObjectAdded(plot3d);
        return true;
    }
}

