/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.Util;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.signals.AOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.IFDSRecordParser;
import pyrosim.io.fds.v7.parsers.ControlParser;
import pyrosim.io.fds.v7.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;

public class PinConnFinisher
implements IFDSRecordParser {
    private final FDSParsingInfo d_pi;
    private final PinConnParser d_pinConns;
    private final ControlParser d_ctrlParser;

    public PinConnFinisher(FDSParsingInfo pi, PinConnParser pinConns, ControlParser ctrl) {
        this.d_pi = pi;
        this.d_pinConns = pinConns;
        this.d_ctrlParser = ctrl;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("CTRL");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    private void addMathControls(Map<ILogicOutPin, ControlBridge> outPinToBridgeMap) {
        LinkedIdentityHashMap<AMathOp, ControlBridge> mathCtrlToBridgeMap = new LinkedIdentityHashMap<AMathOp, ControlBridge>();
        HashMap<AOutPin, IOutPin> ctrlOutToBridgeOutMap = new HashMap<AOutPin, IOutPin>();
        for (PinConnParser.InputRetrieval ret : this.d_pinConns.getRetrievals()) {
            AMathOp mathCtrl;
            ControlBridge bridge;
            if (!(ret.inPin.getAttachedSink() instanceof AMathOp) || (bridge = (ControlBridge)mathCtrlToBridgeMap.get(mathCtrl = (AMathOp)ret.inPin.getAttachedSink())) != null) continue;
            bridge = this.addBridge(mathCtrl);
            outPinToBridgeMap.put(mathCtrl.getLogicOut(), bridge);
            mathCtrlToBridgeMap.put(mathCtrl, bridge);
            ctrlOutToBridgeOutMap.put(mathCtrl.getDoubleOut(), bridge.getDoubleOutPin());
            ctrlOutToBridgeOutMap.put(mathCtrl.getLogicOut(), bridge.getLogicOutPin());
        }
        for (PinConnParser.InputRetrieval ret : this.d_pinConns.getRetrievals()) {
            Set<? extends IOutPin> signalPins = ret.inPin.getConnections();
            HashSet<Pair<IInPin, Pair<IOutPin, IOutPin>>> replacements = new HashSet<Pair<IInPin, Pair<IOutPin, IOutPin>>>();
            for (IOutPin iOutPin : signalPins) {
                IOutPin mathBridgeOut = (IOutPin)ctrlOutToBridgeOutMap.get(iOutPin);
                if (mathBridgeOut == null) continue;
                replacements.add(new Pair<IInPin, Pair<IOutPin, IOutPin>>(ret.inPin, new Pair<IOutPin, IOutPin>(iOutPin, mathBridgeOut)));
            }
            for (Pair pair : replacements) {
                ((IInPin)pair.v1).disconnect((IOutPin)((Pair)pair.v2).v1);
                ((IInPin)pair.v1).connect((IOutPin)((Pair)pair.v2).v2);
            }
        }
    }

    @Override
    public void process(Collection<FDSParseRecord> recs, Collection<FDSParseRecord> unprocessed) throws FDSRecordFormatException {
        this.d_ctrlParser.finish();
        IdentityHashMap<ILogicOutPin, ControlBridge> outPinToBridgeMap = new IdentityHashMap<ILogicOutPin, ControlBridge>();
        this.addMathControls(outPinToBridgeMap);
        for (PinConnParser.InputRetrieval inputRetrieval : this.d_pinConns.getRetrievals()) {
            Set<? extends IOutPin> sourcePins = inputRetrieval.inPin.getConnections();
            if (!(inputRetrieval.inPin.getAttachedSink() instanceof IControl) && inputRetrieval.inPin instanceof ILogicInPin) {
                ArrayList<? extends IOutPin> outPins = new ArrayList<IOutPin>(sourcePins);
                Iterator iterator = outPins.iterator();
                while (iterator.hasNext()) {
                    IOutPin outPin = (IOutPin)iterator.next();
                    ControlBridge bridge = (ControlBridge)outPinToBridgeMap.get(outPin);
                    if (bridge == null) {
                        bridge = this.addBridge((ILogicOutPin)outPin, this.d_pinConns.getPinFDSNameMap().get(outPin));
                        assert (outPin instanceof ILogicOutPin);
                        outPinToBridgeMap.put((ILogicOutPin)outPin, bridge);
                    }
                    inputRetrieval.inPin.disconnect(outPin);
                    inputRetrieval.inPin.connect(bridge.getOutputPins().get(0));
                }
                continue;
            }
            for (IOutPin iOutPin : sourcePins) {
                if (!(iOutPin instanceof ILogicOutPin) || outPinToBridgeMap.containsKey(iOutPin)) continue;
                outPinToBridgeMap.put((ILogicOutPin)iOutPin, null);
            }
        }
        for (Map.Entry entry : this.d_pinConns.getPinFDSNameMap().entrySet()) {
            IOutPin outPin = (IOutPin)entry.getKey();
            String ctrlName = (String)entry.getValue();
            if (!(outPin instanceof ILogicOutPin) || outPinToBridgeMap.containsKey(outPin) || outPin.getAttachedSource() instanceof IDevice && !(outPin.getAttachedSource() instanceof Timer)) continue;
            ControlBridge controlBridge = this.addBridge((ILogicOutPin)outPin, ctrlName);
            outPinToBridgeMap.put((ILogicOutPin)outPin, controlBridge);
        }
        Map<IOutPin, IInPin> mappedConnections = Util.markFirstClassControls(this.d_pi.getContainer().getControls().flatten());
        for (Map.Entry<IOutPin, IInPin> kvPair : mappedConnections.entrySet()) {
            IInPin sinkPin = kvPair.getValue();
            IOutPin iOutPin = kvPair.getKey();
            ControlBridge cb = (ControlBridge)outPinToBridgeMap.get(iOutPin);
            if (cb == null) {
                cb = new ControlBridge(this.d_pinConns.getPinFDSNameMap().get(iOutPin));
                assert (iOutPin instanceof ILogicOutPin);
                cb.getInputPin().connect(iOutPin);
                outPinToBridgeMap.put((ILogicOutPin)iOutPin, cb);
            }
            sinkPin.disconnect(iOutPin);
            sinkPin.connect(cb.getLogicOutPin());
            this.d_pi.getContainer().getControls().add(cb);
            this.d_pi.getParseResult().extractedObjs.add(cb);
        }
    }

    private ControlBridge addBridge(AMathOp mathCtrl) {
        ControlBridge cb = new ControlBridge(mathCtrl.getName());
        cb.getInputPin().connect(mathCtrl.getDoubleOut());
        cb.getInputPin().connect(mathCtrl.getLogicOut());
        this.d_pi.getContainer().getControls().add(cb);
        this.d_pi.getParseResult().extractedObjs.add(cb);
        this.d_pinConns.addOutputName(cb.getLogicOutPin(), mathCtrl.getName() + "->" + cb.getLogicOutPin().getName());
        return cb;
    }

    private ControlBridge addBridge(ILogicOutPin controlOutPin, String ctrlName) {
        ControlBridge cb = new ControlBridge(this.getBridgeName(controlOutPin, ctrlName));
        assert (cb.getInputPin().isCompatible(controlOutPin));
        cb.getInputPin().connect(controlOutPin);
        this.d_pi.getContainer().getControls().add(cb);
        this.d_pi.getParseResult().extractedObjs.add(cb);
        return cb;
    }

    private String getBridgeName(ILogicOutPin outPin, String ctrlName) {
        int lcount = 0;
        for (IOutPin iOutPin : outPin.getAttachedSource().getOutputPins()) {
            if (!(iOutPin instanceof ILogicOutPin)) continue;
            ++lcount;
        }
        if (lcount == 1) {
            return ctrlName;
        }
        return ctrlName + "->" + outPin.getName();
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
    }
}

