/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.tasks.FillGridsWithPartsTask;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDSObjParser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;
import pyrosim.io.fds.v7.parsers.PinConnParser;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;

public class InitParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;

    public InitParser(FDS7ParsingInfo parsingInfo, PinConnParser pinConns) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("INIT");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("DIAMETER", "UNSUPPORTED");
        unsupportedFields.put("HEIGHT", "UNSUPPORTED");
        unsupportedFields.put("HRRPUV", "UNSUPPORTED");
        unsupportedFields.put("PARTICLE_WEIGHT_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("RADIUS", "UNSUPPORTED");
        unsupportedFields.put("SHAPE", "UNSUPPORTED");
        unsupportedFields.put("UVW", "UNSUPPORTED");
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitDouble density = rec.getUnitDouble("DENSITY");
        UnitDouble temp = rec.getUnitDouble("TEMPERATURE");
        boolean hasExSpecComps = rec.contains("MASS_FRACTION") || rec.contains("VOLUME_FRACTION");
        String partid = rec.getString("PART_ID");
        ArrayList<IPyroObject> addObjs = new ArrayList<IPyroObject>();
        if (density != null || temp != null || hasExSpecComps) {
            addObjs.addAll(this.processAsInitRegion(rec));
        }
        if (partid != null) {
            addObjs.addAll(this.processAsPartCloud(rec));
        }
        if (addObjs.isEmpty()) {
            this.addWarning(rec, Intl.intl("Could not extract any data from INIT record."), Intl.intl("Adding INIT record to <b>Additional Records</b>."));
            return false;
        }
        for (PartCloud sink : Hierarchy.flatten(addObjs, PartCloud.class)) {
            if (!(sink.getInsertion() instanceof PartCloud.InsertPeriodically)) continue;
            InitParser.markSingleInputForRetrieval(rec, sink, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        }
        for (ICustomFDSPropsContainer customFDS : Hierarchy.flatten(addObjs, ICustomFDSPropsContainer.class)) {
            this.parseCustomFDSProps(customFDS, rec);
        }
        return true;
    }

    protected Collection<? extends IPyroObject> processAsInitRegion(FDSParseRecord rec) throws FDSRecordFormatException {
        AABoxGeom region;
        UnitDouble density = rec.getUnitDouble("DENSITY");
        UnitDouble temp = rec.getUnitDouble("TEMPERATURE");
        List exSpecNames = rec.getList("SPEC_ID", false);
        String name = rec.getString("ID");
        if (name == null || name.isEmpty()) {
            name = rec.getComment().trim();
        }
        if (name == null || name.isEmpty()) {
            name = Intl.intl("Init Region");
        }
        if ((region = this.parseXBGeom(rec, "INIT", "XB", false)) == null) {
            AABox modelBounds = new AABox();
            for (Grid grid : this.getParsingInfo().getContainer().getGridManager().flatten()) {
                modelBounds.add(grid.getBounds());
            }
            region = new AABoxGeom(modelBounds);
        }
        InitRegion init = new InitRegion(name, region);
        init.setDensity(density);
        init.setTemperature(temp);
        List exSpecs = null;
        InitRegion.SpecFractionType type = null;
        if (rec.contains("MASS_FRACTION")) {
            exSpecs = rec.getList("MASS_FRACTION", false);
            type = InitRegion.SpecFractionType.MASS_FRACTION;
        }
        if (rec.contains("VOLUME_FRACTION")) {
            exSpecs = rec.getList("VOLUME_FRACTION", false);
            type = InitRegion.SpecFractionType.VOLUME_FRACTION;
        }
        if (exSpecs != null) {
            LinkedIdentityHashMap<ExSpec, UnitDouble> specMF = new LinkedIdentityHashMap<ExSpec, UnitDouble>(exSpecs.size());
            for (int m = 0; m < exSpecs.size(); ++m) {
                UnitDouble mf = (UnitDouble)exSpecs.get(m);
                if (mf == null || mf.getValueNoUnit() == 0.0) continue;
                ExSpec spec = this.getContainer().getExSpecList().get((String)exSpecNames.get(m));
                if (spec == null) {
                    String msg = String.format(Intl.intl("Species %d could not be found."), m + 1);
                    String action = String.format(Intl.intl("Ignoring species %d."), m + 1);
                    this.addWarning(rec, msg, action);
                    continue;
                }
                specMF.put(spec, mf);
            }
            init.setExtraSpecies(specMF, type);
        }
        Pair<String, List<InitRegion>> toAdd = this.applyMult(rec, "MULT_ID", init);
        this.addObjects((String)toAdd.v1, (List)toAdd.v2);
        return (Collection)toAdd.v2;
    }

    protected Collection<? extends IPyroObject> processAsPartCloud(FDSParseRecord rec) throws FDSRecordFormatException {
        String partid = rec.getString("PART_ID");
        Particle part = this.findParticle(rec, partid);
        if (part == null) {
            return Collections.EMPTY_LIST;
        }
        PartCloud.IDropletCount dropCount = this.parseParticleCount(rec);
        if (dropCount == null) {
            String msg = Intl.intl("No particle count is specified.");
            String action = Intl.intl("Ignoring INIT particles.");
            this.addWarning(rec, msg, action);
            return Collections.EMPTY_LIST;
        }
        String name = rec.getString("ID");
        if (name == null || name.isEmpty()) {
            name = rec.getComment().trim();
        }
        if (name == null || name.isEmpty()) {
            name = partid;
        }
        IGeom baseGeom = this.parseParticleGeom(rec);
        PartCloud.IInsertion insertion = this.parseInsertion(rec, baseGeom);
        List<Pair<IGeom, PartCloud.IDropletCount>> geoms = this.parseParticleTransform(rec, baseGeom, dropCount);
        if (!geoms.isEmpty()) {
            ArrayList objs = new ArrayList();
            for (Pair<IGeom, PartCloud.IDropletCount> geom : geoms) {
                PartCloud cloud = new PartCloud(name, part, (IGeom)geom.v1);
                cloud.setInsertion(insertion);
                cloud.setInitDrops((PartCloud.IDropletCount)geom.v2);
                Pair<String, List<PartCloud>> toAdd = this.applyMult(rec, "MULT_ID", cloud);
                this.addObjects((String)toAdd.v1, (List)toAdd.v2);
                objs.addAll((Collection)toAdd.v2);
            }
            return objs;
        }
        FillGridsWithPartsTask task = new FillGridsWithPartsTask(this.getContainer(), name, this.getContainer().getGridManager().flatten(), part, dropCount, insertion, false);
        task.run();
        this.flagObjectsAdded(task.getAddedObjects());
        return task.getAddedObjects();
    }

    private PartCloud.IDropletCount parseParticleCount(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.contains("N_PARTICLES") && rec.getInteger("N_PARTICLES", true) != 0 && rec.contains("N_PARTICLES_PER_CELL") && rec.getInteger("N_PARTICLES_PER_CELL", true) != 0) {
            this.addWarning(rec, String.format(Intl.intl("Only %1$s or %2$s should be specified"), "N_PARTICLES", "N_PARTICLES_PER_CELL"), String.format(Intl.intl("Ignoring %s"), "N_PARTICLES_PER_CELL"));
        }
        if (rec.getInteger("N_PARTICLES", true) != 0) {
            return new PartCloud.ConstDropletCount(rec.getInteger("N_PARTICLES", true));
        }
        if (rec.getInteger("N_PARTICLES_PER_CELL", true) != 0) {
            boolean cellCentered = rec.getBoolean("CELL_CENTERED", true);
            return new PartCloud.PerCellCount(rec.getInteger("N_PARTICLES_PER_CELL", true), cellCentered);
        }
        return null;
    }

    protected Particle findParticle(FDSParseRecord rec, String partid) {
        if (partid == null) {
            this.addWarning(rec, Intl.intl("Missing PART_ID for INIT particles."), Intl.intl("Ignoring INIT particles."));
            return null;
        }
        Particle part = this.findObject(Particle.class, partid);
        if (part == null) {
            this.addWarning(rec, String.format(Intl.intl("Could not find particle, %s, for INIT particles."), partid), Intl.intl("Ignoring INIT particles."));
            return null;
        }
        return part;
    }

    protected PartCloud.IInsertion parseInsertion(FDSParseRecord rec, IGeom geom) {
        boolean forceGet;
        UnitDouble massPerVol;
        if (rec.contains("MASS_PER_VOLUME") && geom instanceof Point) {
            this.addWarning(rec, String.format(Intl.intl("%s cannot be used when there is no volume."), "MASS_PER_VOLUME"), String.format(Intl.intl("Ignoring %s"), "MASS_PER_VOLUME"));
        }
        if ((massPerVol = rec.getUnitDouble("MASS_PER_VOLUME", forceGet = !rec.contains("DT_INSERT"))) != null) {
            return new PartCloud.InsertOnce(massPerVol);
        }
        UnitDouble dt = rec.getUnitDouble("DT_INSERT");
        assert (dt != null);
        UnitDouble massPerTime = rec.getUnitDouble("MASS_PER_TIME", true);
        return new PartCloud.InsertPeriodically(dt, massPerTime);
    }

    protected IGeom parseParticleGeom(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.contains("XB") && rec.contains("XYZ")) {
            this.addWarning(rec, String.format(Intl.intl("Only %1$s or %2$s should be specified."), "XB", "XYZ"), String.format(Intl.intl("Ignoring %s."), "XB"));
        }
        if (rec.contains("XYZ")) {
            UnitPoint3D loc = InitParser.parseLoc(rec, "INIT", "XYZ", true);
            return new Point(loc.getPoint3dValue(Geometry.LU));
        }
        if (rec.contains("XB")) {
            return this.parseXBGeom(rec, rec.getType(), "XB", true);
        }
        return null;
    }

    protected List<Pair<IGeom, PartCloud.IDropletCount>> parseParticleTransform(FDSParseRecord rec, IGeom geom, PartCloud.IDropletCount count) throws FDSRecordFormatException {
        if (geom instanceof Point) {
            Point pgeom = (Point)geom;
            ArrayList<Pair<IGeom, PartCloud.IDropletCount>> geoms = new ArrayList<Pair<IGeom, PartCloud.IDropletCount>>();
            int numDrops = count.getNumDrops(null);
            double dx = rec.getUnitDouble("DX", true).get(Geometry.LU);
            double dy = rec.getUnitDouble("DY", true).get(Geometry.LU);
            double dz = rec.getUnitDouble("DZ", true).get(Geometry.LU);
            if (numDrops > 1 && (dx != 0.0 || dy != 0.0 || dz != 0.0)) {
                for (int m = 0; m < numDrops; ++m) {
                    Point3d newLoc = new Point3d(pgeom.loc.x + dx * (double)m, pgeom.loc.y + dy * (double)m, pgeom.loc.z + dz * (double)m);
                    geoms.add(new Pair<Point, PartCloud.ConstDropletCount>(new Point(newLoc), new PartCloud.ConstDropletCount(1)));
                }
            } else {
                geoms.add(new Pair<IGeom, PartCloud.IDropletCount>(geom, count));
            }
            return geoms;
        }
        if (geom != null) {
            if (rec.contains("DX") || rec.contains("DY") || rec.contains("DZ")) {
                this.addWarning(rec, String.format(Intl.intl("%1$s, %2$s, and %3$s may only be specified with %4$s."), "DX", "DY", "DZ", "XYZ"), Intl.intl("Ignoring offset parameters."));
            }
            return Arrays.asList(new Pair<IGeom, PartCloud.IDropletCount>(geom, count));
        }
        return Collections.EMPTY_LIST;
    }
}

