/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jscience.physics.units.SI;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IPropertySet;

public class SimParamsRenderer
extends AFDS6Renderer {
    private final FDS6QuantityMap d_msrMap;
    private final Map<String, Ramp> d_rampsUsed;
    private final FDSNameMap d_uniqueNameMap;
    private final List<Reaction> d_activeReacs;
    private SimParams.Misc d_misc;

    public SimParamsRenderer(FDS6QuantityMap msrMap, FDSNameMap uniqueNameMap) {
        this.d_msrMap = msrMap;
        this.d_rampsUsed = new HashMap<String, Ramp>();
        this.d_uniqueNameMap = uniqueNameMap;
        this.d_activeReacs = new ArrayList<Reaction>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(SimParams.class);
        types.add(Reaction.class);
    }

    @Override
    public void fillSingletonRecords(SingletonRecords sr, Collection<? extends IPyroObject> objs) {
        super.fillSingletonRecords(sr, objs);
        if (this.d_misc != null) {
            this.fillSuppression(sr.combRec, this.d_misc);
        }
    }

    @Override
    public void fillSingletonRecords(SingletonRecords sr, IPyroObject o) {
        if (o instanceof Reaction) {
            Reaction r = (Reaction)o;
            if (r.isActive()) {
                this.d_activeReacs.add(r);
            }
            return;
        }
        SimParams sp = (SimParams)o;
        this.d_misc = sp.getMisc();
        sr.headRec.setValue("TITLE", sp.getJobTitle(), false);
        SimParams.Time time = sp.getTime();
        sr.timeRec.setValue("T_BEGIN", time.getStartTime(), false);
        sr.timeRec.setValue("T_END", time.getStopTime(), false);
        sr.timeRec.setValue("DT", time.getInitTimeStep(), false);
        sr.timeRec.setValue("LOCK_TIME_STEP", time.lockTimeSteps(), false);
        sr.timeRec.setValue("RESTRICT_TIME_STEP", time.restrictTimeSteps(), false);
        sr.timeRec.setValue("WALL_INCREMENT", time.getWallIncrement(), false);
        SimParams.Environment env = sp.getEnvironment();
        this.renderVectorVariant(sr.miscRec, "GVEC", "RAMP_GX", "RAMP_GY", "RAMP_GZ", "GRAVITYX", "GRAVITYY", "GRAVITYZ", env.getGravityX(), env.getGravityY(), env.getGravityZ(), new UnitPoint3D(1.0, 1.0, 1.0, SI.METER.divide(SI.SECOND.pow(2))));
        sr.miscRec.setValue("HUMIDITY", env.getRelHumidity(), false);
        sr.miscRec.setValue("P_INF", env.getAmbPressure(), false);
        sr.miscRec.setValue("TMPA", env.getAmbTemp(), false);
        sr.miscRec.setValue("Y_CO2_INFTY", env.getAmbMFCO2(), false);
        sr.miscRec.setValue("Y_O2_INFTY", env.getAmbMFO2(), false);
        sr.miscRec.setValue("MAXIMUM_VISIBILITY", env.getMaxVisibility(), false);
        sr.miscRec.setValue("VISIBILITY_FACTOR", env.getVisibilityFactor(), false);
        SimParams.Particles par = sp.getParticles();
        sr.miscRec.setValue("POROUS_FLOOR", par.isPourousFloor(), false);
        sr.miscRec.setValue("ALLOW_UNDERSIDE_PARTICLES", par.getAllowUndersideDroplets(), false);
        sr.dumpRec.setValue("MAXIMUM_PARTICLES", par.getMaxParticlesPerMesh(), false);
        SimParams.Zones zones = sp.getZones();
        sr.miscRec.setValue("NO_PRESSURE_ZONES", zones.getNoPressureZones(), false);
        sr.miscRec.setValue("MINIMUM_ZONE_VOLUME", zones.getMinimumZoneVolume(), false);
        SimParams.Calculations calc = sp.getCalculations();
        sr.miscRec.setValue("CFL_MIN", calc.getCflRange()[0], false);
        sr.miscRec.setValue("CFL_MAX", calc.getCflRange()[1], false);
        sr.miscRec.setValue("C_SMAGORINSKY", calc.getCsmag(), false);
        SimParams.Calculations.SimulationMode sm = calc.getSimMode();
        sr.miscRec.setValue("SIMULATION_MODE", sm.simpleName, false);
        if (sm.equals((Object)SimParams.Calculations.SimulationMode.LES) || sm.equals((Object)SimParams.Calculations.SimulationMode.VLES) || sm.equals((Object)SimParams.Calculations.SimulationMode.SVLES)) {
            sr.miscRec.setValue("PR", calc.getPrandtlNum(), false);
            sr.miscRec.setValue("SC", calc.getSchmidtNum(), false);
            sr.combRec.setValue("INITIAL_UNMIXED_FRACTION", calc.getInitUnmixedFraction(), false);
        }
        if (!calc.getBaroclinicState().equals((Object)SimParams.Calculations.BaroclinicState.AUTO)) {
            if (calc.getBaroclinicState().equals((Object)SimParams.Calculations.BaroclinicState.TRUE)) {
                sr.miscRec.setValue("BAROCLINIC", true);
            } else if (calc.getBaroclinicState().equals((Object)SimParams.Calculations.BaroclinicState.FALSE)) {
                sr.miscRec.setValue("BAROCLINIC", false);
            }
        }
        sr.miscRec.setValue("VN_MIN", calc.getVnRange()[0], false);
        sr.miscRec.setValue("VN_MAX", calc.getVnRange()[1], false);
        SimParams.RadiationTransport radi = sp.getRadiTransport();
        if (radi.isRadiationOn()) {
            sr.radiRec.setValue("ANGLE_INCREMENT", radi.getAngleIncrement(), false);
            sr.radiRec.setValue("KAPPA0", radi.getConstAbsorptionCoef(), false);
            sr.radiRec.setValue("NMIEANG", radi.getNumPolarAngles(), false);
            sr.radiRec.setValue("NUMBER_RADIATION_ANGLES", radi.getNumSolidAngles(), false);
            sr.radiRec.setValue("PATH_LENGTH", radi.getRadCalcPathLen(), false);
            sr.radiRec.setValue("RADTMP", radi.getAssumedRadSourceTemp(), false);
            sr.radiRec.setValue("TIME_STEP_INCREMENT", radi.getTimeStepInc(), false);
            sr.radiRec.setValue("WIDE_BAND_MODEL", radi.isNonGrayGasAssumption(), false);
        } else {
            sr.radiRec.setValue("RADIATION", radi.isRadiationOn(), false);
        }
        SimParams.FileOutput output = sp.getFileOutput();
        sr.dumpRec.setValue("COLUMN_DUMP_LIMIT", output.isLimitCSVColumns(), false);
        sr.dumpRec.setValue("HRR_GAS_ONLY", output.isHrrGasOnly(), false);
        sr.dumpRec.setValue("DT_BNDF", output.getDtBoundaryFile(), false);
        sr.dumpRec.setValue("DT_DEVC", output.getDtDeviceFiles(), false);
        sr.dumpRec.setValue("DT_HRR", output.getDtHeatReleaseRateFiles(), false);
        sr.dumpRec.setValue("DT_ISOF", output.getDtIsofFiles(), false);
        sr.dumpRec.setValue("DT_MASS", output.getDtMassFiles(), false);
        sr.dumpRec.setValue("DT_PART", output.getDtParticleFiles(), false);
        sr.dumpRec.setValue("DT_PL3D", output.getDtPlot3dFile(), false);
        sr.dumpRec.setValue("DT_HVAC", output.getDtHvacOutFile(), false);
        sr.dumpRec.setValue("DT_PROF", output.getDtProfileDumpInterval(), false);
        sr.dumpRec.setValue("DT_RESTART", output.getDtRestartFile(), false);
        sr.dumpRec.setValue("DT_SLCF", output.getDtSliceFiles(), false);
        sr.dumpRec.setValue("DT_SL3D", output.getDtSlice3dFiles(), false);
        sr.dumpRec.setValue("NFRAMES", output.getNumOutputFrames(), false);
        sr.dumpRec.setValue("MASS_FILE", output.isWriteSpeciesMassFile(), false);
        sr.dumpRec.setValue("WRITE_XYZ", output.getDtPlot3dFile() != null, false);
        sr.dumpRec.setValue("SUPPRESS_DIAGNOSTICS", output.isSuppressDiagnostics(), false);
        boolean smoke3dVis = output.isVisualize3dSmoke();
        sr.dumpRec.setValue("SMOKE3D", smoke3dVis, false);
        if (smoke3dVis && output.getSmokeQuantity() != null) {
            this.d_msrMap.renderQuantity(sr.sm3dRec, "QUANTITY", null, "SPEC_ID", null, null, null, output.getSmokeQuantity());
        }
        SimParams.Misc misc = sp.getMisc();
        SimParamsRenderer.setUP3DValue(sr.miscRec, "TEXTURE_ORIGIN", misc.getTextureOrigin());
        sr.miscRec.setValue("NEIGHBOR_SEPARATION_DISTANCE", misc.getNeighborSeparationDistance(), false);
        sr.miscRec.setValue("RESTART", misc.getAndClearResume(), false);
        this.fillWindRecords(sr.windRec, sp.getWind());
        SimParamsRenderer.renderCustomFDSProps(sr.timeRec, sp);
        SimParamsRenderer.renderCustomFDSProps(sr.dumpRec, sp);
        SimParamsRenderer.renderCustomFDSProps(sr.miscRec, sp);
        SimParamsRenderer.renderCustomFDSProps(sr.radiRec, sp);
        SimParamsRenderer.renderCustomFDSProps(sr.presRec, sp);
        SimParamsRenderer.renderCustomFDSProps(sr.windRec, sp);
        SimParamsRenderer.renderCustomFDSProps(sr.combRec, sp);
        SimParamsRenderer.renderCustomFDSProps(sr.clipRec, sp);
    }

    private static void setUP3DValue(FDSRenderRecord rec, String key, UnitPoint3D value) {
        FDSArray<Object> vals = new FDSArray<Object>(value.xu(), value.yu(), value.zu());
        rec.setValue(key, vals, false);
    }

    @Override
    public void doneRendering(IFDSRecordRenderer props) {
        super.doneRendering(props);
        RampRenderer.render(props, this.d_rampsUsed, null);
    }

    private void fillWindRecords(FDSRenderRecord windRec, SimParams.Wind wind) {
        windRec.setValue("LAPSE_RATE", wind.get(SimParams.Wind.LAPSE_RATE), false);
        this.renderGeneralVariant(windRec, null, "RAMP_TMP0_Z", "WIND", wind.get(SimParams.Wind.TMP0Z_RAMP));
        windRec.setValue("GROUND_LEVEL", wind.get(SimParams.Wind.GROUND_LEVEL), false);
        windRec.setValue("L", wind.get(SimParams.Wind.L), false);
        windRec.setValue("Z_0", wind.get(SimParams.Wind.Z0), false);
        windRec.setValue("THETA_STAR", wind.get(SimParams.Wind.THETASTAR), false);
        windRec.setValue("U_STAR", wind.get(SimParams.Wind.USTAR), false);
        windRec.setValue("Z_REF", wind.get(SimParams.Wind.ZREF), false);
        switch (wind.get(SimParams.Wind.INITSPEEDOPT)) {
            case SPEED: {
                windRec.setValue("SPEED", wind.get(SimParams.Wind.SPEED), false);
                windRec.setValue("DIRECTION", wind.get(SimParams.Wind.DIRECTION), false);
                break;
            }
            case UV: {
                windRec.setValue("U0", wind.get(SimParams.Wind.U0), false);
                windRec.setValue("V0", wind.get(SimParams.Wind.V0), false);
            }
        }
        windRec.setValue("W0", wind.get(SimParams.Wind.W0), false);
        BiConsumer<String, IPropertySet.Prop> renderSpeed = (rampKey, prop) -> this.renderGeneralVariant(windRec, null, (String)rampKey, "WIND", (Variant)wind.get(prop));
        renderSpeed.accept("RAMP_SPEED_T", SimParams.Wind.SPEED_RAMP_T);
        renderSpeed.accept("RAMP_DIRECTION_T", SimParams.Wind.DIRECTION_RAMP_T);
        renderSpeed.accept("RAMP_U0_T", SimParams.Wind.U0T);
        renderSpeed.accept("RAMP_V0_T", SimParams.Wind.V0T);
        renderSpeed.accept("RAMP_W0_T", SimParams.Wind.W0T);
        renderSpeed.accept("RAMP_U0_Z", SimParams.Wind.U0Z);
        renderSpeed.accept("RAMP_V0_Z", SimParams.Wind.V0Z);
        renderSpeed.accept("RAMP_W0_Z", SimParams.Wind.W0Z);
        UnitPoint3D zeroForce = new UnitPoint3D(0.0, 0.0, 0.0, SI.PASCAL.divide(SI.METER));
        this.renderVectorVariant(windRec, "FORCE_VECTOR", "RAMP_FVX_T", "RAMP_FVY_T", "RAMP_FVZ_T", "WIND", "WIND", "WIND", wind.get(SimParams.Wind.FORCEX), wind.get(SimParams.Wind.FORCEY), wind.get(SimParams.Wind.FORCEZ), zeroForce);
    }

    private void fillSuppression(FDSRenderRecord rec, SimParams.Misc misc) {
        boolean suppressionVal = true;
        if (misc.getSuppression().equals((Object)SimParams.Misc.SUPPRESSION.AUTO)) {
            suppressionVal = this.d_activeReacs.size() <= 1;
        } else if (misc.getSuppression().equals((Object)SimParams.Misc.SUPPRESSION.TRUE)) {
            suppressionVal = true;
        } else if (misc.getSuppression().equals((Object)SimParams.Misc.SUPPRESSION.FALSE)) {
            suppressionVal = false;
        }
        rec.setValue("SUPPRESSION", suppressionVal, false);
    }

    private void renderGeneralVariant(FDSRenderRecord rec, String constKey, String rampKey, String rampBaseName, Variant v) {
        if (v.isConstant()) {
            rec.setValue(constKey, v.val, false);
        }
        if (v.isRamp()) {
            this.renderRamp(rec, (Ramp)v.val, rampKey, rampBaseName);
        }
    }

    private void renderVectorVariant(FDSRenderRecord rec, String constKey, String rampKey1, String rampKey2, String rampKey3, String rampBaseName1, String rampBaseName2, String rampBaseName3, Variant v1, Variant v2, Variant v3, UnitPoint3D rampDefVal) {
        UnitPoint3D defVal;
        if (v1.isDefault() && v2.isDefault() && v3.isDefault()) {
            return;
        }
        FDSRecordSpec.ArrayFld defValFld = (FDSRecordSpec.ArrayFld)rec.getSpec().fields.get(constKey);
        if (defValFld.initialValue != null) {
            FDSArray defArr = (FDSArray)defValFld.initialValue;
            defVal = new UnitPoint3D((UnitDouble)defArr.get(0), (UnitDouble)defArr.get(1), (UnitDouble)defArr.get(2));
        } else {
            UnitDouble cval = (UnitDouble)defValFld.elementChecker.initialValue;
            defVal = new UnitPoint3D(cval, cval, cval);
        }
        UnitDouble comp1 = this.renderVectorVariantComp(rec, rampKey1, rampBaseName1, v1, rampDefVal.xu(), defVal.xu());
        UnitDouble comp2 = this.renderVectorVariantComp(rec, rampKey2, rampBaseName2, v2, rampDefVal.yu(), defVal.yu());
        UnitDouble comp3 = this.renderVectorVariantComp(rec, rampKey3, rampBaseName3, v3, rampDefVal.zu(), defVal.zu());
        if (!(comp1.equals(defVal.xu()) && comp2.equals(defVal.yu()) && comp3.equals(defVal.zu()))) {
            SimParamsRenderer.setUP3DValue(rec, constKey, new UnitPoint3D(comp1, comp2, comp3));
        }
    }

    private UnitDouble renderVectorVariantComp(FDSRenderRecord rec, String rampKey, String rampBaseName, Variant v, UnitDouble rampDefVal, UnitDouble defVal) {
        if (v.isConstant()) {
            return (UnitDouble)v.val;
        }
        if (v.isRamp()) {
            this.renderRamp(rec, (Ramp)v.val, rampKey, rampBaseName);
            return rampDefVal;
        }
        if (v.isFractionalRamp()) {
            Variant.FractionalRamp fr = (Variant.FractionalRamp)v.val;
            this.renderRamp(rec, fr.fractionalRamp, rampKey, rampBaseName);
            return fr.constInput;
        }
        return defVal;
    }

    private void renderRamp(FDSRenderRecord rec, Ramp r, String rampKey, String rampNameBase) {
        String rName = RampRenderer.createID(this.d_uniqueNameMap, rampNameBase, rampKey);
        this.d_rampsUsed.put(rName, r);
        rec.setValue(rampKey, rName, false);
    }
}

