/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import thunderheadeng.units.UnitDouble;

public class Plot3dRenderer
extends AFDS6Renderer {
    private final FDS6QuantityMap d_measurementsMap;

    public Plot3dRenderer(FDS6QuantityMap mmap) {
        this.d_measurementsMap = mmap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(SimParams.class);
        types.add(Plot3d.class);
    }

    @Override
    public void fillSingletonRecords(SingletonRecords sr, Collection<? extends IPyroObject> objs) {
        boolean render = false;
        IPyroObject plot3d = null;
        for (IPyroObject iPyroObject : objs) {
            if (iPyroObject instanceof SimParams) {
                SimParams sp = (SimParams)iPyroObject;
                boolean bl = render = sp.getFileOutput().getDtPlot3dFile() != null;
            }
            if (!(iPyroObject instanceof Plot3d)) continue;
            plot3d = iPyroObject;
        }
        if (render && plot3d != null) {
            this.fillSingletonRecords(sr, plot3d);
        }
    }

    @Override
    public void fillSingletonRecords(SingletonRecords sr, IPyroObject o) {
        Plot3d obj = (Plot3d)o;
        FDSRenderRecord record = sr.dumpRec;
        Set<IQuantity> measurements = obj.getQuantities();
        if (measurements.isEmpty()) {
            UnitDouble dt = obj.getDomain() != null ? ((PyroMod)obj.getDomain()).getSimParams().getTime().getStopTime().add(new UnitDouble(1000.0, SI.SECOND)) : new UnitDouble(100000.0, SI.SECOND);
            record.setValue("DT_PL3D", dt);
            return;
        }
        ArrayList<String> fdsQuantitiesList = new ArrayList<String>(5);
        ArrayList<String> exSpecs = new ArrayList<String>(5);
        ArrayList<String> parts = new ArrayList<String>(5);
        ArrayList<Integer> veloIndexes = new ArrayList<Integer>(5);
        for (IQuantity iQuantity : measurements) {
            fdsQuantitiesList.add(this.d_measurementsMap.getFDSName(iQuantity.get()));
            String exSpec = null;
            String part = null;
            if (iQuantity instanceof ObjectQuantity) {
                ObjectQuantity om = (ObjectQuantity)iQuantity;
                if (om.objects[0] instanceof ExSpec) {
                    exSpec = ((ExSpec)om.objects[0]).getName();
                } else if (om.objects[0] instanceof Particle) {
                    part = ((Particle)om.objects[0]).getName();
                }
            }
            exSpecs.add(exSpec);
            parts.add(part);
            Integer veloIndex = null;
            if (iQuantity.get().equals((Object)Quantity.VELOCITY)) {
                veloIndex = Plot3dRenderer.renderVelocitySign(obj.getVelocitySign());
            }
            veloIndexes.add(veloIndex);
        }
        int defQuantsFound = 0;
        for (String fdsQuant : fdsQuantitiesList) {
            if (!FDS6Const.DEF_PLOT3D_QUANTITIES.contains(fdsQuant)) continue;
            ++defQuantsFound;
        }
        if (defQuantsFound == FDS6Const.DEF_PLOT3D_QUANTITIES.size()) {
            return;
        }
        ArrayList<Integer> arrayList = fdsQuantitiesList.size() == 2 ? new ArrayList<Integer>(Arrays.asList(3, 2, 1, 4, 0)) : new ArrayList<Integer>(Arrays.asList(4, 3, 2, 1, 0));
        FDSArray<Object> fdsQuantities = new FDSArray<Object>(null, null, null, null, null);
        FDSArray<Object> fdsSpecIds = new FDSArray<Object>(null, null, null, null, null);
        FDSArray<Object> fdsPartIds = new FDSArray<Object>(null, null, null, null, null);
        FDSArray<Object> fdsVeloIndexes = new FDSArray<Object>(null, null, null, null, null);
        this.fillArray(fdsQuantities, arrayList, Quantity.U_VELOCITY, 1, fdsQuantitiesList, exSpecs, parts, veloIndexes);
        this.fillArray(fdsQuantities, arrayList, Quantity.V_VELOCITY, 2, fdsQuantitiesList, exSpecs, parts, veloIndexes);
        this.fillArray(fdsQuantities, arrayList, Quantity.W_VELOCITY, 3, fdsQuantitiesList, exSpecs, parts, veloIndexes);
        for (int m = 0; m < fdsQuantitiesList.size() && !arrayList.isEmpty(); ++m) {
            Integer ix = arrayList.remove(arrayList.size() - 1);
            fdsQuantities.set((int)ix, (Object[])new String[]{fdsQuantitiesList.get(m)});
            fdsSpecIds.set((int)ix, (Object[])new String[]{(String)exSpecs.get(m)});
            fdsPartIds.set((int)ix, (Object[])new String[]{(String)parts.get(m)});
            fdsVeloIndexes.set((int)ix, (Object[])new Integer[]{(Integer)veloIndexes.get(m)});
        }
        record.setValue("PLOT3D_QUANTITY", fdsQuantities);
        record.setValue("PLOT3D_SPEC_ID", fdsSpecIds);
        record.setValue("PLOT3D_PART_ID", fdsPartIds);
        record.setValue("PLOT3D_VELO_INDEX", fdsVeloIndexes, false);
    }

    private void fillArray(FDSArray<String> array, ArrayList<Integer> availIxes, Quantity quantity, int ix, ArrayList<String> quants, ArrayList<?> ... extras) {
        String fdsName = this.d_measurementsMap.getFDSName(quantity);
        int nameIx = quants.indexOf(fdsName);
        if (nameIx >= 0) {
            quants.remove(nameIx);
            for (ArrayList<?> extra : extras) {
                extra.remove(nameIx);
            }
            array.set(ix, (String[])new String[]{fdsName});
            availIxes.remove((Object)ix);
        }
    }
}

