/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.evac.PersList;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Sets;

public class PersRenderer
extends AFDS6Renderer {
    public static Pers DEFAULTS = new Pers("__defaults__");
    public static Collection<String> DIST_PROPS = new HashSet<String>(Sets.fromArrayHS("DET_EVAC_DIST", "DET_MEAN", "DET_PARA", "DET_PARA2", "DET_LOW", "DET_HIGH", "PRE_EVAC_DIST", "PRE_MEAN", "PRE_PARA", "PRE_PARA2", "PRE_LOW", "PRE_HIGH", "DIAMETER_DIST", "DIA_MEAN", "DIA_PARA", "DIA_PARA2", "DIA_LOW", "DIA_HIGH", "VELOCITY_DIST", "VEL_MEAN", "VEL_PARA", "VEL_PARA2", "VEL_LOW", "VEL_HIGH", "TAU_EVAC_DIST", "TAU_MEAN", "TAU_PARA", "TAU_PARA2", "TAU_LOW", "TAU_HIGH"));
    public static Collection<String> LOOSE_PROPS = new HashSet<String>(Sets.fromArrayHS("ID", "FYI", "DEFAULT_PROPERTIES", "FCONST_A", "FCONST_B", "L_NON_SP", "C_YOUNG", "KAPPA", "D_TORSO_MEAN", "D_SHOULDER_MEAN", "TAU_ROT", "M_INERTIA"));
    public static Collection<String> GLOBAL_PROPS = new HashSet<String>(Sets.fromArrayHS("FAC_A_WALL", "FAC_B_WALL", "LAMBDA_WALL", "FC_DAMPING", "V_ANGULAR", "NOISEME", "NOISETH", "NOISECM", "HUMAN_SMOKE_HEIGHT", "TDET_SMOKE_DENS", "FED_DOOR_CRIT", "SMOKE_MIN_SPEED", "DENS_INIT", "EVAC_DT_MAX", "EVAC_DT_MIN", "NOT_RANDOM", "COLOR_METHOD", "OUTPUT_SPEED", "OUTPUT_FED", "OUTPUT_CONTACT_FORCE", "OUTPUT_TOTAL_FORCE"));
    public static Collection<String> GLOBAL_PROPS_SPECIAL = new HashSet<String>(Sets.fromArrayHS("AVATAR_COLOR", "AVATAR_RGB", "DEAD_COLOR", "DEAD_RGB"));
    private final PersList d_persList;

    public PersRenderer(PersList manager) {
        this.d_persList = manager;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Pers.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Pers obj = (Pers)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("PERS");
        String strParent = (String)obj.getProp("DEFAULT_PROPERTIES");
        Pers parent = DEFAULTS;
        if (strParent != null) {
            parent = PersList.PREDEFINED.get(strParent);
            assert (parent != null);
        }
        rec.setValue("ID", obj.getName());
        String fyi = (String)obj.getProp("FYI");
        if (fyi != null && !fyi.isEmpty()) {
            rec.setValue("FYI", obj.getProp("FYI"));
        }
        rec.setValue("DEFAULT_PROPERTIES", strParent != null ? strParent : "null");
        Collection<String> diffs = Pers.diff(DIST_PROPS, parent, obj);
        this.addDistRec(rec, obj, diffs, "DET_EVAC_DIST", "DET_MEAN", "DET_PARA", "DET_PARA2", "DET_LOW", "DET_HIGH");
        this.addDistRec(rec, obj, diffs, "PRE_EVAC_DIST", "PRE_MEAN", "PRE_PARA", "PRE_PARA2", "PRE_LOW", "PRE_HIGH");
        this.addDistRec(rec, obj, diffs, "DIAMETER_DIST", "DIA_MEAN", "DIA_PARA", "DIA_PARA2", "DIA_LOW", "DIA_HIGH");
        this.addDistRec(rec, obj, diffs, "VELOCITY_DIST", "VEL_MEAN", "VEL_PARA", "VEL_PARA2", "VEL_LOW", "VEL_HIGH");
        this.addDistRec(rec, obj, diffs, "TAU_EVAC_DIST", "TAU_MEAN", "TAU_PARA", "TAU_PARA2", "TAU_LOW", "TAU_HIGH");
        HashSet<String> remainingProps = new HashSet<String>();
        remainingProps.addAll(LOOSE_PROPS);
        remainingProps.removeAll(Arrays.asList("ID", "FYI", "DEFAULT_PROPERTIES"));
        diffs = Pers.diff(remainingProps, parent, obj);
        for (String key : remainingProps) {
            if (!diffs.contains(key)) continue;
            rec.setValue(key, obj.getProp(key));
        }
        props.render(rec, o);
        return true;
    }

    private void addDistRec(FDSRenderRecord rec, Pers pers, Collection<String> diffs, String keyDist, String keyMean, String keyPara, String keyPara2, String keyLow, String keyHigh) {
        int dist = (Integer)pers.getProp(keyDist);
        UnitDouble mean = (UnitDouble)pers.getProp(keyMean);
        UnitDouble low = (UnitDouble)pers.getProp(keyLow);
        UnitDouble high = (UnitDouble)pers.getProp(keyHigh);
        Double para = (Double)pers.getProp(keyPara);
        Double para2 = (Double)pers.getProp(keyPara2);
        switch (dist) {
            case -1: {
                break;
            }
            case 0: {
                if (!this.changed(diffs, keyDist, keyMean)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyMean, mean);
                break;
            }
            case 1: {
                if (!this.changed(diffs, keyDist, keyLow, keyHigh)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyLow, low);
                rec.setValue(keyHigh, high);
                break;
            }
            case 2: {
                if (!this.changed(diffs, keyDist, keyMean, keyPara, keyLow, keyHigh)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyMean, mean);
                rec.setValue(keyPara, para);
                rec.setValue(keyLow, low);
                rec.setValue(keyHigh, high);
                break;
            }
            case 3: {
                if (!this.changed(diffs, keyDist, keyPara, keyPara2)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyPara, para);
                rec.setValue(keyPara2, para2);
                break;
            }
            case 4: {
                if (!this.changed(diffs, keyDist, keyMean, keyPara)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyMean, mean);
                rec.setValue(keyPara, para);
                break;
            }
            case 5: {
                if (!this.changed(diffs, keyDist, keyMean, keyPara, keyHigh)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyMean, mean);
                rec.setValue(keyPara, para);
                rec.setValue(keyHigh, high);
                break;
            }
            case 6: {
                if (!this.changed(diffs, keyDist, keyPara, keyPara2)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyPara, para);
                rec.setValue(keyPara2, para2);
                break;
            }
            case 7: {
                if (!this.changed(diffs, keyDist, keyMean, keyLow, keyHigh)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyMean, mean);
                rec.setValue(keyLow, low);
                rec.setValue(keyHigh, high);
                break;
            }
            case 8: {
                if (!this.changed(diffs, keyDist, keyPara, keyPara2)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyPara, para);
                rec.setValue(keyPara2, para2);
                break;
            }
            case 9: {
                if (!this.changed(diffs, keyDist, keyPara, keyPara2)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyPara, para);
                rec.setValue(keyPara2, para2);
                break;
            }
            case 10: {
                if (!this.changed(diffs, keyDist, keyPara)) break;
                rec.setValue(keyDist, dist);
                rec.setValue(keyPara, para);
            }
        }
    }

    private boolean changed(Collection<String> diffs, String ... props) {
        for (String s : props) {
            if (!diffs.contains(s)) continue;
            return true;
        }
        return false;
    }
}

