/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Evac;
import pyrosim.domain.evac.Evho;
import pyrosim.domain.evac.Pers;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class EvhoRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Evho.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Evac evacId;
        Pers persId;
        Evho obj = (Evho)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("EVHO");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getProp("FYI"), false);
        UnitDouble[] xb = (UnitDouble[])obj.getProp("XB");
        UnitAABox xbBox = new UnitAABox(new UnitPoint3D(xb[0], xb[2], xb[4]), new UnitPoint3D(xb[1], xb[3], xb[5]));
        EvhoRenderer.renderXB(rec, "XB", xbBox.getMin(), xbBox.getMax());
        Grid meshId = (Grid)obj.getProp("MESH_ID");
        if (meshId != null) {
            rec.setValue("MESH_ID", meshId.getName());
        }
        if ((persId = (Pers)obj.getProp("PERS_ID")) != null) {
            rec.setValue("PERS_ID", persId.getName());
        }
        if ((evacId = (Evac)obj.getProp("EVAC_ID")) != null) {
            rec.setValue("EVAC_ID", evacId.getName());
        }
        props.render(rec, o);
        return true;
    }
}

