/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.common;

import java.util.HashMap;
import java.util.Map;
import pyrosim.io.fds.v6.common.QuantityLookup;

public class StatisticMap {
    private static final QuantityLookup<Long> s_spacialStats = new QuantityLookup();
    private static final QuantityLookup<Long> s_temporalStats = new QuantityLookup();
    private static final Map<String, String> s_temporalToLineMap = new HashMap<String, String>();
    private static final Map<String, String> s_lineToTemporalMap = new HashMap<String, String>();
    private static final Map<String, String> s_areaToVolumeMap = new HashMap<String, String>();
    private static final Map<String, String> s_volumeToAreaMap = new HashMap<String, String>();
    private static final Map<String, Long> s_legacyStatMap = new HashMap<String, Long>();

    public static String getFDSVal_spatial(long pyroVal) {
        return s_spacialStats.getFDSValp(pyroVal);
    }

    public static Long getPyroVal_spatial(String quantity) {
        return s_spacialStats.getPyroValp(quantity);
    }

    public static String getFDSVal_temporal(long pyroVal) {
        return s_temporalStats.getFDSValp(pyroVal);
    }

    public static Long getPyroVal_temporal(String quantity) {
        return s_temporalStats.getPyroValp(quantity);
    }

    public static Long getPyroVal_legacy(String quantity) {
        return s_legacyStatMap.get(quantity);
    }

    public static String getLineValForFDSTemporal(String fdsVal) {
        return s_temporalToLineMap.get(fdsVal);
    }

    public static String getFDSTemporalForLineVal(String lineVal) {
        return s_lineToTemporalMap.get(lineVal);
    }

    public static String getVolumeForArea(String fdsVal) {
        return s_areaToVolumeMap.get(fdsVal);
    }

    public static String getAreaForVolume(String vol) {
        return s_volumeToAreaMap.get(vol);
    }

    static {
        s_spacialStats.add(65536L, "MIN", new String[0]);
        s_spacialStats.add(131072L, "MAX", new String[0]);
        s_spacialStats.add(262144L, "MEAN", new String[0]);
        s_spacialStats.add(524288L, "VOLUME MEAN", new String[0]);
        s_spacialStats.add(0x100000L, "MASS MEAN", new String[0]);
        s_spacialStats.add(0x200000L, "VOLUME INTEGRAL", new String[0]);
        s_spacialStats.add(0x4000000L, "MASS INTEGRAL", new String[0]);
        s_spacialStats.add(0x400000L, "AREA INTEGRAL", new String[0]);
        s_spacialStats.add(0x800000L, "SURFACE INTEGRAL", new String[0]);
        s_spacialStats.add(0x1000000000L, "MINLOC X", new String[0]);
        s_spacialStats.add(0x8000000000L, "MAXLOC X", new String[0]);
        s_spacialStats.add(0x2000000000L, "MINLOC Y", new String[0]);
        s_spacialStats.add(0x10000000000L, "MAXLOC Y", new String[0]);
        s_spacialStats.add(0x4000000000L, "MINLOC Z", new String[0]);
        s_spacialStats.add(0x20000000000L, "MAXLOC Z", new String[0]);
        s_spacialStats.add(0x4000000000000L, "SURFACE INTEGRAL", new String[0]);
        s_spacialStats.add(0x10000000000000L, "CENTROID X", new String[0]);
        s_spacialStats.add(0x20000000000000L, "CENTROID Y", new String[0]);
        s_spacialStats.add(0x40000000000000L, "CENTROID Z", new String[0]);
        s_temporalStats.add(0x80000000L, "TIME AVERAGE", new String[0]);
        s_temporalStats.add(0x100000000L, "RUNNING AVERAGE", new String[0]);
        s_temporalStats.add(0x200000000L, "INSTANT VALUE", new String[0]);
        s_temporalStats.add(0x1000000L, "TIME INTEGRAL", new String[0]);
        s_temporalStats.add(0x400000000L, "MIN", new String[0]);
        s_temporalStats.add(0x800000000L, "MAX", new String[0]);
        s_temporalStats.add(0x8000000L, "RMS", new String[0]);
        s_temporalStats.add(0x10000000L, "COV", new String[0]);
        s_temporalStats.add(0x20000000L, "CORRCOEF", new String[0]);
        s_temporalStats.add(0x80000000000000L, "FAVRE AVERAGE", new String[0]);
        s_temporalStats.add(0x100000000000000L, "FAVRE RMS", new String[0]);
        s_temporalStats.add(0x40000000000L, "LINE TIME AVERAGE", new String[0]);
        s_temporalStats.add(0x80000000000L, "LINE RUNNING AVERAGE", new String[0]);
        s_temporalStats.add(0x100000000000L, "LINE INSTANT VALUE", new String[0]);
        s_temporalStats.add(0x200000000000L, "LINE TIME INTEGRAL", new String[0]);
        s_temporalStats.add(0x400000000000L, "LINE MIN", new String[0]);
        s_temporalStats.add(0x800000000000L, "LINE MAX", new String[0]);
        s_temporalStats.add(0x40000000L, "LINE RMS", new String[0]);
        s_temporalStats.add(0x2000000000000L, "LINE COV", new String[0]);
        s_temporalStats.add(0x1000000000000L, "LINE CORRCOEF", new String[0]);
        s_temporalStats.add(0x200000000000000L, "LINE FAVRE AVERAGE", new String[0]);
        s_temporalStats.add(0x400000000000000L, "LINE FAVRE RMS", new String[0]);
        s_temporalToLineMap.put("TIME AVERAGE", "LINE TIME AVERAGE");
        s_temporalToLineMap.put("RUNNING AVERAGE", "LINE RUNNING AVERAGE");
        s_temporalToLineMap.put("INSTANT VALUE", "LINE INSTANT VALUE");
        s_temporalToLineMap.put("TIME INTEGRAL", "LINE TIME INTEGRAL");
        s_temporalToLineMap.put("MIN", "LINE MIN");
        s_temporalToLineMap.put("MAX", "LINE MAX");
        s_temporalToLineMap.put("RMS", "LINE RMS");
        s_temporalToLineMap.put("COV", "LINE COV");
        s_temporalToLineMap.put("CORRCOEF", "LINE CORRCOEF");
        s_temporalToLineMap.put("FAVRE AVERAGE", "LINE FAVRE AVERAGE");
        s_temporalToLineMap.put("FAVRE RMS", "LINE FAVRE RMS");
        s_lineToTemporalMap.put("LINE TIME AVERAGE", "TIME AVERAGE");
        s_lineToTemporalMap.put("LINE RUNNING AVERAGE", "RUNNING AVERAGE");
        s_lineToTemporalMap.put("LINE INSTANT VALUE", "INSTANT VALUE");
        s_lineToTemporalMap.put("LINE TIME INTEGRAL", "TIME INTEGRAL");
        s_lineToTemporalMap.put("LINE MIN", "MIN");
        s_lineToTemporalMap.put("LINE MAX", "MAX");
        s_lineToTemporalMap.put("LINE RMS", "RMS");
        s_lineToTemporalMap.put("LINE COV", "COV");
        s_lineToTemporalMap.put("LINE CORRCOEF", "CORRCOEF");
        s_lineToTemporalMap.put("LINE FAVRE AVERAGE", "FAVRE AVERAGE");
        s_lineToTemporalMap.put("LINE FAVRE RMS", "FAVRE RMS");
        s_areaToVolumeMap.put("SURFACE INTEGRAL", "SURFACE INTEGRAL");
        s_volumeToAreaMap.put("SURFACE INTEGRAL", "SURFACE INTEGRAL");
        s_legacyStatMap.put("MIN", 65536L);
        s_legacyStatMap.put("MAX", 131072L);
        s_legacyStatMap.put("MEAN", 262144L);
        s_legacyStatMap.put("VOLUME MEAN", 524288L);
        s_legacyStatMap.put("MASS MEAN", 0x100000L);
        s_legacyStatMap.put("VOLUME INTEGRAL", 0x200000L);
        s_legacyStatMap.put("MASS INTEGRAL", 0x4000000L);
        s_legacyStatMap.put("AREA INTEGRAL", 0x400000L);
        s_legacyStatMap.put("SURFACE INTEGRAL", 0x800000L);
        s_legacyStatMap.put("TIME INTEGRAL", 0x1000000L);
        s_legacyStatMap.put("STEADY STATE", 0x2000000L);
        s_legacyStatMap.put("RMS", 0x8000000L);
        s_legacyStatMap.put("LINE RMS", 0x40000000L);
        s_legacyStatMap.put("COV", 0x10000000L);
        s_legacyStatMap.put("CORRCOEF", 0x20000000L);
    }
}

