/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.unitsystem.EnglishUS;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.units.UnitDouble;

public class INIWriter {
    public static final UnitDouble FOV = new UnitDouble(65.0, NonSI.DEGREE_ANGLE);
    private final AABox d_meshBounds;
    public static final int TEMPUNIT_CELCIUS = 0;
    public static final int TEMPUNIT_FARENHEIT = 1;
    public static final int TEMP_KELVIN = 2;
    public static final int VELOUNIT_METER_SECOND = 0;
    public static final int VELOUNIT_MPH = 1;
    public static final int VELOUNIT_FOOT_SECOND = 2;
    public static final int DISTUNIT_METER = 0;
    public static final int DISTUNIT_FOOT = 1;
    public static final int VOLFLOWUNIT_METER3_SECOND = 0;
    public static final int VOLFLOWUNIT_CFM = 1;
    public static final int MASSFRACUNIT_KG_KG = 0;
    public static final int MASSFRACUNIT_G_KG = 1;
    public static final int CONCUNIT_MOL_MOL = 0;
    public static final int CONCUNIT_PPM = 1;

    public INIWriter(AABox meshBounds) {
        this.d_meshBounds = meshBounds;
    }

    public void write(OutputStream out, boolean writeGE1, boolean showGE1, boolean writeViews, Collection<? extends IPyroObject> objs) throws IOException {
        IniWriter writer = new IniWriter(out);
        if (writeGE1) {
            if (showGE1) {
                writer.write("BLOCKLOCATION", 7);
            } else {
                writer.write("BLOCKLOCATION", 5);
            }
        }
        writer.write("SHOWNORMALWHENSMOOTH", 1);
        writer.write("SHOWALLTEXTURES", 1);
        writer.write("APERTURE", 1);
        writer.write("ZOOM", -1, INIWriter.aperatureToZoom(FOV));
        writer.write("LIGHT1", 0);
        writer.write("LIGHTPOS0", 0, 0, 0, 1);
        writer.write("LIGHTMODELLOCALVIEWER", 1);
        writer.write("LIGHTMODELSEPARATESPECULARCOLOR", 1);
        writer.write("ENABLETEXTURELIGHTING", 1);
        writer.write("AMBIENTLIGHT", 0.2, 0.2, 0.2, 1);
        writer.write("DIFFUSELIGHT", 1, 1, 1, 1);
        writer.write("BLOCKSPECULAR", 0, 0, 0);
        writer.write("BLOCKSHININESS", 0);
        this.writeUnitPrefs(writer);
        if (writeViews) {
            this.writeViewpoints(writer, objs);
        }
        writer.flush();
    }

    private static double aperatureToZoom(UnitDouble fov) {
        return INIWriter.aperatureToZoom(fov.get(SI.RADIAN));
    }

    private static double aperatureToZoom(double fovRad) {
        return Math.tan(Math.toRadians(45.0) / 2.0) / Math.tan(fovRad / 2.0);
    }

    public void writeViewpoints(IniWriter writer, Collection<? extends IPyroObject> objs) throws IOException {
        PrintWriter pw = writer.iniWriter;
        ArrayList<View> views = new ArrayList<View>(Hierarchy.flatten(objs, View.class, v -> v.get(View.PROP_CAMERA) != null && ((CameraRecord)v.get(View.PROP_CAMERA).get()).frustum instanceof PerspectiveCamera.FrustumRecord));
        double maxAxisLen = DoubleStream.of(this.d_meshBounds.getWidth(), this.d_meshBounds.getHeight(), this.d_meshBounds.getDepth()).max().getAsDouble();
        double iaxislen = 1.0 / maxAxisLen;
        UnaryOperator toSMVPoint = p -> new Point3d((p.x - this.d_meshBounds.getMinX()) * iaxislen, (p.y - this.d_meshBounds.getMinY()) * iaxislen, (p.z - this.d_meshBounds.getMinZ()) * iaxislen);
        BiConsumer<CameraRecord, Integer> writeCamRec = (cr, eyeView) -> {
            boolean persp = cr.frustum instanceof PerspectiveCamera.FrustumRecord;
            double zoom = persp ? INIWriter.aperatureToZoom(FOV) : 1.0;
            zoom *= cr.zoom;
            boolean forceZeroRoll = eyeView == 0;
            double[] rpy = INIWriter.getAxes(cr, Order.XYZ, forceZeroRoll);
            double az = rpy[2] + 1.5707963267948966;
            if (az > Math.PI) {
                az -= Math.PI * 2;
            }
            double azDeg = Math.toDegrees(az);
            double elev = rpy[1];
            double elevDeg = Math.toDegrees(elev);
            Point3d loc = (Point3d)toSMVPoint.apply(cr.loc);
            Point3d ref = (Point3d)toSMVPoint.apply(cr.ref);
            double directionAngle = 0.0;
            double elevationAngle = 0.0;
            double angleZX0 = 0.0;
            double angleZX1 = 0.0;
            switch (eyeView) {
                case 0: {
                    elevDeg = -elevDeg;
                    Matrix4d xform = INIWriter.getSMVXform(ref, Math.toRadians(azDeg), Math.toRadians(elevDeg));
                    xform.transform(loc);
                    xform.transform(ref);
                    angleZX0 = azDeg;
                    angleZX1 = elevDeg;
                    break;
                }
                case 1: {
                    if (elevDeg < -89.999) {
                        elevDeg = -89.999;
                    } else if (elevDeg > 89.999) {
                        elevDeg = 89.999;
                    }
                    directionAngle = azDeg;
                    elevationAngle = elevDeg;
                }
            }
            pw.printf("%f %f %f %f -1%n", loc.x, loc.y, loc.z, zoom);
            pw.printf("0.0 %f %f %d%n", directionAngle, elevationAngle, persp ? 0 : 1);
            pw.printf("%f %f %f%n", ref.x, ref.y, ref.z);
            pw.printf("%f %f%n", angleZX0, angleZX1);
            pw.printf("1.0 0.0 0.0 0.0%n", new Object[0]);
            pw.printf("0.0 1.0 0.0 0.0%n", new Object[0]);
            pw.printf("0.0 0.0 1.0 0.0%n", new Object[0]);
            pw.printf("0.0 0.0 0.0 1.0%n", new Object[0]);
        };
        Function<SectionBox, AABoxGeom> getSectionGeom = sbox -> {
            if (sbox == null) {
                return null;
            }
            IGeom geom = (IGeom)sbox.get();
            if (geom instanceof AABoxGeom) {
                return (AABoxGeom)geom;
            }
            if (geom.getNumPrims(1) != 6) {
                return null;
            }
            int planes = 0;
            for (IPlanarFace face : GeomUtil.explode(Arrays.asList(geom), IPlanarFace.class)) {
                Vector3d normal = face.getPlane(true).getNormal();
                if (normal.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-6)) {
                    planes |= 1;
                    continue;
                }
                if (normal.epsilonEquals(GeomConstants.VEC3D_XPOS, 1.0E-6)) {
                    planes |= 2;
                    continue;
                }
                if (normal.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-6)) {
                    planes |= 4;
                    continue;
                }
                if (normal.epsilonEquals(GeomConstants.VEC3D_YPOS, 1.0E-6)) {
                    planes |= 8;
                    continue;
                }
                if (normal.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-6)) {
                    planes |= 0x10;
                    continue;
                }
                if (!normal.epsilonEquals(GeomConstants.VEC3D_ZPOS, 1.0E-6)) continue;
                planes |= 0x20;
            }
            if (planes == 63) {
                return new AABoxGeom(geom.getBoundingBox(new AABox()));
            }
            return null;
        };
        Consumer<SectionBox> writeSectionBox = sbox -> {
            AABoxGeom box = (AABoxGeom)getSectionGeom.apply((SectionBox)sbox);
            if (box == null) {
                pw.printf("0 0 0 0 0 0 0%n", new Object[0]);
                pw.printf("0 0 0 0 0 0%n", new Object[0]);
            } else {
                pw.printf("1 1 1 1 1 1 1%n", new Object[0]);
                pw.printf("%f %f %f %f %f %f%n", box.min.x, box.min.y, box.min.z, box.max.x, box.max.y, box.max.z);
            }
        };
        int id = 2;
        for (int m = views.size() - 1; m >= 0; --m) {
            View view = views.get(m);
            CameraState cs = view.get(View.PROP_CAMERA);
            int eyeView2 = 0;
            switch (view.get(View.PROP_NAV_TOOL)) {
                case ROAM: {
                    eyeView2 = 1;
                    break;
                }
                default: {
                    eyeView2 = 0;
                }
            }
            int rotIndex = 4;
            pw.println("VIEWPOINT5");
            pw.printf("%d %d %d%n", eyeView2, rotIndex, id + m);
            CameraRecord cf = (CameraRecord)cs.get();
            writeCamRec.accept(cf, eyeView2);
            writeSectionBox.accept(view.get(View.PROP_SECTION_BOX));
            String name = view.getName();
            pw.println(name);
        }
    }

    private void writeUnitPrefs(IniWriter writer) {
        if (PyroSim.getApp().getUnitSystem() instanceof EnglishUS) {
            writer.write("UNITCLASSES", Units.values().length);
            PrintWriter pw = writer.iniWriter;
            for (Units unit : Units.values()) {
                pw.println(unit.engUnit);
            }
        }
    }

    private static void writeTours(IniWriter writer, Collection<? extends IPyroObject> objs) throws IOException {
    }

    private static Matrix4d getSMVXform(Point3d ref, double az, double elev) {
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        xform.mul(Util.translateMat(ref.x, ref.y, ref.z));
        xform.mul(Util.rotMat(1.0, 0.0, 0.0, elev));
        xform.mul(Util.rotMat(0.0, 0.0, 1.0, az));
        xform.mul(Util.translateMat(-ref.x, -ref.y, -ref.z));
        return xform;
    }

    private static double[] getAxes(CameraRecord cr, Order system, boolean forceZeroRoll) {
        Vector3d forward = Util3D.vectorN(cr.loc, cr.ref);
        Vector3d up = cr.up;
        Vector3d right = Util3D.cross(forward, up);
        Matrix3d xform = new Matrix3d(forward.x, forward.y, forward.z, -right.x, -right.y, -right.z, up.x, up.y, up.z);
        return INIWriter.tr2rpy(xform, system, 1.0E-9, forceZeroRoll);
    }

    private static double[] tr2rpy(Matrix3d m, Order system, double eps, boolean forceZeroRoll) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        if (system == Order.XYZ) {
            if (forceZeroRoll || Math.abs(m.m22) < eps && Math.abs(m.m12) < eps) {
                result[0] = 0.0;
                result[1] = Math.atan2(m.m02, m.m22);
                result[2] = Math.atan2(m.m10, m.m11);
            } else {
                result[0] = Math.atan2(-m.m12, m.m22);
                double sr = Math.sin(result[0]);
                double cr = Math.cos(result[0]);
                result[1] = Math.atan2(m.m02, cr * m.m22 - sr * m.m12);
                result[2] = Math.atan2(-m.m01, m.m00);
            }
        } else if (forceZeroRoll || Math.abs(m.m00) < eps && Math.abs(m.m10) < eps) {
            result[0] = 0.0;
            result[1] = Math.atan2(-m.m20, m.m00);
            result[2] = Math.atan2(-m.m12, m.m11);
        } else {
            result[0] = Math.atan2(m.m10, m.m00);
            double sp = Math.sin(result[0]);
            double cp = Math.cos(result[0]);
            result[1] = Math.atan2(-m.m20, cp * m.m00 + sp * m.m10);
            result[2] = Math.atan2(sp * m.m02 - cp * m.m12, cp * m.m11 - sp * m.m01);
        }
        return result;
    }

    private static class IniWriter {
        final PrintWriter iniWriter;

        public IniWriter(OutputStream out) throws IOException {
            this.iniWriter = new PrintWriter(new OutputStreamWriter(out));
        }

        public void write(String s, Object ... varr) {
            this.iniWriter.println(s);
            for (int m = 0; m < varr.length; ++m) {
                if (m != 0) {
                    this.iniWriter.print(' ');
                }
                this.iniWriter.print(varr[m].toString());
            }
            this.iniWriter.println();
        }

        public void flush() {
            this.iniWriter.flush();
        }
    }

    public static enum Units {
        TEMPERATURE(0, 1),
        VELOCITY(0, 2),
        DISTANCE(0, 1),
        VOLUME_FLOW(0, 1),
        MASS_FRACTION(0, 0),
        CONCENTRATION(0, 0);

        public final int siUnit;
        public final int engUnit;

        private Units(int siUnit, int engUnit) {
            this.siUnit = siUnit;
            this.engUnit = engUnit;
        }
    }

    private static enum Order {
        XYZ,
        ZYX;

    }
}

