/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.SyntaxMap;
import thunderheadeng.util.theUtil;

public abstract class FDSRecord
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private String d_comment;
    private final FDSRecordSpec d_spec;
    private Map<String, Object> d_properties;
    private List<UnknownProp> d_unknownProps;
    private Runnable d_additionalRecord;

    public FDSRecord(FDSRecordSpec spec, boolean init) {
        this.d_spec = spec;
        this.d_properties = new LinkedHashMap<String, Object>();
        this.d_additionalRecord = null;
        if (init) {
            this.init();
        }
    }

    public void init() {
        for (FDSRecordSpec.Field field : this.d_spec.fields.values()) {
            this.setValue(field.name, field.initialValue);
        }
    }

    public FDSRecordSpec getSpec() {
        return this.d_spec;
    }

    public String getType() {
        return this.d_spec.rectype;
    }

    public Runnable getAdditionalRec() {
        return this.d_additionalRecord;
    }

    public void setAdditionalRecord(Runnable obj) {
        this.d_additionalRecord = obj;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.d_properties);
    }

    public boolean empty() {
        return this.d_properties.isEmpty() && (this.d_unknownProps == null || this.d_unknownProps.isEmpty());
    }

    public boolean contains(String field) {
        return this.d_properties.containsKey(field);
    }

    public <T> T get(String key) {
        return this.get(key, false);
    }

    public <T> Optional<T> getOptional(String key) {
        return Optional.ofNullable(this.get(key, false));
    }

    public String getString(String key) {
        return (String)this.d_properties.get(key);
    }

    public <T> T get(String key, boolean getDefaultIfNull) {
        Object val = this.d_properties.get(key);
        if (val == null && getDefaultIfNull) {
            val = this.getSpec().fields.get((Object)key).initialValue;
        }
        return (T)val;
    }

    public void setValue(String name, Object value) {
        this.setValue(name, value, true);
    }

    public void setValue(String key, Object value, boolean overrideIfDefault) {
        if (value == null) {
            this.d_properties.remove(key);
            return;
        }
        assert (this.getSpec().fields.get(key) != null);
        assert (this.getSpec().fields.get((Object)key).clazz.isAssignableFrom(value.getClass()));
        if (!overrideIfDefault) {
            Object defValue = this.getSpec().fields.get((Object)key).initialValue;
            if (!value.equals(defValue)) {
                this.d_properties.put(key, value);
            }
        } else {
            this.d_properties.put(key, value);
        }
    }

    public String getComment() {
        return this.d_comment;
    }

    public void setComment(String comment) {
        this.d_comment = comment;
    }

    public void addUnknownProp(String key, List<String> vals) {
        if (this.d_unknownProps == null) {
            this.d_unknownProps = new ArrayList<UnknownProp>(1);
        }
        this.d_unknownProps.add(new UnknownProp(key, vals));
    }

    public Object clone() {
        try {
            FDSRecord rec = (FDSRecord)super.clone();
            rec.d_properties = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.d_properties.entrySet()) {
                rec.d_properties.put(entry.getKey(), entry.getValue());
            }
            if (this.d_unknownProps != null) {
                rec.d_unknownProps = new ArrayList<UnknownProp>(this.d_unknownProps);
            }
            return rec;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public List<UnknownProp> getUnknownProps() {
        return this.d_unknownProps == null ? Collections.EMPTY_LIST : this.d_unknownProps;
    }

    public DiffResult diff(FDSRecord rec) {
        HashSet<String> missing = Collections.EMPTY_SET;
        HashSet<String> additional = Collections.EMPTY_SET;
        HashSet<String> different = Collections.EMPTY_SET;
        for (Map.Entry<String, Object> entry : this.d_properties.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (rec.d_properties.containsKey(key)) {
                Object val2 = rec.d_properties.get(key);
                if (theUtil.equal(val, val2)) continue;
                if (different == Collections.EMPTY_SET) {
                    different = new HashSet<String>();
                }
                different.add(key);
                continue;
            }
            if (missing == Collections.EMPTY_SET) {
                missing = new HashSet<String>();
            }
            missing.add(key);
        }
        for (String key2 : rec.d_properties.keySet()) {
            if (this.d_properties.containsKey(key2)) continue;
            if (additional == Collections.EMPTY_SET) {
                additional = new HashSet<String>();
            }
            additional.add(key2);
        }
        return new DiffResult((Set<String>)missing, (Set<String>)additional, (Set<String>)different);
    }

    public static class UnknownProp
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final String key;
        public final List<String> values;

        public UnknownProp(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }

        public String render(SyntaxMap sMap) {
            sMap.putSmart(this.key.length(), "SYMBOL_KEYWORD");
            sMap.putSmart(1, "SYMBOL_SPECIAL");
            String str = this.key + "=";
            for (int m = 0; m < this.values.size(); ++m) {
                if (m > 0) {
                    sMap.putSmart(1, "SYMBOL_SPECIAL");
                    str = str + ",";
                }
                sMap.putSmart(this.values.get(m).length(), "SYMBOL_REFERENCE");
                str = str + this.values.get(m);
            }
            return str;
        }

        public String renderVal() {
            Object str = "";
            for (int m = 0; m < this.values.size(); ++m) {
                if (m > 0) {
                    str = (String)str + ",";
                }
                str = (String)str + this.values.get(m);
            }
            return str;
        }
    }

    public static class DiffResult {
        public final Set<String> missing;
        public final Set<String> additional;
        public final Set<String> different;

        public DiffResult(Set<String> missing, Set<String> additional, Set<String> different) {
            this.missing = missing;
            this.additional = additional;
            this.different = different;
        }
    }
}

