/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.ArrayList;
import java.util.List;
import org.jscience.physics.units.Unit;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordDebugInfo;
import pyrosim.io.fds.FDSRecordSpec;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Lists;

public class FDSParseRecord
extends FDSRecord {
    static final long serialVersionUID = 1L;
    private FDSRecordDebugInfo d_debugInfo = null;

    public FDSParseRecord(FDSRecordSpec spec, boolean init) {
        super(spec, init);
    }

    public FDSRecordDebugInfo getDebugInfo() {
        return this.d_debugInfo;
    }

    public void setDebugInfo(FDSRecordDebugInfo di) {
        this.d_debugInfo = di;
    }

    public <T> FDSArray<T> getArray(String key, boolean getDef) {
        FDSRecordSpec.ArrayFld field = (FDSRecordSpec.ArrayFld)this.getSpec().fields.get(key);
        Object fillElement = getDef ? field.elementChecker.initialValue : null;
        FDSArray setvals = (FDSArray)this.get(key, getDef);
        FDSArray<Object> vals = new FDSArray<Object>(fillElement, field.dimensions);
        if (setvals != null) {
            this.setArray(vals, setvals, 0, new int[field.dimensions.length]);
        }
        return vals;
    }

    private <T> void setArray(FDSArray<T> sinkArr, FDSArray<T> srcArr, int dimIx, int[] ixes) {
        int numElements = sinkArr.getDimensions()[dimIx];
        if (dimIx == ixes.length - 1) {
            for (int m = 0; m < numElements; ++m) {
                ixes[dimIx] = m;
                T element = srcArr.get(ixes);
                if (element == null) continue;
                sinkArr.set(element, ixes);
            }
        } else {
            int m = 0;
            while (m < numElements) {
                ixes[dimIx] = m++;
                this.setArray(sinkArr, srcArr, dimIx + 1, ixes);
            }
        }
    }

    public <T> List<T> getList(String key, boolean getDef) {
        return this.getList(key, 0, getDef);
    }

    public <T> List<T> getList(String key, int minSize, boolean getDef) {
        List<Object> vals;
        FDSRecordSpec.ListFld dataField = (FDSRecordSpec.ListFld)this.getSpec().fields.get(key);
        if (dataField.isRenderedAsArray()) {
            List setValsList = (List)this.get(key, getDef);
            FDSArray setVals = new FDSArray(setValsList);
            FDSArray<Object> vals2 = new FDSArray<Object>(dataField.elementChecker.initialValue, setVals.getDimensions());
            this.setArray(vals2, setVals, 0, dataField.getDimensions());
        }
        Object fillElement = getDef ? ((FDSRecordSpec.ListFld)this.getSpec().fields.get((Object)key)).elementChecker.initialValue : null;
        List setvals = (List)this.get(key, getDef);
        if (setvals == null) {
            vals = minSize == 0 ? null : Lists.filled(minSize, fillElement);
        } else {
            int size = Math.max(minSize, setvals.size());
            vals = Lists.filled(size, fillElement);
            for (int m = 0; m < setvals.size(); ++m) {
                Object setVal = setvals.get(m);
                if (setVal == null) continue;
                vals.set(m, setVal);
            }
        }
        return vals;
    }

    public String getString(String key, boolean getDefaultIfNull) {
        return (String)this.get(key, getDefaultIfNull);
    }

    @Override
    public String getString(String key) {
        return (String)this.get(key);
    }

    public Boolean getBoolean(String key, boolean getDef) {
        return (Boolean)this.get(key, getDef);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Double getDouble(String key, boolean getDef) {
        return (Double)this.get(key, getDef);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public UnitDouble getUnitDouble(String key, boolean getDef) {
        return (UnitDouble)this.get(key, getDef);
    }

    public UnitDouble getUnitDouble(String key) {
        return (UnitDouble)this.get(key);
    }

    public UnitDouble getUnitDouble(String key, Unit unit, boolean getDef) {
        Double dval = (Double)this.get(key, getDef);
        if (dval == null) {
            return null;
        }
        return new UnitDouble(dval, unit);
    }

    public UnitDouble getUnitDouble(String key, Unit unit) {
        Double dval = (Double)this.get(key);
        if (dval == null) {
            return null;
        }
        return new UnitDouble(dval, unit);
    }

    public List<UnitDouble> getUnitDoubleList(String key, Unit unit, boolean getDef) {
        return this.getUnitDoubleList(key, unit, getDef, 0);
    }

    public List<UnitDouble> getUnitDoubleList(String key, Unit unit, boolean getDef, int minSize) {
        List dvals = this.getList(key, minSize, getDef);
        if (dvals == null) {
            return null;
        }
        ArrayList<UnitDouble> vals = new ArrayList<UnitDouble>(dvals.size());
        for (Double dval : dvals) {
            vals.add(dval == null ? null : new UnitDouble(dval, unit));
        }
        return vals;
    }

    public Integer getInteger(String key, boolean getDef) {
        return (Integer)this.get(key, getDef);
    }

    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }
}

