/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.awt.Color;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jscience.physics.units.SI;
import pyroloader.IPyroSurface;
import pyroloader.PyroTexture;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.io.extloader.DataStore;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;

public class SurfWrapper
implements IPyroSurface {
    private final DataStore d_store;
    private final Surface d_surf;
    private final Map<Texture, PyroTexture> d_texMap;

    public SurfWrapper(DataStore store, Surface surf) {
        this.d_store = store;
        this.d_surf = surf;
        this.d_texMap = new IdentityHashMap<Texture, PyroTexture>();
    }

    public String getName() {
        return this.d_surf.getName();
    }

    public Color getColor() {
        Material ti = this.d_surf.getAppearance();
        if (ti == null) {
            return this.d_surf.getColor();
        }
        Color c = ti.getAttributes().getColor(MatChannel.DIFFUSE);
        if (c != null) {
            return ti.getAttributes().getDiffuseColorWithOpacity();
        }
        return this.d_surf.getColor();
    }

    public double[] getDimensions() {
        Material ti = this.d_surf.getAppearance();
        if (ti == null || !ti.getAttributes().hasTexture()) {
            return new double[]{1.0, 1.0};
        }
        return new double[]{ti.getWidth().getValue(SI.METER), ti.getHeight().getValue(SI.METER)};
    }

    public synchronized PyroTexture getDiffuseTexture() {
        return (PyroTexture)this.getAttribute(new IPyroSurface.Prop(IMatAttrs.DIFFUSE_TEXTURE.strKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttribute(IPyroSurface.Prop<T> prop) {
        IMatAttrs.MatProp<?> nprop = this.d_store.getMatProp(prop.key);
        Object nresult = this.d_surf.getAttributes().get(nprop);
        if (nresult instanceof Texture) {
            Map<Texture, PyroTexture> map = this.d_texMap;
            synchronized (map) {
                Texture tex = (Texture)nresult;
                return (T)this.d_texMap.computeIfAbsent(tex, this::getUncachedTexture);
            }
        }
        if (nresult instanceof Enum) {
            return (T)nresult.toString();
        }
        return (T)nresult;
    }

    private PyroTexture getUncachedTexture(Texture tex) {
        if (tex == null) {
            return null;
        }
        return this.d_store.getTexture(tex);
    }
}

