/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.geom.Geometry;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.GridComboBox;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.Point3DPanel;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.IntVR;

public class StatisticsPanel
extends guiPanel
implements IEditor<IMeasurementStat>,
ItemListener {
    private static final long serialVersionUID = 5078624111651396306L;
    private final GridList d_gridManager;
    private final guiTextField d_msrField;
    private final guiRadioButton d_volumeStatsRB;
    private final guiRadioButton d_areaStatsRB;
    private final guiRadioButton d_pointStatsRB;
    private final guiRadioButton d_devcArrayRB;
    private final LinkedHashMap<UIStatistic, StatBtn> d_stats;
    private final guiRadioButton d_boxRB;
    private final guiRadioButton d_gridRB;
    private final guiRadioButton d_arrayRB;
    private final GridComboBox d_gridCombo;
    private final AABoxGeomEditor d_boxPanel;
    private final AARectangleEditor d_rectPanel;
    private final Point3DPanel d_pointPanel;
    private final LinearArrayGeomEditor d_temporalLineSegPanel;
    private final LinearVolumeArrayGeomEditor d_spatialLineSegPanel;
    private final CardLayout d_spatialGeomLayout;
    private final CardLayout d_temporalGeomLayout;
    private final guiPanel d_spatialGeomPnl;
    private final guiPanel d_temporalGeomPnl;
    private final guiPanel d_temporalPnl;
    private final guiPanel d_spatialPnl;
    private final JTabbedPane d_tabs;
    private final guiComboBox<String> d_statTypeCB;
    private static final String TEMPORAL_COMBO_STR = Intl.intl("Temporal");
    private static final String SPATIAL_COMBO_STR = Intl.intl("Spatial");
    private static final String TEMPORAL_TAB_STR = Intl.intl("Temporal Properties");
    private static final String SPATIAL_TAB_STR = Intl.intl("Spatial Properties");
    private static final String ADVANCED_TAB_STR = Intl.intl("Advanced");
    private final CustomFDSPanel d_customProps;
    private LinkedHashMap<IQuantity, ArrayList<Long>> d_quantities;
    private IQuantity d_currMsr;
    private static final String CARD_VOL = "CV";
    private static final String CARD_AREA = "CA";
    private static final String CARD_POINT = "CP";
    private static final String CARD_LINE = "CL";
    private static final int STAT_TYPE_POINT = 0;
    private static final int STAT_TYPE_AREA = 1;
    private static final int STAT_TYPE_VOLUME = 2;
    private static final int STAT_TYPE_LINE = 3;
    private static final int STAT_TYPE_NONE = 4;
    private static final Map<Long, UIStatistic> UIStatTable = new HashMap<Long, UIStatistic>();

    public StatisticsPanel(PyroMod model) {
        this.d_gridManager = model.getGridManager();
        this.d_quantities = new LinkedHashMap();
        this.d_currMsr = null;
        this.d_temporalGeomLayout = new CardLayout(0, 0);
        this.d_spatialGeomLayout = new CardLayout(0, 0);
        this.d_temporalGeomPnl = new guiPanel(this.d_temporalGeomLayout);
        this.d_spatialGeomPnl = new guiPanel(this.d_spatialGeomLayout);
        this.d_statTypeCB = new guiComboBox<String>((T[])new String[]{SPATIAL_COMBO_STR, TEMPORAL_COMBO_STR});
        this.d_statTypeCB.addActionListener(e -> this.updateTabs());
        this.d_volumeStatsRB = new guiRadioButton(Intl.intl("Volume Statistics"));
        this.d_areaStatsRB = new guiRadioButton(Intl.intl("Area Statistics"));
        this.d_pointStatsRB = new guiRadioButton(Intl.intl("Point Statistics"));
        this.d_devcArrayRB = new guiRadioButton(Intl.intl("Line Statistics"));
        guiUtil.group(new AbstractButton[]{this.d_volumeStatsRB, this.d_areaStatsRB});
        guiUtil.group(new AbstractButton[]{this.d_pointStatsRB, this.d_devcArrayRB});
        this.d_volumeStatsRB.setSelected(true);
        this.d_volumeStatsRB.addItemListener(this);
        this.d_areaStatsRB.addItemListener(this);
        this.d_pointStatsRB.addItemListener(this);
        this.d_devcArrayRB.addItemListener(this);
        this.d_msrField = new guiTextField();
        this.d_msrField.setEnabled(false);
        this.d_msrField.setColumns(30);
        this.d_gridRB = new guiRadioButton(Intl.intl("Record in an entire mesh:"));
        this.d_boxRB = new guiRadioButton(Intl.intl("Record in a volume:"));
        this.d_arrayRB = new guiRadioButton(Intl.intl("Record in an array:"));
        this.d_spatialLineSegPanel = new LinearVolumeArrayGeomEditor();
        this.d_gridCombo = new GridComboBox(model.getGridManager());
        this.d_boxPanel = new AABoxGeomEditor(false, true, true);
        this.d_rectPanel = new AARectangleEditor(false);
        this.d_pointPanel = new Point3DPanel(Intl.intl("Recording Location"), false, 0, true, true);
        this.d_temporalLineSegPanel = new LinearArrayGeomEditor();
        new guiButtonGroup(this.d_gridRB, this.d_boxRB, this.d_arrayRB);
        LinkStatus.link((AbstractButton)this.d_gridRB, this.d_gridCombo);
        LinkStatus.link((AbstractButton)this.d_boxRB, this.d_boxPanel);
        LinkStatus.link((AbstractButton)this.d_arrayRB, this.d_spatialLineSegPanel);
        this.d_stats = new LinkedHashMap();
        Stream.of(UIStatistic.values()).filter(uiStat -> uiStat.getStatType() != 4L).forEach(uiStat -> this.addStatBtn(new guiCheckBox(uiStat.getDisplayName()), (UIStatistic)((Object)uiStat)));
        this.d_spatialPnl = this.buildSpatialPropsPanel();
        this.d_temporalPnl = this.buildTemporalPropsPanel();
        this.d_customProps = new CustomFDSPanel(6);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(SPATIAL_TAB_STR, this.d_spatialPnl);
        this.d_tabs.addTab(TEMPORAL_TAB_STR, this.d_temporalPnl);
        this.d_tabs.addTab(ADVANCED_TAB_STR, this.d_customProps);
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_spatialPnl, this.d_temporalPnl, this.d_customProps));
        this.setLayout(new MigLayout("insets 0"));
        this.add((Component)new guiLabel(Intl.intl("Quantity:")), "");
        this.add((Component)this.d_msrField, "span, wrap");
        this.add((Component)new guiLabel(Intl.intl("Statistic Type:")), "");
        this.add(this.d_statTypeCB, "span, wrap");
        this.add((Component)this.d_tabs, "span 2");
        this.d_statTypeCB.setSelectedItem(SPATIAL_COMBO_STR);
        this.init(null);
    }

    private void updateTabs() {
        this.d_tabs.removeAll();
        String selection = this.d_statTypeCB.getSelectedItem();
        if (selection.equals(SPATIAL_COMBO_STR)) {
            this.d_tabs.addTab(SPATIAL_TAB_STR, this.d_spatialPnl);
        } else if (selection.equals(TEMPORAL_COMBO_STR)) {
            this.d_tabs.addTab(TEMPORAL_TAB_STR, this.d_temporalPnl);
        }
        this.updateEnabledStats();
        this.d_tabs.addTab(ADVANCED_TAB_STR, this.d_customProps);
    }

    private guiPanel buildSpatialPropsPanel() {
        guiPanel spatialPnl = new guiPanel(new MigLayout("wrap 3", "[][]15[]"));
        ArrayList<StatBtn> volBtns = new ArrayList<StatBtn>();
        ArrayList<StatBtn> areaBtns = new ArrayList<StatBtn>();
        for (Map.Entry<UIStatistic, StatBtn> kvPair : this.d_stats.entrySet()) {
            long quantType = kvPair.getKey().getStatType();
            if (quantType == 4L) continue;
            if (quantType == 2L) {
                volBtns.add(kvPair.getValue());
                continue;
            }
            if (quantType != 1L) continue;
            areaBtns.add(kvPair.getValue());
        }
        spatialPnl.add((Component)this.d_volumeStatsRB, "span, wrap");
        StatisticsPanel.subPanelAdder(spatialPnl, volBtns);
        spatialPnl.add((Component)this.d_areaStatsRB, "span, wrap");
        StatisticsPanel.subPanelAdder(spatialPnl, areaBtns);
        guiPanel volPanel = new guiPanel(new MigLayout());
        volPanel.add((Component)this.d_boxRB, "gapbottom 3, wrap");
        volPanel.add((Component)this.d_boxPanel, "gapleft 12, gapbottom 3, wrap, span 3");
        volPanel.add((Component)this.d_gridRB, "gapbottom 3, gapright 6");
        volPanel.add((Component)this.d_gridCombo, "gapbottom 3, wrap");
        volPanel.add((Component)this.d_arrayRB, "gapbottom 3, wrap, span 3");
        volPanel.add((Component)this.d_spatialLineSegPanel, "gapbottom 3, span, wrap");
        guiPanel rectPanel = new guiPanel(new MigLayout());
        rectPanel.add((Component)new TitleSeparator(Intl.intl("Recording Area")), "gaptop 0, gapleft 0, gapbottom 3, gapright 0, wrap");
        rectPanel.add((Component)this.d_rectPanel, "gaptop 0, gapleft 12, gapbottom 0, gapright 0");
        this.d_spatialGeomPnl.add((Component)volPanel, CARD_VOL);
        this.d_spatialGeomLayout.addLayoutComponent(volPanel, CARD_VOL);
        this.d_spatialGeomPnl.add((Component)rectPanel, CARD_AREA);
        this.d_boxRB.setSelected(true);
        spatialPnl.add((Component)new guiLabel(Intl.intl("Options")), "gapbottom 0");
        spatialPnl.add((Component)new JSeparator(), "gapbottom 0, span, growx, wrap");
        spatialPnl.add((Component)this.d_spatialGeomPnl, "gaptop 0, gapleft 12, span, wrap");
        return spatialPnl;
    }

    private guiPanel buildTemporalPropsPanel() {
        guiPanel tempPnl = new guiPanel(new MigLayout("wrap 3", "[][]15[]"));
        ArrayList<StatBtn> pointBtns = new ArrayList<StatBtn>();
        ArrayList<StatBtn> lineBtns = new ArrayList<StatBtn>();
        for (Map.Entry<UIStatistic, StatBtn> kvPair : this.d_stats.entrySet()) {
            long quantType = kvPair.getKey().getStatType();
            if (quantType == 4L) continue;
            if (quantType == 0L) {
                pointBtns.add(kvPair.getValue());
                continue;
            }
            if (quantType != 3L) continue;
            lineBtns.add(kvPair.getValue());
        }
        tempPnl.add((Component)this.d_pointStatsRB, "span, wrap");
        StatisticsPanel.subPanelAdder(tempPnl, pointBtns);
        tempPnl.add((Component)this.d_devcArrayRB, "span, wrap");
        StatisticsPanel.subPanelAdder(tempPnl, lineBtns);
        this.d_temporalGeomPnl.add((Component)this.d_pointPanel, CARD_POINT);
        this.d_temporalGeomPnl.add((Component)this.d_temporalLineSegPanel, CARD_LINE);
        this.d_pointStatsRB.setSelected(true);
        tempPnl.add(new guiLabel(Intl.intl("Options")));
        tempPnl.add((Component)new JSeparator(), "span, growx, wrap");
        tempPnl.add((Component)this.d_temporalGeomPnl, "gapleft 18, span, wrap");
        return tempPnl;
    }

    @Override
    public IMeasurementStat preview(IMeasurementStat previewObj) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.save(previewObj);
        return previewObj;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateEnabledStats();
        this.updateGeomParameters();
    }

    private void addStatBtn(JToggleButton btn, UIStatistic stat) {
        StatBtn sb = new StatBtn(btn, stat.getQuantType());
        this.d_stats.put(stat, sb);
    }

    private static void subPanelAdder(guiPanel panel, List<StatBtn> btnColl) {
        for (int i = 0; i < btnColl.size(); ++i) {
            Object layout = "";
            if (i % 2 == 0) {
                layout = "gapleft 18, span 2";
            }
            if (i + 1 == btnColl.size()) {
                layout = (String)layout + ", wrap";
            }
            panel.add((Component)btnColl.get((int)i).button, layout);
        }
    }

    private void updateEnabledStats() {
        List enabledStats = this.d_quantities.get(this.d_currMsr);
        if (enabledStats == null) {
            return;
        }
        if (this.isTemporalSelected()) {
            if (this.d_devcArrayRB.isSelected()) {
                this.setSelectedForType(3L, enabledStats);
            } else if (this.d_pointStatsRB.isSelected()) {
                this.setSelectedForType(0L, enabledStats);
            }
        }
        if (this.isSpatialSelected()) {
            if (this.d_areaStatsRB.isSelected()) {
                this.setSelectedForType(1L, enabledStats);
            } else if (this.d_volumeStatsRB.isSelected()) {
                this.setSelectedForType(2L, enabledStats);
            }
        }
    }

    private void setSelectedForType(long type, List<Long> enabledStats) {
        for (Map.Entry<UIStatistic, StatBtn> kvPair : this.d_stats.entrySet()) {
            if (kvPair.getKey().statType == 4) continue;
            if ((long)kvPair.getKey().statType == type) {
                kvPair.getValue().button.setEnabled(enabledStats.contains(kvPair.getKey().getQuantType()));
                continue;
            }
            kvPair.getValue().button.setEnabled(false);
        }
    }

    private void updateGeomParameters() {
        if (this.d_volumeStatsRB.isSelected()) {
            this.d_spatialGeomLayout.show(this.d_spatialGeomPnl, CARD_VOL);
        } else if (this.d_areaStatsRB.isSelected()) {
            this.d_spatialGeomLayout.show(this.d_spatialGeomPnl, CARD_AREA);
        }
        if (this.d_pointStatsRB.isSelected()) {
            this.d_temporalGeomLayout.show(this.d_temporalGeomPnl, CARD_POINT);
        } else if (this.d_devcArrayRB.isSelected()) {
            this.d_temporalGeomLayout.show(this.d_temporalGeomPnl, CARD_LINE);
        }
        this.d_gridRB.setEnabled(!this.d_gridManager.flatten().isEmpty());
        if (!this.d_gridRB.isEnabled()) {
            this.d_gridRB.setToolTipText(Intl.intl("There are no meshes currently in the model."));
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(IMeasurementStat dataObj) {
        IQuantity msr;
        this.setEnabled(dataObj != null);
        this.d_currMsr = msr = dataObj != null ? dataObj.getQuantity() : null;
        boolean addQuantity = !this.d_quantities.containsKey(this.d_currMsr);
        ArrayList<Long> quo = new ArrayList<Long>();
        this.d_msrField.setEnabled(false);
        this.d_msrField.setValue("");
        boolean volEnabled = false;
        boolean areaEnabled = false;
        boolean pointEnabled = false;
        boolean lineEnabled = false;
        for (StatBtn sb : this.d_stats.values()) {
            UIStatistic uiStat;
            boolean visible = this.d_currMsr != null ? QuantityUtil.canOutputAll(this.d_currMsr.get(), sb.outputID) : false;
            sb.button.setEnabled(visible);
            sb.button.setSelected(false);
            if (addQuantity && visible) {
                quo.add(sb.outputID);
            }
            if ((uiStat = UIStatTable.get(sb.outputID)) == null) continue;
            if (uiStat.getStatType() == 2L && !volEnabled) {
                volEnabled = visible;
                continue;
            }
            if (uiStat.getStatType() == 1L && !areaEnabled) {
                areaEnabled = visible;
                continue;
            }
            if (uiStat.getStatType() == 0L && !pointEnabled) {
                pointEnabled = visible;
                continue;
            }
            if (uiStat.getStatType() != 3L || lineEnabled) continue;
            lineEnabled = visible;
        }
        if (addQuantity) {
            this.d_quantities.put(this.d_currMsr, quo);
        }
        if (dataObj != null) {
            this.d_msrField.setValue(dataObj.getQuantity().getDescription());
            this.d_volumeStatsRB.setEnabled(volEnabled);
            this.d_areaStatsRB.setEnabled(areaEnabled);
            this.d_pointStatsRB.setEnabled(pointEnabled);
            this.d_devcArrayRB.setEnabled(lineEnabled);
            if (this.d_volumeStatsRB.isEnabled()) {
                this.d_volumeStatsRB.setSelected(true);
            }
            if (this.d_pointStatsRB.isEnabled()) {
                this.d_pointStatsRB.setSelected(true);
            }
            for (Long statid : dataObj.getStats()) {
                UIStatistic stat = UIStatTable.get(statid);
                if (stat == null) continue;
                StatBtn sb = this.d_stats.get((Object)stat);
                sb.button.setSelected(true);
                if (stat.getStatType() == 3L || stat.getStatType() == 0L) {
                    this.d_statTypeCB.setSelectedItem(TEMPORAL_COMBO_STR);
                    if (stat.getStatType() == 3L) {
                        this.d_devcArrayRB.setSelected(true);
                    } else {
                        this.d_pointStatsRB.setSelected(true);
                    }
                }
                if (stat.getStatType() != 1L && stat.getStatType() != 2L) continue;
                this.d_statTypeCB.setSelectedItem(SPATIAL_COMBO_STR);
                if (stat.getStatType() == 1L) {
                    this.d_areaStatsRB.setSelected(true);
                    continue;
                }
                this.d_volumeStatsRB.setSelected(true);
            }
            this.validateRBSelection();
            this.updateEnabledStats();
            this.updateGeomParameters();
            IGeom geom = dataObj.getGeom().flatten().getLocalGeom();
            if (geom instanceof AARectangle) {
                assert (this.d_rectPanel.isVisible());
                this.d_rectPanel.load((AARectangle)geom);
            } else if (geom instanceof AABoxGeom) {
                assert (this.d_boxPanel.isVisible());
                this.d_boxPanel.load((AABoxGeom)geom);
                this.d_boxRB.setSelected(true);
            } else if (geom instanceof StatGeom.GridGeom) {
                assert (this.d_boxPanel.isVisible());
                this.d_gridCombo.setSelectedItem(((StatGeom.GridGeom)geom).grid);
                this.d_gridRB.setSelected(true);
            } else if (geom instanceof Point) {
                assert (this.d_pointPanel.isVisible());
                Point p = (Point)geom;
                this.d_pointPanel.load(new UnitPoint3D(p.loc, Geometry.LU));
            } else if (geom instanceof StatGeom.LinearPointArrayGeom) {
                assert (this.d_temporalLineSegPanel.isVisible());
                this.d_temporalLineSegPanel.load((StatGeom.LinearPointArrayGeom)geom);
            } else if (geom instanceof StatGeom.LinearVolumeArrayGeom) {
                assert (this.d_spatialLineSegPanel.isVisible());
                this.d_spatialLineSegPanel.load((StatGeom.LinearVolumeArrayGeom)geom);
                this.d_arrayRB.setSelected(true);
            }
            this.d_customProps.load(dataObj);
        }
        this.setModified(false);
    }

    private void validateRBSelection() {
        int selectedSpatial = -1;
        int selectedTemporal = -1;
        if (this.d_volumeStatsRB.isSelected()) {
            selectedSpatial = 2;
        }
        if (this.d_areaStatsRB.isSelected()) {
            selectedSpatial = 1;
        }
        if (this.d_pointStatsRB.isSelected()) {
            selectedTemporal = 0;
        }
        if (this.d_devcArrayRB.isSelected()) {
            selectedTemporal = 3;
        }
        boolean volEnabled = this.d_volumeStatsRB.isEnabled();
        boolean areaEnabled = this.d_areaStatsRB.isEnabled();
        boolean pointEnabled = this.d_pointStatsRB.isEnabled();
        boolean lineEnabled = this.d_devcArrayRB.isEnabled();
        boolean spatialValid = true;
        boolean temporalValid = true;
        switch (selectedSpatial) {
            case 2: {
                if (volEnabled) break;
                spatialValid = false;
                break;
            }
            case 1: {
                if (areaEnabled) break;
                spatialValid = false;
            }
        }
        if (!spatialValid) {
            if (volEnabled) {
                this.d_volumeStatsRB.setSelected(true);
            } else if (areaEnabled) {
                this.d_areaStatsRB.setSelected(true);
            }
        }
        switch (selectedTemporal) {
            case 0: {
                if (pointEnabled) break;
                temporalValid = false;
                break;
            }
            case 3: {
                if (lineEnabled) break;
                temporalValid = false;
            }
        }
        if (!temporalValid) {
            if (pointEnabled) {
                this.d_pointStatsRB.setSelected(true);
            } else if (lineEnabled) {
                this.d_devcArrayRB.setSelected(true);
            }
        }
    }

    @Override
    public IMeasurementStat commit(final IMeasurementStat dataObj) {
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                StatisticsPanel.this.save(dataObj);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Statistic"));
        this.setModified(false);
        return dataObj;
    }

    private boolean isSpatialSelected() {
        return this.d_statTypeCB.getSelectedItem().equals(SPATIAL_COMBO_STR);
    }

    private boolean isTemporalSelected() {
        return this.d_statTypeCB.getSelectedItem().equals(TEMPORAL_COMBO_STR);
    }

    private void save(IMeasurementStat dataObj) {
        int activeStatType = 4;
        if (this.isSpatialSelected()) {
            if (this.d_volumeStatsRB.isSelected()) {
                activeStatType = 2;
            } else if (this.d_areaStatsRB.isSelected()) {
                activeStatType = 1;
            }
        } else if (this.isTemporalSelected()) {
            if (this.d_pointStatsRB.isSelected()) {
                activeStatType = 0;
            } else if (this.d_devcArrayRB.isSelected()) {
                activeStatType = 3;
            }
        }
        ArrayList<Long> stats = new ArrayList<Long>();
        for (Map.Entry<UIStatistic, StatBtn> kvPair : this.d_stats.entrySet()) {
            JToggleButton cb;
            if (kvPair.getKey().statType != activeStatType || !(cb = kvPair.getValue().button).isEnabled() || !cb.isSelected()) continue;
            stats.add(kvPair.getValue().outputID);
        }
        dataObj.setStats(stats);
        IGeom geom = null;
        if (activeStatType == 0) {
            UnitPoint3D pt = this.d_pointPanel.save();
            geom = new Point(pt.getPoint3dValue(Geometry.LU));
        } else if (activeStatType == 1) {
            geom = this.d_rectPanel.saveData();
        } else if (activeStatType == 3) {
            geom = this.d_temporalLineSegPanel.saveData();
        } else if (activeStatType == 2) {
            if (this.d_boxRB.isSelected()) {
                geom = this.d_boxPanel.save();
            } else if (this.d_arrayRB.isSelected()) {
                geom = this.d_spatialLineSegPanel.saveData();
            } else {
                Grid grid = (Grid)this.d_gridCombo.getSelectedItem();
                geom = new StatGeom.GridGeom(grid);
            }
        }
        dataObj.setGeom(GeomNodeUtil.newNode(geom));
        this.d_customProps.save(dataObj);
    }

    static {
        Stream.of(UIStatistic.values()).forEach(stat -> UIStatTable.put(stat.getQuantType(), (UIStatistic)((Object)stat)));
    }

    private static class LinearVolumeArrayGeomEditor
    extends guiPanel {
        private final ValueField<Integer> d_numPoints;
        private final Point3DPanel d_p1;
        private final Point3DPanel d_p2;
        private final Point3DPanel d_delta;

        public LinearVolumeArrayGeomEditor() {
            this.setLayout(new MigLayout());
            this.d_numPoints = ValueFields.intFld(IntVR.between(2, 100, true, true));
            this.d_p1 = new Point3DPanel(Intl.intl("Point 1:"), false, 0, true, false);
            this.d_p2 = new Point3DPanel(Intl.intl("Point 2:"), false, 0, true, false);
            this.add((Component)new guiLabel(Intl.intl("Num Points:")), "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
            this.add(this.d_numPoints, "gaptop 0, gapleft 0, gapbottom 3, gapright 6, span 2, wrap");
            this.d_p1.addToPanel(this, 0, 0);
            this.d_p2.addToPanel(this, 0, 0);
            this.d_delta = new Point3DPanel(Intl.intl("Delta:"), false, 0, true, false);
            this.d_delta.addToPanel(this, 0, 0);
        }

        public StatGeom.LinearVolumeArrayGeom saveData() {
            int numPoints = (Integer)this.d_numPoints.getValue();
            UnitPoint3D up1 = this.d_p1.save();
            UnitPoint3D up2 = this.d_p2.save();
            UnitPoint3D delta = this.d_delta.save();
            return new StatGeom.LinearVolumeArrayGeom(up1.getPoint3dValue(Geometry.LU), up2.getPoint3dValue(Geometry.LU), delta.getPoint3dValue(Geometry.LU), numPoints);
        }

        public void load(StatGeom.LinearVolumeArrayGeom geom) {
            this.d_numPoints.setValue(geom.d_numPoints);
            this.d_p1.load(new UnitPoint3D(geom.p1, Geometry.LU));
            this.d_p2.load(new UnitPoint3D(geom.p2, Geometry.LU));
            this.d_delta.load(new UnitPoint3D(geom.getDelta(), Geometry.LU));
        }
    }

    private static class LinearArrayGeomEditor
    extends guiPanel {
        static final long serialVersionUID = 1L;
        private final ValueField<Integer> d_numPoints;
        private final Point3DPanel d_p1;
        private final Point3DPanel d_p2;

        public LinearArrayGeomEditor() {
            this.setLayout(new MigLayout());
            this.d_numPoints = ValueFields.intFld(IntVR.between(2, 100, true, true));
            this.d_p1 = new Point3DPanel(Intl.intl("Point 1:"), false, 0, true, false);
            this.d_p2 = new Point3DPanel(Intl.intl("Point 2:"), false, 0, true, false);
            this.add((Component)new guiLabel(Intl.intl("Num Points:")), "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
            this.add(this.d_numPoints, "gaptop 0, gapleft 0, gapbottom 3, gapright 6, span 2, wrap");
            this.d_p1.addToPanel(this, 0, 0);
            this.d_p2.addToPanel(this, 0, 0);
        }

        public StatGeom.LinearPointArrayGeom saveData() {
            int numPoints = (Integer)this.d_numPoints.getValue();
            UnitPoint3D up1 = this.d_p1.save();
            UnitPoint3D up2 = this.d_p2.save();
            return new StatGeom.LinearPointArrayGeom(up1.getPoint3dValue(Geometry.LU), up2.getPoint3dValue(Geometry.LU), numPoints);
        }

        public void load(StatGeom.LinearPointArrayGeom geom) {
            this.d_numPoints.setValue(geom.d_numPoints);
            this.d_p1.load(new UnitPoint3D(geom.p1, Geometry.LU));
            this.d_p2.load(new UnitPoint3D(geom.p2, Geometry.LU));
        }
    }

    private static enum UIStatistic {
        MINIMUM(Intl.intl("Minimum"), 65536L, 2),
        MAXIMUM(Intl.intl("Maximum"), 131072L, 2),
        MEAN(Intl.intl("Mean"), 262144L, 2),
        VOLMEAN(Intl.intl("Volume Mean"), 524288L, 2),
        MASSMEAN(Intl.intl("Mass Mean"), 0x100000L, 2),
        VOLINTEGRAL(Intl.intl("Volume Integral"), 0x200000L, 2),
        MASSINTEGRAL(Intl.intl("Mass Integral"), 0x4000000L, 2),
        SURFINTEGRALVOL(Intl.intl("Surface Integral"), 0x4000000000000L, 2),
        CENTROIDX(Intl.intl("Centroid X"), 0x10000000000000L, 2),
        CENTROIDY(Intl.intl("Centroid Y"), 0x20000000000000L, 2),
        CENTROIDZ(Intl.intl("Centroid Z"), 0x40000000000000L, 2),
        AREAINTEGRAL(Intl.intl("Area Integral"), 0x400000L, 1),
        SURFINTEGRAL(Intl.intl("Surface Integral"), 0x800000L, 1),
        TIMEAVERAGE(Intl.intl("Time Average"), 0x80000000L, 0),
        RUNNINGAVG(Intl.intl("Running Average"), 0x100000000L, 0),
        INSTANTVAL(Intl.intl("Instant Value"), 0x200000000L, 0),
        TIMEINTEGRAL(Intl.intl("Time Integral"), 0x1000000L, 0),
        TEMPMIN(Intl.intl("Minimum"), 0x400000000L, 0),
        TEMPMAX(Intl.intl("Maximum"), 0x800000000L, 0),
        RMS(Intl.intl("RMS"), 0x8000000L, 0),
        FAVREAVG(Intl.intl("Favre Average"), 0x80000000000000L, 0),
        FAVRERMS(Intl.intl("Favre RMS"), 0x100000000000000L, 0),
        TIMEAVGLINE(Intl.intl("Time Average"), 0x40000000000L, 3),
        RUNNINGAVGLINE(Intl.intl("Running Average"), 0x80000000000L, 3),
        INSTANTVALLINE(Intl.intl("Instant Value"), 0x100000000000L, 3),
        TIMEINTEGRALLINE(Intl.intl("Time Integral"), 0x200000000000L, 3),
        TEMPMINLINE(Intl.intl("Minimum"), 0x400000000000L, 3),
        TEMPMAXLINE(Intl.intl("Maximum"), 0x800000000000L, 3),
        RMS_ARRAY(Intl.intl("RMS"), 0x40000000L, 3),
        FAVREAVGLINE(Intl.intl("Favre Average"), 0x200000000000000L, 3),
        FAVRERMSLINE(Intl.intl("Favre RMS"), 0x400000000000000L, 3),
        STEADYSTATE(Intl.intl("Steady State Profile"), 0x2000000L, 3);

        private final String displayName;
        private final long quantType;
        private final int statType;

        private UIStatistic(String displayName, long quantType, int statType) {
            this.displayName = displayName;
            this.quantType = quantType;
            this.statType = statType;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public long getQuantType() {
            return this.quantType;
        }

        public long getStatType() {
            return this.statType;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static class StatBtn {
        public final long outputID;
        public final JToggleButton button;

        public StatBtn(JToggleButton tb, long outputID) {
            this.button = tb;
            this.outputID = outputID;
        }
    }
}

