/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.output.QuantitySetDlg;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypedProp;

public class Plot3dDlg
extends QuantitySetDlg {
    private static final long serialVersionUID = -5531515506280662998L;
    private final guiCheckBox d_enable = new guiCheckBox(Intl.intl("Enable Plot 3D Output"));
    private final guiLabel d_intervalLbl = new guiLabel(Intl.intl("Output Interval:"));
    private final ValueField<UnitDouble> d_intervalFd = ValueFields.udFld(UnitSystem.getSource(2), PLOT3d_INTERVAL_RANGE);
    public static final UnitDoubleVR PLOT3d_INTERVAL_RANGE = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), false);

    public Plot3dDlg(JFrame owner, String title, AMeasurementSet mset, int maxQuantities, TypedProp<Integer> prefSizeX, TypedProp<Integer> prefSizeY) {
        super(owner, title, mset, maxQuantities, prefSizeX, prefSizeY, new FDSDefaultAction(Intl.intl("FDS Default")), new PFQuantitiesAction(Intl.intl("Pathfinder Quantities")));
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new GridBagLayout());
        LinkStatus.link((AbstractButton)this.d_enable, this.getQuantitiesTable());
        LinkStatus.link((AbstractButton)this.d_enable, this.getNumberQuansChosen());
        LinkStatus.link((AbstractButton)this.d_enable, this.d_intervalLbl);
        LinkStatus.link((AbstractButton)this.d_enable, this.d_intervalFd);
        LinkStatus.link((AbstractButton)this.d_enable, this.getResetButton());
        int row = 0;
        GridBagUtil.add(mainPanel, this.d_enable, 0, row, 2, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.getResetButton(), 2, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
        GridBagUtil.add(mainPanel, this.getspEnabledQuantities(), 0, row++, 3, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(mainPanel, this.d_intervalLbl, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_intervalFd, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.getNumberQuansChosen(), 2, row++, 1, 1, 0, 12, 6, 12, 0, 1.0, 0.0, 13);
        if (this.containsQauntity(Quantity.VELOCITY.create())) {
            GridBagUtil.add(mainPanel, this.getVelSignLbl(), 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(mainPanel, this.getVelSignCB(), 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        }
        this.d_intervalFd.setPreferredSize(new Dimension(this.getVelSignCB().getPreferredSize().width, this.d_intervalFd.getPreferredSize().height));
        this.loadPlot3dSettings();
        this.d_enable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Plot3dDlg.this.setComponentStatus(e.getStateChange());
            }
        });
    }

    private void setComponentStatus(int e) {
        if (e == 1) {
            this.updateVelSign();
        } else if (e == 2) {
            this.getVelSignLbl().setEnabled(false);
            this.getVelSignCB().setEnabled(false);
        }
    }

    private void loadPlot3dSettings() {
        SimParams.FileOutput fo = this.getFileOutput();
        if (fo.getDtPlot3dFile() != null) {
            this.d_intervalFd.setValue(fo.getDtPlot3dFile());
        } else {
            this.d_intervalFd.setValue(new UnitDouble(10.0, PyroSim.getApp().getUnitSystem().getTimeUnit()));
        }
        boolean sel = fo.getDtPlot3dFile() != null;
        this.d_enable.setSelected(sel);
        if (sel) {
            this.setComponentStatus(1);
        } else {
            this.setComponentStatus(2);
        }
    }

    private void savePlot3dSettings() {
        if (this.d_enable.isSelected()) {
            SimParams.FileOutput fo = this.getFileOutput();
            fo.setDtPlot3dFile((UnitDouble)this.d_intervalFd.getValue());
        } else {
            SimParams.FileOutput fo = this.getFileOutput();
            fo.setDtPlot3dFile(null);
        }
    }

    public Task taskSaveValues() {
        final PyroMod mod = this.getPyroMod();
        CompositeTask<PyroMod> ctask = new CompositeTask<PyroMod>(this.getPyroMod());
        ctask.addTask(super.getSaveTask());
        UnitDouble newVal = this.d_enable.isSelected() ? (UnitDouble)this.d_intervalFd.getValue() : null;
        ctask.addTask(new AReplaceRefTask<UnitDouble>(this, (Object)this.getFileOutput().getDtPlot3dFile(), (Object)newVal){

            @Override
            protected void set(UnitDouble obj) {
                mod.getSimParams().getFileOutput().setDtPlot3dFile(obj);
            }
        });
        return ctask;
    }

    private static Quantity getQuantityForSpecies(Map<ExSpecList.Predefined, Quantity> fedQuantities, ExSpec species) {
        for (Map.Entry<ExSpecList.Predefined, Quantity> entry : fedQuantities.entrySet()) {
            ExSpecList.Predefined pspec = entry.getKey();
            if (!pspec.spec.equals(species)) continue;
            return entry.getValue();
        }
        assert (false);
        return null;
    }

    private void setPFQuantitiesSelection() {
        Quantity q;
        HashMap<ExSpecList.Predefined, Quantity> fedQuantities = new HashMap<ExSpecList.Predefined, Quantity>();
        fedQuantities.put(ExSpecList.Predefined.CARBON_DIOXIDE, Quantity.SPEC_VOLUME_FRACTION);
        fedQuantities.put(ExSpecList.Predefined.CARBON_MONOXIDE, Quantity.SPEC_VOLUME_FRACTION);
        fedQuantities.put(ExSpecList.Predefined.SOOT, Quantity.SPEC_VISIBILITY);
        fedQuantities.put(ExSpecList.Predefined.OXYGEN, Quantity.SPEC_VOLUME_FRACTION);
        ArrayList<ExSpec> foundSpecs = new ArrayList<ExSpec>();
        ArrayList<ExSpec> missingSpecs = new ArrayList<ExSpec>();
        ArrayList<ExSpec> conflictSpecs = new ArrayList<ExSpec>();
        for (Object predef : fedQuantities.keySet()) {
            ExSpec exSpec = this.getPyroMod().getExSpecList().find(((ExSpecList.Predefined)((Object)predef)).spec.getName(), ExSpec.class, true);
            if (exSpec != null && ((ExSpecList.Predefined)((Object)predef)).spec.equals(exSpec)) {
                foundSpecs.add(exSpec);
                continue;
            }
            if (exSpec != null) {
                conflictSpecs.add(((ExSpecList.Predefined)((Object)predef)).spec);
                continue;
            }
            missingSpecs.add(((ExSpecList.Predefined)((Object)predef)).spec);
        }
        if (!conflictSpecs.isEmpty()) {
            ArrayList<String> conflictSpecDescription = new ArrayList<String>();
            for (ExSpec exSpec : conflictSpecs) {
                q = Plot3dDlg.getQuantityForSpecies(fedQuantities, exSpec);
                conflictSpecDescription.add(String.format("[%s] %s", exSpec.getName(), q.name));
            }
            String msg = String.format(Intl.intl("Non-default Pathfinder species must be selected manually:%n%s%n"), String.join((CharSequence)"\n", conflictSpecDescription));
            JOptionPane.showMessageDialog(this, msg);
        }
        HashSet<IQuantity> quantities = new HashSet<IQuantity>();
        for (ExSpec exSpec : foundSpecs) {
            if (exSpec == null) continue;
            q = Plot3dDlg.getQuantityForSpecies(fedQuantities, exSpec);
            quantities.add(q.create(exSpec));
        }
        if (!missingSpecs.isEmpty()) {
            String title;
            LinkedList<String> missingSpeciesNames = new LinkedList<String>();
            for (ExSpec currSpec : missingSpecs) {
                missingSpeciesNames.add(currSpec.getName());
            }
            String string = String.join((CharSequence)"\n", missingSpeciesNames);
            String format = missingSpecs.size() == 1 ? Intl.intl("The following Pathfinder species is missing:%n%s%nDo you want to add this species?") : Intl.intl("The following Pathfinder species are missing:%n%s%nDo you want to add these species?");
            String message = String.format(format, string);
            int sel = JOptionPane.showConfirmDialog(this, message, title = String.format(Intl.intl("Add missing species"), new Object[0]), 1);
            if (sel == 0) {
                ArrayList<ExSpec> newSpecs = new ArrayList<ExSpec>(missingSpecs.size());
                for (ExSpec missing : missingSpecs) {
                    newSpecs.add((ExSpec)missing.clone());
                }
                AddTask task = new AddTask((IPyroObject)this.getPyroMod().getExSpecList(), newSpecs);
                this.getPyroMod().getTaskManager().exec(task, Intl.intl("New Extra Species"));
                this.updateMeasurementTableModel();
                for (ExSpec spec : newSpecs) {
                    Quantity q2 = Plot3dDlg.getQuantityForSpecies(fedQuantities, spec);
                    quantities.add(q2.create(spec));
                }
            } else if (sel == 2) {
                return;
            }
        }
        this.clearSelection();
        this.selectQuantities(quantities);
        this.updateUI();
        this.updateNumQuansSelected();
    }

    private void setFDSDefaultSelection() {
        this.selectQuantities(new Plot3d().getQuantities());
    }

    private static class FDSDefaultAction
    extends guiAction {
        private static final long serialVersionUID = -4066927347979838926L;

        public FDSDefaultAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getValue("QuantityDlg") instanceof Plot3dDlg) {
                Plot3dDlg dlg = (Plot3dDlg)this.getValue("QuantityDlg");
                dlg.clearSelection();
                dlg.setFDSDefaultSelection();
            }
        }
    }

    private static class PFQuantitiesAction
    extends guiAction {
        private static final long serialVersionUID = 8281328019102077230L;

        public PFQuantitiesAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getValue("QuantityDlg") instanceof Plot3dDlg) {
                Plot3dDlg dlg = (Plot3dDlg)this.getValue("QuantityDlg");
                dlg.setPFQuantitiesSelection();
            }
        }
    }
}

