/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.StaticQuantity;

public class MeasurementTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7028159279044149212L;
    private final Map<IQuantity, Integer> d_ixMap;
    private final IQuantity[] d_availMsr;
    private final boolean[] d_enableStatus;
    private final String d_quantHeader;

    public MeasurementTableModel(long outputType) {
        this(outputType, Intl.intl("Quantity"));
    }

    public MeasurementTableModel(long outputType, String quantHeader) {
        this.d_quantHeader = quantHeader;
        ArrayList<StaticQuantity> quantities = new ArrayList<StaticQuantity>();
        QuantityUtil.TypeFilter filter = new QuantityUtil.TypeFilter(outputType, new QuantityType[0]);
        quantities.addAll(QuantityUtil.generateAllObjectQuanties(PyroSim.getApp().getMediator(), filter, true));
        quantities.addAll(QuantityUtil.generateStaticQuantities(filter, true));
        this.d_availMsr = quantities.toArray(new IQuantity[quantities.size()]);
        this.d_ixMap = new HashMap<IQuantity, Integer>();
        int ix = 0;
        for (IQuantity m : this.d_availMsr) {
            this.d_ixMap.put(m, ix++);
        }
        this.d_enableStatus = new boolean[this.d_availMsr.length];
        Arrays.fill(this.d_enableStatus, false);
    }

    protected boolean isMsrSelected(IQuantity msr) {
        int ix = this.d_ixMap.get(msr);
        return this.d_enableStatus[ix];
    }

    public void loadValues(Set<IQuantity> measurements) {
        for (IQuantity m : measurements) {
            int ix = this.d_ixMap.get(m);
            this.d_enableStatus[ix] = true;
        }
    }

    public Collection<IQuantity> saveValues() {
        ArrayList<IQuantity> measurements = new ArrayList<IQuantity>(5);
        for (int m = 0; m < this.getRowCount(); ++m) {
            if (!((Boolean)this.getValueAt(m, 0)).booleanValue()) continue;
            measurements.add(this.d_availMsr[m]);
        }
        return measurements;
    }

    public Map<IQuantity, Integer> getIxMap() {
        return this.d_ixMap;
    }

    public boolean getEnableStatus(int ix) {
        if (ix >= this.d_enableStatus.length) {
            return false;
        }
        return this.d_enableStatus[ix];
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.d_availMsr.length;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Intl.intl("Output");
            }
            case 1: {
                return this.d_quantHeader;
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return c == 0 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.d_enableStatus[row];
            }
            case 1: {
                return this.d_availMsr[row].getDescription();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        boolean newVal;
        boolean oldVal;
        if (col == 0 && value != null && (oldVal = this.d_enableStatus[row]) != (newVal = ((Boolean)value).booleanValue())) {
            this.d_enableStatus[row] = newVal;
            this.fireTableCellUpdated(row, col);
        }
    }
}

