/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JFrame;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.output.HvacDuctOutput;
import pyrosim.domain.output.HvacNodeOutput;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.gui.output.DualQuantitySetDlg;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypedProp;

public class HvacOutputDlg
extends DualQuantitySetDlg {
    private static final long serialVersionUID = -4787108556148621714L;
    private final guiCheckBox d_enable = new guiCheckBox(Intl.intl("Enable HVAC Output"));
    private final guiLabel d_intervalLbl = new guiLabel(Intl.intl("Output Interval:"));
    private final ValueField<UnitDouble> d_intervalFd = ValueFields.udFld(UnitSystem.getSource(2), HVAC_OUTPUT_INTERVAL_RANGE);
    public static final UnitDoubleVR HVAC_OUTPUT_INTERVAL_RANGE = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), false);

    public HvacOutputDlg(PyroMod domain, JFrame owner, String title, AMeasurementSet nodeSet, AMeasurementSet ductSet, int maxNodeQuantities, int maxDuctQuantities, TypedProp<Integer> prefSizeX, TypedProp<Integer> prefSizeY) {
        super(domain, owner, title, Intl.intl("Node Quantities"), Intl.intl("Duct Quantities"), nodeSet, ductSet, maxNodeQuantities, maxDuctQuantities, prefSizeX, prefSizeY, new Action[0]);
        this.getNumberTopQuantsChosen().setForeground(Color.BLUE);
        this.getNumberBotQuantsChosen().setForeground(Color.BLUE);
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new GridBagLayout());
        LinkStatus.link((AbstractButton)this.d_enable, this.getQuantitiesTableTop());
        LinkStatus.link((AbstractButton)this.d_enable, this.getQuantitiesTableBot());
        LinkStatus.link((AbstractButton)this.d_enable, this.getNumberTopQuantsChosen());
        LinkStatus.link((AbstractButton)this.d_enable, this.getNumberBotQuantsChosen());
        LinkStatus.link((AbstractButton)this.d_enable, this.d_intervalLbl);
        LinkStatus.link((AbstractButton)this.d_enable, this.d_intervalFd);
        LinkStatus.link((AbstractButton)this.d_enable, this.getResetButton());
        int row = 0;
        GridBagUtil.add(mainPanel, this.d_enable, 0, row, 2, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.getResetButton(), 2, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
        GridBagUtil.add(mainPanel, this.getspEnabledQuantitiesTop(), 0, row++, 3, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(mainPanel, this.getNumberTopQuantsChosen(), 2, row++, 1, 1, 0, 12, 6, 12, 0, 1.0, 0.0, 13);
        GridBagUtil.add(mainPanel, this.getspEnabledQuantitiesBot(), 0, row++, 3, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(mainPanel, this.d_intervalLbl, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_intervalFd, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.getNumberBotQuantsChosen(), 2, row++, 1, 1, 0, 12, 6, 12, 0, 1.0, 0.0, 13);
        this.loadHvacOutSettings();
    }

    private void loadHvacOutSettings() {
        SimParams.FileOutput fo = this.getFileOutput();
        if (fo.getDtHvacOutFile() != null) {
            this.d_intervalFd.setValue(fo.getDtHvacOutFile());
        } else {
            this.d_intervalFd.setValue(new UnitDouble(0.5, PyroSim.getApp().getUnitSystem().getTimeUnit()));
        }
        boolean sel = fo.getDtHvacOutFile() != null;
        this.d_enable.setSelected(sel);
    }

    public Task taskSaveValues() {
        final PyroMod mod = this.getPyroMod();
        CompositeTask<PyroMod> ctask = new CompositeTask<PyroMod>(this.getPyroMod());
        ctask.addTask(super.getSaveTask());
        UnitDouble newVal = this.d_enable.isSelected() ? (UnitDouble)this.d_intervalFd.getValue() : null;
        ctask.addTask(new AReplaceRefTask<UnitDouble>(this, (Object)this.getFileOutput().getDtHvacOutFile(), (Object)newVal){

            @Override
            protected void set(UnitDouble obj) {
                mod.getSimParams().getFileOutput().setDtHvacOutFile(obj);
            }
        });
        return ctask;
    }

    private void setFDSDefaultSelectionNode() {
        this.selectQuantities(new HvacNodeOutput().getQuantities());
    }

    private void setFDSDefaultSelectionDuct() {
        this.selectQuantities(new HvacDuctOutput().getQuantities());
    }

    private static class FDSDefaultAction
    extends guiAction {
        private static final long serialVersionUID = -4066927347979838926L;

        public FDSDefaultAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HvacOutputDlg dlg;
            if (this.getValue("QuantityDlg") instanceof HvacNodeOutput) {
                dlg = (HvacOutputDlg)this.getValue("QuantityDlg");
                dlg.clearSelection();
                dlg.setFDSDefaultSelectionNode();
            }
            if (this.getValue("QuantityDlg") instanceof HvacDuctOutput) {
                dlg = (HvacOutputDlg)this.getValue("QuantityDlg");
                dlg.clearSelection();
                dlg.setFDSDefaultSelectionDuct();
            }
        }
    }
}

