/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderProps;
import thunderheadeng.units.UnitDouble;

public class Validator {
    public static final int OVERLAP_NONE = 0;
    public static final int OVERLAP_INTERSECT = 7;
    public static final int OVERLAP_TOUCH_X_FACE = 1;
    public static final int OVERLAP_TOUCH_Y_FACE = 2;
    public static final int OVERLAP_TOUCH_Z_FACE = 3;

    public static List<Alignment> getValidity(List<? extends Grid> gridsColl) {
        Unit u = Geometry.LU;
        Alignment[] validity = new Alignment[gridsColl.size()];
        for (int m = 0; m < gridsColl.size(); ++m) {
            validity[m] = new Alignment();
        }
        Grid[] grids = gridsColl.toArray(new Grid[gridsColl.size()]);
        for (int m = 0; m < grids.length; ++m) {
            Grid grid1 = grids[m];
            if (!grid1.isEnabled()) continue;
            Point3d min1 = grid1.getMinPoint().getPoint3dValue(u);
            Point3d max1 = grid1.getMaxPoint().getPoint3dValue(u);
            Alignment gval1 = validity[m];
            for (int n = m + 1; n < grids.length; ++n) {
                Grid grid2 = grids[n];
                if (!grid2.isEnabled()) continue;
                Point3d min2 = grid2.getMinPoint().getPoint3dValue(u);
                Point3d max2 = grid2.getMaxPoint().getPoint3dValue(u);
                Alignment gval2 = validity[n];
                int overlap = Validator.getOverlap(min1, max1, min2, max2, 1.0E-6);
                Validator.getAlignment(grid1, grid2, gval1, gval2, overlap);
            }
        }
        return Arrays.asList(validity);
    }

    public static Alignment getValidity(List<? extends Grid> gridsColl, Grid grid) {
        Unit u = Geometry.LU;
        Alignment gval1 = new Alignment();
        if (!grid.isEnabled()) {
            return gval1;
        }
        Grid[] grids = gridsColl.toArray(new Grid[gridsColl.size()]);
        Grid grid1 = grid;
        Point3d min1 = grid1.getMinPoint().getPoint3dValue(u);
        Point3d max1 = grid1.getMaxPoint().getPoint3dValue(u);
        for (int n = 0; n < grids.length; ++n) {
            Grid grid2 = grids[n];
            if (grid2 == grid1 || grid1.getEvacuation() != grid2.getEvacuation() || !grid2.isEnabled()) continue;
            Point3d min2 = grid2.getMinPoint().getPoint3dValue(u);
            Point3d max2 = grid2.getMaxPoint().getPoint3dValue(u);
            PyroSim pySim = PyroSim.getApp();
            FDSRenderProps props = pySim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter formatter = props.getDecimalFormatter();
            int overlap = Validator.getOverlap(Validator.getRoundedP3d(min1, formatter), Validator.getRoundedP3d(max1, formatter), Validator.getRoundedP3d(min2, formatter), Validator.getRoundedP3d(max2, formatter), 1.0E-6);
            Validator.getAlignment(grid1, grid2, gval1, null, overlap);
        }
        return gval1;
    }

    private static Point3d getRoundedP3d(Point3d original, FDSRenderProps.IDecimalFormatter formatter) {
        try {
            return new Point3d(Double.parseDouble(formatter.format(original.x)), Double.parseDouble(formatter.format(original.y)), Double.parseDouble(formatter.format(original.z)));
        }
        catch (Exception e) {
            return original;
        }
    }

    private static void getAlignment(Grid grid1, Grid grid2, Alignment gval1, Alignment gval2, int overlap) {
        if (overlap == 0) {
            return;
        }
        if (overlap == 7) {
            boolean valid = true;
            for (int o = 1; o <= 3 && (valid &= Validator.isTouchValid(grid1, grid2, o, 1.0E-6)); ++o) {
            }
            if (valid) {
                gval1.alignedOverlap.add(grid2);
                if (gval2 != null) {
                    gval2.alignedOverlap.add(grid1);
                }
            } else {
                gval1.unalignedOverlap.add(grid2);
                if (gval2 != null) {
                    gval2.unalignedOverlap.add(grid1);
                }
            }
        } else {
            boolean valid = Validator.isTouchValid(grid1, grid2, overlap, 1.0E-6);
            if (!valid) {
                gval1.unalignedTouch.add(grid2);
                if (gval2 != null) {
                    gval2.unalignedTouch.add(grid1);
                }
            }
        }
    }

    private static int compare(double v1, double v2, double tol) {
        if (v1 == v2 || Math.abs(v1 - v2) < tol) {
            return 0;
        }
        return Double.compare(v1, v2);
    }

    protected static int getOverlap(Point3d m1, Point3d M1, Point3d m2, Point3d M2, double tol) {
        boolean zin;
        int cMx = Validator.compare(M1.x, m2.x, tol);
        int cmx = Validator.compare(m1.x, M2.x, tol);
        int cMy = Validator.compare(M1.y, m2.y, tol);
        int cmy = Validator.compare(m1.y, M2.y, tol);
        int cMz = Validator.compare(M1.z, m2.z, tol);
        int cmz = Validator.compare(m1.z, M2.z, tol);
        boolean xin = cmx < 0 && cMx > 0;
        boolean yin = cmy < 0 && cMy > 0;
        boolean bl = zin = cmz < 0 && cMz > 0;
        if (xin && yin && zin) {
            return 7;
        }
        if (cmx == 0 || cMx == 0) {
            return yin && zin ? 1 : 0;
        }
        if (cmy == 0 || cMy == 0) {
            return xin && zin ? 2 : 0;
        }
        if (cmz == 0 || cMz == 0) {
            return xin && yin ? 3 : 0;
        }
        return 0;
    }

    private static Double[] toDoubles(UnitDouble[] vals, Unit u) {
        Double[] dvals = new Double[vals.length];
        for (int m = 0; m < vals.length; ++m) {
            dvals[m] = vals[m].getValue(u);
        }
        return dvals;
    }

    protected static boolean isTouchValid(Grid g1, Grid g2, int touch, double tol) {
        UnitDouble[] divx1 = null;
        UnitDouble[] divx2 = null;
        UnitDouble[] divy1 = null;
        UnitDouble[] divy2 = null;
        switch (touch) {
            case 1: {
                divx1 = g1.getYLinePositions();
                divy1 = g1.getZLinePositions();
                divx2 = g2.getYLinePositions();
                divy2 = g2.getZLinePositions();
                break;
            }
            case 2: {
                divx1 = g1.getXLinePositions();
                divy1 = g1.getZLinePositions();
                divx2 = g2.getXLinePositions();
                divy2 = g2.getZLinePositions();
                break;
            }
            case 3: {
                divx1 = g1.getXLinePositions();
                divy1 = g1.getYLinePositions();
                divx2 = g2.getXLinePositions();
                divy2 = g2.getYLinePositions();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Unit u = Geometry.LU;
        return Validator.isTouchValid(Validator.toDoubles(divx1, u), Validator.toDoubles(divy1, u), Validator.toDoubles(divx2, u), Validator.toDoubles(divy2, u), tol);
    }

    protected static boolean isTouchValid(Double[] divx1, Double[] divy1, Double[] divx2, Double[] divy2, double tol) {
        TolComparator comparator = new TolComparator(tol);
        return Validator.areCellsFilled(divx1, divy1, divx2, divy2, comparator) && Validator.areCellsFilled(divx2, divy2, divx1, divy1, comparator);
    }

    protected static boolean areCellsFilled(Double[] divx1, Double[] divy1, Double[] divx2, Double[] divy2, Comparator<Double> comparator) {
        for (int ix1 = 0; ix1 < divx1.length - 1; ++ix1) {
            for (int iy1 = 0; iy1 < divy1.length - 1; ++iy1) {
                double cMy1;
                double cmx1 = divx1[ix1];
                double cMx1 = divx1[ix1 + 1];
                double cmy1 = divy1[iy1];
                if (Validator.isCellFilled(cmx1, cmy1, cMx1, cMy1 = divy1[iy1 + 1].doubleValue(), divx2, divy2, comparator)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean isCellFilled(double mx, double my, double Mx, double My, Double[] divx2, Double[] divy2, Comparator<Double> comparator) {
        double maxx = divx2.length - 1;
        double maxy = divy2.length - 1;
        int imx = Validator.findCellBoundary(mx, divx2, -1, comparator);
        int iMx = Validator.findCellBoundary(Mx, divx2, 1, comparator);
        int imy = Validator.findCellBoundary(my, divy2, -1, comparator);
        int iMy = Validator.findCellBoundary(My, divy2, 1, comparator);
        int numcellsx = iMx - imx;
        int numcellsy = iMy - imy;
        if (numcellsx == 1 && numcellsy == 1) {
            return true;
        }
        if (imx < 0 && iMx <= 0 || (double)imx >= maxx && (double)iMx > maxx || imy < 0 && iMy <= 0 || (double)imy >= maxy && (double)iMy > maxy) {
            return true;
        }
        if (imx < 0 && iMx > 0 || (double)imx < maxx && (double)iMx > maxx || imy < 0 && iMy > 0 || (double)imy < maxy && (double)iMy > maxy) {
            return false;
        }
        double cellArea = (My - my) * (Mx - mx);
        double touchingTotArea = 0.0;
        double overlapArea = 0.0;
        for (int m = imx; m < iMx; ++m) {
            double x1 = divx2[m];
            double x2 = divx2[m + 1];
            for (int n = imy; n < iMy; ++n) {
                double y1 = divy2[n];
                double y2 = divy2[n + 1];
                touchingTotArea += (x2 - x1) * (y2 - y1);
                overlapArea += Validator.getOverlapArea(mx, my, Mx, My, x1, y1, x2, y2);
            }
        }
        return comparator.compare(cellArea, touchingTotArea) == 0 && comparator.compare(cellArea, overlapArea) == 0;
    }

    private static double getOverlapArea(double mx1, double my1, double Mx1, double My1, double mx2, double my2, double Mx2, double My2) {
        double minx = Math.max(mx1, mx2);
        double maxx = Math.min(Mx1, Mx2);
        double miny = Math.max(my1, my2);
        double maxy = Math.min(My1, My2);
        return (maxx - minx) * (maxy - miny);
    }

    private static int findCellBoundary(double val, Double[] vals, int lower, Comparator<Double> comparator) {
        int ix = Arrays.binarySearch(vals, val, comparator);
        if (ix >= 0) {
            return ix;
        }
        return lower < 0 ? -ix - 2 : -ix - 1;
    }

    private static boolean isIntegral(double val) {
        return val - Math.floor(val) == 0.0;
    }

    public static class Alignment {
        public final List<Grid> alignedOverlap = new ArrayList<Grid>();
        public final List<Grid> unalignedOverlap = new ArrayList<Grid>();
        public final List<Grid> unalignedTouch = new ArrayList<Grid>();

        public boolean isValid() {
            return this.alignedOverlap.isEmpty() && this.unalignedOverlap.isEmpty() && this.unalignedTouch.isEmpty();
        }

        public boolean isQuestionable() {
            return this.unalignedTouch.isEmpty() && !this.alignedOverlap.isEmpty() && this.unalignedOverlap.isEmpty();
        }
    }

    private static class TolComparator
    implements Comparator<Double> {
        private final double tol;

        public TolComparator(double tol) {
            this.tol = tol;
        }

        @Override
        public int compare(Double o1, Double o2) {
            return Validator.compare(o1, o2, this.tol);
        }
    }
}

