/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.geom.plane.AAPlane;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.View;
import pyrosim.gui.geom.PlaneDialog;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Task;

public class ViewClipDlg
extends guiDialog {
    private static final long serialVersionUID = -5392202711233254665L;
    private final List<ClipPlaneEditor> d_editors = new ArrayList<ClipPlaneEditor>(4);

    public ViewClipDlg(Window parent) {
        super(parent, Intl.intl("Edit Clipping Planes"), 9);
        for (int m = 0; m < 4; ++m) {
            this.d_editors.add(new ClipPlaneEditor(m));
        }
        guiLabel help = new guiLabel("<html><b>" + Intl.intl("NOTE: Geometry on the positive side of the planes is clipped from view."));
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        for (ClipPlaneEditor editor : this.d_editors) {
            editor.add(gb);
        }
        gb.addFilledRow(help);
        gb.finalizeRows();
    }

    public void load(View view) {
        Set<ClipPlane> planes = view.getClipPlanes();
        assert (planes.size() <= 4);
        int ix = 0;
        for (ClipPlane plane : planes) {
            this.d_editors.get(ix).load(view, plane);
            ++ix;
        }
        for (int m = ix; m < 4; ++m) {
            this.d_editors.get(m).load(view, null);
        }
    }

    public Task taskSave(final View view) {
        return new AOneTimeTask(){

            @Override
            public void run() {
                ViewClipDlg.this.save(view);
            }
        };
    }

    private void save(View view) {
        for (ClipPlaneEditor editor : this.d_editors) {
            editor.save(view);
        }
    }

    private static class ClipPlaneEditor {
        private final PlaneEditor d_editor = new PlaneEditor();
        private final guiCheckBox d_enabledCB;
        private ClipPlane d_plane;

        public ClipPlaneEditor(int ix) {
            this.d_enabledCB = new guiCheckBox(String.format(Intl.intl("Plane %d:"), ix + 1));
            LinkStatus.link((AbstractButton)this.d_enabledCB, this.d_editor);
        }

        public void add(GridBagHelper gb) {
            gb.addRow(this.d_enabledCB, this.d_editor, 1.0, 0);
        }

        public void load(View view, ClipPlane plane) {
            this.d_plane = plane;
            this.d_enabledCB.setSelected(plane != null);
            if (plane != null) {
                this.d_editor.setPlane(plane.getPlane());
            } else {
                this.d_editor.setPlane(null);
            }
        }

        public void save(View view) {
            IPlane newPlane;
            IPlane iPlane = newPlane = this.d_enabledCB.isSelected() ? this.d_editor.getPlane() : null;
            if (this.d_plane != null && newPlane != null) {
                this.d_plane.setPlane(newPlane);
            } else if (this.d_plane != null) {
                view.removeClipPlane(this.d_plane);
            } else if (newPlane != null) {
                ClipPlane plane = new ClipPlane(newPlane);
                view.addClipPlane(plane);
            }
        }
    }

    private static class PlaneEditor
    extends guiPanel {
        private static final long serialVersionUID = -1943465494986451072L;
        private final HTMLBtn d_label = new HTMLBtn("");
        private IPlane d_plane;

        public PlaneEditor() {
            this.d_label.addActionListener(e -> {
                PlaneDialog dlg = new PlaneDialog(SwingUtilities.getWindowAncestor(this));
                IPlane plane = this.d_plane != null ? this.d_plane : new AAPlane(AAPlane.Axis.X, 0.0, true);
                dlg.load(plane);
                if (dlg.doModal() != 1) {
                    return;
                }
                this.setPlane(dlg.save());
                this.setModified(true);
            });
            this.updateLbl();
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(this.d_label);
            gb.finalizeRows();
        }

        public IPlane getPlane() {
            return this.d_plane;
        }

        public void setPlane(IPlane plane) {
            this.d_plane = plane;
            this.setModified(false);
            this.updateLbl();
        }

        private void updateLbl() {
            String text = this.d_plane == null ? String.format("&lt;%s&gt;", Intl.intl("edit")) : this.d_plane.toString(PyroSim.getApp().getUnitSystem().getLengthUnit());
            this.d_label.setText(text);
        }
    }
}

