/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.util.Collection;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.ScaleTask;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;

public class ScaleDialog
extends TransformDialog {
    private static final long serialVersionUID = 1518400242791892604L;
    private final ValueField<Double> d_bx;
    private final ValueField<Double> d_by;
    private final ValueField<Double> d_bz;
    private final ValueField<Double> d_sx;
    private final ValueField<Double> d_sy;
    private final ValueField<Double> d_sz;
    private final Unit d_lu;
    private static final String SCALE = Intl.intl("Scale");

    public ScaleDialog(PyroMod mediator, Collection<? extends IPyroObject> objs) {
        super(Intl.intl(SCALE), mediator, objs, true, true);
        UnitSystem currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lu = currentUS.getLengthUnit();
        DoubleVR scaleRange = DoubleVR.above(0.0, false);
        this.d_sx = ValueFields.doubleFld(1.0, scaleRange);
        this.d_sy = ValueFields.doubleFld(1.0, scaleRange);
        this.d_sz = ValueFields.doubleFld(1.0, scaleRange);
        this.d_bx = ValueFields.doubleFld(0.0);
        this.d_by = ValueFields.doubleFld(0.0);
        this.d_bz = ValueFields.doubleFld(0.0);
        int numCols = 6;
        this.d_sx.setColumns(numCols);
        this.d_sy.setColumns(numCols);
        this.d_sz.setColumns(numCols);
        this.d_bx.setColumns(numCols + 4);
        this.d_by.setColumns(numCols + 4);
        this.d_bz.setColumns(numCols + 4);
        guiLabel sxLab = new guiLabel("X:");
        guiLabel syLab = new guiLabel("Y:");
        guiLabel szLab = new guiLabel("Z:");
        guiLabel bxLab = new guiLabel("X:");
        guiLabel byLab = new guiLabel("Y:");
        guiLabel bzLab = new guiLabel("Z:");
        guiPanel scalePanel = new guiPanel();
        scalePanel.setLayout(new MigLayout("insets 3 0 3 0"));
        scalePanel.add((Component)sxLab, "gapleft 10, width 10::");
        scalePanel.add(this.d_sx);
        scalePanel.add((Component)syLab, "width 10::");
        scalePanel.add(this.d_sy);
        scalePanel.add((Component)szLab, "width 10::");
        scalePanel.add(this.d_sz);
        guiPanel basePanel = new guiPanel(new MigLayout("insets 3 0 0 0"));
        basePanel.add((Component)bxLab, "gapleft 10, width 10::");
        basePanel.add(this.d_bx, "gapleft 1, wrap");
        basePanel.add((Component)byLab, "gapleft 10, width 10::");
        basePanel.add(this.d_by, "gapleft 1, wrap");
        basePanel.add((Component)bzLab, "gapleft 10, width 10::");
        basePanel.add(this.d_bz, "gapleft 1, wrap");
        basePanel.add((Component)this.getCenterForBaseButton(), "skip");
        guiPanel dlgPane = super.getDialogPane();
        dlgPane.setLayout(new MigLayout("insets 5"));
        dlgPane.add((Component)this.getModePanel(), "span");
        dlgPane.add((Component)new TitleSeparator(Intl.intl("Scale")), "growx, span");
        dlgPane.add((Component)scalePanel, "growx, span");
        dlgPane.add((Component)new TitleSeparator(Intl.intl("Base Point") + " (" + String.valueOf(this.d_lu) + ")"), "growx, span");
        dlgPane.add((Component)basePanel, "growx, span");
        super.init();
    }

    @Override
    protected String getTransformTypeName() {
        return SCALE;
    }

    private UnitPoint3D getBasePoint() {
        return new UnitPoint3D((Double)this.d_bx.getValue(), (Double)this.d_by.getValue(), (Double)this.d_bz.getValue(), this.d_lu);
    }

    private Tuple3d getScale() {
        return new Vector3d((Double)this.d_sx.getValue(), (Double)this.d_sy.getValue(), (Double)this.d_sz.getValue());
    }

    @Override
    protected void setBase(UnitPoint3D base) {
        this.d_bx.setValue(base.x(this.d_lu));
        this.d_by.setValue(base.y(this.d_lu));
        this.d_bz.setValue(base.z(this.d_lu));
    }

    @Override
    protected TransformTask taskTransform(Collection<? extends IPyroObject> objs) {
        UnitPoint3D basePoint = this.getBasePoint();
        Tuple3d scale = this.getScale();
        return new ScaleTask(this.getMediator(), objs, this.getNumCopies(), basePoint, scale);
    }
}

